"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const x3_package_generator_1 = require("../lib/functions/x3-package-generator");
// eslint-disable-next-line react-hooks/rules-of-hooks
(0, chai_1.use)(chai_as_promised_1.default);
describe('Package creation', () => {
    let extraDependencies = {};
    const extraDependencyNames = x3_package_generator_1.X3PackageGenerator.devDependenciesNames;
    before(() => {
        extraDependencies = x3_package_generator_1.X3PackageGenerator.getPackageDependencies(extraDependencyNames);
    });
    after(() => {
        fs.rmSync(path.join(__dirname, 'x3-foo'), { recursive: true, force: true });
        fs.rmSync(path.join(__dirname, '@acme'), { recursive: true, force: true });
    });
    it('Can create a new standard package', () => {
        const packageName = '@sage/x3-foo';
        const version = '99.0.0';
        x3_package_generator_1.X3PackageGenerator.ensurePackageStructureExists(__dirname, {
            name: packageName,
            version,
            isCustom: false,
            serviceName: 'x3',
        });
        const pathToPackage = path.join(__dirname, path.basename(packageName));
        const packageJsonPath = path.join(pathToPackage, 'package.json');
        chai_1.assert.isTrue(fs.existsSync(packageJsonPath), `${packageJsonPath} does not exist`);
        const packageJsonContent = JSON.parse(fs.readFileSync(packageJsonPath, 'utf-8'));
        chai_1.assert.equal(packageJsonContent.name, packageName);
        chai_1.assert.equal(packageJsonContent.description, 'Sage X3 Foo');
        chai_1.assert.equal(packageJsonContent.author, 'sage');
        chai_1.assert.deepEqual(packageJsonContent.xtrem, {
            packageName,
        });
        chai_1.assert.equal(packageJsonContent.keywords, 'xtrem-x3-services-application-package');
        chai_1.assert.deepEqual(packageJsonContent.publishConfig, {
            registry: 'https://pkgs.dev.azure.com/Sage-LiveServices/_packaging/Sage-ERP/npm/registry/',
        });
        chai_1.assert.deepEqual(packageJsonContent.repository, {
            type: 'git',
            url: 'git://github.com/Sage-ERP-X3/xtrem.git',
        });
        chai_1.assert.deepEqual(packageJsonContent.dependencies, {
            '@sage/xtrem-async-helper': 'workspace:*',
            '@sage/xtrem-core': 'workspace:*',
            '@sage/xtrem-date-time': 'workspace:*',
            '@sage/xtrem-decimal': 'workspace:*',
            '@sage/xtrem-ui': 'workspace:*',
            '@sage/xtrem-shared': 'workspace:*',
            '@sage/xtrem-x3-gateway': 'workspace:*',
            '@sage/xtrem-x3-syracuse': 'workspace:*',
            '@sage/xtrem-x3-system-utils': 'workspace:*',
        });
        chai_1.assert.deepEqual(packageJsonContent.devDependencies, {
            '@sage/eslint-plugin-xtrem': 'workspace:*',
            '@sage/xtrem-cli': 'workspace:*',
            '@sage/xtrem-cli-bundle-x3': 'workspace:*',
            ...extraDependencies,
        });
        chai_1.assert.deepEqual(packageJsonContent.scripts, {
            build: 'xtrem compile',
            'build:api': 'xtrem build --only-api-client',
            'build:binary': 'pnpm run clean && pnpm run build',
            clean: 'rm -rf build',
            'generate-package': 'xtrem x3-dev generate-package --service-name x3',
            'generate-migrate-translations': 'xtrem x3-dev generate-migrate-translations',
            'generate-translations': 'xtrem x3-dev generate-translations --service-name x3',
            lint: 'xtrem lint',
            start: 'xtrem start',
            test: 'xtrem test --unit --graphql',
            'test:ci': 'xtrem test --unit --ci',
            xtrem: 'xtrem',
        });
        ['nodes', 'node-extensions', 'enums', 'service-options'].forEach(apiComponent => {
            const pathToApiComponent = path.join(pathToPackage, 'lib', apiComponent, 'index.ts');
            chai_1.assert.isTrue(fs.existsSync(pathToApiComponent), `${pathToApiComponent} does not exist`);
        });
        ['eslint.config.mjs', 'eslint-filename.config.mjs'].forEach(template => {
            const pathToFile = path.join(pathToPackage, template);
            const stats = fs.statSync(pathToFile, { throwIfNoEntry: false });
            chai_1.assert.isTrue(stats?.isFile(), `${pathToFile} does not exist`);
            const content = fs.readFileSync(pathToFile, 'utf-8');
            chai_1.assert.match(content, /export default/);
            const expectContent = fs.readFileSync(path.join(__dirname, '../lib/templates', template), 'utf-8');
            chai_1.assert.equal(content, expectContent);
        });
    });
    it('Can create a new specific package', () => {
        const packageName = '@acme/x3-bar';
        const version = '5.0.0';
        const pathToPackage = path.join(__dirname, packageName);
        x3_package_generator_1.X3PackageGenerator.ensurePackageStructureExists(path.parse(pathToPackage).dir, {
            name: packageName,
            version,
            isCustom: true,
            serviceName: 'x3',
        });
        const packageJsonPath = path.join(pathToPackage, 'package.json');
        chai_1.assert.isTrue(fs.existsSync(packageJsonPath), `${packageJsonPath} does not exist`);
        const packageJsonContent = JSON.parse(fs.readFileSync(packageJsonPath, 'utf-8'));
        chai_1.assert.equal(packageJsonContent.name, packageName);
        chai_1.assert.equal(packageJsonContent.description, 'Acme X3 Bar');
        chai_1.assert.equal(packageJsonContent.author, 'acme');
        chai_1.assert.deepEqual(packageJsonContent.xtrem, {
            packageName,
        });
        chai_1.assert.equal(packageJsonContent.keywords, 'xtrem-x3-services-specific-application-package');
        chai_1.assert.isUndefined(packageJsonContent.publishConfig);
        chai_1.assert.isUndefined(packageJsonContent.repository);
        const devDependencies = x3_package_generator_1.X3PackageGenerator.getPackageDependencies(x3_package_generator_1.X3PackageGenerator.devDependenciesNames);
        const eslintConfigVersion = devDependencies['@sage/eslint-config-xtrem']?.replace(/[^0-9.]/g, '') || '0.0.0';
        chai_1.assert.deepEqual(packageJsonContent.peerDependencies, {
            '@sage/eslint-config-xtrem': `file:../../sage-packages/sage-eslint-config-xtrem-${eslintConfigVersion}.tgz`,
            '@sage/eslint-plugin-xtrem': 'file:../../sage-packages/sage-eslint-plugin-xtrem-5.0.0.tgz',
            '@sage/x3-main': 'file:../../sage-packages/sage-x3-main-5.0.0.tgz',
            '@sage/xtrem-async-helper': 'file:../../sage-packages/sage-xtrem-async-helper-5.0.0.tgz',
            '@sage/xtrem-core': 'file:../../sage-packages/sage-xtrem-core-5.0.0.tgz',
            '@sage/xtrem-date-time': 'file:../../sage-packages/sage-xtrem-date-time-5.0.0.tgz',
            '@sage/xtrem-decimal': 'file:../../sage-packages/sage-xtrem-decimal-5.0.0.tgz',
            '@sage/xtrem-shared': 'file:../../sage-packages/sage-xtrem-shared-5.0.0.tgz',
            '@sage/xtrem-ui': 'file:../../sage-packages/sage-xtrem-ui-5.0.0.tgz',
            '@sage/xtrem-x3-gateway': 'file:../../sage-packages/sage-xtrem-x3-gateway-5.0.0.tgz',
            '@sage/xtrem-x3-syracuse': 'file:../../sage-packages/sage-xtrem-x3-syracuse-5.0.0.tgz',
            '@sage/xtrem-x3-system-utils': 'file:../../sage-packages/sage-xtrem-x3-system-utils-5.0.0.tgz',
        });
        chai_1.assert.deepEqual(packageJsonContent.devDependencies, {
            '@acme/x3-bar-api': '^5.0.0',
            ...extraDependencies,
        });
        chai_1.assert.deepEqual(packageJsonContent.scripts, {
            build: 'xtrem compile',
            'build:api': 'xtrem build --only-api-client',
            clean: 'rm -rf build',
            'generate-package': 'xtrem x3-dev generate-package --service-name x3',
            'generate-migrate-translations': 'xtrem x3-dev generate-migrate-translations',
            'generate-translations': 'xtrem x3-dev generate-translations --service-name x3',
            lint: 'xtrem lint',
            start: 'xtrem start',
            test: 'xtrem test --unit --graphql',
            'test:ci': 'xtrem test --unit --ci',
            xtrem: 'xtrem',
        });
        ['nodes', 'node-extensions', 'enums', 'service-options'].forEach(apiComponent => {
            const pathToApiComponent = path.join(pathToPackage, 'lib', apiComponent, 'index.ts');
            chai_1.assert.isTrue(fs.existsSync(pathToApiComponent), `${pathToApiComponent} does not exist`);
        });
    });
    it('Can update the dependencies of a package', () => {
        const packageName = '@acme/x3-bar';
        const version = '5.0.0';
        const pathToPackage = path.join(__dirname, packageName);
        const packageJsonPath = path.join(pathToPackage, 'package.json');
        chai_1.assert.isTrue(fs.existsSync(packageJsonPath), `${packageJsonPath} does not exist`);
        const packageJsonContent = JSON.parse(fs.readFileSync(packageJsonPath, 'utf-8'));
        packageJsonContent.peerDependencies['@sage/x3-sales'] = `file:../../sage-packages/sage-x3-sales-${version}.tgz`;
        fs.writeFileSync(packageJsonPath, JSON.stringify(packageJsonContent));
        x3_package_generator_1.X3PackageGenerator.ensurePackageStructureExists(path.parse(pathToPackage).dir, {
            name: packageName,
            version,
            isCustom: true,
            serviceName: 'x3',
        });
        const postUpdatePackageJsonContent = JSON.parse(fs.readFileSync(packageJsonPath, 'utf-8'));
        chai_1.assert.deepEqual(packageJsonContent.peerDependencies, postUpdatePackageJsonContent.peerDependencies);
        chai_1.assert.deepEqual(packageJsonContent.devDependencies, { '@acme/x3-bar-api': '^5.0.0', ...extraDependencies });
    });
});
//# sourceMappingURL=create-package-test.js.map