"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tsconfigTemplate = void 0;
exports.tsconfigTemplate = {
    compilerOptions: {
        module: 'commonjs',
        moduleResolution: 'node',
        target: 'es2022',
        lib: ['es2022', 'dom'],
        composite: true,
        sourceMap: true,
        declaration: true,
        declarationMap: true,
        noUnusedLocals: false,
        noImplicitAny: true,
        noImplicitThis: true,
        strictNullChecks: true,
        experimentalDecorators: true,
        stripInternal: true,
        watch: false,
        skipLibCheck: true,
        useDefineForClassFields: false,
        disableReferencedProjectLoad: true,
        outDir: 'build',
        rootDir: '.',
        baseUrl: '.',
    },
    compileOnSave: true,
    include: ['index.ts', 'application.ts', 'lib/**/*', 'test/**/*.ts', 'test/**/*.json', 'api/api.d.ts'],
    exclude: [
        'lib/pages/**/*',
        'lib/page-extensions/**/*',
        'lib/page-fragments/**/*',
        'lib/widgets/**/*',
        'lib/stickers/**/*',
        'lib/i18n/**/*',
        '**/*.feature',
        '**/*.png',
        'lib/client-functions/**/*',
    ],
};
//# sourceMappingURL=tsconfig-template.js.map