import { Pool } from '@sage/xtrem-x3-sql';
import { ActivityCode } from './x3-dictionary-interfaces';
import { X3PackageGenerator } from './x3-package-generator';
export declare class X3ServiceOptionsGenerator {
    private readonly packageGenerator;
    private readonly activityCode;
    constructor(packageGenerator: X3PackageGenerator, activityCode: ActivityCode);
    private static activityCodes;
    static clearCache(): void;
    get activityCodeName(): string;
    get filename(): string;
    get filepath(): string;
    private generateServiceOptionsStatement;
    private static generateServiceOptionImport;
    private activityCodeDef;
    createServiceOption(): string;
    generateServiceOption(): void;
    static generatePackageServiceOptions(packageGenerator: X3PackageGenerator): Promise<void>;
    private static queryActivityCodes;
    static findActivityCode(connPool: Pool, x3Folder: string, code: string, serviceName: string): Promise<ActivityCode | undefined>;
    static loadActivityCodes(connPool: Pool, x3Folder: string, serviceName: string): Promise<ActivityCode[]>;
}
//# sourceMappingURL=x3-service-options-generator.d.ts.map