import { Dict } from '@sage/xtrem-core';
import { Logger } from '@sage/xtrem-log';
import { Pool } from '@sage/xtrem-x3-sql';
import * as ts from 'typescript';
import { ActivityCode, ApiNodeClassObject, ImportEntry, MetadataPackage } from './x3-dictionary-interfaces';
import { X3NodeGenerator } from './x3-node-generator';
export declare const logger: Logger;
export declare class X3PackageGenerator {
    readonly dir: string;
    readonly packageName: string;
    readonly connPool: Pool;
    readonly serviceName: string;
    readonly x3FolderName: string;
    /** list of package imports, by entity (node, enum, etc.) */
    imports: Dict<Dict<string[]>>;
    static readonly newline: ts.Identifier;
    static readonly devDependenciesNames: string[];
    private _metadata;
    readonly nodeGenerator: X3NodeGenerator;
    constructor(dir: string, packageName: string, connPool: Pool, serviceName: string, x3FolderName: string);
    static packages: MetadataPackage[] | undefined;
    static allActivityCodes: ActivityCode[] | undefined;
    static allNodeObjects: ApiNodeClassObject[];
    static allNodesPerPackage: Dict<ApiNodeClassObject[]>;
    static localPackages: Dict<string> | undefined;
    static get devDependencies(): Dict<string>;
    static clearCache(): void;
    static preLoadPackageData(connPool: Pool, x3FolderName: string, serviceName: string): Promise<void>;
    /**
     * Initialize package generator
     */
    init(): Promise<void>;
    get metadata(): MetadataPackage;
    static readPackageJson(packagePath: string): Dict<any>;
    /**
     * Format typescript node
     * @param node
     * @param sourcePath
     * @returns
     */
    private static formatNodes;
    /**
     * Prettyify typescript file content
     * @param nodes
     * @param sourcePath
     * @returns
     */
    static prettyifyTypescript(nodes: ts.Node | ts.Node[] | string, sourcePath?: string, path?: string): string;
    /**
     * Prettyify JSON file content
     * @param jsonSource
     * @returns
     */
    static prettyifyJson(jsonSource: string): string;
    /**
     * Add an import to the list of imports this will be used later determined the dependencies of the package
     * @param type
     * @param name
     * @param importEntry
     */
    addImport(type: string, name: string, importEntry: ImportEntry): void;
    static sortImports(importsMap: Dict<string[]>): [string, string[]][];
    /**
     * Get the package alias for the import * statement
     * @param packageName
     * @returns
     */
    static getPackageAlias(packageName: string): string;
    getDependencies(): string[];
    static getInternalDependencies(version: string, isCustom: boolean, serviceName: string): Dict<string>;
    private updatePackageDependencies;
    static getFilesInPath(dirPath: string): string[];
    static traversePackageTree(rootPath: string): Dict<string>;
    private get rootPath();
    private getLocalPackages;
    private updatePackageReferences;
    static getPackageDependencies(deps: string[]): Dict<string>;
    /**
     * Build the package.json structure
     * @param packageName
     * @param version
     * @param isCustom
     * @returns
     */
    private static getPackageJsonContent;
    private static updatePackageJsonFile;
    static writePackageFile(packageName: string, filePath: string, content: string): void;
    /**
     * @param rootPackagePath
     * @param packageParentFolder parent folder of package, standard packages => x3-services/packages and specific package => add-ons
     * @param packageDetails
     */
    static ensurePackageStructureExists(packageParentFolder: string, packageDetails: {
        name: string;
        version: string;
        serviceName: string;
        isCustom: boolean;
        isHidden?: boolean;
    }): void;
    static getPackages(connPool: Pool, x3Folder: string, serviceName: string, options?: {
        scope?: string;
        specificOnly?: boolean;
    }): Promise<MetadataPackage[]>;
    /**
     * Main package generation method
     */
    generate(): Promise<void>;
    static generateMainPackage(dir: string, version: string, serviceName: string): void;
}
//# sourceMappingURL=x3-package-generator.d.ts.map