"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3PackageDictionaryHelper = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_log_1 = require("@sage/xtrem-log");
const xtrem_toposort_1 = require("@sage/xtrem-toposort");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const _ = __importStar(require("lodash"));
const x3_dictionary_helper_1 = require("./x3-dictionary-helper");
const x3_local_menu_dictionary_helper_1 = require("./x3-local-menu-dictionary-helper");
const logger = xtrem_log_1.Logger.getLogger(__filename, 'x3-dictionary-helper');
class X3PackageDictionaryHelper {
    static { this.packageDependencies = {}; }
    static clearCache() {
        X3PackageDictionaryHelper.packages = undefined;
        X3PackageDictionaryHelper.sortedPackages = undefined;
        X3PackageDictionaryHelper.packageTypes = undefined;
        X3PackageDictionaryHelper.packageDependencies = {};
    }
    static async comparePackages(connPool, x3Folder, fromPackage, targetPackage, serviceName) {
        const sortedPackages = await this.getSortedPackages(connPool, x3Folder, serviceName);
        const fromIndex = sortedPackages.findIndex(pack => pack.name === fromPackage);
        const targetPackageIndex = sortedPackages.findIndex(pack => pack.name === targetPackage);
        logger.info(`Comparing ${fromPackage}(${fromIndex}) to ${targetPackage}(${targetPackageIndex})`);
        return fromIndex - targetPackageIndex;
    }
    static async getPackageTypes(connPool, x3Folder) {
        if (this.packageTypes)
            return this.packageTypes;
        this.packageTypes = await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.getLocalMenuValues(connPool, x3Folder, 69, 'ENG');
        return this.packageTypes;
    }
    static async getPackageType(connPool, x3Folder, feedNumber) {
        const localMenuValues = await this.getPackageTypes(connPool, x3Folder);
        const type = localMenuValues.find(val => val.valueNumber === feedNumber);
        return type ? _.kebabCase(type.description) : 'shared';
    }
    static async loadPackageDependencies(connPool, x3Folder) {
        if (Object.keys(this.packageDependencies).length)
            return;
        // Query 1 - node extensions properties
        // Query 2 - node extensions operations
        // Query 3 - Reference property target node dependency
        // Query 4 - local menu dependency
        // Query 5 - computed properties
        // Query 6 - node activity code
        // Query 7 - property activty code
        const sql = `
        SELECT
            DISTINCT a2.APACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},a.APACKAGE_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a ON
            pack.APACK_0 = a.APACKAGE_0
            AND a.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.ANODPROP a2 ON
            a.ANODE_0 = a2.ANODE_0
            AND a.APACKAGE_0 <> a2.APACK_0
        UNION
        SELECT
            DISTINCT a2.APACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},a.APACKAGE_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a ON
            pack.APACK_0 = a.APACKAGE_0
            AND a.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.APIOPE a2 ON
            a.ANODE_0 = a2.APIREF_0
            AND a.APACKAGE_0 <> a2.APACK_0
            AND a2.APIOPEOVW_0 = ' '
        UNION
        SELECT
            DISTINCT CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},a3.APACKAGE_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a1 ON
            pack.APACK_0 = a1.APACKAGE_0
            AND a1.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.ANODPROP a2 ON
            a1.ANODE_0 = a2.ANODE_0
            AND a2.ATARGET_0 <> ' '
        LEFT JOIN ${x3Folder}.ANODE anode ON a2.DENCOLNOD_0 = anode.ANODE_0
        LEFT JOIN  ${x3Folder}.ANODPBDG pbdg ON
            pbdg.APROPNAM_0 = a2.APROPNAM_0
            AND a2.ANODE_0 = pbdg.ANODE_0
            AND a1.AREFBIND_0 = pbdg.AREFBIND_0
            AND ((anode.DENCOLGR_0 IS NULL AND pbdg.DENCOLGR_0 = ' ') OR pbdg.DENCOLGR_0 = anode.DENCOLGR_0)
        JOIN ${x3Folder}.ANODEBDG a3 ON
            a2.ATARGET_0 = a3.ANODE_0
            AND a3.ABDGTYP_0  IN (2,5)
        WHERE CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END <> a3.APACKAGE_0
        UNION
        SELECT DISTINCT CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},COALESCE(aebh.APACK_0,apackdata.APACK_0,apack.APACK_0) ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a1 ON
            pack.APACK_0 = a1.APACKAGE_0
            AND a1.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.ANODPROP a2 ON
                        a1.ANODE_0 = a2.ANODE_0
            AND a2.ATYPE_0 = 8
        LEFT JOIN ${x3Folder}.ANODE anode ON a2.DENCOLNOD_0 = anode.ANODE_0
        JOIN ${x3Folder}.ANODPBDG a3 ON
            a2.ANODE_0 = a3.ANODE_0
            AND a2.APROPNAM_0 = a3.APROPNAM_0
            AND a1.AREFBIND_0 = a3.AREFBIND_0
            AND ((anode.DENCOLGR_0 IS NULL AND a3.DENCOLGR_0 = ' ') OR a3.DENCOLGR_0 = anode.DENCOLGR_0)
            AND a3.JOINVAL_0 <> '0'
        JOIN ${x3Folder}.AMENLOC aml ON ${xtrem_x3_gateway_1.SqlResolver.toChar({ sql: 'aml.MENLOC_0', type: 'integer' }, connPool.dialect)} = a3.JOINVAL_0
        LEFT JOIN ${x3Folder}.AENUMBDGH aebh ON
            aml.MENLOC_0 = aebh.AMENLOC_0 AND aebh.APACK_0 <> ' '
        LEFT JOIN ${x3Folder}.APACKAGE apack ON
            apack.MAINPACK_0 = 2
            AND apack.MODULE_0 = aml.MODULE_0
            AND apack.CODACT_0 = aml.CODACT_0
        LEFT JOIN ${x3Folder}.APACKAGE apackdata ON
            apackdata.APACK_0 = CONCAT(apack.APACK_0,'-data')
        WHERE COALESCE(aebh.APACK_0,apackdata.APACK_0,apack.APACK_0) IS NOT NULL
        AND CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END <> COALESCE(aebh.APACK_0,apackdata.APACK_0,apack.APACK_0)
        UNION
        SELECT
            DISTINCT CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)}, a2.FNCPACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a1 ON
            pack.APACK_0 = a1.APACKAGE_0
            AND a1.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.ANODPROP a2 ON
            a1.ANODE_0 = a2.ANODE_0
            AND a2.FNCPACK_0 <> CASE WHEN a2.APACK_0 = ' ' THEN a1.APACKAGE_0 ELSE a2.APACK_0 END
            AND a2.FNCPACK_0 <> ' ' AND a2.FNCPACK_0 IS NOT NULL
        UNION
        SELECT
            DISTINCT
            a.APACKAGE_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},
            depPack.APACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a ON
            pack.APACK_0 = a.APACKAGE_0
            AND a.ABDGTYP_0  IN (2,5)
        JOIN  ${x3Folder}.ACTIV ac ON
            ac.CODACT_0 = a.CODACT_0
        JOIN
            ${x3Folder}.APACKACV acv ON
            ac.CODACT_0 = acv.CODACT_0
        JOIN
            ${x3Folder}.APACKAGE depPack
        ON
            depPack.APACKCOD_0  = acv.APACKCOD_0
        UNION
        SELECT
            DISTINCT
            a2.APACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)},
            depPack.APACK_0 ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('DEPENDENCY', connPool.dialect)}
        FROM
            ${x3Folder}.APACKAGE pack
        JOIN ${x3Folder}.ANODEBDG a ON
            pack.APACK_0 = a.APACKAGE_0
            AND a.ABDGTYP_0  IN (2,5)
        JOIN ${x3Folder}.ANODPROP a2 ON
            a.ANODE_0 = a2.ANODE_0
        JOIN  ${x3Folder}.ACTIV ac ON
            ac.CODACT_0 = a2.CODACT_0
        JOIN
            ${x3Folder}.APACKACV acv ON
            ac.CODACT_0 = acv.CODACT_0
        JOIN
            ${x3Folder}.APACKAGE depPack
        ON
            depPack.APACKCOD_0  = acv.APACKCOD_0
        ORDER BY ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias('PACKAGE_NAME', connPool.dialect)}`;
        const result = await connPool.withConnection(cnx => {
            return connPool.createReader(cnx, sql).readAll();
        });
        result.forEach((record) => {
            if (!this.packageDependencies[record.PACKAGE_NAME])
                this.packageDependencies[record.PACKAGE_NAME] = [];
            this.packageDependencies[record.PACKAGE_NAME].push(record.DEPENDENCY);
        });
    }
    static async getPackageDependencies(connPool, x3Folder, packageDefinition) {
        await this.loadPackageDependencies(connPool, x3Folder);
        return this.packageDependencies[packageDefinition.name] || [];
    }
    static async getSortedPackages(connPool, x3Folder, serviceName) {
        if (this.sortedPackages)
            return this.sortedPackages;
        const packsWithDependencies = await (0, xtrem_core_1.asyncArray)(await this.getPackages(connPool, x3Folder, serviceName))
            .map(async (pack) => {
            return { ...pack, dependsOn: await this.getPackageDependencies(connPool, x3Folder, pack) };
        })
            .toArray();
        logger.info(`Unsorted packages: \n ${packsWithDependencies
            .map(p => {
            const dependencies = p.dependsOn?.map(d => `\t\t${d}`).join('\n');
            return `\t${p.name}\n\t\tDependencies\n${dependencies}`;
        })
            .join('\n')}`);
        // On internal packages, we don't allow dependencies between application packages
        packsWithDependencies.forEach(pack => {
            if (pack.type === 'application' &&
                !pack.linkedPackage1 &&
                !pack.linkedPackage2 &&
                pack.dependsOn.length > 0 &&
                pack.name.startsWith('@sage/')) {
                const applicationDependencies = pack.dependsOn.filter(p => {
                    const dependency = packsWithDependencies.find(d => d.name === p);
                    return dependency?.type === 'application';
                });
                if (applicationDependencies.length > 0) {
                    throw new Error(`Application package ${pack.name} is dependant on another application package(s): ${applicationDependencies.join(', ')}`);
                }
            }
        });
        this.sortedPackages = (0, xtrem_toposort_1.topoSort)(packsWithDependencies);
        logger.info(`Sorted packages: \n ${this.sortedPackages
            .map(p => {
            const dependencies = p.dependsOn?.map(d => `\t\t${d}`).join('\n');
            return `\t${p.name}\n\t\tDependencies\n${dependencies}`;
        })
            .join('\n')}`);
        return this.sortedPackages;
    }
    static async getPackages(connPool, x3Folder, serviceName) {
        if (this.packages)
            return this.packages;
        const result = await connPool
            .createTableReader(await x3_dictionary_helper_1.X3DictionaryHelper.getTableDefinition(connPool, x3Folder, 'APACKAGE'), [])
            .readAll();
        this.packages = await (0, xtrem_core_1.asyncArray)(result)
            .map(async (record) => {
            const owner = x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', record.AFACTORYOWN_0);
            const name = record.APACK_0;
            const isCustom = !name.startsWith('@sage/');
            const metadata = {
                name,
                description: record.ADES_0,
                isActive: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('boolean', record.ENAFLG_0),
                owner,
                serviceName,
                isCustom,
                module: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('integer', record.MODULE_0),
                activityCode: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', record.CODACT_0),
                isMain: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('boolean', record.MAINPACK_0),
                type: await this.getPackageType(connPool, x3Folder, x3_dictionary_helper_1.X3DictionaryHelper.fromSql('integer', record.TYPPACK_0)),
                linkedPackage1: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', record.LINKPACK1_0),
                linkedPackage2: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', record.LINKPACK2_0),
            };
            if (metadata.type === 'shared')
                metadata.isHidden = true;
            return metadata;
        })
            .toArray();
        return this.packages;
    }
}
exports.X3PackageDictionaryHelper = X3PackageDictionaryHelper;
//# sourceMappingURL=x3-package-dictionary-helper.js.map