import { Dict } from '@sage/xtrem-core';
import { Pool } from '@sage/xtrem-x3-sql';
import * as ts from 'typescript';
import { ApiNodeClassObject, ApiNodeExtensionClassObject, ImportEntry, JoinValue, ResolvedFilterValue } from './x3-dictionary-interfaces';
import { X3NodeClassGenerator } from './x3-node-class-generator';
import { X3PackageGenerator } from './x3-package-generator';
export declare class X3NodeGenerator {
    private readonly packageGenerator;
    private readonly connPool;
    private readonly x3FolderName;
    nodeDefinitions: Dict<string>;
    nodeExtensionDefinitions: Dict<string>;
    readonly x3NodeClassGenerator: X3NodeClassGenerator;
    constructor(packageGenerator: X3PackageGenerator, connPool: Pool, x3FolderName: string);
    addImport(name: string, importEntry: ImportEntry, isExtension: boolean): void;
    /**
     * Generate const join object that will be passed as a parameter to the X3StorageManagerExtension constructor
     * @param nodeObject
     * @param packageName package of proeprties to generate joins on
     * @returns
     */
    generateNodeExtensionJoinsObject(nodeExtensionObject: ApiNodeExtensionClassObject, packageName: string): Promise<ts.Node>;
    /**
     * Create the node from metadata
     * @param nodeObject
     * @returns
     */
    createNodeExtension(nodeExtensionObject: ApiNodeExtensionClassObject): Promise<string>;
    static getExpressionFromPath(targetNode: string, propertyPath: string[]): ts.PropertyAccessChain | ts.PropertyAccessExpression;
    private static generateNodeJoinPropertyPathTypeExpression;
    /**
     * Generate the join value for a literal type
     * @param joinValue
     * @param propName
     * @param nodeObject
     * @returns
     */
    generateNodeJoinTypeExpression(joinValue: JoinValue, propName: string, nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, isExtension: boolean): Promise<{
        expression: ts.Expression;
        hasAwait?: boolean;
    }>;
    /**
     * Resolve the join value based on the type.
     * @param nodeObject
     * @param propertyName
     * @param joinValue
     * @param useArrowFunctions
     * @returns
     */
    private resolveJoinValue;
    resolveFilterJoinValue(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, propertyName: string, joinValue: JoinValue, isExtension: boolean): Promise<ResolvedFilterValue>;
    /**
     * Get reference or collection join
     * @param nodeObject
     * @param packageName
     * @param propertyType
     * @returns
     */
    private getForeignJoins;
    static getFunctionFromExpression(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, expresionString: string, functionName: string): ts.MethodDeclaration;
    /**
     * Generate all localized string joins
     * @param nodeObject
     * @param packageName
     * @returns
     */
    getLocalizedStringJoins(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, packageName: string, isExtension: boolean): Promise<ts.ObjectLiteralExpression | undefined>;
    /**
     * Generate the reference, collection and localized string joins
     * @param nodeObject
     * @param packageName package property belongs to
     * @returns
     */
    generateNodeJoinsObjectProperties(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, packageName: string, isExtension: boolean): Promise<ts.ObjectLiteralElementLike[]>;
    /**
     * Generate const join object that will be passed as a parameter to the X3StorageManager constructor
     * @param nodeObject
     * @param packageName package of proeprties to generate joins on
     * @returns
     */
    generateNodeJoinsObject(nodeObject: ApiNodeClassObject, packageName: string): Promise<ts.Node>;
    static getCompositeReferencesObjLiteralExpression(compositeReferences: Dict<Dict<string>>): ts.PropertyAssignment[];
    static generateCompositeNodeReferenceObject(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, packageName: string, isExtension: boolean): ts.Node | undefined;
    /**
     * Generate const denormalized object that will be passed as a parameter to the X3StorageManager constructor
     * @param nodeObject
     * @param packageName package of proeprties to generate joins on
     * @returns
     */
    generateNodeDenormalizedObject(nodeObject: ApiNodeClassObject): ts.Node;
    /**
     * Import statements of a node files
     * @param name
     * @param currentPackageName
     * @returns
     */
    generateImportForNodeClass(name: string, currentPackageName: string, isExtension?: boolean): ts.Node[];
    /**
     * Create the node from metadata
     * @param nodeObject
     * @returns
     */
    createNode(nodeObject: ApiNodeClassObject): Promise<string>;
    /**
     * Generate the nodes of the package
     * @param nodeClassName
     */
    generateNodes(): Promise<void>;
    /**
     * Generate the nodes of the package
     * @param nodeClassName
     */
    generateNodeExtensions(): Promise<void>;
}
//# sourceMappingURL=x3-node-generator.d.ts.map