import { AnyValue } from '@sage/xtrem-shared';
import { Dict, Pool } from '@sage/xtrem-x3-sql';
import { AnodeDataModelBind, AnodeOperation, AnodeProperty, JoinValue, JoinValueType, NodeIndex, PropertyKind, PropertyType } from './x3-dictionary-interfaces';
export declare class X3NodeDictionaryHelper {
    private static readonly numberOfJoins;
    static anodePropertiesData: Dict<AnodeProperty[]>;
    private static globalVariableData;
    private static nodeData;
    private static denormalizeNodeData;
    static denormalizedNodeDbData: AnyValue[] | undefined;
    private static propertyDataDb;
    static nodeIndexDefinitions: Dict<NodeIndex[]> | undefined;
    private static nodeExtensionData;
    private static baseNodeOperations;
    private static nodeOperationProperties;
    static clearCache(): void;
    static getDenormalizedNodeData(connPool: Pool, x3Folder: string, nodeName: string): Promise<AnyValue[]>;
    static findDenormalizedNodeData(connPool: Pool, x3Folder: string, parent: AnodeDataModelBind): Promise<AnodeDataModelBind[]>;
    static findNodeData(connPool: Pool, x3Folder: string, nodeName: string): Promise<AnodeDataModelBind>;
    /**
     * Fills the node data in the dictionary.
     *
     * @param connPool The connection pool.
     * @param x3Folder The X3 folder.
     * @param nodeBindingType The node binding type.
     * @returns A promise that resolves when the node data is filled.
     */
    static fillNodeData(connPool: Pool, x3Folder: string, nodeBindingType: string): Promise<void>;
    static getAllNodeData(connPool: Pool, x3Folder: string): Promise<AnodeDataModelBind[]>;
    static getPropertyKind(propertyKind: string): PropertyKind | undefined;
    static getPropertyType(propertyType: number, nodeName?: string, propertyName?: string, propertyKind?: string): PropertyType;
    static getReferenceColumnType(connPool: Pool, x3Folder: string, property: AnodeProperty): Promise<PropertyType | undefined>;
    static getGlobalVariables(connPool: Pool, x3Folder: string): Promise<Dict<any>>;
    static getGlobalVariableValue(connPool: Pool, x3Folder: string, glVarName: string, columnName: string, tableName: string): Promise<any>;
    static getReferenceJoinValues(connPool: Pool, x3Folder: string, property: AnodeProperty, dbProp: any): Promise<JoinValue[]>;
    static getJoinValues(connPool: Pool, x3Folder: string, property: AnodeProperty, dbProp: any): Promise<JoinValue[]>;
    static getDenormalizedNodeKeyProperties(connPool: Pool, x3Folder: string, nodeData: AnodeDataModelBind, nodePackage: string): Promise<AnodeProperty[]>;
    private static getDenormalizedCollectionPropertyData;
    /**
     * Retrieve the property data at the end of a path
     * This walk searches and returns the raw DB property data
     * @param targetNode
     * @param path
     * @returns
     */
    private static getPropertyDataFromPath;
    /**
     * This walk searches and returns the list of activity codes for the given path.
     * @param targetNode
     * @param path
     * @returns
     */
    static getActivityCodesFromPath(connPool: Pool, x3Folder: string, nodeClassPropObject: AnodeProperty): Promise<string[]>;
    private static getPropertyDirection;
    /**
     * Determines the boolean value of a property argument's lookup access.
     *
     * This method evaluates the provided `mLookupAccess` and `aLookupAccess` arguments to determine
     * which value should be converted to a boolean using the `fromSql` method. If `mLookupAccess` is
     * neither `'0'` nor `null`, it is used for the conversion. Otherwise, if `mLookupAccess` is `'0'`
     * or `null`, `aLookupAccess` is used. If neither condition is met, the method returns `false`.
     *
     * @param mLookupAccess - The manual lookup access value, which may be a string or null.
     * @param aLookupAccess - The automatic lookup access value, used as a fallback when conditions for `mLookupAccess` are not met.
     * @returns A boolean indicating the resolved lookup access.
     */
    private static getPropertyArgumentLookupAccess;
    private static getCompositePropertyDerivedInfo;
    static computedDependsOnSplit(dbProp: any): string[] | undefined;
    private static fillComputedProperty;
    private static fillEnumProperty;
    private static fillPropertyProvides;
    private static fillReferenceProperty;
    private static fillReferenceLookup;
    static buildPropertyFromDbDefinition(connPool: Pool, x3Folder: string, dbProp: any, nodePackage: string, options?: {
        fromOperation?: boolean;
    }): Promise<AnodeProperty>;
    static getPropertyData(connPool: Pool, x3Folder: string): Promise<any[]>;
    static getNodeProperties(connPool: Pool, x3Folder: string, nodeName: string, nodeBinding: string, nodePackage: string): Promise<AnodeProperty[]>;
    static getJoinType(result: string): JoinValueType;
    static getNodeIndexDefinitions(connPool: Pool, x3Folder: string): Promise<Dict<NodeIndex[]>>;
    static getNodeIndexes(connPool: Pool, x3Folder: string, nodeName: string): Promise<NodeIndex[]>;
    static getNodePrimaryIndex(connPool: Pool, x3Folder: string, nodeName: string): Promise<NodeIndex>;
    static getNodeExtensionData(connPool: Pool, x3Folder: string): Promise<{
        nodeName: string;
        nodePackage: string;
        nodeBinding: string;
        package: string;
        tableName: string;
    }[]>;
    static expandPropertyPath(targetNode: string, path: string[]): string[];
    static getPropertyFromPath(targetNode: string, path: string[]): AnodeProperty;
    static getComposedPropertyFromPath(composedProperty: AnodeProperty): AnodeProperty;
    private static getOperationMethod;
    private static getOperationType;
    static getBaseNodeOperations(connPool: Pool, x3Folder: string): Promise<AnodeOperation[]>;
    static getOperationNodeProperties(connPool: Pool, x3Folder: string, nodeBinding: string): Promise<AnodeProperty[]>;
}
//# sourceMappingURL=x3-node-dictionary-helper.d.ts.map