import { Dict, Pool } from '@sage/xtrem-x3-sql';
import { BaseLocalMenuValue, LocalMenuDefinition, LocalMenuHeader, LocalMenuValue, MetadataPackage, TranslationLocalMenuLanguageValues } from './x3-dictionary-interfaces';
export declare class X3LocalMenuDictionaryHelper {
    private static customLocalMenuRanges;
    static getCustomLocalMenuRanges(connPool: Pool, x3Folder: string): Promise<{
        from: number;
        to: number;
    }[]>;
    static isCustomLocalMenu(connPool: Pool, x3Folder: string, localMenuNumber: number): Promise<boolean>;
    private static localMenuHeaderData;
    private static localMenusPerPackage;
    private static localMenuValueOverrideDbData;
    private static localMenuValues;
    private static localMenus;
    static localMenuHeaders: Dict<LocalMenuHeader>;
    private static translationsLocalMenuDefinitions;
    static clearCache(): void;
    /**
     * Query the header of local menues
     *
     * Passing 'currentPackage' parameter limits the search to the current package
     * and is used for generation/update i18n translation files
     *
     * @param connPool
     * @param x3Folder
     * @param currentPackage optional parameter for i18n translation files generator
     * @returns
     */
    static loadLocalMenuHeaders(connPool: Pool, x3Folder: string): Promise<any[]>;
    private static buildLocalMenuHeader;
    private static setPackageLocalMenuHeader;
    static isValidLocalMenu(record: any, packageDefinition: MetadataPackage): boolean;
    /**
     * Load all the relevant local menues of a package that relate to a node property
     * @param connPool
     * @param x3Folder
     * @param packageName
     * @returns
     */
    static loadPackageLocalMenuHeaders(connPool: Pool, x3Folder: string, packageDefinition: MetadataPackage): Promise<Dict<LocalMenuHeader>>;
    /**
     * Get the header details of an enum
     * @param connPool
     * @param x3Folder
     * @param localMenuNumber
     * @returns
     */
    static getLocalMenuHeader(connPool: Pool, x3Folder: string, localMenuNumber: number, packageDefinition: MetadataPackage): Promise<LocalMenuHeader>;
    static getLocalMenuValueOverrideDbData(connPool: Pool, x3Folder: string): Promise<any[]>;
    static getLocalMenuValueOverride(connPool: Pool, x3Folder: string, localMenuNumber: number, valueNumber: number): Promise<{
        value: string;
        packageName?: string;
    } | undefined>;
    static getLocalMenuValues(connPool: Pool, x3Folder: string, localMenuNumber: number, language: string, valueNumber?: number): Promise<BaseLocalMenuValue[]>;
    static fixName(name: string): string;
    static getLocalMenuValueTranslations(connPool: Pool, x3Folder: string, localMenuNumber: number, language?: string): Promise<LocalMenuValue[]>;
    /**
     * Get the list of numeric values and string keys of a local menu to be used in the enum definition
     * @param connPool
     * @param x3Folder
     * @param localMenuNumber
     * @param valueNumber
     * @param language
     * @returns
     */
    static getLocalMenuValue(connPool: Pool, x3Folder: string, localMenuNumber: number, valueNumber: number, language?: string): Promise<LocalMenuValue>;
    /**
     * Get local menu defintion that will be used to generate the enum definition
     * @param connPool
     * @param x3Folder
     * @param localMenuNumber
     * @param currentPackage
     * @returns
     */
    static getLocalMenuDefinition(connPool: Pool, x3Folder: string, localMenuNumber: number, currentPackage: MetadataPackage): Promise<LocalMenuDefinition>;
    static getPackageFromHeader(localMenuDefinition: LocalMenuHeader, options?: {
        doNotThrow?: true;
    }): string | undefined;
    /**
     * Get local menu definition that will be used to generate the enum definition
     * @param connPool
     * @param x3Folder
     * @param localMenuNumber
     * @param currentPackage
     * @returns
     */
    static getTranslationLocalMenuDefinition(connPool: Pool, x3Folder: string, localMenuNumber: number, currentPackage: MetadataPackage): Promise<TranslationLocalMenuLanguageValues>;
}
//# sourceMappingURL=x3-local-menu-dictionary-helper.d.ts.map