import { ImportEntry, LocalMenuDefinition, LocalMenuValue } from './x3-dictionary-interfaces';
import { X3PackageGenerator } from './x3-package-generator';
export declare class X3EnumGenerator {
    private readonly packageGenerator;
    private readonly localMenuDefinition;
    constructor(packageGenerator: X3PackageGenerator, localMenuDefinition: LocalMenuDefinition);
    addImport(importEntry: ImportEntry): void;
    get name(): string;
    get rootName(): string;
    get enumName(): string;
    get dataTypeName(): string;
    get rootDataTypeName(): string;
    get isCustom(): boolean;
    get rootPackageName(): string;
    /**
     * Then the current package is one the extension packages this instance will be manages as an enum extension.
     */
    get isExtension(): boolean;
    get localMenuNumber(): number;
    get filename(): string;
    get rootFilename(): string;
    get filepath(): string;
    get extensionFilepath(): string;
    get interfaceName(): string;
    /**
     * The local menu values relevant to the current package.
     */
    get values(): LocalMenuValue[];
    private getEnumPropertySignatures;
    private getEnumInterface;
    private getEnumDeclaration;
    private getTypeAliasDeclaration;
    private getDataTypeDeclaration;
    private generateImportForEnum;
    private enumDefinition;
    /**
     * Create the node from metadata
     * @param nodeObject
     * @returns
     */
    createEnum(): string;
    generateEnum(): void;
    private enumExtensionDefinition;
    createEnumExtension(): string;
    generateEnumExtension(): void;
    private static resetDirectory;
    private static generateIndexFile;
    static generatePackageEnums(packageGenerator: X3PackageGenerator): Promise<void>;
}
//# sourceMappingURL=x3-enum-generator.d.ts.map