"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageI18nMigration = void 0;
exports.infoMessageI18nMigration = infoMessageI18nMigration;
exports.warnMessageI18nMigration = warnMessageI18nMigration;
const xtrem_log_1 = require("@sage/xtrem-log");
const logger = xtrem_log_1.Logger.getLogger(__filename, 'x3-translation-migration');
var MessageI18nMigration;
(function (MessageI18nMigration) {
    MessageI18nMigration["NEW"] = "NEW";
    MessageI18nMigration["UPDATE"] = "UPDATE";
    MessageI18nMigration["NOT_FOUND"] = "NOT FOUND";
    MessageI18nMigration["SET_ENV"] = "SET ENV";
})(MessageI18nMigration || (exports.MessageI18nMigration = MessageI18nMigration = {}));
function infoMessageI18nMigration(status, i18nKey, i18nValue, customMessage) {
    const fullMessage = [status, i18nKey, i18nValue, customMessage].join(' | ');
    logger.info(fullMessage);
}
function warnMessageI18nMigration(status, i18nKey, i18nValue, customMessage) {
    const fullMessage = [status, i18nKey, i18nValue, customMessage].join(' | ');
    logger.warn(fullMessage);
}
//# sourceMappingURL=x3-translations-migration-logger.js.map