import type { integration } from '@sage/xtrem-ui';
import * as React from 'react';
import type { EndpointOption, Profile } from '../service/profile-schema';
export interface SettingsPageProps {
    profile: Profile | null;
    menuItems: integration.Menu[];
    updateSoundDisabled: (isSoundDisabled: boolean) => Promise<void>;
}
export interface SettingsPageState {
    infoMessageIgnored: boolean;
    endpointsOpen: boolean;
}
export declare class SettingsPage extends React.Component<SettingsPageProps, SettingsPageState> {
    constructor(props: SettingsPageProps);
    onInfoDismiss: () => void;
    static onLogout: () => void;
    getFirstName: () => string;
    getLastName: () => string;
    getNames: () => string[];
    getProfilePicture: () => string;
    getEndpoint: () => string;
    toggleEndpoints: () => void;
    selectEndpoint: (endpoint: EndpointOption) => () => void;
    soundOnChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof SettingsPage, {
    ref?: React.LegacyRef<SettingsPage> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=settings-page.d.ts.map