import { integration } from '@sage/xtrem-ui';
import * as React from 'react';
import type { Profile } from '../service/profile-schema';
export interface MainPageProps {
    profile: Profile | null;
    path: string;
    goHome: () => void;
    onInternalNavigationChange: (path: string) => void;
    setPageTitle: (newTitle: string, newSubtitle: string | null) => void;
    setMenuItems: (menuItems: integration.Menu[]) => void;
    onDirtyStatusChange: (isApplicationDirty: boolean, preNavigationConfirmation: () => Promise<void>) => void;
}
export interface MainPageState {
    applicationContext: Partial<integration.ApplicationContext>;
    sessionExpired: boolean;
}
export declare class MainPage extends React.Component<MainPageProps, MainPageState> {
    constructor(props: MainPageProps);
    componentDidMount(): void;
    componentWillUnmount(): void;
    onKeyDown: (event: KeyboardEvent) => void;
    handleLoginRedirect: () => void;
    renderSessionExpiredDialog(): React.ReactElement;
    render(): React.ReactNode | null;
}
declare const _default: import("react-redux").ConnectedComponent<typeof MainPage, {
    ref?: React.LegacyRef<MainPage> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=main-page.d.ts.map