/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Pool=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared");class Pool{constructor(e,t){this.logger=t,this.connections=[],this.usePool=!!e.usePool,this.config=e}async withConnection(e){const t=await this.allocConnection();try{return await e(t)}finally{await this.releaseConnection(t)}}async closeConnections(){await(0,xtrem_async_helper_1.asyncArray)(this.connections).forEach(async e=>{e&&await this.closeConnection(e)}),this.connections=[]}async allocConnection(){const e=this.config.connectionMaxRetries||3,t=this.config.connectionRetryMillis||15e3;let o="";for(let n=1;n<=e;n+=1)try{let e=this.connections.pop();if(e=this.checkConnection(e),!e)this.logger?.debug(()=>`Connections in pool ${this.connections.length}`),e=await this.createConnection();return e}catch(s){this.logger&&this.logger.error(`Retry: try number ${n}/${e}: Error \r\n${JSON.stringify(s)}`),o+=`${s?.response?.data?.error||s.message||JSON.stringify(s)}\r\n\r\n`,await new Promise(e=>{setTimeout(e,t)})}throw new xtrem_shared_1.SystemError(o)}async releaseConnection(e,t){if(t)this.logger&&this.logger.error(t.stack),await this.closeConnection(e);else if(this.usePool&&this.connections.length<=(this.config.poolSize||10))this.connections.push(e);else await this.closeConnection(e);return}createTableReader(e,t){if(!e.columns)throw new Error("Must call readTableSchema() before.");let o,n=`SELECT ${e.columns.map(e=>"postgres"===this.dialect?`T.${e.name} "${e.name.toUpperCase()}"`:`T.${e.name}`).join(",")} FROM ${this.getFullTableDefName(e)} T`;if(t)o=[],t.forEach((e,t)=>{if(0===t)n+=" WHERE ";else n+=" AND ";n+=`(T.${e.key} ${e.operator} ${this.param(t)})`,o.push(e.value)});if(e.indexes){const t=e.indexes.filter(e=>e.isUnique)[0];if(t)t.columns.forEach((e,t)=>{if(0===t)n+=" ORDER BY ";else n+=", ";n+=`T.${e.name}`})}return this.reader(n,o)}}exports.Pool=Pool;
//# sourceMappingURL=pool.js.map