/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.serviceOptions=exports.nodes=exports.dataTypes=void 0;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),dataTypes=require("./data-types/_index");exports.dataTypes=dataTypes;const testNodes=require("./nodes/_index"),serviceOptions=require("./service-options");exports.serviceOptions=serviceOptions;const fixtures=(0,xtrem_core_1.getTestFixtures)();fixtures.updateContext();const{TestOperation,TestOperationReference}=fixtures.nodes;class TestTenantManager{initializeManager(){}async ensureTenantExists(e,t){await e.application.asRoot.withCommittedContext(t.tenant.id,async e=>{let a=await e.tryRead(testNodes.SysTenant,{tenantId:t.tenant.id},{forUpdate:true});if(!a)a=await e.create(testNodes.SysTenant,{tenantId:t.tenant.id,name:t.tenant.name}),await a.$.save();await xtrem_core_1.Context.accessRightsManager.createRequiredUsers(e)},{withoutTransactionUser:true}),await e.application.asRoot.withCommittedContext(t.tenant.id,async e=>{if(!await e.tryRead(xtrem_core_1.TestUser,{email:"unit.test@acme.com"})){const t=await e.create(xtrem_core_1.TestUser,{email:"unit.test@acme.com",firstName:"Unit",lastName:"Test",isActive:true,isAdministrator:true});await t.$.save()}})}async listTenantsIds(e){const t=await e.query(testNodes.SysTenant).toArray();return(0,xtrem_core_1.asyncArray)(t).map(e=>e.tenantId).toArray()}async getTenantsInfo(e,t){const a=t?{filter:{tenantId:t}}:void 0,s=await e.query(testNodes.SysTenant,a).toArray();return(0,xtrem_core_1.asyncArray)(s).map(async e=>({id:await e.tenantId,name:await e.name,directoryName:"",customer:{id:await e.tenantId,name:await e.name}})).toArray()}async deleteTenant(e,t){const a=e.getAllSortedFactories().reverse();await e.withCommittedContext(null,async e=>{await e.executeSql("SET CONSTRAINTS ALL DEFERRED",[]),await(0,xtrem_core_1.asyncArray)(a).forEach(async a=>{if(a.isSharedByAllTenants)return;if(typesLib.strictNe(a.storage,"sql"))return;if(!await a.table.tableExists(e))return;await e.executeSql(`DELETE FROM ${e.application.schemaName}.${a.table.name} WHERE _tenant_id=$1`,[t])}),await e.executeSql(`DELETE FROM ${e.application.schemaName}.sys_tenant WHERE tenant_id=$1`,[t])})}}xtrem_core_1.Context.tenantManager=new TestTenantManager;const nodes={TestUser:xtrem_core_1.TestUser,TestSysVendor:xtrem_core_1.TestSysVendor,TestOperation,TestOperationReference,...testNodes};exports.nodes=nodes;
//# sourceMappingURL=test-application.js.map