/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MetadataHelper=void 0;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),i18n=require("@sage/xtrem-i18n"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash");class MetadataHelper{static getLocalizedTitles(e,a){return _.zipObject(xtrem_shared_1.supportedLocales,xtrem_shared_1.supportedLocales.map(t=>{try{return(0,xtrem_i18n_1.localizedText)(e,a,{},t)}catch{return _.startCase(a)}}))}static{this.dataByNode={}}static async loadPackages(e){const a=await e.getActivePackageNames(),{application:t}=e;this.dataByNode.MetaPackage=[],this.packages=_.mapValues(t.packagesByName,e=>{const t={_id:e.name,name:e.name,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),e.name),isActive:a.includes(e.name)};return this.dataByNode.MetaPackage.push(t),t})}static loadServiceOptions(e){const{application:a}=e,t=a.serviceOptionsByName;this.dataByNode.MetaServiceOption=[],this.serviceOptions=_.mapValues(t,(e,a)=>{const t={...e,_id:a,name:a,package:e.packageName,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),a)};return this.dataByNode.MetaServiceOption.push(t),t})}static loadDatatypes(e){const{application:a}=e,localize=(e,a)=>this.getLocalizedTitles(e,a)||{base:a};this.dataByNode.MetaDataType=[],this.dataTypes=_.mapValues(a.dataTypes,(e,t)=>{const i=e.getMetaData({application:a,localize}),s={_id:t,definingPackage:e.pack||"",name:t,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),t),type:e.type,attributes:{...e?.dataTypeOptions?.(),...i},serviceOptionNames:e.serviceOptions?.map(e=>e.name)||null};return this.dataByNode.MetaDataType.push(s),s})}static getOperationLocalizedTitleKey(e,a){const t=a.definingPackage?.name||"";return i18n.getKey({isExtension:typesLib.strictNe(t,e.package.name),nodeName:e.name,packageName:t,operation:{name:a.name,kind:a.operationKind}})}static loadNodeFactories(e){const{application:a}=e,t=a.getAllFactories();this.dataByNode.MetaNodeFactory=[],this.dataByNode.MetaNodeProperty=[],this.dataByNode.MetaNodeOperation=[],this.factories={},this.properties={},this.operations={},t.forEach(e=>{const a=[...e.mutations,...e.queries];this.factories[e.name]={_id:e.name,name:e.name,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),e.name),package:e.package.name,isPublished:e.isPublished,isAbstract:e.isAbstract,isCached:e.isCached,extends:null,storage:e.storage,isSharedByAllTenants:e.isSharedByAllTenants,isSetupNode:e.isSetupNode,isPlatformNode:e.isPlatformNode,isVitalReferenceChild:e.isVitalReferenceChild,isVitalCollectionChild:e.isVitalCollectionChild,isCustomizable:e.isCustomizable,isSynchronizable:e.isSynchronizable,isSynchronized:e.isSynchronized,serviceOptionNames:e.serviceOptions?.map(e=>e.name)||null,properties:e.properties.map(a=>`${e.name}|${a.name}`),operations:a.map(a=>`${e.name}|${a.name}`),naturalKey:e.naturalKey??null,isClearedByReset:!!e.isClearedByReset,canCreate:e.canCreate,canDelete:e.canDelete,canUpdate:e.canUpdate,canDuplicate:e.canDuplicate},this.dataByNode.MetaNodeFactory.push(this.factories[e.name]),e.properties.forEach(a=>{this.properties[`${e.name}|${a.name}`]={_id:`${e.name}|${a.name}`,factory:e.name,name:a.name,title:this.getLocalizedTitles(a.getLocalizedTitleKey(),a.name),package:a.definingPackage.name??e.package.name,serviceOptionNames:a.serviceOptions?.map(e=>e.name)||null,type:a.type,dataType:a.dataType?.name,dependencyIndex:a.dependencyIndex||-1,isPublished:a.isPublished,isStored:a.isStored,isTransientInput:a.isTransientInput,isStoredOutput:a.isStoredOutput,isRequired:a.isRequired,isNullable:a.isNullable,targetFactory:a.isForeignNodeProperty()?a.targetFactory.name:null,reverseReference:a.reverseReference??null,isVital:a.isVital,isVitalParent:a.isVitalParent,isInherited:a.isInherited,canSort:a.canSort,canFilter:a.canFilter,isOnInputType:a.isOnInputType,isOnOutputType:a.isOnOutputType,isMutable:a.isMutable,hasDefaultValue:typesLib.strictNe(a.defaultValue,void 0)},this.dataByNode.MetaNodeProperty.push(this.properties[`${e.name}|${a.name}`])}),a.forEach(a=>{this.operations[`${e.name}|${a.name}`]={_id:`${e.name}|${a.name}`,factory:e.name,name:a.name,title:this.getLocalizedTitles(this.getOperationLocalizedTitleKey(e,a),a.name),package:a.definingPackage?.name??e.package.name,serviceOptionNames:a.serviceOptions?.().map(e=>e.name)||null,kind:a.operationKind,action:a.action?a.action:null,isPublished:!!a.isPublished,isSchedulable:!!a.isSchedulable,isMutation:!!e.mutations.find(e=>typesLib.strictEq(e.name,a.name)),parameters:a.parameters,return:a.return,signature:(0,xtrem_core_1.friendlyOperationSignature)(a),topic:""},this.dataByNode.MetaNodeOperation.push(this.operations[`${e.name}|${a.name}`])})})}static async getIsActiveValue(e,a,t){if(typesLib.eq(a.propertiesByName.isActive,null))return;const{serviceOptionsByName:i}=e.application,isServiceOptionActive=a=>{const t=i[a];return t?e.isServiceOptionActiveSync(t):false};switch(a.name){case"MetaPackage":return(await e.getActivePackageNames()).includes(t.name);case"MetaServiceOption":return isServiceOptionActive(t.name);case"MetaDataType":case"MetaNodeFactory":case"MetaNodeProperty":case"MetaNodeOperation":{const e=t,{serviceOptionNames:a}=e;if(!a||typesLib.strictEq(a.length,0))return true;return Promise.resolve(a.every(isServiceOptionActive))}default:return}}static async loadMetadataStorage(e){await this.loadPackages(e),this.loadServiceOptions(e),this.loadDatatypes(e),this.loadNodeFactories(e)}}exports.MetadataHelper=MetadataHelper;
//# sourceMappingURL=metadata-helper.js.map