import { Context, Dict, NodeFactory } from '@sage/xtrem-core';
import { MetaArtifacts, MetaDataType, MetaNodeFactory, MetaNodeOperation, MetaNodeProperty, MetaPackage, MetaServiceOption } from './metadata-interfaces';
export declare class MetadataHelper {
    private static getLocalizedTitles;
    static dataByNode: Dict<MetaArtifacts[]>;
    static packages: Dict<MetaPackage>;
    static loadPackages(context: Context): Promise<void>;
    static serviceOptions: Dict<MetaServiceOption>;
    static loadServiceOptions(context: Context): void;
    static dataTypes: Dict<MetaDataType>;
    static loadDatatypes(context: Context): void;
    static factories: Dict<MetaNodeFactory>;
    static properties: Dict<MetaNodeProperty>;
    static operations: Dict<MetaNodeOperation>;
    private static getOperationLocalizedTitleKey;
    static loadNodeFactories(context: Context): void;
    static getIsActiveValue(context: Context, factory: NodeFactory, value: MetaArtifacts): Promise<boolean | undefined>;
    static loadMetadataStorage(context: Context): Promise<void>;
}
//# sourceMappingURL=metadata-helper.d.ts.map