/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";var __decorate=this&&this.__decorate||function(e,t,r,o){var a,i=arguments.length,d=i<3?t:null===o?o=Object.getOwnPropertyDescriptor(t,r):o;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)d=Reflect.decorate(e,t,r,o);else for(var s=e.length-1;s>=0;s--)if(a=e[s])d=(i<3?a(d):i>3?a(t,r,d):a(t,r))||d;return i>3&&d&&Object.defineProperty(t,r,d),d};Object.defineProperty(exports,"__esModule",{value:true}),exports.MetaNodeOperation=void 0;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtremAppMetadata=require(".."),metadata_storage_manager_1=require("../services/metadata-storage-manager");let MetaNodeOperation=class MetaNodeOperation extends xtrem_core_1.Node{};exports.MetaNodeOperation=MetaNodeOperation,__decorate([xtrem_core_1.decorators.referenceProperty({isStored:true,isPublished:true,isVitalParent:true,node:()=>xtremAppMetadata.nodes.MetaNodeFactory,lookupAccess:true})],MetaNodeOperation.prototype,"factory",void 0),__decorate([xtrem_core_1.decorators.stringProperty({isStored:true,isPublished:true,dataType:()=>xtremAppMetadata.dataTypes.metadataName,lookupAccess:true})],MetaNodeOperation.prototype,"name",void 0),__decorate([xtrem_core_1.decorators.stringProperty({isStored:true,isPublished:true,dataType:()=>xtremAppMetadata.dataTypes.metadataTitle,lookupAccess:true})],MetaNodeOperation.prototype,"title",void 0),__decorate([xtrem_core_1.decorators.referenceProperty({isStored:true,isPublished:true,node:()=>xtremAppMetadata.nodes.MetaPackage,lookupAccess:true})],MetaNodeOperation.prototype,"package",void 0),__decorate([xtrem_core_1.decorators.jsonProperty({isStored:true,isPublished:true})],MetaNodeOperation.prototype,"serviceOptionNames",void 0),__decorate([xtrem_core_1.decorators.referenceArrayProperty({isPublished:true,dependsOn:["serviceOptionNames"],node:()=>xtremAppMetadata.nodes.MetaServiceOption,async computeValue(){const e=Object.values(await this.serviceOptionNames??{});if(!e||typesLib.strictEq(e.length,0))return[];return this.$.context.query(xtremAppMetadata.nodes.MetaServiceOption,{filter:{name:{_in:e}}}).toArray()}})],MetaNodeOperation.prototype,"serviceOptions",void 0),__decorate([xtrem_core_1.decorators.booleanProperty({isStored:true,isPublished:true,provides:["isActive"]})],MetaNodeOperation.prototype,"isActive",void 0),__decorate([xtrem_core_1.decorators.enumProperty({isStored:true,isPublished:true,dataType:()=>xtremAppMetadata.enums.operationKindDataType})],MetaNodeOperation.prototype,"kind",void 0),__decorate([xtrem_core_1.decorators.enumProperty({isStored:true,isPublished:true,isNullable:true,allowedInUniqueIndex:true,dataType:()=>xtremAppMetadata.enums.operationActionDataType})],MetaNodeOperation.prototype,"action",void 0),__decorate([xtrem_core_1.decorators.booleanProperty({isStored:true,isPublished:true})],MetaNodeOperation.prototype,"isPublished",void 0),__decorate([xtrem_core_1.decorators.booleanProperty({isStored:true,isPublished:true})],MetaNodeOperation.prototype,"isSchedulable",void 0),__decorate([xtrem_core_1.decorators.booleanProperty({isStored:true,isPublished:true})],MetaNodeOperation.prototype,"isMutation",void 0),__decorate([xtrem_core_1.decorators.jsonProperty({isPublished:true,async getValue(){return(await this.signature).parameters}})],MetaNodeOperation.prototype,"parameters",void 0),__decorate([xtrem_core_1.decorators.jsonProperty({isPublished:true,async getValue(){return(await this.signature).return}})],MetaNodeOperation.prototype,"return",void 0),__decorate([xtrem_core_1.decorators.jsonProperty({isStored:true,isPublished:true})],MetaNodeOperation.prototype,"signature",void 0),__decorate([xtrem_core_1.decorators.stringProperty({isPublished:true,dataType:()=>xtremAppMetadata.dataTypes.metadataName,async getValue(){return`${await(await this.factory).name}/${await this.name}`}})],MetaNodeOperation.prototype,"topic",void 0),exports.MetaNodeOperation=MetaNodeOperation=__decorate([xtrem_core_1.decorators.node({isPublished:true,storage:"external",externalStorageManager:new metadata_storage_manager_1.MetadataStorageManager,isSharedByAllTenants:true,isCached:true,isPlatformNode:true,isVitalCollectionChild:true,canCreate:true,canRead:true,canUpdate:true,canDeleteMany:true,keyPropertyNames:["factory","name","action"],indexes:[{orderBy:{factory:1,name:1,action:1},isUnique:true,isNaturalKey:true}],isFrozen:true})],MetaNodeOperation);
//# sourceMappingURL=meta-node-operation.js.map