import { Collection, Dict, Node, Reference } from '@sage/xtrem-core';
import { MetaCustomField } from '@sage/xtrem-shared';
import * as xtremAppMetadata from '../index';
export declare class MetaNodeFactory extends Node {
    readonly name: Promise<string>;
    readonly title: Promise<string>;
    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
    readonly isActive: Promise<boolean>;
    readonly isPublished: Promise<boolean>;
    readonly isAbstract: Promise<boolean>;
    readonly extends: Reference<MetaNodeFactory | null>;
    readonly storage: Promise<xtremAppMetadata.enums.MetaStorage>;
    readonly isSharedByAllTenants: Promise<boolean>;
    readonly isSetupNode: Promise<boolean>;
    readonly isPlatformNode: Promise<boolean>;
    readonly isVitalReferenceChild: Promise<boolean>;
    readonly isVitalCollectionChild: Promise<boolean>;
    readonly isCustomizable: Promise<boolean>;
    readonly isSynchronizable: Promise<boolean>;
    readonly isSynchronized: Promise<boolean>;
    readonly isClearedByReset: Promise<boolean>;
    readonly canCreate: Promise<boolean>;
    readonly canUpdate: Promise<boolean>;
    readonly canDelete: Promise<boolean>;
    readonly canDuplicate: Promise<boolean>;
    readonly serviceOptionNames: Promise<Dict<string>>;
    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[] | null>;
    readonly naturalKey: Promise<string[] | null>;
    readonly customFields: Promise<MetaCustomField[]>;
    readonly properties: Collection<xtremAppMetadata.nodes.MetaNodeProperty>;
    readonly operations: Collection<xtremAppMetadata.nodes.MetaNodeOperation>;
    getNode(): Promise<typeof Node>;
}
//# sourceMappingURL=meta-node-factory.d.ts.map