/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../../../node_modules/.pnpm/@floating-ui+core@1.7.1/node_modules/@floating-ui/core/dist/floating-ui.core.mjs":
/*!********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@floating-ui+core@1.7.1/node_modules/@floating-ui/core/dist/floating-ui.core.mjs ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   computePosition: () => (/* binding */ computePosition),\n/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   rectToClientRect: () => (/* reexport safe */ _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ \"../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\");\n\n\n\nfunction computeCoordsFromPlacement(_ref, placement, rtl) {\n  let {\n    reference,\n    floating\n  } = _ref;\n  const sideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);\n  const alignmentAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);\n  const alignLength = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(alignmentAxis);\n  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n  const isVertical = sideAxis === 'y';\n  const commonX = reference.x + reference.width / 2 - floating.width / 2;\n  const commonY = reference.y + reference.height / 2 - floating.height / 2;\n  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;\n  let coords;\n  switch (side) {\n    case 'top':\n      coords = {\n        x: commonX,\n        y: reference.y - floating.height\n      };\n      break;\n    case 'bottom':\n      coords = {\n        x: commonX,\n        y: reference.y + reference.height\n      };\n      break;\n    case 'right':\n      coords = {\n        x: reference.x + reference.width,\n        y: commonY\n      };\n      break;\n    case 'left':\n      coords = {\n        x: reference.x - floating.width,\n        y: commonY\n      };\n      break;\n    default:\n      coords = {\n        x: reference.x,\n        y: reference.y\n      };\n  }\n  switch ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement)) {\n    case 'start':\n      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);\n      break;\n    case 'end':\n      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);\n      break;\n  }\n  return coords;\n}\n\n/**\n * Computes the `x` and `y` coordinates that will place the floating element\n * next to a given reference element.\n *\n * This export does not have any `platform` interface logic. You will need to\n * write one for the platform you are using Floating UI with.\n */\nconst computePosition = async (reference, floating, config) => {\n  const {\n    placement = 'bottom',\n    strategy = 'absolute',\n    middleware = [],\n    platform\n  } = config;\n  const validMiddleware = middleware.filter(Boolean);\n  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));\n  let rects = await platform.getElementRects({\n    reference,\n    floating,\n    strategy\n  });\n  let {\n    x,\n    y\n  } = computeCoordsFromPlacement(rects, placement, rtl);\n  let statefulPlacement = placement;\n  let middlewareData = {};\n  let resetCount = 0;\n  for (let i = 0; i < validMiddleware.length; i++) {\n    const {\n      name,\n      fn\n    } = validMiddleware[i];\n    const {\n      x: nextX,\n      y: nextY,\n      data,\n      reset\n    } = await fn({\n      x,\n      y,\n      initialPlacement: placement,\n      placement: statefulPlacement,\n      strategy,\n      middlewareData,\n      rects,\n      platform,\n      elements: {\n        reference,\n        floating\n      }\n    });\n    x = nextX != null ? nextX : x;\n    y = nextY != null ? nextY : y;\n    middlewareData = {\n      ...middlewareData,\n      [name]: {\n        ...middlewareData[name],\n        ...data\n      }\n    };\n    if (reset && resetCount <= 50) {\n      resetCount++;\n      if (typeof reset === 'object') {\n        if (reset.placement) {\n          statefulPlacement = reset.placement;\n        }\n        if (reset.rects) {\n          rects = reset.rects === true ? await platform.getElementRects({\n            reference,\n            floating,\n            strategy\n          }) : reset.rects;\n        }\n        ({\n          x,\n          y\n        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));\n      }\n      i = -1;\n    }\n  }\n  return {\n    x,\n    y,\n    placement: statefulPlacement,\n    strategy,\n    middlewareData\n  };\n};\n\n/**\n * Resolves with an object of overflow side offsets that determine how much the\n * element is overflowing a given clipping boundary on each side.\n * - positive = overflowing the boundary by that number of pixels\n * - negative = how many pixels left before it will overflow\n * - 0 = lies flush with the boundary\n * @see https://floating-ui.com/docs/detectOverflow\n */\nasync function detectOverflow(state, options) {\n  var _await$platform$isEle;\n  if (options === void 0) {\n    options = {};\n  }\n  const {\n    x,\n    y,\n    platform,\n    rects,\n    elements,\n    strategy\n  } = state;\n  const {\n    boundary = 'clippingAncestors',\n    rootBoundary = 'viewport',\n    elementContext = 'floating',\n    altBoundary = false,\n    padding = 0\n  } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n  const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n  const altContext = elementContext === 'floating' ? 'reference' : 'floating';\n  const element = elements[altBoundary ? altContext : elementContext];\n  const clippingClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(await platform.getClippingRect({\n    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),\n    boundary,\n    rootBoundary,\n    strategy\n  }));\n  const rect = elementContext === 'floating' ? {\n    x,\n    y,\n    width: rects.floating.width,\n    height: rects.floating.height\n  } : rects.reference;\n  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));\n  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {\n    x: 1,\n    y: 1\n  } : {\n    x: 1,\n    y: 1\n  };\n  const elementClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({\n    elements,\n    rect,\n    offsetParent,\n    strategy\n  }) : rect);\n  return {\n    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,\n    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,\n    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,\n    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x\n  };\n}\n\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * @see https://floating-ui.com/docs/arrow\n */\nconst arrow = options => ({\n  name: 'arrow',\n  options,\n  async fn(state) {\n    const {\n      x,\n      y,\n      placement,\n      rects,\n      platform,\n      elements,\n      middlewareData\n    } = state;\n    // Since `element` is required, we don't Partial<> the type.\n    const {\n      element,\n      padding = 0\n    } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state) || {};\n    if (element == null) {\n      return {};\n    }\n    const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n    const coords = {\n      x,\n      y\n    };\n    const axis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);\n    const length = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(axis);\n    const arrowDimensions = await platform.getDimensions(element);\n    const isYAxis = axis === 'y';\n    const minProp = isYAxis ? 'top' : 'left';\n    const maxProp = isYAxis ? 'bottom' : 'right';\n    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';\n    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];\n    const startDiff = coords[axis] - rects.reference[axis];\n    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));\n    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;\n\n    // DOM platform can return `window` as the `offsetParent`.\n    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {\n      clientSize = elements.floating[clientProp] || rects.floating[length];\n    }\n    const centerToReference = endDiff / 2 - startDiff / 2;\n\n    // If the padding is large enough that it causes the arrow to no longer be\n    // centered, modify the padding so that it is centered.\n    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;\n    const minPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[minProp], largestPossiblePadding);\n    const maxPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[maxProp], largestPossiblePadding);\n\n    // Make sure the arrow doesn't overflow the floating element if the center\n    // point is outside the floating element's bounds.\n    const min$1 = minPadding;\n    const max = clientSize - arrowDimensions[length] - maxPadding;\n    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;\n    const offset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min$1, center, max);\n\n    // If the reference is small enough that the arrow's padding causes it to\n    // to point to nothing for an aligned placement, adjust the offset of the\n    // floating element itself. To ensure `shift()` continues to take action,\n    // a single reset is performed when this is true.\n    const shouldAddOffset = !middlewareData.arrow && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;\n    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;\n    return {\n      [axis]: coords[axis] + alignmentOffset,\n      data: {\n        [axis]: offset,\n        centerOffset: center - offset - alignmentOffset,\n        ...(shouldAddOffset && {\n          alignmentOffset\n        })\n      },\n      reset: shouldAddOffset\n    };\n  }\n});\n\nfunction getPlacementList(alignment, autoAlignment, allowedPlacements) {\n  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment), ...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) !== alignment)] : allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === placement);\n  return allowedPlacementsSortedByAlignment.filter(placement => {\n    if (alignment) {\n      return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment || (autoAlignment ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAlignmentPlacement)(placement) !== placement : false);\n    }\n    return true;\n  });\n}\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */\nconst autoPlacement = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'autoPlacement',\n    options,\n    async fn(state) {\n      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;\n      const {\n        rects,\n        middlewareData,\n        placement,\n        platform,\n        elements\n      } = state;\n      const {\n        crossAxis = false,\n        alignment,\n        allowedPlacements = _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements,\n        autoAlignment = true,\n        ...detectOverflowOptions\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      const placements$1 = alignment !== undefined || allowedPlacements === _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;\n      const overflow = await detectOverflow(state, detectOverflowOptions);\n      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;\n      const currentPlacement = placements$1[currentIndex];\n      if (currentPlacement == null) {\n        return {};\n      }\n      const alignmentSides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));\n\n      // Make `computeCoords` start from the right place.\n      if (placement !== currentPlacement) {\n        return {\n          reset: {\n            placement: placements$1[0]\n          }\n        };\n      }\n      const currentOverflows = [overflow[(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];\n      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {\n        placement: currentPlacement,\n        overflows: currentOverflows\n      }];\n      const nextPlacement = placements$1[currentIndex + 1];\n\n      // There are more placements to check.\n      if (nextPlacement) {\n        return {\n          data: {\n            index: currentIndex + 1,\n            overflows: allOverflows\n          },\n          reset: {\n            placement: nextPlacement\n          }\n        };\n      }\n      const placementsSortedByMostSpace = allOverflows.map(d => {\n        const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d.placement);\n        return [d.placement, alignment && crossAxis ?\n        // Check along the mainAxis and main crossAxis side.\n        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :\n        // Check only the mainAxis.\n        d.overflows[0], d.overflows];\n      }).sort((a, b) => a[1] - b[1]);\n      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,\n      // Aligned placements should not check their opposite crossAxis\n      // side.\n      (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d[0]) ? 2 : 3).every(v => v <= 0));\n      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];\n      if (resetPlacement !== placement) {\n        return {\n          data: {\n            index: currentIndex + 1,\n            overflows: allOverflows\n          },\n          reset: {\n            placement: resetPlacement\n          }\n        };\n      }\n      return {};\n    }\n  };\n};\n\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */\nconst flip = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'flip',\n    options,\n    async fn(state) {\n      var _middlewareData$arrow, _middlewareData$flip;\n      const {\n        placement,\n        middlewareData,\n        rects,\n        initialPlacement,\n        platform,\n        elements\n      } = state;\n      const {\n        mainAxis: checkMainAxis = true,\n        crossAxis: checkCrossAxis = true,\n        fallbackPlacements: specifiedFallbackPlacements,\n        fallbackStrategy = 'bestFit',\n        fallbackAxisSideDirection = 'none',\n        flipAlignment = true,\n        ...detectOverflowOptions\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n\n      // If a reset by the arrow was caused due to an alignment offset being\n      // added, we should skip any logic now since `flip()` has already done its\n      // work.\n      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643\n      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {\n        return {};\n      }\n      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n      const initialSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(initialPlacement);\n      const isBasePlacement = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(initialPlacement) === initialPlacement;\n      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));\n      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositePlacement)(initialPlacement)] : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getExpandedPlacements)(initialPlacement));\n      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== 'none';\n      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {\n        fallbackPlacements.push(...(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxisPlacements)(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));\n      }\n      const placements = [initialPlacement, ...fallbackPlacements];\n      const overflow = await detectOverflow(state, detectOverflowOptions);\n      const overflows = [];\n      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];\n      if (checkMainAxis) {\n        overflows.push(overflow[side]);\n      }\n      if (checkCrossAxis) {\n        const sides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(placement, rects, rtl);\n        overflows.push(overflow[sides[0]], overflow[sides[1]]);\n      }\n      overflowsData = [...overflowsData, {\n        placement,\n        overflows\n      }];\n\n      // One or more sides is overflowing.\n      if (!overflows.every(side => side <= 0)) {\n        var _middlewareData$flip2, _overflowsData$filter;\n        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;\n        const nextPlacement = placements[nextIndex];\n        if (nextPlacement) {\n          const ignoreCrossAxisOverflow = checkCrossAxis === 'alignment' ? initialSideAxis !== (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(nextPlacement) : false;\n          if (!ignoreCrossAxisOverflow ||\n          // We leave the current main axis only if every placement on that axis\n          // overflows the main axis.\n          overflowsData.every(d => d.overflows[0] > 0 && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement) === initialSideAxis)) {\n            // Try next placement and re-run the lifecycle.\n            return {\n              data: {\n                index: nextIndex,\n                overflows: overflowsData\n              },\n              reset: {\n                placement: nextPlacement\n              }\n            };\n          }\n        }\n\n        // First, find the candidates that fit on the mainAxis side of overflow,\n        // then find the placement that fits the best on the main crossAxis side.\n        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;\n\n        // Otherwise fallback.\n        if (!resetPlacement) {\n          switch (fallbackStrategy) {\n            case 'bestFit':\n              {\n                var _overflowsData$filter2;\n                const placement = (_overflowsData$filter2 = overflowsData.filter(d => {\n                  if (hasFallbackAxisSideDirection) {\n                    const currentSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement);\n                    return currentSideAxis === initialSideAxis ||\n                    // Create a bias to the `y` side axis due to horizontal\n                    // reading directions favoring greater width.\n                    currentSideAxis === 'y';\n                  }\n                  return true;\n                }).map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];\n                if (placement) {\n                  resetPlacement = placement;\n                }\n                break;\n              }\n            case 'initialPlacement':\n              resetPlacement = initialPlacement;\n              break;\n          }\n        }\n        if (placement !== resetPlacement) {\n          return {\n            reset: {\n              placement: resetPlacement\n            }\n          };\n        }\n      }\n      return {};\n    }\n  };\n};\n\nfunction getSideOffsets(overflow, rect) {\n  return {\n    top: overflow.top - rect.height,\n    right: overflow.right - rect.width,\n    bottom: overflow.bottom - rect.height,\n    left: overflow.left - rect.width\n  };\n}\nfunction isAnySideFullyClipped(overflow) {\n  return _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.sides.some(side => overflow[side] >= 0);\n}\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */\nconst hide = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'hide',\n    options,\n    async fn(state) {\n      const {\n        rects\n      } = state;\n      const {\n        strategy = 'referenceHidden',\n        ...detectOverflowOptions\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      switch (strategy) {\n        case 'referenceHidden':\n          {\n            const overflow = await detectOverflow(state, {\n              ...detectOverflowOptions,\n              elementContext: 'reference'\n            });\n            const offsets = getSideOffsets(overflow, rects.reference);\n            return {\n              data: {\n                referenceHiddenOffsets: offsets,\n                referenceHidden: isAnySideFullyClipped(offsets)\n              }\n            };\n          }\n        case 'escaped':\n          {\n            const overflow = await detectOverflow(state, {\n              ...detectOverflowOptions,\n              altBoundary: true\n            });\n            const offsets = getSideOffsets(overflow, rects.floating);\n            return {\n              data: {\n                escapedOffsets: offsets,\n                escaped: isAnySideFullyClipped(offsets)\n              }\n            };\n          }\n        default:\n          {\n            return {};\n          }\n      }\n    }\n  };\n};\n\nfunction getBoundingRect(rects) {\n  const minX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.left));\n  const minY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.top));\n  const maxX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.right));\n  const maxY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.bottom));\n  return {\n    x: minX,\n    y: minY,\n    width: maxX - minX,\n    height: maxY - minY\n  };\n}\nfunction getRectsByLine(rects) {\n  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);\n  const groups = [];\n  let prevRect = null;\n  for (let i = 0; i < sortedRects.length; i++) {\n    const rect = sortedRects[i];\n    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {\n      groups.push([rect]);\n    } else {\n      groups[groups.length - 1].push(rect);\n    }\n    prevRect = rect;\n  }\n  return groups.map(rect => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(rect)));\n}\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */\nconst inline = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'inline',\n    options,\n    async fn(state) {\n      const {\n        placement,\n        elements,\n        rects,\n        platform,\n        strategy\n      } = state;\n      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a\n      // ClientRect's bounds, despite the event listener being triggered. A\n      // padding of 2 seems to handle this issue.\n      const {\n        padding = 2,\n        x,\n        y\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);\n      const clientRects = getRectsByLine(nativeClientRects);\n      const fallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(nativeClientRects));\n      const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n      function getBoundingClientRect() {\n        // There are two rects and they are disjoined.\n        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {\n          // Find the first rect in which the point is fully inside.\n          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;\n        }\n\n        // There are 2 or more connected rects.\n        if (clientRects.length >= 2) {\n          if ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y') {\n            const firstRect = clientRects[0];\n            const lastRect = clientRects[clientRects.length - 1];\n            const isTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'top';\n            const top = firstRect.top;\n            const bottom = lastRect.bottom;\n            const left = isTop ? firstRect.left : lastRect.left;\n            const right = isTop ? firstRect.right : lastRect.right;\n            const width = right - left;\n            const height = bottom - top;\n            return {\n              top,\n              bottom,\n              left,\n              right,\n              width,\n              height,\n              x: left,\n              y: top\n            };\n          }\n          const isLeftSide = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'left';\n          const maxRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...clientRects.map(rect => rect.right));\n          const minLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...clientRects.map(rect => rect.left));\n          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);\n          const top = measureRects[0].top;\n          const bottom = measureRects[measureRects.length - 1].bottom;\n          const left = minLeft;\n          const right = maxRight;\n          const width = right - left;\n          const height = bottom - top;\n          return {\n            top,\n            bottom,\n            left,\n            right,\n            width,\n            height,\n            x: left,\n            y: top\n          };\n        }\n        return fallback;\n      }\n      const resetRects = await platform.getElementRects({\n        reference: {\n          getBoundingClientRect\n        },\n        floating: elements.floating,\n        strategy\n      });\n      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {\n        return {\n          reset: {\n            rects: resetRects\n          }\n        };\n      }\n      return {};\n    }\n  };\n};\n\n// For type backwards-compatibility, the `OffsetOptions` type was also\n// Derivable.\n\nasync function convertValueToCoords(state, options) {\n  const {\n    placement,\n    platform,\n    elements\n  } = state;\n  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));\n  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n  const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);\n  const isVertical = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';\n  const mainAxisMulti = ['left', 'top'].includes(side) ? -1 : 1;\n  const crossAxisMulti = rtl && isVertical ? -1 : 1;\n  const rawValue = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n\n  // eslint-disable-next-line prefer-const\n  let {\n    mainAxis,\n    crossAxis,\n    alignmentAxis\n  } = typeof rawValue === 'number' ? {\n    mainAxis: rawValue,\n    crossAxis: 0,\n    alignmentAxis: null\n  } : {\n    mainAxis: rawValue.mainAxis || 0,\n    crossAxis: rawValue.crossAxis || 0,\n    alignmentAxis: rawValue.alignmentAxis\n  };\n  if (alignment && typeof alignmentAxis === 'number') {\n    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;\n  }\n  return isVertical ? {\n    x: crossAxis * crossAxisMulti,\n    y: mainAxis * mainAxisMulti\n  } : {\n    x: mainAxis * mainAxisMulti,\n    y: crossAxis * crossAxisMulti\n  };\n}\n\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */\nconst offset = function (options) {\n  if (options === void 0) {\n    options = 0;\n  }\n  return {\n    name: 'offset',\n    options,\n    async fn(state) {\n      var _middlewareData$offse, _middlewareData$arrow;\n      const {\n        x,\n        y,\n        placement,\n        middlewareData\n      } = state;\n      const diffCoords = await convertValueToCoords(state, options);\n\n      // If the placement is the same and the arrow caused an alignment offset\n      // then we don't need to change the positioning coordinates.\n      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {\n        return {};\n      }\n      return {\n        x: x + diffCoords.x,\n        y: y + diffCoords.y,\n        data: {\n          ...diffCoords,\n          placement\n        }\n      };\n    }\n  };\n};\n\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */\nconst shift = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'shift',\n    options,\n    async fn(state) {\n      const {\n        x,\n        y,\n        placement\n      } = state;\n      const {\n        mainAxis: checkMainAxis = true,\n        crossAxis: checkCrossAxis = false,\n        limiter = {\n          fn: _ref => {\n            let {\n              x,\n              y\n            } = _ref;\n            return {\n              x,\n              y\n            };\n          }\n        },\n        ...detectOverflowOptions\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      const coords = {\n        x,\n        y\n      };\n      const overflow = await detectOverflow(state, detectOverflowOptions);\n      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));\n      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);\n      let mainAxisCoord = coords[mainAxis];\n      let crossAxisCoord = coords[crossAxis];\n      if (checkMainAxis) {\n        const minSide = mainAxis === 'y' ? 'top' : 'left';\n        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';\n        const min = mainAxisCoord + overflow[minSide];\n        const max = mainAxisCoord - overflow[maxSide];\n        mainAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, mainAxisCoord, max);\n      }\n      if (checkCrossAxis) {\n        const minSide = crossAxis === 'y' ? 'top' : 'left';\n        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';\n        const min = crossAxisCoord + overflow[minSide];\n        const max = crossAxisCoord - overflow[maxSide];\n        crossAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, crossAxisCoord, max);\n      }\n      const limitedCoords = limiter.fn({\n        ...state,\n        [mainAxis]: mainAxisCoord,\n        [crossAxis]: crossAxisCoord\n      });\n      return {\n        ...limitedCoords,\n        data: {\n          x: limitedCoords.x - x,\n          y: limitedCoords.y - y,\n          enabled: {\n            [mainAxis]: checkMainAxis,\n            [crossAxis]: checkCrossAxis\n          }\n        }\n      };\n    }\n  };\n};\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */\nconst limitShift = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    options,\n    fn(state) {\n      const {\n        x,\n        y,\n        placement,\n        rects,\n        middlewareData\n      } = state;\n      const {\n        offset = 0,\n        mainAxis: checkMainAxis = true,\n        crossAxis: checkCrossAxis = true\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      const coords = {\n        x,\n        y\n      };\n      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);\n      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);\n      let mainAxisCoord = coords[mainAxis];\n      let crossAxisCoord = coords[crossAxis];\n      const rawOffset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(offset, state);\n      const computedOffset = typeof rawOffset === 'number' ? {\n        mainAxis: rawOffset,\n        crossAxis: 0\n      } : {\n        mainAxis: 0,\n        crossAxis: 0,\n        ...rawOffset\n      };\n      if (checkMainAxis) {\n        const len = mainAxis === 'y' ? 'height' : 'width';\n        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;\n        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;\n        if (mainAxisCoord < limitMin) {\n          mainAxisCoord = limitMin;\n        } else if (mainAxisCoord > limitMax) {\n          mainAxisCoord = limitMax;\n        }\n      }\n      if (checkCrossAxis) {\n        var _middlewareData$offse, _middlewareData$offse2;\n        const len = mainAxis === 'y' ? 'width' : 'height';\n        const isOriginSide = ['top', 'left'].includes((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));\n        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);\n        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);\n        if (crossAxisCoord < limitMin) {\n          crossAxisCoord = limitMin;\n        } else if (crossAxisCoord > limitMax) {\n          crossAxisCoord = limitMax;\n        }\n      }\n      return {\n        [mainAxis]: mainAxisCoord,\n        [crossAxis]: crossAxisCoord\n      };\n    }\n  };\n};\n\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */\nconst size = function (options) {\n  if (options === void 0) {\n    options = {};\n  }\n  return {\n    name: 'size',\n    options,\n    async fn(state) {\n      var _state$middlewareData, _state$middlewareData2;\n      const {\n        placement,\n        rects,\n        platform,\n        elements\n      } = state;\n      const {\n        apply = () => {},\n        ...detectOverflowOptions\n      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n      const overflow = await detectOverflow(state, detectOverflowOptions);\n      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n      const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);\n      const isYAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';\n      const {\n        width,\n        height\n      } = rects.floating;\n      let heightSide;\n      let widthSide;\n      if (side === 'top' || side === 'bottom') {\n        heightSide = side;\n        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';\n      } else {\n        widthSide = side;\n        heightSide = alignment === 'end' ? 'top' : 'bottom';\n      }\n      const maximumClippingHeight = height - overflow.top - overflow.bottom;\n      const maximumClippingWidth = width - overflow.left - overflow.right;\n      const overflowAvailableHeight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(height - overflow[heightSide], maximumClippingHeight);\n      const overflowAvailableWidth = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(width - overflow[widthSide], maximumClippingWidth);\n      const noShift = !state.middlewareData.shift;\n      let availableHeight = overflowAvailableHeight;\n      let availableWidth = overflowAvailableWidth;\n      if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) {\n        availableWidth = maximumClippingWidth;\n      }\n      if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) {\n        availableHeight = maximumClippingHeight;\n      }\n      if (noShift && !alignment) {\n        const xMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, 0);\n        const xMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.right, 0);\n        const yMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, 0);\n        const yMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.bottom, 0);\n        if (isYAxis) {\n          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, overflow.right));\n        } else {\n          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, overflow.bottom));\n        }\n      }\n      await apply({\n        ...state,\n        availableWidth,\n        availableHeight\n      });\n      const nextDimensions = await platform.getDimensions(elements.floating);\n      if (width !== nextDimensions.width || height !== nextDimensions.height) {\n        return {\n          reset: {\n            rects: true\n          }\n        };\n      }\n      return {};\n    }\n  };\n};\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@floating-ui+core@1.7.1/node_modules/@floating-ui/core/dist/floating-ui.core.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@floating-ui+dom@1.7.1/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs":
/*!*****************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@floating-ui+dom@1.7.1/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   autoUpdate: () => (/* binding */ autoUpdate),\n/* harmony export */   computePosition: () => (/* binding */ computePosition),\n/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   platform: () => (/* binding */ platform),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ \"../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\");\n/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/core */ \"../../../node_modules/.pnpm/@floating-ui+core@1.7.1/node_modules/@floating-ui/core/dist/floating-ui.core.mjs\");\n/* harmony import */ var _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/utils/dom */ \"../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\");\n\n\n\n\n\nfunction getCssDimensions(element) {\n  const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element);\n  // In testing environments, the `width` and `height` properties are empty\n  // strings for SVG elements, returning NaN. Fallback to `0` in this case.\n  let width = parseFloat(css.width) || 0;\n  let height = parseFloat(css.height) || 0;\n  const hasOffset = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element);\n  const offsetWidth = hasOffset ? element.offsetWidth : width;\n  const offsetHeight = hasOffset ? element.offsetHeight : height;\n  const shouldFallback = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(width) !== offsetWidth || (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(height) !== offsetHeight;\n  if (shouldFallback) {\n    width = offsetWidth;\n    height = offsetHeight;\n  }\n  return {\n    width,\n    height,\n    $: shouldFallback\n  };\n}\n\nfunction unwrapElement(element) {\n  return !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(element) ? element.contextElement : element;\n}\n\nfunction getScale(element) {\n  const domElement = unwrapElement(element);\n  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(domElement)) {\n    return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);\n  }\n  const rect = domElement.getBoundingClientRect();\n  const {\n    width,\n    height,\n    $\n  } = getCssDimensions(domElement);\n  let x = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) : rect.width) / width;\n  let y = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) : rect.height) / height;\n\n  // 0, NaN, or Infinity should always fallback to 1.\n\n  if (!x || !Number.isFinite(x)) {\n    x = 1;\n  }\n  if (!y || !Number.isFinite(y)) {\n    y = 1;\n  }\n  return {\n    x,\n    y\n  };\n}\n\nconst noOffsets = /*#__PURE__*/(0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\nfunction getVisualOffsets(element) {\n  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);\n  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)() || !win.visualViewport) {\n    return noOffsets;\n  }\n  return {\n    x: win.visualViewport.offsetLeft,\n    y: win.visualViewport.offsetTop\n  };\n}\nfunction shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {\n  if (isFixed === void 0) {\n    isFixed = false;\n  }\n  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element)) {\n    return false;\n  }\n  return isFixed;\n}\n\nfunction getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {\n  if (includeScale === void 0) {\n    includeScale = false;\n  }\n  if (isFixedStrategy === void 0) {\n    isFixedStrategy = false;\n  }\n  const clientRect = element.getBoundingClientRect();\n  const domElement = unwrapElement(element);\n  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);\n  if (includeScale) {\n    if (offsetParent) {\n      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent)) {\n        scale = getScale(offsetParent);\n      }\n    } else {\n      scale = getScale(element);\n    }\n  }\n  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\n  let x = (clientRect.left + visualOffsets.x) / scale.x;\n  let y = (clientRect.top + visualOffsets.y) / scale.y;\n  let width = clientRect.width / scale.x;\n  let height = clientRect.height / scale.y;\n  if (domElement) {\n    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(domElement);\n    const offsetWin = offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent) ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(offsetParent) : offsetParent;\n    let currentWin = win;\n    let currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);\n    while (currentIFrame && offsetParent && offsetWin !== currentWin) {\n      const iframeScale = getScale(currentIFrame);\n      const iframeRect = currentIFrame.getBoundingClientRect();\n      const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentIFrame);\n      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;\n      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;\n      x *= iframeScale.x;\n      y *= iframeScale.y;\n      width *= iframeScale.x;\n      height *= iframeScale.y;\n      x += left;\n      y += top;\n      currentWin = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(currentIFrame);\n      currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);\n    }\n  }\n  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)({\n    width,\n    height,\n    x,\n    y\n  });\n}\n\n// If <html> has a CSS width greater than the viewport, then this will be\n// incorrect for RTL.\nfunction getWindowScrollBarX(element, rect) {\n  const leftScroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element).scrollLeft;\n  if (!rect) {\n    return getBoundingClientRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element)).left + leftScroll;\n  }\n  return rect.left + leftScroll;\n}\n\nfunction getHTMLOffset(documentElement, scroll, ignoreScrollbarX) {\n  if (ignoreScrollbarX === void 0) {\n    ignoreScrollbarX = false;\n  }\n  const htmlRect = documentElement.getBoundingClientRect();\n  const x = htmlRect.left + scroll.scrollLeft - (ignoreScrollbarX ? 0 :\n  // RTL <body> scrollbar.\n  getWindowScrollBarX(documentElement, htmlRect));\n  const y = htmlRect.top + scroll.scrollTop;\n  return {\n    x,\n    y\n  };\n}\n\nfunction convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {\n  let {\n    elements,\n    rect,\n    offsetParent,\n    strategy\n  } = _ref;\n  const isFixed = strategy === 'fixed';\n  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);\n  const topLayer = elements ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(elements.floating) : false;\n  if (offsetParent === documentElement || topLayer && isFixed) {\n    return rect;\n  }\n  let scroll = {\n    scrollLeft: 0,\n    scrollTop: 0\n  };\n  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);\n  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\n  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);\n  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {\n      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);\n    }\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent)) {\n      const offsetRect = getBoundingClientRect(offsetParent);\n      scale = getScale(offsetParent);\n      offsets.x = offsetRect.x + offsetParent.clientLeft;\n      offsets.y = offsetRect.y + offsetParent.clientTop;\n    }\n  }\n  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll, true) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\n  return {\n    width: rect.width * scale.x,\n    height: rect.height * scale.y,\n    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,\n    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y\n  };\n}\n\nfunction getClientRects(element) {\n  return Array.from(element.getClientRects());\n}\n\n// Gets the entire size of the scrollable document area, even extending outside\n// of the `<html>` and `<body>` rect bounds if horizontally scrollable.\nfunction getDocumentRect(element) {\n  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);\n  const scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element);\n  const body = element.ownerDocument.body;\n  const width = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);\n  const height = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);\n  let x = -scroll.scrollLeft + getWindowScrollBarX(element);\n  const y = -scroll.scrollTop;\n  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(body).direction === 'rtl') {\n    x += (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.clientWidth, body.clientWidth) - width;\n  }\n  return {\n    width,\n    height,\n    x,\n    y\n  };\n}\n\nfunction getViewportRect(element, strategy) {\n  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);\n  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);\n  const visualViewport = win.visualViewport;\n  let width = html.clientWidth;\n  let height = html.clientHeight;\n  let x = 0;\n  let y = 0;\n  if (visualViewport) {\n    width = visualViewport.width;\n    height = visualViewport.height;\n    const visualViewportBased = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)();\n    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {\n      x = visualViewport.offsetLeft;\n      y = visualViewport.offsetTop;\n    }\n  }\n  return {\n    width,\n    height,\n    x,\n    y\n  };\n}\n\n// Returns the inner client rect, subtracting scrollbars if present.\nfunction getInnerBoundingClientRect(element, strategy) {\n  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');\n  const top = clientRect.top + element.clientTop;\n  const left = clientRect.left + element.clientLeft;\n  const scale = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) ? getScale(element) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);\n  const width = element.clientWidth * scale.x;\n  const height = element.clientHeight * scale.y;\n  const x = left * scale.x;\n  const y = top * scale.y;\n  return {\n    width,\n    height,\n    x,\n    y\n  };\n}\nfunction getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {\n  let rect;\n  if (clippingAncestor === 'viewport') {\n    rect = getViewportRect(element, strategy);\n  } else if (clippingAncestor === 'document') {\n    rect = getDocumentRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element));\n  } else if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(clippingAncestor)) {\n    rect = getInnerBoundingClientRect(clippingAncestor, strategy);\n  } else {\n    const visualOffsets = getVisualOffsets(element);\n    rect = {\n      x: clippingAncestor.x - visualOffsets.x,\n      y: clippingAncestor.y - visualOffsets.y,\n      width: clippingAncestor.width,\n      height: clippingAncestor.height\n    };\n  }\n  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(rect);\n}\nfunction hasFixedPositionAncestor(element, stopNode) {\n  const parentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);\n  if (parentNode === stopNode || !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(parentNode) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(parentNode)) {\n    return false;\n  }\n  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);\n}\n\n// A \"clipping ancestor\" is an `overflow` element with the characteristic of\n// clipping (or hiding) child elements. This returns all clipping ancestors\n// of the given element up the tree.\nfunction getClippingElementAncestors(element, cache) {\n  const cachedResult = cache.get(element);\n  if (cachedResult) {\n    return cachedResult;\n  }\n  let result = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(element, [], false).filter(el => (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(el) && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(el) !== 'body');\n  let currentContainingBlockComputedStyle = null;\n  const elementIsFixed = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed';\n  let currentNode = elementIsFixed ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element) : element;\n\n  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block\n  while ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(currentNode) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(currentNode)) {\n    const computedStyle = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentNode);\n    const currentNodeIsContaining = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(currentNode);\n    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {\n      currentContainingBlockComputedStyle = null;\n    }\n    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && ['absolute', 'fixed'].includes(currentContainingBlockComputedStyle.position) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);\n    if (shouldDropCurrentNode) {\n      // Drop non-containing blocks.\n      result = result.filter(ancestor => ancestor !== currentNode);\n    } else {\n      // Record last containing block for next iteration.\n      currentContainingBlockComputedStyle = computedStyle;\n    }\n    currentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(currentNode);\n  }\n  cache.set(element, result);\n  return result;\n}\n\n// Gets the maximum area that the element is visible in due to any number of\n// clipping ancestors.\nfunction getClippingRect(_ref) {\n  let {\n    element,\n    boundary,\n    rootBoundary,\n    strategy\n  } = _ref;\n  const elementClippingAncestors = boundary === 'clippingAncestors' ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);\n  const clippingAncestors = [...elementClippingAncestors, rootBoundary];\n  const firstClippingAncestor = clippingAncestors[0];\n  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {\n    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);\n    accRect.top = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.top, accRect.top);\n    accRect.right = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.right, accRect.right);\n    accRect.bottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.bottom, accRect.bottom);\n    accRect.left = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.left, accRect.left);\n    return accRect;\n  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));\n  return {\n    width: clippingRect.right - clippingRect.left,\n    height: clippingRect.bottom - clippingRect.top,\n    x: clippingRect.left,\n    y: clippingRect.top\n  };\n}\n\nfunction getDimensions(element) {\n  const {\n    width,\n    height\n  } = getCssDimensions(element);\n  return {\n    width,\n    height\n  };\n}\n\nfunction getRectRelativeToOffsetParent(element, offsetParent, strategy) {\n  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);\n  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);\n  const isFixed = strategy === 'fixed';\n  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);\n  let scroll = {\n    scrollLeft: 0,\n    scrollTop: 0\n  };\n  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\n\n  // If the <body> scrollbar appears on the left (e.g. RTL systems). Use\n  // Firefox with layout.scrollbar.side = 3 in about:config to test this.\n  function setLeftRTLScrollbarOffset() {\n    offsets.x = getWindowScrollBarX(documentElement);\n  }\n  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {\n      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);\n    }\n    if (isOffsetParentAnElement) {\n      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);\n      offsets.x = offsetRect.x + offsetParent.clientLeft;\n      offsets.y = offsetRect.y + offsetParent.clientTop;\n    } else if (documentElement) {\n      setLeftRTLScrollbarOffset();\n    }\n  }\n  if (isFixed && !isOffsetParentAnElement && documentElement) {\n    setLeftRTLScrollbarOffset();\n  }\n  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);\n  const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;\n  const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;\n  return {\n    x,\n    y,\n    width: rect.width,\n    height: rect.height\n  };\n}\n\nfunction isStaticPositioned(element) {\n  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'static';\n}\n\nfunction getTrueOffsetParent(element, polyfill) {\n  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed') {\n    return null;\n  }\n  if (polyfill) {\n    return polyfill(element);\n  }\n  let rawOffsetParent = element.offsetParent;\n\n  // Firefox returns the <html> element as the offsetParent if it's non-static,\n  // while Chrome and Safari return the <body> element. The <body> element must\n  // be used to perform the correct calculations even if the <html> element is\n  // non-static.\n  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element) === rawOffsetParent) {\n    rawOffsetParent = rawOffsetParent.ownerDocument.body;\n  }\n  return rawOffsetParent;\n}\n\n// Gets the closest ancestor positioned element. Handles some edge cases,\n// such as table ancestors and cross browser bugs.\nfunction getOffsetParent(element, polyfill) {\n  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);\n  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element)) {\n    return win;\n  }\n  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element)) {\n    let svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);\n    while (svgOffsetParent && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(svgOffsetParent)) {\n      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {\n        return svgOffsetParent;\n      }\n      svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(svgOffsetParent);\n    }\n    return win;\n  }\n  let offsetParent = getTrueOffsetParent(element, polyfill);\n  while (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTableElement)(offsetParent) && isStaticPositioned(offsetParent)) {\n    offsetParent = getTrueOffsetParent(offsetParent, polyfill);\n  }\n  if (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(offsetParent) && isStaticPositioned(offsetParent) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(offsetParent)) {\n    return win;\n  }\n  return offsetParent || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getContainingBlock)(element) || win;\n}\n\nconst getElementRects = async function (data) {\n  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;\n  const getDimensionsFn = this.getDimensions;\n  const floatingDimensions = await getDimensionsFn(data.floating);\n  return {\n    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),\n    floating: {\n      x: 0,\n      y: 0,\n      width: floatingDimensions.width,\n      height: floatingDimensions.height\n    }\n  };\n};\n\nfunction isRTL(element) {\n  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).direction === 'rtl';\n}\n\nconst platform = {\n  convertOffsetParentRelativeRectToViewportRelativeRect,\n  getDocumentElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement,\n  getClippingRect,\n  getOffsetParent,\n  getElementRects,\n  getClientRects,\n  getDimensions,\n  getScale,\n  isElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement,\n  isRTL\n};\n\nfunction rectsAreEqual(a, b) {\n  return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;\n}\n\n// https://samthor.au/2021/observing-dom/\nfunction observeMove(element, onMove) {\n  let io = null;\n  let timeoutId;\n  const root = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);\n  function cleanup() {\n    var _io;\n    clearTimeout(timeoutId);\n    (_io = io) == null || _io.disconnect();\n    io = null;\n  }\n  function refresh(skip, threshold) {\n    if (skip === void 0) {\n      skip = false;\n    }\n    if (threshold === void 0) {\n      threshold = 1;\n    }\n    cleanup();\n    const elementRectForRootMargin = element.getBoundingClientRect();\n    const {\n      left,\n      top,\n      width,\n      height\n    } = elementRectForRootMargin;\n    if (!skip) {\n      onMove();\n    }\n    if (!width || !height) {\n      return;\n    }\n    const insetTop = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(top);\n    const insetRight = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientWidth - (left + width));\n    const insetBottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientHeight - (top + height));\n    const insetLeft = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(left);\n    const rootMargin = -insetTop + \"px \" + -insetRight + \"px \" + -insetBottom + \"px \" + -insetLeft + \"px\";\n    const options = {\n      rootMargin,\n      threshold: (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(0, (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(1, threshold)) || 1\n    };\n    let isFirstUpdate = true;\n    function handleObserve(entries) {\n      const ratio = entries[0].intersectionRatio;\n      if (ratio !== threshold) {\n        if (!isFirstUpdate) {\n          return refresh();\n        }\n        if (!ratio) {\n          // If the reference is clipped, the ratio is 0. Throttle the refresh\n          // to prevent an infinite loop of updates.\n          timeoutId = setTimeout(() => {\n            refresh(false, 1e-7);\n          }, 1000);\n        } else {\n          refresh(false, ratio);\n        }\n      }\n      if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {\n        // It's possible that even though the ratio is reported as 1, the\n        // element is not actually fully within the IntersectionObserver's root\n        // area anymore. This can happen under performance constraints. This may\n        // be a bug in the browser's IntersectionObserver implementation. To\n        // work around this, we compare the element's bounding rect now with\n        // what it was at the time we created the IntersectionObserver. If they\n        // are not equal then the element moved, so we refresh.\n        refresh();\n      }\n      isFirstUpdate = false;\n    }\n\n    // Older browsers don't support a `document` as the root and will throw an\n    // error.\n    try {\n      io = new IntersectionObserver(handleObserve, {\n        ...options,\n        // Handle <iframe>s\n        root: root.ownerDocument\n      });\n    } catch (_e) {\n      io = new IntersectionObserver(handleObserve, options);\n    }\n    io.observe(element);\n  }\n  refresh(true);\n  return cleanup;\n}\n\n/**\n * Automatically updates the position of the floating element when necessary.\n * Should only be called when the floating element is mounted on the DOM or\n * visible on the screen.\n * @returns cleanup function that should be invoked when the floating element is\n * removed from the DOM or hidden from the screen.\n * @see https://floating-ui.com/docs/autoUpdate\n */\nfunction autoUpdate(reference, floating, update, options) {\n  if (options === void 0) {\n    options = {};\n  }\n  const {\n    ancestorScroll = true,\n    ancestorResize = true,\n    elementResize = typeof ResizeObserver === 'function',\n    layoutShift = typeof IntersectionObserver === 'function',\n    animationFrame = false\n  } = options;\n  const referenceEl = unwrapElement(reference);\n  const ancestors = ancestorScroll || ancestorResize ? [...(referenceEl ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(referenceEl) : []), ...(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(floating)] : [];\n  ancestors.forEach(ancestor => {\n    ancestorScroll && ancestor.addEventListener('scroll', update, {\n      passive: true\n    });\n    ancestorResize && ancestor.addEventListener('resize', update);\n  });\n  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;\n  let reobserveFrame = -1;\n  let resizeObserver = null;\n  if (elementResize) {\n    resizeObserver = new ResizeObserver(_ref => {\n      let [firstEntry] = _ref;\n      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {\n        // Prevent update loops when using the `size` middleware.\n        // https://github.com/floating-ui/floating-ui/issues/1740\n        resizeObserver.unobserve(floating);\n        cancelAnimationFrame(reobserveFrame);\n        reobserveFrame = requestAnimationFrame(() => {\n          var _resizeObserver;\n          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);\n        });\n      }\n      update();\n    });\n    if (referenceEl && !animationFrame) {\n      resizeObserver.observe(referenceEl);\n    }\n    resizeObserver.observe(floating);\n  }\n  let frameId;\n  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;\n  if (animationFrame) {\n    frameLoop();\n  }\n  function frameLoop() {\n    const nextRefRect = getBoundingClientRect(reference);\n    if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {\n      update();\n    }\n    prevRefRect = nextRefRect;\n    frameId = requestAnimationFrame(frameLoop);\n  }\n  update();\n  return () => {\n    var _resizeObserver2;\n    ancestors.forEach(ancestor => {\n      ancestorScroll && ancestor.removeEventListener('scroll', update);\n      ancestorResize && ancestor.removeEventListener('resize', update);\n    });\n    cleanupIo == null || cleanupIo();\n    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();\n    resizeObserver = null;\n    if (animationFrame) {\n      cancelAnimationFrame(frameId);\n    }\n  };\n}\n\n/**\n * Resolves with an object of overflow side offsets that determine how much the\n * element is overflowing a given clipping boundary on each side.\n * - positive = overflowing the boundary by that number of pixels\n * - negative = how many pixels left before it will overflow\n * - 0 = lies flush with the boundary\n * @see https://floating-ui.com/docs/detectOverflow\n */\nconst detectOverflow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.detectOverflow;\n\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */\nconst offset = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.offset;\n\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */\nconst autoPlacement = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.autoPlacement;\n\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */\nconst shift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.shift;\n\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */\nconst flip = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.flip;\n\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */\nconst size = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.size;\n\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */\nconst hide = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.hide;\n\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * @see https://floating-ui.com/docs/arrow\n */\nconst arrow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.arrow;\n\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */\nconst inline = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.inline;\n\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */\nconst limitShift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.limitShift;\n\n/**\n * Computes the `x` and `y` coordinates that will place the floating element\n * next to a given reference element.\n */\nconst computePosition = (reference, floating, options) => {\n  // This caches the expensive `getClippingElementAncestors` function so that\n  // multiple lifecycle resets re-use the same result. It only lives for a\n  // single call. If other functions become expensive, we can add them as well.\n  const cache = new Map();\n  const mergedOptions = {\n    platform,\n    ...options\n  };\n  const platformWithCache = {\n    ...mergedOptions.platform,\n    _c: cache\n  };\n  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.computePosition)(reference, floating, {\n    ...mergedOptions,\n    platform: platformWithCache\n  });\n};\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@floating-ui+dom@1.7.1/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@floating-ui+react-dom@2.1.3_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs":
/*!*******************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@floating-ui+react-dom@2.1.3_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs ***!
  \*******************************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   autoUpdate: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.autoUpdate),\n/* harmony export */   computePosition: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.computePosition),\n/* harmony export */   detectOverflow: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.getOverflowAncestors),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   platform: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.platform),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size),\n/* harmony export */   useFloating: () => (/* binding */ useFloating)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/dom */ \"../../../node_modules/.pnpm/@floating-ui+dom@1.7.1/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs\");\n/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/dom */ \"../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ \"../../../node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js\");\n\n\n\n\n\n\nvar isClient = typeof document !== 'undefined';\n\nvar noop = function noop() {};\nvar index = isClient ? react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect : noop;\n\n// Fork of `fast-deep-equal` that only does the comparisons we need and compares\n// functions\nfunction deepEqual(a, b) {\n  if (a === b) {\n    return true;\n  }\n  if (typeof a !== typeof b) {\n    return false;\n  }\n  if (typeof a === 'function' && a.toString() === b.toString()) {\n    return true;\n  }\n  let length;\n  let i;\n  let keys;\n  if (a && b && typeof a === 'object') {\n    if (Array.isArray(a)) {\n      length = a.length;\n      if (length !== b.length) return false;\n      for (i = length; i-- !== 0;) {\n        if (!deepEqual(a[i], b[i])) {\n          return false;\n        }\n      }\n      return true;\n    }\n    keys = Object.keys(a);\n    length = keys.length;\n    if (length !== Object.keys(b).length) {\n      return false;\n    }\n    for (i = length; i-- !== 0;) {\n      if (!{}.hasOwnProperty.call(b, keys[i])) {\n        return false;\n      }\n    }\n    for (i = length; i-- !== 0;) {\n      const key = keys[i];\n      if (key === '_owner' && a.$$typeof) {\n        continue;\n      }\n      if (!deepEqual(a[key], b[key])) {\n        return false;\n      }\n    }\n    return true;\n  }\n  return a !== a && b !== b;\n}\n\nfunction getDPR(element) {\n  if (typeof window === 'undefined') {\n    return 1;\n  }\n  const win = element.ownerDocument.defaultView || window;\n  return win.devicePixelRatio || 1;\n}\n\nfunction roundByDPR(element, value) {\n  const dpr = getDPR(element);\n  return Math.round(value * dpr) / dpr;\n}\n\nfunction useLatestRef(value) {\n  const ref = react__WEBPACK_IMPORTED_MODULE_2__.useRef(value);\n  index(() => {\n    ref.current = value;\n  });\n  return ref;\n}\n\n/**\n * Provides data to position a floating element.\n * @see https://floating-ui.com/docs/useFloating\n */\nfunction useFloating(options) {\n  if (options === void 0) {\n    options = {};\n  }\n  const {\n    placement = 'bottom',\n    strategy = 'absolute',\n    middleware = [],\n    platform,\n    elements: {\n      reference: externalReference,\n      floating: externalFloating\n    } = {},\n    transform = true,\n    whileElementsMounted,\n    open\n  } = options;\n  const [data, setData] = react__WEBPACK_IMPORTED_MODULE_2__.useState({\n    x: 0,\n    y: 0,\n    strategy,\n    placement,\n    middlewareData: {},\n    isPositioned: false\n  });\n  const [latestMiddleware, setLatestMiddleware] = react__WEBPACK_IMPORTED_MODULE_2__.useState(middleware);\n  if (!deepEqual(latestMiddleware, middleware)) {\n    setLatestMiddleware(middleware);\n  }\n  const [_reference, _setReference] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);\n  const [_floating, _setFloating] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);\n  const setReference = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(node => {\n    if (node !== referenceRef.current) {\n      referenceRef.current = node;\n      _setReference(node);\n    }\n  }, []);\n  const setFloating = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(node => {\n    if (node !== floatingRef.current) {\n      floatingRef.current = node;\n      _setFloating(node);\n    }\n  }, []);\n  const referenceEl = externalReference || _reference;\n  const floatingEl = externalFloating || _floating;\n  const referenceRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);\n  const floatingRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);\n  const dataRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(data);\n  const hasWhileElementsMounted = whileElementsMounted != null;\n  const whileElementsMountedRef = useLatestRef(whileElementsMounted);\n  const platformRef = useLatestRef(platform);\n  const openRef = useLatestRef(open);\n  const update = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(() => {\n    if (!referenceRef.current || !floatingRef.current) {\n      return;\n    }\n    const config = {\n      placement,\n      strategy,\n      middleware: latestMiddleware\n    };\n    if (platformRef.current) {\n      config.platform = platformRef.current;\n    }\n    (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.computePosition)(referenceRef.current, floatingRef.current, config).then(data => {\n      const fullData = {\n        ...data,\n        // The floating element's position may be recomputed while it's closed\n        // but still mounted (such as when transitioning out). To ensure\n        // `isPositioned` will be `false` initially on the next open, avoid\n        // setting it to `true` when `open === false` (must be specified).\n        isPositioned: openRef.current !== false\n      };\n      if (isMountedRef.current && !deepEqual(dataRef.current, fullData)) {\n        dataRef.current = fullData;\n        react_dom__WEBPACK_IMPORTED_MODULE_3__.flushSync(() => {\n          setData(fullData);\n        });\n      }\n    });\n  }, [latestMiddleware, placement, strategy, platformRef, openRef]);\n  index(() => {\n    if (open === false && dataRef.current.isPositioned) {\n      dataRef.current.isPositioned = false;\n      setData(data => ({\n        ...data,\n        isPositioned: false\n      }));\n    }\n  }, [open]);\n  const isMountedRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(false);\n  index(() => {\n    isMountedRef.current = true;\n    return () => {\n      isMountedRef.current = false;\n    };\n  }, []);\n  index(() => {\n    if (referenceEl) referenceRef.current = referenceEl;\n    if (floatingEl) floatingRef.current = floatingEl;\n    if (referenceEl && floatingEl) {\n      if (whileElementsMountedRef.current) {\n        return whileElementsMountedRef.current(referenceEl, floatingEl, update);\n      }\n      update();\n    }\n  }, [referenceEl, floatingEl, update, whileElementsMountedRef, hasWhileElementsMounted]);\n  const refs = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({\n    reference: referenceRef,\n    floating: floatingRef,\n    setReference,\n    setFloating\n  }), [setReference, setFloating]);\n  const elements = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({\n    reference: referenceEl,\n    floating: floatingEl\n  }), [referenceEl, floatingEl]);\n  const floatingStyles = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => {\n    const initialStyles = {\n      position: strategy,\n      left: 0,\n      top: 0\n    };\n    if (!elements.floating) {\n      return initialStyles;\n    }\n    const x = roundByDPR(elements.floating, data.x);\n    const y = roundByDPR(elements.floating, data.y);\n    if (transform) {\n      return {\n        ...initialStyles,\n        transform: \"translate(\" + x + \"px, \" + y + \"px)\",\n        ...(getDPR(elements.floating) >= 1.5 && {\n          willChange: 'transform'\n        })\n      };\n    }\n    return {\n      position: strategy,\n      left: x,\n      top: y\n    };\n  }, [strategy, transform, elements.floating, data.x, data.y]);\n  return react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({\n    ...data,\n    update,\n    refs,\n    elements,\n    floatingStyles\n  }), [data, update, refs, elements, floatingStyles]);\n}\n\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * This wraps the core `arrow` middleware to allow React refs as the element.\n * @see https://floating-ui.com/docs/arrow\n */\nconst arrow$1 = options => {\n  function isRef(value) {\n    return {}.hasOwnProperty.call(value, 'current');\n  }\n  return {\n    name: 'arrow',\n    options,\n    fn(state) {\n      const {\n        element,\n        padding\n      } = typeof options === 'function' ? options(state) : options;\n      if (element && isRef(element)) {\n        if (element.current != null) {\n          return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({\n            element: element.current,\n            padding\n          }).fn(state);\n        }\n        return {};\n      }\n      if (element) {\n        return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({\n          element,\n          padding\n        }).fn(state);\n      }\n      return {};\n    }\n  };\n};\n\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */\nconst offset = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.offset)(options),\n  options: [options, deps]\n});\n\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */\nconst shift = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.shift)(options),\n  options: [options, deps]\n});\n\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */\nconst limitShift = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.limitShift)(options),\n  options: [options, deps]\n});\n\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */\nconst flip = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.flip)(options),\n  options: [options, deps]\n});\n\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */\nconst size = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.size)(options),\n  options: [options, deps]\n});\n\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */\nconst autoPlacement = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.autoPlacement)(options),\n  options: [options, deps]\n});\n\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */\nconst hide = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.hide)(options),\n  options: [options, deps]\n});\n\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */\nconst inline = (options, deps) => ({\n  ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.inline)(options),\n  options: [options, deps]\n});\n\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * This wraps the core `arrow` middleware to allow React refs as the element.\n * @see https://floating-ui.com/docs/arrow\n */\nconst arrow = (options, deps) => ({\n  ...arrow$1(options),\n  options: [options, deps]\n});\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@floating-ui+react-dom@2.1.3_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs":
/*!***************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getComputedStyle: () => (/* binding */ getComputedStyle),\n/* harmony export */   getContainingBlock: () => (/* binding */ getContainingBlock),\n/* harmony export */   getDocumentElement: () => (/* binding */ getDocumentElement),\n/* harmony export */   getFrameElement: () => (/* binding */ getFrameElement),\n/* harmony export */   getNearestOverflowAncestor: () => (/* binding */ getNearestOverflowAncestor),\n/* harmony export */   getNodeName: () => (/* binding */ getNodeName),\n/* harmony export */   getNodeScroll: () => (/* binding */ getNodeScroll),\n/* harmony export */   getOverflowAncestors: () => (/* binding */ getOverflowAncestors),\n/* harmony export */   getParentNode: () => (/* binding */ getParentNode),\n/* harmony export */   getWindow: () => (/* binding */ getWindow),\n/* harmony export */   isContainingBlock: () => (/* binding */ isContainingBlock),\n/* harmony export */   isElement: () => (/* binding */ isElement),\n/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),\n/* harmony export */   isLastTraversableNode: () => (/* binding */ isLastTraversableNode),\n/* harmony export */   isNode: () => (/* binding */ isNode),\n/* harmony export */   isOverflowElement: () => (/* binding */ isOverflowElement),\n/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot),\n/* harmony export */   isTableElement: () => (/* binding */ isTableElement),\n/* harmony export */   isTopLayer: () => (/* binding */ isTopLayer),\n/* harmony export */   isWebKit: () => (/* binding */ isWebKit)\n/* harmony export */ });\nfunction hasWindow() {\n  return typeof window !== 'undefined';\n}\nfunction getNodeName(node) {\n  if (isNode(node)) {\n    return (node.nodeName || '').toLowerCase();\n  }\n  // Mocked nodes in testing environments may not be instances of Node. By\n  // returning `#document` an infinite loop won't occur.\n  // https://github.com/floating-ui/floating-ui/issues/2317\n  return '#document';\n}\nfunction getWindow(node) {\n  var _node$ownerDocument;\n  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;\n}\nfunction getDocumentElement(node) {\n  var _ref;\n  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;\n}\nfunction isNode(value) {\n  if (!hasWindow()) {\n    return false;\n  }\n  return value instanceof Node || value instanceof getWindow(value).Node;\n}\nfunction isElement(value) {\n  if (!hasWindow()) {\n    return false;\n  }\n  return value instanceof Element || value instanceof getWindow(value).Element;\n}\nfunction isHTMLElement(value) {\n  if (!hasWindow()) {\n    return false;\n  }\n  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;\n}\nfunction isShadowRoot(value) {\n  if (!hasWindow() || typeof ShadowRoot === 'undefined') {\n    return false;\n  }\n  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;\n}\nfunction isOverflowElement(element) {\n  const {\n    overflow,\n    overflowX,\n    overflowY,\n    display\n  } = getComputedStyle(element);\n  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !['inline', 'contents'].includes(display);\n}\nfunction isTableElement(element) {\n  return ['table', 'td', 'th'].includes(getNodeName(element));\n}\nfunction isTopLayer(element) {\n  return [':popover-open', ':modal'].some(selector => {\n    try {\n      return element.matches(selector);\n    } catch (e) {\n      return false;\n    }\n  });\n}\nfunction isContainingBlock(elementOrCss) {\n  const webkit = isWebKit();\n  const css = isElement(elementOrCss) ? getComputedStyle(elementOrCss) : elementOrCss;\n\n  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block\n  // https://drafts.csswg.org/css-transforms-2/#individual-transforms\n  return ['transform', 'translate', 'scale', 'rotate', 'perspective'].some(value => css[value] ? css[value] !== 'none' : false) || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || ['transform', 'translate', 'scale', 'rotate', 'perspective', 'filter'].some(value => (css.willChange || '').includes(value)) || ['paint', 'layout', 'strict', 'content'].some(value => (css.contain || '').includes(value));\n}\nfunction getContainingBlock(element) {\n  let currentNode = getParentNode(element);\n  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {\n    if (isContainingBlock(currentNode)) {\n      return currentNode;\n    } else if (isTopLayer(currentNode)) {\n      return null;\n    }\n    currentNode = getParentNode(currentNode);\n  }\n  return null;\n}\nfunction isWebKit() {\n  if (typeof CSS === 'undefined' || !CSS.supports) return false;\n  return CSS.supports('-webkit-backdrop-filter', 'none');\n}\nfunction isLastTraversableNode(node) {\n  return ['html', 'body', '#document'].includes(getNodeName(node));\n}\nfunction getComputedStyle(element) {\n  return getWindow(element).getComputedStyle(element);\n}\nfunction getNodeScroll(element) {\n  if (isElement(element)) {\n    return {\n      scrollLeft: element.scrollLeft,\n      scrollTop: element.scrollTop\n    };\n  }\n  return {\n    scrollLeft: element.scrollX,\n    scrollTop: element.scrollY\n  };\n}\nfunction getParentNode(node) {\n  if (getNodeName(node) === 'html') {\n    return node;\n  }\n  const result =\n  // Step into the shadow DOM of the parent of a slotted node.\n  node.assignedSlot ||\n  // DOM Element detected.\n  node.parentNode ||\n  // ShadowRoot detected.\n  isShadowRoot(node) && node.host ||\n  // Fallback.\n  getDocumentElement(node);\n  return isShadowRoot(result) ? result.host : result;\n}\nfunction getNearestOverflowAncestor(node) {\n  const parentNode = getParentNode(node);\n  if (isLastTraversableNode(parentNode)) {\n    return node.ownerDocument ? node.ownerDocument.body : node.body;\n  }\n  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {\n    return parentNode;\n  }\n  return getNearestOverflowAncestor(parentNode);\n}\nfunction getOverflowAncestors(node, list, traverseIframes) {\n  var _node$ownerDocument2;\n  if (list === void 0) {\n    list = [];\n  }\n  if (traverseIframes === void 0) {\n    traverseIframes = true;\n  }\n  const scrollableAncestor = getNearestOverflowAncestor(node);\n  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);\n  const win = getWindow(scrollableAncestor);\n  if (isBody) {\n    const frameElement = getFrameElement(win);\n    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);\n  }\n  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));\n}\nfunction getFrameElement(win) {\n  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs":
/*!***********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   alignments: () => (/* binding */ alignments),\n/* harmony export */   clamp: () => (/* binding */ clamp),\n/* harmony export */   createCoords: () => (/* binding */ createCoords),\n/* harmony export */   evaluate: () => (/* binding */ evaluate),\n/* harmony export */   expandPaddingObject: () => (/* binding */ expandPaddingObject),\n/* harmony export */   floor: () => (/* binding */ floor),\n/* harmony export */   getAlignment: () => (/* binding */ getAlignment),\n/* harmony export */   getAlignmentAxis: () => (/* binding */ getAlignmentAxis),\n/* harmony export */   getAlignmentSides: () => (/* binding */ getAlignmentSides),\n/* harmony export */   getAxisLength: () => (/* binding */ getAxisLength),\n/* harmony export */   getExpandedPlacements: () => (/* binding */ getExpandedPlacements),\n/* harmony export */   getOppositeAlignmentPlacement: () => (/* binding */ getOppositeAlignmentPlacement),\n/* harmony export */   getOppositeAxis: () => (/* binding */ getOppositeAxis),\n/* harmony export */   getOppositeAxisPlacements: () => (/* binding */ getOppositeAxisPlacements),\n/* harmony export */   getOppositePlacement: () => (/* binding */ getOppositePlacement),\n/* harmony export */   getPaddingObject: () => (/* binding */ getPaddingObject),\n/* harmony export */   getSide: () => (/* binding */ getSide),\n/* harmony export */   getSideAxis: () => (/* binding */ getSideAxis),\n/* harmony export */   max: () => (/* binding */ max),\n/* harmony export */   min: () => (/* binding */ min),\n/* harmony export */   placements: () => (/* binding */ placements),\n/* harmony export */   rectToClientRect: () => (/* binding */ rectToClientRect),\n/* harmony export */   round: () => (/* binding */ round),\n/* harmony export */   sides: () => (/* binding */ sides)\n/* harmony export */ });\n/**\n * Custom positioning reference element.\n * @see https://floating-ui.com/docs/virtual-elements\n */\n\nconst sides = ['top', 'right', 'bottom', 'left'];\nconst alignments = ['start', 'end'];\nconst placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + \"-\" + alignments[0], side + \"-\" + alignments[1]), []);\nconst min = Math.min;\nconst max = Math.max;\nconst round = Math.round;\nconst floor = Math.floor;\nconst createCoords = v => ({\n  x: v,\n  y: v\n});\nconst oppositeSideMap = {\n  left: 'right',\n  right: 'left',\n  bottom: 'top',\n  top: 'bottom'\n};\nconst oppositeAlignmentMap = {\n  start: 'end',\n  end: 'start'\n};\nfunction clamp(start, value, end) {\n  return max(start, min(value, end));\n}\nfunction evaluate(value, param) {\n  return typeof value === 'function' ? value(param) : value;\n}\nfunction getSide(placement) {\n  return placement.split('-')[0];\n}\nfunction getAlignment(placement) {\n  return placement.split('-')[1];\n}\nfunction getOppositeAxis(axis) {\n  return axis === 'x' ? 'y' : 'x';\n}\nfunction getAxisLength(axis) {\n  return axis === 'y' ? 'height' : 'width';\n}\nfunction getSideAxis(placement) {\n  return ['top', 'bottom'].includes(getSide(placement)) ? 'y' : 'x';\n}\nfunction getAlignmentAxis(placement) {\n  return getOppositeAxis(getSideAxis(placement));\n}\nfunction getAlignmentSides(placement, rects, rtl) {\n  if (rtl === void 0) {\n    rtl = false;\n  }\n  const alignment = getAlignment(placement);\n  const alignmentAxis = getAlignmentAxis(placement);\n  const length = getAxisLength(alignmentAxis);\n  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';\n  if (rects.reference[length] > rects.floating[length]) {\n    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);\n  }\n  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];\n}\nfunction getExpandedPlacements(placement) {\n  const oppositePlacement = getOppositePlacement(placement);\n  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];\n}\nfunction getOppositeAlignmentPlacement(placement) {\n  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);\n}\nfunction getSideList(side, isStart, rtl) {\n  const lr = ['left', 'right'];\n  const rl = ['right', 'left'];\n  const tb = ['top', 'bottom'];\n  const bt = ['bottom', 'top'];\n  switch (side) {\n    case 'top':\n    case 'bottom':\n      if (rtl) return isStart ? rl : lr;\n      return isStart ? lr : rl;\n    case 'left':\n    case 'right':\n      return isStart ? tb : bt;\n    default:\n      return [];\n  }\n}\nfunction getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {\n  const alignment = getAlignment(placement);\n  let list = getSideList(getSide(placement), direction === 'start', rtl);\n  if (alignment) {\n    list = list.map(side => side + \"-\" + alignment);\n    if (flipAlignment) {\n      list = list.concat(list.map(getOppositeAlignmentPlacement));\n    }\n  }\n  return list;\n}\nfunction getOppositePlacement(placement) {\n  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);\n}\nfunction expandPaddingObject(padding) {\n  return {\n    top: 0,\n    right: 0,\n    bottom: 0,\n    left: 0,\n    ...padding\n  };\n}\nfunction getPaddingObject(padding) {\n  return typeof padding !== 'number' ? expandPaddingObject(padding) : {\n    top: padding,\n    right: padding,\n    bottom: padding,\n    left: padding\n  };\n}\nfunction rectToClientRect(rect) {\n  const {\n    x,\n    y,\n    width,\n    height\n  } = rect;\n  return {\n    width,\n    height,\n    top: y,\n    left: x,\n    right: x + width,\n    bottom: y + height,\n    x,\n    y\n  };\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@floating-ui+utils@0.2.9/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+react@0.29.0_@codemirror+language@6.11.3_@types+node@24.9.0_@types+react-dom@_08b4c03f213ee5c49169b3648695812c/node_modules/@graphiql/react/dist/index.mjs":
/*!********************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+react@0.29.0_@codemirror+language@6.11.3_@types+node@24.9.0_@types+react-dom@_08b4c03f213ee5c49169b3648695812c/node_modules/@graphiql/react/dist/index.mjs ***!
  \********************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Argument: () => (/* binding */ Argument),\n/* harmony export */   ArgumentIcon: () => (/* binding */ ArgumentIcon),\n/* harmony export */   Button: () => (/* binding */ Button$1),\n/* harmony export */   ButtonGroup: () => (/* binding */ ButtonGroup),\n/* harmony export */   ChevronDownIcon: () => (/* binding */ ChevronDownIcon),\n/* harmony export */   ChevronLeftIcon: () => (/* binding */ ChevronLeftIcon),\n/* harmony export */   ChevronUpIcon: () => (/* binding */ ChevronUpIcon),\n/* harmony export */   CloseIcon: () => (/* binding */ CloseIcon),\n/* harmony export */   CopyIcon: () => (/* binding */ CopyIcon),\n/* harmony export */   DOC_EXPLORER_PLUGIN: () => (/* binding */ DOC_EXPLORER_PLUGIN),\n/* harmony export */   DefaultValue: () => (/* binding */ DefaultValue),\n/* harmony export */   DeprecatedArgumentIcon: () => (/* binding */ DeprecatedArgumentIcon),\n/* harmony export */   DeprecatedEnumValueIcon: () => (/* binding */ DeprecatedEnumValueIcon),\n/* harmony export */   DeprecatedFieldIcon: () => (/* binding */ DeprecatedFieldIcon),\n/* harmony export */   DeprecationReason: () => (/* binding */ DeprecationReason),\n/* harmony export */   Dialog: () => (/* binding */ Dialog),\n/* harmony export */   DialogRoot: () => (/* binding */ DialogRoot),\n/* harmony export */   Directive: () => (/* binding */ Directive),\n/* harmony export */   DirectiveIcon: () => (/* binding */ DirectiveIcon),\n/* harmony export */   DocExplorer: () => (/* binding */ DocExplorer),\n/* harmony export */   DocsFilledIcon: () => (/* binding */ DocsFilledIcon),\n/* harmony export */   DocsIcon: () => (/* binding */ DocsIcon),\n/* harmony export */   DropdownMenu: () => (/* binding */ DropdownMenu),\n/* harmony export */   EditorContext: () => (/* binding */ EditorContext),\n/* harmony export */   EditorContextProvider: () => (/* binding */ EditorContextProvider),\n/* harmony export */   EnumValueIcon: () => (/* binding */ EnumValueIcon),\n/* harmony export */   ExecuteButton: () => (/* binding */ ExecuteButton),\n/* harmony export */   ExecutionContext: () => (/* binding */ ExecutionContext),\n/* harmony export */   ExecutionContextProvider: () => (/* binding */ ExecutionContextProvider),\n/* harmony export */   ExplorerContext: () => (/* binding */ ExplorerContext),\n/* harmony export */   ExplorerContextProvider: () => (/* binding */ ExplorerContextProvider),\n/* harmony export */   ExplorerSection: () => (/* binding */ ExplorerSection),\n/* harmony export */   FieldDocumentation: () => (/* binding */ FieldDocumentation),\n/* harmony export */   FieldIcon: () => (/* binding */ FieldIcon),\n/* harmony export */   FieldLink: () => (/* binding */ FieldLink),\n/* harmony export */   GraphiQLProvider: () => (/* binding */ GraphiQLProvider),\n/* harmony export */   HISTORY_PLUGIN: () => (/* binding */ HISTORY_PLUGIN),\n/* harmony export */   HeaderEditor: () => (/* binding */ HeaderEditor),\n/* harmony export */   History: () => (/* binding */ History),\n/* harmony export */   HistoryContext: () => (/* binding */ HistoryContext),\n/* harmony export */   HistoryContextProvider: () => (/* binding */ HistoryContextProvider),\n/* harmony export */   HistoryIcon: () => (/* binding */ HistoryIcon),\n/* harmony export */   ImagePreview: () => (/* binding */ ImagePreview),\n/* harmony export */   ImplementsIcon: () => (/* binding */ ImplementsIcon),\n/* harmony export */   KeyboardShortcutIcon: () => (/* binding */ KeyboardShortcutIcon),\n/* harmony export */   MagnifyingGlassIcon: () => (/* binding */ MagnifyingGlassIcon),\n/* harmony export */   MarkdownContent: () => (/* binding */ MarkdownContent),\n/* harmony export */   MergeIcon: () => (/* binding */ MergeIcon),\n/* harmony export */   PenIcon: () => (/* binding */ PenIcon),\n/* harmony export */   PlayIcon: () => (/* binding */ PlayIcon),\n/* harmony export */   PluginContext: () => (/* binding */ PluginContext),\n/* harmony export */   PluginContextProvider: () => (/* binding */ PluginContextProvider),\n/* harmony export */   PlusIcon: () => (/* binding */ PlusIcon),\n/* harmony export */   PrettifyIcon: () => (/* binding */ PrettifyIcon),\n/* harmony export */   QueryEditor: () => (/* binding */ QueryEditor),\n/* harmony export */   ReloadIcon: () => (/* binding */ ReloadIcon),\n/* harmony export */   ResponseEditor: () => (/* binding */ ResponseEditor),\n/* harmony export */   RootTypeIcon: () => (/* binding */ RootTypeIcon),\n/* harmony export */   SchemaContext: () => (/* binding */ SchemaContext),\n/* harmony export */   SchemaContextProvider: () => (/* binding */ SchemaContextProvider),\n/* harmony export */   SchemaDocumentation: () => (/* binding */ SchemaDocumentation),\n/* harmony export */   Search: () => (/* binding */ Search),\n/* harmony export */   SettingsIcon: () => (/* binding */ SettingsIcon),\n/* harmony export */   Spinner: () => (/* binding */ Spinner),\n/* harmony export */   StarFilledIcon: () => (/* binding */ StarFilledIcon),\n/* harmony export */   StarIcon: () => (/* binding */ StarIcon),\n/* harmony export */   StopIcon: () => (/* binding */ StopIcon),\n/* harmony export */   StorageContext: () => (/* binding */ StorageContext),\n/* harmony export */   StorageContextProvider: () => (/* binding */ StorageContextProvider),\n/* harmony export */   Tab: () => (/* binding */ Tab),\n/* harmony export */   Tabs: () => (/* binding */ Tabs),\n/* harmony export */   ToolbarButton: () => (/* binding */ ToolbarButton),\n/* harmony export */   ToolbarMenu: () => (/* binding */ ToolbarMenu),\n/* harmony export */   Tooltip: () => (/* binding */ Tooltip),\n/* harmony export */   TooltipRoot: () => (/* binding */ TooltipRoot),\n/* harmony export */   TrashIcon: () => (/* binding */ TrashIcon),\n/* harmony export */   TypeDocumentation: () => (/* binding */ TypeDocumentation),\n/* harmony export */   TypeIcon: () => (/* binding */ TypeIcon),\n/* harmony export */   TypeLink: () => (/* binding */ TypeLink),\n/* harmony export */   UnStyledButton: () => (/* binding */ UnStyledButton),\n/* harmony export */   VariableEditor: () => (/* binding */ VariableEditor),\n/* harmony export */   isMacOs: () => (/* binding */ isMacOs),\n/* harmony export */   useAutoCompleteLeafs: () => (/* binding */ useAutoCompleteLeafs),\n/* harmony export */   useCopyQuery: () => (/* binding */ useCopyQuery),\n/* harmony export */   useDragResize: () => (/* binding */ useDragResize),\n/* harmony export */   useEditorContext: () => (/* binding */ useEditorContext),\n/* harmony export */   useEditorState: () => (/* binding */ useEditorState),\n/* harmony export */   useExecutionContext: () => (/* binding */ useExecutionContext),\n/* harmony export */   useExplorerContext: () => (/* binding */ useExplorerContext),\n/* harmony export */   useHeaderEditor: () => (/* binding */ useHeaderEditor),\n/* harmony export */   useHeadersEditorState: () => (/* binding */ useHeadersEditorState),\n/* harmony export */   useHistoryContext: () => (/* binding */ useHistoryContext),\n/* harmony export */   useMergeQuery: () => (/* binding */ useMergeQuery),\n/* harmony export */   useOperationsEditorState: () => (/* binding */ useOperationsEditorState),\n/* harmony export */   useOptimisticState: () => (/* binding */ useOptimisticState),\n/* harmony export */   usePluginContext: () => (/* binding */ usePluginContext),\n/* harmony export */   usePrettifyEditors: () => (/* binding */ usePrettifyEditors),\n/* harmony export */   useQueryEditor: () => (/* binding */ useQueryEditor),\n/* harmony export */   useResponseEditor: () => (/* binding */ useResponseEditor),\n/* harmony export */   useSchemaContext: () => (/* binding */ useSchemaContext),\n/* harmony export */   useStorageContext: () => (/* binding */ useStorageContext),\n/* harmony export */   useTheme: () => (/* binding */ useTheme),\n/* harmony export */   useVariableEditor: () => (/* binding */ useVariableEditor),\n/* harmony export */   useVariablesEditorState: () => (/* binding */ useVariablesEditorState)\n/* harmony export */ });\n/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ \"../../../node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js\");\n/* harmony import */ var react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-compiler-runtime */ \"../../../node_modules/.pnpm/react-compiler-runtime@19.1.0-rc.1_react@18.3.1/node_modules/react-compiler-runtime/dist/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! clsx */ \"../../../node_modules/.pnpm/clsx@1.2.1/node_modules/clsx/dist/clsx.m.js\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/type/schema.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/utilities/getIntrospectionQuery.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/type/definition.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/utilities/buildClientSchema.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/type/validate.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/parser.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/printer.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/visitor.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/utilities/astFromValue.mjs\");\n/* harmony import */ var _graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @graphiql/toolkit */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/index.js\");\n/* harmony import */ var graphql_language_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! graphql-language-service */ \"../../../node_modules/.pnpm/graphql-language-service@5.4.0_graphql@16.11.0/node_modules/graphql-language-service/esm/index.js\");\n/* harmony import */ var set_value__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! set-value */ \"../../../node_modules/.pnpm/set-value@4.1.0/node_modules/set-value/index.js\");\n/* harmony import */ var get_value__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! get-value */ \"../../../node_modules/.pnpm/get-value@3.0.1/node_modules/get-value/index.js\");\n/* harmony import */ var copy_to_clipboard__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! copy-to-clipboard */ \"../../../node_modules/.pnpm/copy-to-clipboard@3.3.3/node_modules/copy-to-clipboard/index.js\");\n/* harmony import */ var _radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @radix-ui/react-dialog */ \"../../../node_modules/.pnpm/@radix-ui+react-dialog@1.1.14_@types+react-dom@18.3.7_@types+react@18.3.26__@types+reac_4c36b68d2f1de6c0bc42388d8c6642bb/node_modules/@radix-ui/react-dialog/dist/index.mjs\");\n/* harmony import */ var _radix_ui_react_visually_hidden__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @radix-ui/react-visually-hidden */ \"../../../node_modules/.pnpm/@radix-ui+react-visually-hidden@1.2.3_@types+react-dom@18.3.7_@types+react@18.3.26__@ty_699add8356bb40b0a726133b69555ec2/node_modules/@radix-ui/react-visually-hidden/dist/index.mjs\");\n/* harmony import */ var _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @radix-ui/react-dropdown-menu */ \"../../../node_modules/.pnpm/@radix-ui+react-dropdown-menu@2.1.15_@types+react-dom@18.3.7_@types+react@18.3.26__@typ_7d0cac3bce5689540e606badb24e3f0e/node_modules/@radix-ui/react-dropdown-menu/dist/index.mjs\");\n/* harmony import */ var markdown_it__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! markdown-it */ \"../../../node_modules/.pnpm/markdown-it@14.1.0/node_modules/markdown-it/index.mjs\");\n/* harmony import */ var framer_motion__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! framer-motion */ \"../../../node_modules/.pnpm/framer-motion@6.5.1_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/framer-motion/dist/es/components/Reorder/index.mjs\");\n/* harmony import */ var _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @radix-ui/react-tooltip */ \"../../../node_modules/.pnpm/@radix-ui+react-tooltip@1.2.7_@types+react-dom@18.3.7_@types+react@18.3.26__@types+reac_746a84df87c3300e7cc8b2e3b01d7d29/node_modules/@radix-ui/react-tooltip/dist/index.mjs\");\n/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @headlessui/react */ \"../../../node_modules/.pnpm/@headlessui+react@1.7.19_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@headlessui/react/dist/components/combobox/combobox.js\");\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! react-dom */ \"../../../node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfunction createNullableContext(name) {\n  const context = (0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)(null);\n  context.displayName = name;\n  return context;\n}\nfunction createContextHook(context) {\n  function useGivenContext(options) {\n    var _a;\n    const value = (0,react__WEBPACK_IMPORTED_MODULE_2__.useContext)(context);\n    if (value === null && (options == null ? void 0 : options.nonNull)) {\n      throw new Error(`Tried to use \\`${((_a = options.caller) == null ? void 0 : _a.name) || \"a component\"}\\` without the necessary context. Make sure to render the \\`${context.displayName}Provider\\` component higher up the tree.`);\n    }\n    return value;\n  }\n  Object.defineProperty(useGivenContext, \"name\", {\n    value: `use${context.displayName}`\n  });\n  return useGivenContext;\n}\nconst StorageContext = createNullableContext(\"StorageContext\");\nfunction StorageContextProvider(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(8);\n  const isInitialRender = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(true);\n  let t0;\n  if ($[0] !== props.storage) {\n    t0 = () => new _graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.StorageAPI(props.storage);\n    $[0] = props.storage;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  const [storage, setStorage] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t0);\n  let t1;\n  let t2;\n  if ($[2] !== props.storage) {\n    t1 = () => {\n      if (isInitialRender.current) {\n        isInitialRender.current = false;\n      } else {\n        setStorage(new _graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.StorageAPI(props.storage));\n      }\n    };\n    t2 = [props.storage];\n    $[2] = props.storage;\n    $[3] = t1;\n    $[4] = t2;\n  } else {\n    t1 = $[3];\n    t2 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n  let t3;\n  if ($[5] !== props.children || $[6] !== storage) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StorageContext.Provider, { value: storage, children: props.children });\n    $[5] = props.children;\n    $[6] = storage;\n    $[7] = t3;\n  } else {\n    t3 = $[7];\n  }\n  return t3;\n}\nconst useStorageContext = createContextHook(StorageContext);\nconst SvgArgument = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M5.0484 1.40838C6.12624 0.33054 7.87376 0.330541 8.9516 1.40838L12.5916 5.0484C13.6695 6.12624 13.6695 7.87376 12.5916 8.9516L8.9516 12.5916C7.87376 13.6695 6.12624 13.6695 5.0484 12.5916L1.40838 8.9516C0.33054 7.87376 0.330541 6.12624 1.40838 5.0484L5.0484 1.40838Z\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 6, y: 6, width: 2, height: 2, rx: 1, fill: \"currentColor\" }));\nconst SvgChevronDown = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 9\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1 1L7 7L13 1\", stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgChevronLeft = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 7 10\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M6 1.04819L2 5.04819L6 9.04819\", stroke: \"currentColor\", strokeWidth: 1.75 }));\nconst SvgChevronUp = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 9\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M13 8L7 2L1 8\", stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgClose = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", stroke: \"currentColor\", strokeWidth: 3, xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1 1L12.9998 12.9997\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M13 1L1.00079 13.0003\" }));\nconst SvgCopy = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"-2 -2 22 22\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M11.25 14.2105V15.235C11.25 16.3479 10.3479 17.25 9.23501 17.25H2.76499C1.65214 17.25 0.75 16.3479 0.75 15.235L0.75 8.76499C0.75 7.65214 1.65214 6.75 2.76499 6.75L3.78947 6.75\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 6.75, y: 0.75, width: 10.5, height: 10.5, rx: 2.2069, stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgDeprecatedArgument = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M5.0484 1.40838C6.12624 0.33054 7.87376 0.330541 8.9516 1.40838L12.5916 5.0484C13.6695 6.12624 13.6695 7.87376 12.5916 8.9516L8.9516 12.5916C7.87376 13.6695 6.12624 13.6695 5.0484 12.5916L1.40838 8.9516C0.33054 7.87376 0.330541 6.12624 1.40838 5.0484L5.0484 1.40838Z\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M5 9L9 5\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M5 5L9 9\", stroke: \"currentColor\", strokeWidth: 1.2 }));\nconst SvgDeprecatedEnumValue = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 12 12\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4 8L8 4\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4 4L8 8\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M8.5 1.2H9C9.99411 1.2 10.8 2.00589 10.8 3V9C10.8 9.99411 9.99411 10.8 9 10.8H8.5V12H9C10.6569 12 12 10.6569 12 9V3C12 1.34315 10.6569 0 9 0H8.5V1.2ZM3.5 1.2V0H3C1.34315 0 0 1.34315 0 3V9C0 10.6569 1.34315 12 3 12H3.5V10.8H3C2.00589 10.8 1.2 9.99411 1.2 9V3C1.2 2.00589 2.00589 1.2 3 1.2H3.5Z\", fill: \"currentColor\" }));\nconst SvgDeprecatedField = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 12 12\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 0.6, y: 0.6, width: 10.8, height: 10.8, rx: 3.4, stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4 8L8 4\", stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4 4L8 8\", stroke: \"currentColor\", strokeWidth: 1.2 }));\nconst SvgDirective = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0.5 12 12\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 7, y: 5.5, width: 2, height: 2, rx: 1, transform: \"rotate(90 7 5.5)\", fill: \"currentColor\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M10.8 9L10.8 9.5C10.8 10.4941 9.99411 11.3 9 11.3L3 11.3C2.00589 11.3 1.2 10.4941 1.2 9.5L1.2 9L-3.71547e-07 9L-3.93402e-07 9.5C-4.65826e-07 11.1569 1.34314 12.5 3 12.5L9 12.5C10.6569 12.5 12 11.1569 12 9.5L12 9L10.8 9ZM10.8 4L12 4L12 3.5C12 1.84315 10.6569 0.5 9 0.5L3 0.5C1.34315 0.5 -5.87117e-08 1.84315 -1.31135e-07 3.5L-1.5299e-07 4L1.2 4L1.2 3.5C1.2 2.50589 2.00589 1.7 3 1.7L9 1.7C9.99411 1.7 10.8 2.50589 10.8 3.5L10.8 4Z\", fill: \"currentColor\" }));\nconst SvgDocsFilled = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 20 24\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M0.75 3C0.75 1.75736 1.75736 0.75 3 0.75H17.25C17.8023 0.75 18.25 1.19772 18.25 1.75V5.25\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M0.75 3C0.75 4.24264 1.75736 5.25 3 5.25H18.25C18.8023 5.25 19.25 5.69771 19.25 6.25V22.25C19.25 22.8023 18.8023 23.25 18.25 23.25H3C1.75736 23.25 0.75 22.2426 0.75 21V3Z\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M3 5.25C1.75736 5.25 0.75 4.24264 0.75 3V21C0.75 22.2426 1.75736 23.25 3 23.25H18.25C18.8023 23.25 19.25 22.8023 19.25 22.25V6.25C19.25 5.69771 18.8023 5.25 18.25 5.25H3ZM13 11L6 11V12.5L13 12.5V11Z\", fill: \"currentColor\" }));\nconst SvgDocs = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 20 24\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M0.75 3C0.75 4.24264 1.75736 5.25 3 5.25H17.25M0.75 3C0.75 1.75736 1.75736 0.75 3 0.75H16.25C16.8023 0.75 17.25 1.19772 17.25 1.75V5.25M0.75 3V21C0.75 22.2426 1.75736 23.25 3 23.25H18.25C18.8023 23.25 19.25 22.8023 19.25 22.25V6.25C19.25 5.69771 18.8023 5.25 18.25 5.25H17.25\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"line\", { x1: 13, y1: 11.75, x2: 6, y2: 11.75, stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgEnumValue = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 12 12\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 5, y: 5, width: 2, height: 2, rx: 1, fill: \"currentColor\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M8.5 1.2H9C9.99411 1.2 10.8 2.00589 10.8 3V9C10.8 9.99411 9.99411 10.8 9 10.8H8.5V12H9C10.6569 12 12 10.6569 12 9V3C12 1.34315 10.6569 0 9 0H8.5V1.2ZM3.5 1.2V0H3C1.34315 0 0 1.34315 0 3V9C0 10.6569 1.34315 12 3 12H3.5V10.8H3C2.00589 10.8 1.2 9.99411 1.2 9V3C1.2 2.00589 2.00589 1.2 3 1.2H3.5Z\", fill: \"currentColor\" }));\nconst SvgField = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 12 13\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 0.6, y: 1.1, width: 10.8, height: 10.8, rx: 2.4, stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 5, y: 5.5, width: 2, height: 2, rx: 1, fill: \"currentColor\" }));\nconst SvgHistory = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 24 20\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1.59375 9.52344L4.87259 12.9944L8.07872 9.41249\", stroke: \"currentColor\", strokeWidth: 1.5, strokeLinecap: \"square\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M13.75 5.25V10.75H18.75\", stroke: \"currentColor\", strokeWidth: 1.5, strokeLinecap: \"square\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4.95427 11.9332C4.55457 10.0629 4.74441 8.11477 5.49765 6.35686C6.25089 4.59894 7.5305 3.11772 9.16034 2.11709C10.7902 1.11647 12.6901 0.645626 14.5986 0.769388C16.5071 0.893151 18.3303 1.60543 19.8172 2.80818C21.3042 4.01093 22.3818 5.64501 22.9017 7.48548C23.4216 9.32595 23.3582 11.2823 22.7203 13.0853C22.0824 14.8883 20.9013 16.4492 19.3396 17.5532C17.778 18.6572 15.9125 19.25 14 19.25\", stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgImplements = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 12 12\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"circle\", { cx: 6, cy: 6, r: 5.4, stroke: \"currentColor\", strokeWidth: 1.2, strokeDasharray: \"4.241025 4.241025\", transform: \"rotate(22.5)\", \"transform-origin\": \"center\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"circle\", { cx: 6, cy: 6, r: 1, fill: \"currentColor\" }));\nconst SvgKeyboardShortcut = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 19 18\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1.5 14.5653C1.5 15.211 1.75652 15.8303 2.21314 16.2869C2.66975 16.7435 3.28905 17 3.9348 17C4.58054 17 5.19984 16.7435 5.65646 16.2869C6.11307 15.8303 6.36959 15.211 6.36959 14.5653V12.1305H3.9348C3.28905 12.1305 2.66975 12.387 2.21314 12.8437C1.75652 13.3003 1.5 13.9195 1.5 14.5653Z\", stroke: \"currentColor\", strokeWidth: 1.125, strokeLinecap: \"round\", strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M3.9348 1.00063C3.28905 1.00063 2.66975 1.25715 2.21314 1.71375C1.75652 2.17035 1.5 2.78964 1.5 3.43537C1.5 4.0811 1.75652 4.70038 2.21314 5.15698C2.66975 5.61358 3.28905 5.8701 3.9348 5.8701H6.36959V3.43537C6.36959 2.78964 6.11307 2.17035 5.65646 1.71375C5.19984 1.25715 4.58054 1.00063 3.9348 1.00063Z\", stroke: \"currentColor\", strokeWidth: 1.125, strokeLinecap: \"round\", strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M15.0652 12.1305H12.6304V14.5653C12.6304 15.0468 12.7732 15.5175 13.0407 15.9179C13.3083 16.3183 13.6885 16.6304 14.1334 16.8147C14.5783 16.9989 15.0679 17.0472 15.5402 16.9532C16.0125 16.8593 16.4464 16.6274 16.7869 16.2869C17.1274 15.9464 17.3593 15.5126 17.4532 15.0403C17.5472 14.568 17.4989 14.0784 17.3147 13.6335C17.1304 13.1886 16.8183 12.8084 16.4179 12.5409C16.0175 12.2733 15.5468 12.1305 15.0652 12.1305Z\", stroke: \"currentColor\", strokeWidth: 1.125, strokeLinecap: \"round\", strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M12.6318 5.86775H6.36955V12.1285H12.6318V5.86775Z\", stroke: \"currentColor\", strokeWidth: 1.125, strokeLinecap: \"round\", strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M17.5 3.43473C17.5 2.789 17.2435 2.16972 16.7869 1.71312C16.3303 1.25652 15.711 1 15.0652 1C14.4195 1 13.8002 1.25652 13.3435 1.71312C12.8869 2.16972 12.6304 2.789 12.6304 3.43473V5.86946H15.0652C15.711 5.86946 16.3303 5.61295 16.7869 5.15635C17.2435 4.69975 17.5 4.08046 17.5 3.43473Z\", stroke: \"currentColor\", strokeWidth: 1.125, strokeLinecap: \"round\", strokeLinejoin: \"round\" }));\nconst SvgMagnifyingGlass = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 13 13\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"circle\", { cx: 5, cy: 5, r: 4.35, stroke: \"currentColor\", strokeWidth: 1.3 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"line\", { x1: 8.45962, y1: 8.54038, x2: 11.7525, y2: 11.8333, stroke: \"currentColor\", strokeWidth: 1.3 }));\nconst SvgMerge = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"-2 -2 22 22\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M17.2492 6V2.9569C17.2492 1.73806 16.2611 0.75 15.0423 0.75L2.9569 0.75C1.73806 0.75 0.75 1.73806 0.75 2.9569L0.75 6\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M0.749873 12V15.0431C0.749873 16.2619 1.73794 17.25 2.95677 17.25H15.0421C16.261 17.25 17.249 16.2619 17.249 15.0431V12\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M6 4.5L9 7.5L12 4.5\", stroke: \"currentColor\", strokeWidth: 1.5 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M12 13.5L9 10.5L6 13.5\", stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgPen = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M0.75 13.25L0.0554307 12.967C-0.0593528 13.2488 0.00743073 13.5719 0.224488 13.7851C0.441545 13.9983 0.765869 14.0592 1.04549 13.9393L0.75 13.25ZM12.8214 1.83253L12.2911 2.36286L12.2911 2.36286L12.8214 1.83253ZM12.8214 3.90194L13.3517 4.43227L12.8214 3.90194ZM10.0981 1.17859L9.56773 0.648259L10.0981 1.17859ZM12.1675 1.17859L12.6978 0.648258L12.6978 0.648257L12.1675 1.17859ZM2.58049 8.75697L3.27506 9.03994L2.58049 8.75697ZM2.70066 8.57599L3.23099 9.10632L2.70066 8.57599ZM5.2479 11.4195L4.95355 10.7297L5.2479 11.4195ZM5.42036 11.303L4.89003 10.7727L5.42036 11.303ZM4.95355 10.7297C4.08882 11.0987 3.41842 11.362 2.73535 11.6308C2.05146 11.9 1.35588 12.1743 0.454511 12.5607L1.04549 13.9393C1.92476 13.5624 2.60256 13.2951 3.28469 13.0266C3.96762 12.7578 4.65585 12.4876 5.54225 12.1093L4.95355 10.7297ZM1.44457 13.533L3.27506 9.03994L1.88592 8.474L0.0554307 12.967L1.44457 13.533ZM3.23099 9.10632L10.6284 1.70892L9.56773 0.648259L2.17033 8.04566L3.23099 9.10632ZM11.6371 1.70892L12.2911 2.36286L13.3517 1.3022L12.6978 0.648258L11.6371 1.70892ZM12.2911 3.37161L4.89003 10.7727L5.95069 11.8333L13.3517 4.43227L12.2911 3.37161ZM12.2911 2.36286C12.5696 2.64142 12.5696 3.09305 12.2911 3.37161L13.3517 4.43227C14.2161 3.56792 14.2161 2.16654 13.3517 1.3022L12.2911 2.36286ZM10.6284 1.70892C10.9069 1.43036 11.3586 1.43036 11.6371 1.70892L12.6978 0.648257C11.8335 -0.216088 10.4321 -0.216084 9.56773 0.648259L10.6284 1.70892ZM3.27506 9.03994C3.26494 9.06479 3.24996 9.08735 3.23099 9.10632L2.17033 8.04566C2.04793 8.16806 1.95123 8.31369 1.88592 8.474L3.27506 9.03994ZM5.54225 12.1093C5.69431 12.0444 5.83339 11.9506 5.95069 11.8333L4.89003 10.7727C4.90863 10.7541 4.92988 10.7398 4.95355 10.7297L5.54225 12.1093Z\", fill: \"currentColor\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M11.5 4.5L9.5 2.5\", stroke: \"currentColor\", strokeWidth: 1.4026, strokeLinecap: \"round\", strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M5.5 10.5L3.5 8.5\", stroke: \"currentColor\", strokeWidth: 1.4026, strokeLinecap: \"round\", strokeLinejoin: \"round\" }));\nconst SvgPlay = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 16 18\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1.32226e-07 1.6609C7.22332e-08 0.907329 0.801887 0.424528 1.46789 0.777117L15.3306 8.11621C16.0401 8.49182 16.0401 9.50818 15.3306 9.88379L1.46789 17.2229C0.801886 17.5755 1.36076e-06 17.0927 1.30077e-06 16.3391L1.32226e-07 1.6609Z\", fill: \"currentColor\" }));\nconst SvgPlus = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 10 16\", fill: \"currentColor\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M4.25 9.25V13.5H5.75V9.25L10 9.25V7.75L5.75 7.75V3.5H4.25V7.75L0 7.75V9.25L4.25 9.25Z\" }));\nconst SvgPrettify = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { width: 25, height: 25, viewBox: \"0 0 25 25\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M10.2852 24.0745L13.7139 18.0742\", stroke: \"currentColor\", strokeWidth: 1.5625 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M14.5742 24.0749L17.1457 19.7891\", stroke: \"currentColor\", strokeWidth: 1.5625 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M19.4868 24.0735L20.7229 21.7523C21.3259 20.6143 21.5457 19.3122 21.3496 18.0394C21.1535 16.7666 20.5519 15.591 19.6342 14.6874L23.7984 6.87853C24.0123 6.47728 24.0581 6.00748 23.9256 5.57249C23.7932 5.1375 23.4933 4.77294 23.0921 4.55901C22.6908 4.34509 22.221 4.29932 21.7861 4.43178C21.3511 4.56424 20.9865 4.86408 20.7726 5.26533L16.6084 13.0742C15.3474 12.8142 14.0362 12.9683 12.8699 13.5135C11.7035 14.0586 10.7443 14.9658 10.135 16.1L6 24.0735\", stroke: \"currentColor\", strokeWidth: 1.5625 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4 15L5 13L7 12L5 11L4 9L3 11L1 12L3 13L4 15Z\", stroke: \"currentColor\", strokeWidth: 1.5625, strokeLinejoin: \"round\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M11.5 8L12.6662 5.6662L15 4.5L12.6662 3.3338L11.5 1L10.3338 3.3338L8 4.5L10.3338 5.6662L11.5 8Z\", stroke: \"currentColor\", strokeWidth: 1.5625, strokeLinejoin: \"round\" }));\nconst SvgReload = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 16 16\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4.75 9.25H1.25V12.75\", stroke: \"currentColor\", strokeWidth: 1, strokeLinecap: \"square\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M11.25 6.75H14.75V3.25\", stroke: \"currentColor\", strokeWidth: 1, strokeLinecap: \"square\" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M14.1036 6.65539C13.8 5.27698 13.0387 4.04193 11.9437 3.15131C10.8487 2.26069 9.48447 1.76694 8.0731 1.75043C6.66173 1.73392 5.28633 2.19563 4.17079 3.0604C3.05526 3.92516 2.26529 5.14206 1.92947 6.513\", stroke: \"currentColor\", strokeWidth: 1 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M1.89635 9.34461C2.20001 10.723 2.96131 11.9581 4.05631 12.8487C5.15131 13.7393 6.51553 14.2331 7.9269 14.2496C9.33827 14.2661 10.7137 13.8044 11.8292 12.9396C12.9447 12.0748 13.7347 10.8579 14.0705 9.487\", stroke: \"currentColor\", strokeWidth: 1 }));\nconst SvgRootType = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 13 13\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 0.6, y: 0.6, width: 11.8, height: 11.8, rx: 5.9, stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M4.25 7.5C4.25 6 5.75 5 6.5 6.5C7.25 8 8.75 7 8.75 5.5\", stroke: \"currentColor\", strokeWidth: 1.2 }));\nconst SvgSettings = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 21 20\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { fillRule: \"evenodd\", clipRule: \"evenodd\", d: \"M9.29186 1.92702C9.06924 1.82745 8.87014 1.68202 8.70757 1.50024L7.86631 0.574931C7.62496 0.309957 7.30773 0.12592 6.95791 0.0479385C6.60809 -0.0300431 6.24274 0.00182978 5.91171 0.139208C5.58068 0.276585 5.3001 0.512774 5.10828 0.815537C4.91645 1.1183 4.82272 1.47288 4.83989 1.83089L4.90388 3.08019C4.91612 3.32348 4.87721 3.56662 4.78968 3.79394C4.70215 4.02126 4.56794 4.2277 4.39571 4.39994C4.22347 4.57219 4.01704 4.7064 3.78974 4.79394C3.56243 4.88147 3.3193 4.92038 3.07603 4.90814L1.8308 4.84414C1.47162 4.82563 1.11553 4.91881 0.811445 5.11086C0.507359 5.30292 0.270203 5.58443 0.132561 5.91671C-0.00508149 6.249 -0.0364554 6.61576 0.0427496 6.9666C0.121955 7.31744 0.307852 7.63514 0.5749 7.87606L1.50016 8.71204C1.68193 8.87461 1.82735 9.07373 1.92692 9.29636C2.02648 9.51898 2.07794 9.76012 2.07794 10.004C2.07794 10.2479 2.02648 10.489 1.92692 10.7116C1.82735 10.9343 1.68193 11.1334 1.50016 11.296L0.5749 12.1319C0.309856 12.3729 0.125575 12.6898 0.0471809 13.0393C-0.0312128 13.3888 9.64098e-05 13.754 0.13684 14.0851C0.273583 14.4162 0.509106 14.6971 0.811296 14.8894C1.11349 15.0817 1.46764 15.1762 1.82546 15.1599L3.0707 15.0959C3.31397 15.0836 3.5571 15.1225 3.7844 15.2101C4.01171 15.2976 4.21814 15.4318 4.39037 15.6041C4.56261 15.7763 4.69682 15.9827 4.78435 16.2101C4.87188 16.4374 4.91078 16.6805 4.89855 16.9238L4.83455 18.1691C4.81605 18.5283 4.90921 18.8844 5.10126 19.1885C5.2933 19.4926 5.5748 19.7298 5.90707 19.8674C6.23934 20.0051 6.60608 20.0365 6.9569 19.9572C7.30772 19.878 7.6254 19.6921 7.86631 19.4251L8.7129 18.4998C8.87547 18.318 9.07458 18.1725 9.29719 18.073C9.51981 17.9734 9.76093 17.9219 10.0048 17.9219C10.2487 17.9219 10.4898 17.9734 10.7124 18.073C10.935 18.1725 11.1341 18.318 11.2967 18.4998L12.1326 19.4251C12.3735 19.6921 12.6912 19.878 13.042 19.9572C13.3929 20.0365 13.7596 20.0051 14.0919 19.8674C14.4241 19.7298 14.7056 19.4926 14.8977 19.1885C15.0897 18.8844 15.1829 18.5283 15.1644 18.1691L15.1004 16.9238C15.0882 16.6805 15.1271 16.4374 15.2146 16.2101C15.3021 15.9827 15.4363 15.7763 15.6086 15.6041C15.7808 15.4318 15.9872 15.2976 16.2145 15.2101C16.4418 15.1225 16.685 15.0836 16.9282 15.0959L18.1735 15.1599C18.5326 15.1784 18.8887 15.0852 19.1928 14.8931C19.4969 14.7011 19.7341 14.4196 19.8717 14.0873C20.0093 13.755 20.0407 13.3882 19.9615 13.0374C19.8823 12.6866 19.6964 12.3689 19.4294 12.1279L18.5041 11.292C18.3223 11.1294 18.1769 10.9303 18.0774 10.7076C17.9778 10.485 17.9263 10.2439 17.9263 10C17.9263 9.75612 17.9778 9.51499 18.0774 9.29236C18.1769 9.06973 18.3223 8.87062 18.5041 8.70804L19.4294 7.87206C19.6964 7.63114 19.8823 7.31344 19.9615 6.9626C20.0407 6.61176 20.0093 6.245 19.8717 5.91271C19.7341 5.58043 19.4969 5.29892 19.1928 5.10686C18.8887 4.91481 18.5326 4.82163 18.1735 4.84014L16.9282 4.90414C16.685 4.91638 16.4418 4.87747 16.2145 4.78994C15.9872 4.7024 15.7808 4.56818 15.6086 4.39594C15.4363 4.2237 15.3021 4.01726 15.2146 3.78994C15.1271 3.56262 15.0882 3.31948 15.1004 3.07619L15.1644 1.83089C15.1829 1.4717 15.0897 1.11559 14.8977 0.811487C14.7056 0.507385 14.4241 0.270217 14.0919 0.132568C13.7596 -0.00508182 13.3929 -0.0364573 13.042 0.0427519C12.6912 0.121961 12.3735 0.307869 12.1326 0.574931L11.2914 1.50024C11.1288 1.68202 10.9297 1.82745 10.7071 1.92702C10.4845 2.02659 10.2433 2.07805 9.99947 2.07805C9.7556 2.07805 9.51448 2.02659 9.29186 1.92702ZM14.3745 10C14.3745 12.4162 12.4159 14.375 9.99977 14.375C7.58365 14.375 5.625 12.4162 5.625 10C5.625 7.58375 7.58365 5.625 9.99977 5.625C12.4159 5.625 14.3745 7.58375 14.3745 10Z\", fill: \"currentColor\" }));\nconst SvgStarFilled = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M6.5782 1.07092C6.71096 0.643026 7.28904 0.643027 7.4218 1.07092L8.59318 4.84622C8.65255 5.03758 8.82284 5.16714 9.01498 5.16714L12.8056 5.16714C13.2353 5.16714 13.4139 5.74287 13.0663 6.00732L9.99962 8.34058C9.84418 8.45885 9.77913 8.66848 9.83851 8.85984L11.0099 12.6351C11.1426 13.063 10.675 13.4189 10.3274 13.1544L7.26069 10.8211C7.10524 10.7029 6.89476 10.7029 6.73931 10.8211L3.6726 13.1544C3.32502 13.4189 2.85735 13.063 2.99012 12.6351L4.16149 8.85984C4.22087 8.66848 4.15582 8.45885 4.00038 8.34058L0.933671 6.00732C0.586087 5.74287 0.764722 5.16714 1.19436 5.16714L4.98502 5.16714C5.17716 5.16714 5.34745 5.03758 5.40682 4.84622L6.5782 1.07092Z\", fill: \"currentColor\", stroke: \"currentColor\" }));\nconst SvgStar = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 14 14\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M6.5782 1.07092C6.71096 0.643026 7.28904 0.643027 7.4218 1.07092L8.59318 4.84622C8.65255 5.03758 8.82284 5.16714 9.01498 5.16714L12.8056 5.16714C13.2353 5.16714 13.4139 5.74287 13.0663 6.00732L9.99962 8.34058C9.84418 8.45885 9.77913 8.66848 9.83851 8.85984L11.0099 12.6351C11.1426 13.063 10.675 13.4189 10.3274 13.1544L7.26069 10.8211C7.10524 10.7029 6.89476 10.7029 6.73931 10.8211L3.6726 13.1544C3.32502 13.4189 2.85735 13.063 2.99012 12.6351L4.16149 8.85984C4.22087 8.66848 4.15582 8.45885 4.00038 8.34058L0.933671 6.00732C0.586087 5.74287 0.764722 5.16714 1.19436 5.16714L4.98502 5.16714C5.17716 5.16714 5.34745 5.03758 5.40682 4.84622L6.5782 1.07092Z\", stroke: \"currentColor\", strokeWidth: 1.5 }));\nconst SvgStop = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 16 16\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { width: 16, height: 16, rx: 2, fill: \"currentColor\" }));\nconst SvgTrash = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { width: \"1em\", height: \"5em\", xmlns: \"http://www.w3.org/2000/svg\", fillRule: \"evenodd\", \"aria-hidden\": \"true\", viewBox: \"0 0 23 23\", style: {\n  height: \"1.5em\"\n}, clipRule: \"evenodd\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"path\", { d: \"M19 24h-14c-1.104 0-2-.896-2-2v-17h-1v-2h6v-1.5c0-.827.673-1.5 1.5-1.5h5c.825 0 1.5.671 1.5 1.5v1.5h6v2h-1v17c0 1.104-.896 2-2 2zm0-19h-14v16.5c0 .276.224.5.5.5h13c.276 0 .5-.224.5-.5v-16.5zm-7 7.586l3.293-3.293 1.414 1.414-3.293 3.293 3.293 3.293-1.414 1.414-3.293-3.293-3.293 3.293-1.414-1.414 3.293-3.293-3.293-3.293 1.414-1.414 3.293 3.293zm2-10.586h-4v1h4v-1z\", fill: \"currentColor\", strokeWidth: 0.25, stroke: \"currentColor\" }));\nconst SvgType = ({\n  title,\n  titleId,\n  ...props\n}) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"svg\", { height: \"1em\", viewBox: \"0 0 13 13\", fill: \"none\", xmlns: \"http://www.w3.org/2000/svg\", \"aria-labelledby\": titleId, ...props }, title ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"title\", { id: titleId }, title) : null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 0.6, y: 0.6, width: 11.8, height: 11.8, rx: 5.9, stroke: \"currentColor\", strokeWidth: 1.2 }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_2__.createElement(\"rect\", { x: 5.5, y: 5.5, width: 2, height: 2, rx: 1, fill: \"currentColor\" }));\nconst ArgumentIcon = generateIcon(SvgArgument);\nconst ChevronDownIcon = generateIcon(SvgChevronDown);\nconst ChevronLeftIcon = generateIcon(SvgChevronLeft);\nconst ChevronUpIcon = generateIcon(SvgChevronUp);\nconst CloseIcon = generateIcon(SvgClose);\nconst CopyIcon = generateIcon(SvgCopy);\nconst DeprecatedArgumentIcon = generateIcon(SvgDeprecatedArgument);\nconst DeprecatedEnumValueIcon = generateIcon(SvgDeprecatedEnumValue);\nconst DeprecatedFieldIcon = generateIcon(SvgDeprecatedField);\nconst DirectiveIcon = generateIcon(SvgDirective);\nconst DocsFilledIcon = generateIcon(SvgDocsFilled);\nconst DocsIcon = generateIcon(SvgDocs);\nconst EnumValueIcon = generateIcon(SvgEnumValue);\nconst FieldIcon = generateIcon(SvgField);\nconst HistoryIcon = generateIcon(SvgHistory);\nconst ImplementsIcon = generateIcon(SvgImplements);\nconst KeyboardShortcutIcon = generateIcon(SvgKeyboardShortcut);\nconst MagnifyingGlassIcon = generateIcon(SvgMagnifyingGlass);\nconst MergeIcon = generateIcon(SvgMerge);\nconst PenIcon = generateIcon(SvgPen);\nconst PlayIcon = generateIcon(SvgPlay);\nconst PlusIcon = generateIcon(SvgPlus);\nconst PrettifyIcon = generateIcon(SvgPrettify);\nconst ReloadIcon = generateIcon(SvgReload);\nconst RootTypeIcon = generateIcon(SvgRootType);\nconst SettingsIcon = generateIcon(SvgSettings);\nconst StarFilledIcon = generateIcon(SvgStarFilled);\nconst StarIcon = generateIcon(SvgStar);\nconst StopIcon = generateIcon(SvgStop);\nconst TrashIcon = generateIcon(SvgTrash);\nconst TypeIcon = generateIcon(SvgType);\nfunction generateIcon(RawComponent) {\n  const title = RawComponent.name.replace(\"Svg\", \"\").replaceAll(/([A-Z])/g, \" $1\").trimStart().toLowerCase() + \" icon\";\n  function IconComponent(props) {\n    const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n    let t0;\n    if ($[0] !== props) {\n      t0 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RawComponent, { title, ...props });\n      $[0] = props;\n      $[1] = t0;\n    } else {\n      t0 = $[1];\n    }\n    return t0;\n  }\n  IconComponent.displayName = RawComponent.name;\n  return IconComponent;\n}\nconst UnStyledButton = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-un-styled\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"button\", { ...props, ref, className: t0 });\n    $[2] = props;\n    $[3] = ref;\n    $[4] = t0;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  return t1;\n});\nUnStyledButton.displayName = \"UnStyledButton\";\nconst Button$1 = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  let t0;\n  if ($[0] !== props.className || $[1] !== props.state) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-button\", {\n      success: \"graphiql-button-success\",\n      error: \"graphiql-button-error\"\n    }[props.state], props.className);\n    $[0] = props.className;\n    $[1] = props.state;\n    $[2] = t0;\n  } else {\n    t0 = $[2];\n  }\n  let t1;\n  if ($[3] !== props || $[4] !== ref || $[5] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"button\", { ...props, ref, className: t0 });\n    $[3] = props;\n    $[4] = ref;\n    $[5] = t0;\n    $[6] = t1;\n  } else {\n    t1 = $[6];\n  }\n  return t1;\n});\nButton$1.displayName = \"Button\";\nconst ButtonGroup = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-button-group\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { ...props, ref, className: t0 });\n    $[2] = props;\n    $[3] = ref;\n    $[4] = t0;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  return t1;\n});\nButtonGroup.displayName = \"ButtonGroup\";\nconst createComponentGroup = (root, children) => Object.entries(children).reduce((r, [key, value]) => {\n  r[key] = value;\n  return r;\n}, root);\nconst DialogClose = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(8);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-dialog-close\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  let t2;\n  if ($[2] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_visually_hidden__WEBPACK_IMPORTED_MODULE_19__.Root, { children: \"Close dialog\" });\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(CloseIcon, {});\n    $[2] = t1;\n    $[3] = t2;\n  } else {\n    t1 = $[2];\n    t2 = $[3];\n  }\n  let t3;\n  if ($[4] !== props || $[5] !== ref || $[6] !== t0) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Close, { asChild: true, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(UnStyledButton, { ...props, ref, type: \"button\", className: t0, children: [\n      t1,\n      t2\n    ] }) });\n    $[4] = props;\n    $[5] = ref;\n    $[6] = t0;\n    $[7] = t3;\n  } else {\n    t3 = $[7];\n  }\n  return t3;\n});\nDialogClose.displayName = \"Dialog.Close\";\nfunction DialogRoot(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(9);\n  let children;\n  let props;\n  if ($[0] !== t0) {\n    ({\n      children,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = props;\n  } else {\n    children = $[1];\n    props = $[2];\n  }\n  let t1;\n  if ($[3] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Overlay, { className: \"graphiql-dialog-overlay\" });\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  let t2;\n  if ($[4] !== children) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Portal, { children: [\n      t1,\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Content, { className: \"graphiql-dialog\", children })\n    ] });\n    $[4] = children;\n    $[5] = t2;\n  } else {\n    t2 = $[5];\n  }\n  let t3;\n  if ($[6] !== props || $[7] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Root, { ...props, children: t2 });\n    $[6] = props;\n    $[7] = t2;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  return t3;\n}\nconst Dialog = createComponentGroup(DialogRoot, {\n  Close: DialogClose,\n  Title: _radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Title,\n  Trigger: _radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Trigger,\n  Description: _radix_ui_react_dialog__WEBPACK_IMPORTED_MODULE_18__.Description\n});\nconst Button = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-un-styled\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__.Trigger, { asChild: true, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"button\", { ...props, ref, className: t0 }) });\n    $[2] = props;\n    $[3] = ref;\n    $[4] = t0;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  return t1;\n});\nButton.displayName = \"DropdownMenuButton\";\nfunction Content(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(14);\n  let children;\n  let className;\n  let props;\n  let t1;\n  let t2;\n  if ($[0] !== t0) {\n    ({\n      children,\n      align: t1,\n      sideOffset: t2,\n      className,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = className;\n    $[3] = props;\n    $[4] = t1;\n    $[5] = t2;\n  } else {\n    children = $[1];\n    className = $[2];\n    props = $[3];\n    t1 = $[4];\n    t2 = $[5];\n  }\n  const align = t1 === void 0 ? \"start\" : t1;\n  const sideOffset = t2 === void 0 ? 5 : t2;\n  let t3;\n  if ($[6] !== className) {\n    t3 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-dropdown-content\", className);\n    $[6] = className;\n    $[7] = t3;\n  } else {\n    t3 = $[7];\n  }\n  let t4;\n  if ($[8] !== align || $[9] !== children || $[10] !== props || $[11] !== sideOffset || $[12] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__.Portal, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__.Content, { align, sideOffset, className: t3, ...props, children }) });\n    $[8] = align;\n    $[9] = children;\n    $[10] = props;\n    $[11] = sideOffset;\n    $[12] = t3;\n    $[13] = t4;\n  } else {\n    t4 = $[13];\n  }\n  return t4;\n}\nconst Item = (t0) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  let children;\n  let className;\n  let props;\n  if ($[0] !== t0) {\n    ({\n      className,\n      children,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = className;\n    $[3] = props;\n  } else {\n    children = $[1];\n    className = $[2];\n    props = $[3];\n  }\n  let t1;\n  if ($[4] !== className) {\n    t1 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-dropdown-item\", className);\n    $[4] = className;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  let t2;\n  if ($[6] !== children || $[7] !== props || $[8] !== t1) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__.Item, { className: t1, ...props, children });\n    $[6] = children;\n    $[7] = props;\n    $[8] = t1;\n    $[9] = t2;\n  } else {\n    t2 = $[9];\n  }\n  return t2;\n};\nconst DropdownMenu = createComponentGroup(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_20__.Root, {\n  Button,\n  Item,\n  Content\n});\nconst markdown = new markdown_it__WEBPACK_IMPORTED_MODULE_21__[\"default\"]({\n  breaks: true,\n  linkify: true\n});\nconst MarkdownContent = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((t0, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(18);\n  let children;\n  let onlyShowFirstChild;\n  let props;\n  let type;\n  if ($[0] !== t0) {\n    ({\n      children,\n      onlyShowFirstChild,\n      type,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = onlyShowFirstChild;\n    $[3] = props;\n    $[4] = type;\n  } else {\n    children = $[1];\n    onlyShowFirstChild = $[2];\n    props = $[3];\n    type = $[4];\n  }\n  const t1 = `graphiql-markdown-${type}`;\n  const t2 = onlyShowFirstChild && \"graphiql-markdown-preview\";\n  let t3;\n  if ($[5] !== props.className || $[6] !== t1 || $[7] !== t2) {\n    t3 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(t1, t2, props.className);\n    $[5] = props.className;\n    $[6] = t1;\n    $[7] = t2;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  let t4;\n  if ($[9] !== children) {\n    t4 = markdown.render(children);\n    $[9] = children;\n    $[10] = t4;\n  } else {\n    t4 = $[10];\n  }\n  let t5;\n  if ($[11] !== t4) {\n    t5 = {\n      __html: t4\n    };\n    $[11] = t4;\n    $[12] = t5;\n  } else {\n    t5 = $[12];\n  }\n  let t6;\n  if ($[13] !== props || $[14] !== ref || $[15] !== t3 || $[16] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { ...props, ref, className: t3, dangerouslySetInnerHTML: t5 });\n    $[13] = props;\n    $[14] = ref;\n    $[15] = t3;\n    $[16] = t5;\n    $[17] = t6;\n  } else {\n    t6 = $[17];\n  }\n  return t6;\n});\nMarkdownContent.displayName = \"MarkdownContent\";\nconst Spinner = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-spinner\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { ...props, ref, className: t0 });\n    $[2] = props;\n    $[3] = ref;\n    $[4] = t0;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  return t1;\n});\nSpinner.displayName = \"Spinner\";\nfunction TooltipRoot(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  const {\n    children,\n    align: t1,\n    side: t2,\n    sideOffset: t3,\n    label\n  } = t0;\n  const align = t1 === void 0 ? \"start\" : t1;\n  const side = t2 === void 0 ? \"bottom\" : t2;\n  const sideOffset = t3 === void 0 ? 5 : t3;\n  let t4;\n  if ($[0] !== children) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__.Trigger, { asChild: true, children });\n    $[0] = children;\n    $[1] = t4;\n  } else {\n    t4 = $[1];\n  }\n  let t5;\n  if ($[2] !== align || $[3] !== label || $[4] !== side || $[5] !== sideOffset) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__.Portal, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__.Content, { className: \"graphiql-tooltip\", align, side, sideOffset, children: label }) });\n    $[2] = align;\n    $[3] = label;\n    $[4] = side;\n    $[5] = sideOffset;\n    $[6] = t5;\n  } else {\n    t5 = $[6];\n  }\n  let t6;\n  if ($[7] !== t4 || $[8] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__.Root, { children: [\n      t4,\n      t5\n    ] });\n    $[7] = t4;\n    $[8] = t5;\n    $[9] = t6;\n  } else {\n    t6 = $[9];\n  }\n  return t6;\n}\nconst Tooltip = createComponentGroup(TooltipRoot, {\n  Provider: _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_23__.Provider\n});\nconst TabRoot = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((t0, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(16);\n  let children;\n  let className;\n  let isActive;\n  let props;\n  let value;\n  if ($[0] !== t0) {\n    ({\n      isActive,\n      value,\n      children,\n      className,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = className;\n    $[3] = isActive;\n    $[4] = props;\n    $[5] = value;\n  } else {\n    children = $[1];\n    className = $[2];\n    isActive = $[3];\n    props = $[4];\n    value = $[5];\n  }\n  const t1 = isActive ? \"true\" : void 0;\n  const t2 = isActive && \"graphiql-tab-active\";\n  let t3;\n  if ($[6] !== className || $[7] !== t2) {\n    t3 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-tab\", t2, className);\n    $[6] = className;\n    $[7] = t2;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  let t4;\n  if ($[9] !== children || $[10] !== props || $[11] !== ref || $[12] !== t1 || $[13] !== t3 || $[14] !== value) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(framer_motion__WEBPACK_IMPORTED_MODULE_22__.Reorder.Item, { ...props, ref, value, \"aria-selected\": t1, role: \"tab\", className: t3, children });\n    $[9] = children;\n    $[10] = props;\n    $[11] = ref;\n    $[12] = t1;\n    $[13] = t3;\n    $[14] = value;\n    $[15] = t4;\n  } else {\n    t4 = $[15];\n  }\n  return t4;\n});\nTabRoot.displayName = \"Tab\";\nconst TabButton = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-tab-button\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { ...props, ref, type: \"button\", className: t0, children: props.children });\n    $[2] = props;\n    $[3] = ref;\n    $[4] = t0;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  return t1;\n});\nTabButton.displayName = \"Tab.Button\";\nconst TabClose = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  let t0;\n  if ($[0] !== props.className) {\n    t0 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-tab-close\", props.className);\n    $[0] = props.className;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(CloseIcon, {});\n    $[2] = t1;\n  } else {\n    t1 = $[2];\n  }\n  let t2;\n  if ($[3] !== props || $[4] !== ref || $[5] !== t0) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label: \"Close Tab\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { \"aria-label\": \"Close Tab\", ...props, ref, type: \"button\", className: t0, children: t1 }) });\n    $[3] = props;\n    $[4] = ref;\n    $[5] = t0;\n    $[6] = t2;\n  } else {\n    t2 = $[6];\n  }\n  return t2;\n});\nTabClose.displayName = \"Tab.Close\";\nconst Tab = createComponentGroup(TabRoot, {\n  Button: TabButton,\n  Close: TabClose\n});\nconst Tabs = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((t0, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(15);\n  let children;\n  let className;\n  let onReorder;\n  let props;\n  let values;\n  if ($[0] !== t0) {\n    ({\n      values,\n      onReorder,\n      children,\n      className,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = children;\n    $[2] = className;\n    $[3] = onReorder;\n    $[4] = props;\n    $[5] = values;\n  } else {\n    children = $[1];\n    className = $[2];\n    onReorder = $[3];\n    props = $[4];\n    values = $[5];\n  }\n  let t1;\n  if ($[6] !== className) {\n    t1 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-tabs\", className);\n    $[6] = className;\n    $[7] = t1;\n  } else {\n    t1 = $[7];\n  }\n  let t2;\n  if ($[8] !== children || $[9] !== onReorder || $[10] !== props || $[11] !== ref || $[12] !== t1 || $[13] !== values) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(framer_motion__WEBPACK_IMPORTED_MODULE_22__.Reorder.Group, { ...props, ref, values, onReorder, axis: \"x\", role: \"tablist\", className: t1, children });\n    $[8] = children;\n    $[9] = onReorder;\n    $[10] = props;\n    $[11] = ref;\n    $[12] = t1;\n    $[13] = values;\n    $[14] = t2;\n  } else {\n    t2 = $[14];\n  }\n  return t2;\n});\nTabs.displayName = \"Tabs\";\nconst HistoryContext = createNullableContext(\"HistoryContext\");\nfunction HistoryContextProvider(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(11);\n  const {\n    maxHistoryLength: t1,\n    children\n  } = t0;\n  const maxHistoryLength = t1 === void 0 ? DEFAULT_HISTORY_LENGTH : t1;\n  const storage = useStorageContext();\n  let t2;\n  if ($[0] !== maxHistoryLength || $[1] !== storage) {\n    t2 = () => new _graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.HistoryStore(storage || new _graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.StorageAPI(null), maxHistoryLength);\n    $[0] = maxHistoryLength;\n    $[1] = storage;\n    $[2] = t2;\n  } else {\n    t2 = $[2];\n  }\n  const [historyStore] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t2);\n  let t3;\n  if ($[3] !== historyStore.queries) {\n    t3 = () => historyStore.queries || [];\n    $[3] = historyStore.queries;\n    $[4] = t3;\n  } else {\n    t3 = $[4];\n  }\n  const [items, setItems] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t3);\n  let t4;\n  if ($[5] !== historyStore || $[6] !== items) {\n    t4 = {\n      addToHistory(operation) {\n        historyStore.updateHistory(operation);\n        setItems(historyStore.queries);\n      },\n      editLabel(operation_0, index) {\n        historyStore.editLabel(operation_0, index);\n        setItems(historyStore.queries);\n      },\n      items,\n      toggleFavorite(operation_1) {\n        historyStore.toggleFavorite(operation_1);\n        setItems(historyStore.queries);\n      },\n      setActive: _temp$9,\n      deleteFromHistory(item_0, clearFavorites) {\n        historyStore.deleteHistory(item_0, clearFavorites);\n        setItems(historyStore.queries);\n      }\n    };\n    $[5] = historyStore;\n    $[6] = items;\n    $[7] = t4;\n  } else {\n    t4 = $[7];\n  }\n  const value = t4;\n  let t5;\n  if ($[8] !== children || $[9] !== value) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HistoryContext.Provider, { value, children });\n    $[8] = children;\n    $[9] = value;\n    $[10] = t5;\n  } else {\n    t5 = $[10];\n  }\n  return t5;\n}\nfunction _temp$9(item) {\n  return item;\n}\nconst useHistoryContext = createContextHook(HistoryContext);\nconst DEFAULT_HISTORY_LENGTH = 20;\nfunction handleDelete(items, deleteFromHistory) {\n  for (const item of items) {\n    deleteFromHistory(item, true);\n  }\n}\nfunction History() {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(11);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    items: all,\n    deleteFromHistory\n  } = useHistoryContext(t0);\n  let items;\n  items = all.slice().map(_temp$8).reverse();\n  const favorites = items.filter(_temp2$5);\n  if (favorites.length) {\n    items = items.filter(_temp3$4);\n  }\n  const [clearStatus, setClearStatus] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  let t1;\n  let t2;\n  if ($[1] !== clearStatus) {\n    t1 = () => {\n      if (clearStatus) {\n        setTimeout(() => {\n          setClearStatus(null);\n        }, 2e3);\n      }\n    };\n    t2 = [clearStatus];\n    $[1] = clearStatus;\n    $[2] = t1;\n    $[3] = t2;\n  } else {\n    t1 = $[2];\n    t2 = $[3];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n  const handleClearStatus = () => {\n    try {\n      handleDelete(items, deleteFromHistory);\n      setClearStatus(\"success\");\n    } catch {\n      setClearStatus(\"error\");\n    }\n  };\n  const t3 = \"History\";\n  const t4 = \"graphiql-history\";\n  const t5 = (clearStatus || items.length > 0) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Button$1, { type: \"button\", state: clearStatus || void 0, disabled: !items.length, onClick: handleClearStatus, children: {\n    success: \"Cleared\",\n    error: \"Failed to Clear\"\n  }[clearStatus] || \"Clear\" });\n  let t6;\n  if ($[4] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-history-header\", children: [\n      \"History\",\n      t5\n    ] });\n    $[4] = t5;\n    $[5] = t6;\n  } else {\n    t6 = $[5];\n  }\n  const t7 = Boolean(favorites.length) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"ul\", { className: \"graphiql-history-items\", children: favorites.map(_temp4$3) });\n  const t8 = Boolean(favorites.length) && Boolean(items.length) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-history-item-spacer\" });\n  const t9 = Boolean(items.length) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"ul\", { className: \"graphiql-history-items\", children: items.map(_temp5$1) });\n  let t10;\n  if ($[6] !== t6 || $[7] !== t7 || $[8] !== t8 || $[9] !== t9) {\n    t10 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"section\", { \"aria-label\": t3, className: t4, children: [\n      t6,\n      t7,\n      t8,\n      t9\n    ] });\n    $[6] = t6;\n    $[7] = t7;\n    $[8] = t8;\n    $[9] = t9;\n    $[10] = t10;\n  } else {\n    t10 = $[10];\n  }\n  return t10;\n}\nfunction _temp5$1(item_3) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HistoryItem, { item: item_3 }, item_3.index);\n}\nfunction _temp4$3(item_2) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HistoryItem, { item: item_2 }, item_2.index);\n}\nfunction _temp3$4(item_1) {\n  return !item_1.favorite;\n}\nfunction _temp2$5(item_0) {\n  return item_0.favorite;\n}\nfunction _temp$8(item, i) {\n  return {\n    ...item,\n    index: i\n  };\n}\nfunction HistoryItem(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(40);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: HistoryItem\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    editLabel,\n    toggleFavorite,\n    deleteFromHistory,\n    setActive\n  } = useHistoryContext(t0);\n  let t1;\n  if ($[1] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: HistoryItem\n    };\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    headerEditor,\n    queryEditor,\n    variableEditor\n  } = useEditorContext(t1);\n  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const buttonRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const [isEditable, setIsEditable] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  let t2;\n  let t3;\n  if ($[2] !== isEditable) {\n    t2 = () => {\n      var _a;\n      if (isEditable) {\n        (_a = inputRef.current) == null ? void 0 : _a.focus();\n      }\n    };\n    t3 = [isEditable];\n    $[2] = isEditable;\n    $[3] = t2;\n    $[4] = t3;\n  } else {\n    t2 = $[3];\n    t3 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t2, t3);\n  let t4;\n  if ($[5] !== props.item.label || $[6] !== props.item.operationName || $[7] !== props.item.query) {\n    t4 = props.item.label || props.item.operationName || formatQuery(props.item.query);\n    $[5] = props.item.label;\n    $[6] = props.item.operationName;\n    $[7] = props.item.query;\n    $[8] = t4;\n  } else {\n    t4 = $[8];\n  }\n  const displayName = t4;\n  let t5;\n  if ($[9] !== editLabel || $[10] !== props.item) {\n    t5 = () => {\n      var _a;\n      setIsEditable(false);\n      const {\n        index,\n        ...item\n      } = props.item;\n      editLabel({\n        ...item,\n        label: (_a = inputRef.current) == null ? void 0 : _a.value\n      }, index);\n    };\n    $[9] = editLabel;\n    $[10] = props.item;\n    $[11] = t5;\n  } else {\n    t5 = $[11];\n  }\n  const handleSave = t5;\n  let t6;\n  if ($[12] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t6 = () => {\n      setIsEditable(false);\n    };\n    $[12] = t6;\n  } else {\n    t6 = $[12];\n  }\n  const handleClose = t6;\n  let t7;\n  if ($[13] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t7 = (e) => {\n      e.stopPropagation();\n      setIsEditable(true);\n    };\n    $[13] = t7;\n  } else {\n    t7 = $[13];\n  }\n  const handleEditLabel = t7;\n  let t8;\n  if ($[14] !== headerEditor || $[15] !== props.item || $[16] !== queryEditor || $[17] !== setActive || $[18] !== variableEditor) {\n    t8 = () => {\n      const {\n        query,\n        variables,\n        headers\n      } = props.item;\n      queryEditor == null ? void 0 : queryEditor.setValue(query ?? \"\");\n      variableEditor == null ? void 0 : variableEditor.setValue(variables ?? \"\");\n      headerEditor == null ? void 0 : headerEditor.setValue(headers ?? \"\");\n      setActive(props.item);\n    };\n    $[14] = headerEditor;\n    $[15] = props.item;\n    $[16] = queryEditor;\n    $[17] = setActive;\n    $[18] = variableEditor;\n    $[19] = t8;\n  } else {\n    t8 = $[19];\n  }\n  const handleHistoryItemClick = t8;\n  let t9;\n  if ($[20] !== deleteFromHistory || $[21] !== props.item) {\n    t9 = (e_0) => {\n      e_0.stopPropagation();\n      deleteFromHistory(props.item);\n    };\n    $[20] = deleteFromHistory;\n    $[21] = props.item;\n    $[22] = t9;\n  } else {\n    t9 = $[22];\n  }\n  const handleDeleteItemFromHistory = t9;\n  let t10;\n  if ($[23] !== props.item || $[24] !== toggleFavorite) {\n    t10 = (e_1) => {\n      e_1.stopPropagation();\n      toggleFavorite(props.item);\n    };\n    $[23] = props.item;\n    $[24] = toggleFavorite;\n    $[25] = t10;\n  } else {\n    t10 = $[25];\n  }\n  const handleToggleFavorite = t10;\n  const t11 = isEditable && \"editable\";\n  let t12;\n  if ($[26] !== t11) {\n    t12 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-history-item\", t11);\n    $[26] = t11;\n    $[27] = t12;\n  } else {\n    t12 = $[27];\n  }\n  let t13;\n  if ($[28] !== displayName || $[29] !== editLabel || $[30] !== handleDeleteItemFromHistory || $[31] !== handleHistoryItemClick || $[32] !== handleSave || $[33] !== handleToggleFavorite || $[34] !== isEditable || $[35] !== props.item) {\n    t13 = isEditable ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"text\", defaultValue: props.item.label, ref: inputRef, onKeyDown: (e_2) => {\n        if (e_2.key === \"Esc\") {\n          setIsEditable(false);\n        } else {\n          if (e_2.key === \"Enter\") {\n            setIsEditable(false);\n            editLabel({\n              ...props.item,\n              label: e_2.currentTarget.value\n            });\n          }\n        }\n      }, placeholder: \"Type a label\" }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", ref: buttonRef, onClick: handleSave, children: \"Save\" }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", ref: buttonRef, onClick: handleClose, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(CloseIcon, {}) })\n    ] }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label: \"Set active\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", className: \"graphiql-history-item-label\", onClick: handleHistoryItemClick, \"aria-label\": \"Set active\", children: displayName }) }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label: \"Edit label\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", className: \"graphiql-history-item-action\", onClick: handleEditLabel, \"aria-label\": \"Edit label\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PenIcon, { \"aria-hidden\": \"true\" }) }) }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label: props.item.favorite ? \"Remove favorite\" : \"Add favorite\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", className: \"graphiql-history-item-action\", onClick: handleToggleFavorite, \"aria-label\": props.item.favorite ? \"Remove favorite\" : \"Add favorite\", children: props.item.favorite ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StarFilledIcon, { \"aria-hidden\": \"true\" }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StarIcon, { \"aria-hidden\": \"true\" }) }) }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label: \"Delete from history\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { type: \"button\", className: \"graphiql-history-item-action\", onClick: handleDeleteItemFromHistory, \"aria-label\": \"Delete from history\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TrashIcon, { \"aria-hidden\": \"true\" }) }) })\n    ] });\n    $[28] = displayName;\n    $[29] = editLabel;\n    $[30] = handleDeleteItemFromHistory;\n    $[31] = handleHistoryItemClick;\n    $[32] = handleSave;\n    $[33] = handleToggleFavorite;\n    $[34] = isEditable;\n    $[35] = props.item;\n    $[36] = t13;\n  } else {\n    t13 = $[36];\n  }\n  let t14;\n  if ($[37] !== t12 || $[38] !== t13) {\n    t14 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"li\", { className: t12, children: t13 });\n    $[37] = t12;\n    $[38] = t13;\n    $[39] = t14;\n  } else {\n    t14 = $[39];\n  }\n  return t14;\n}\nfunction formatQuery(query) {\n  return query == null ? void 0 : query.split(\"\\n\").map((line) => line.replace(/#(.*)/, \"\")).join(\" \").replaceAll(\"{\", \" { \").replaceAll(\"}\", \" } \").replaceAll(/[\\s]{2,}/g, \" \");\n}\nconst ExecutionContext = createNullableContext(\"ExecutionContext\");\nfunction ExecutionContextProvider(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(27);\n  const {\n    fetcher,\n    getDefaultFieldNames,\n    children,\n    operationName\n  } = t0;\n  if (!fetcher) {\n    throw new TypeError(\"The `ExecutionContextProvider` component requires a `fetcher` function to be passed as prop.\");\n  }\n  let t1;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: ExecutionContextProvider\n    };\n    $[0] = t1;\n  } else {\n    t1 = $[0];\n  }\n  const {\n    externalFragments,\n    headerEditor,\n    queryEditor,\n    responseEditor,\n    variableEditor,\n    updateActiveTabValues\n  } = useEditorContext(t1);\n  const history = useHistoryContext();\n  let t2;\n  if ($[1] !== getDefaultFieldNames) {\n    t2 = {\n      getDefaultFieldNames,\n      caller: ExecutionContextProvider\n    };\n    $[1] = getDefaultFieldNames;\n    $[2] = t2;\n  } else {\n    t2 = $[2];\n  }\n  const autoCompleteLeafs = useAutoCompleteLeafs(t2);\n  const [isFetching, setIsFetching] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  const [subscription, setSubscription] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const queryIdRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(0);\n  let t3;\n  if ($[3] !== subscription) {\n    t3 = () => {\n      subscription == null ? void 0 : subscription.unsubscribe();\n      setIsFetching(false);\n      setSubscription(null);\n    };\n    $[3] = subscription;\n    $[4] = t3;\n  } else {\n    t3 = $[4];\n  }\n  const stop = t3;\n  let t4;\n  if ($[5] !== autoCompleteLeafs || $[6] !== externalFragments || $[7] !== fetcher || $[8] !== headerEditor || $[9] !== history || $[10] !== operationName || $[11] !== queryEditor || $[12] !== responseEditor || $[13] !== stop || $[14] !== subscription || $[15] !== updateActiveTabValues || $[16] !== variableEditor) {\n    t4 = async () => {\n      if (!queryEditor || !responseEditor) {\n        return;\n      }\n      if (subscription) {\n        stop();\n        return;\n      }\n      const setResponse = (value) => {\n        responseEditor.setValue(value);\n        updateActiveTabValues({\n          response: value\n        });\n      };\n      queryIdRef.current = queryIdRef.current + 1;\n      const queryId = queryIdRef.current;\n      let query = autoCompleteLeafs() || queryEditor.getValue();\n      const variablesString = variableEditor == null ? void 0 : variableEditor.getValue();\n      let variables;\n      try {\n        variables = tryParseJsonObject({\n          json: variablesString,\n          errorMessageParse: \"Variables are invalid JSON\",\n          errorMessageType: \"Variables are not a JSON object.\"\n        });\n      } catch (t52) {\n        const error = t52;\n        setResponse(error instanceof Error ? error.message : `${error}`);\n        return;\n      }\n      const headersString = headerEditor == null ? void 0 : headerEditor.getValue();\n      let headers;\n      try {\n        headers = tryParseJsonObject({\n          json: headersString,\n          errorMessageParse: \"Headers are invalid JSON\",\n          errorMessageType: \"Headers are not a JSON object.\"\n        });\n      } catch (t62) {\n        const error_0 = t62;\n        setResponse(error_0 instanceof Error ? error_0.message : `${error_0}`);\n        return;\n      }\n      if (externalFragments) {\n        const fragmentDependencies = queryEditor.documentAST ? (0,graphql_language_service__WEBPACK_IMPORTED_MODULE_14__.getFragmentDependenciesForAST)(queryEditor.documentAST, externalFragments) : [];\n        if (fragmentDependencies.length > 0) {\n          query = query + (\"\\n\" + fragmentDependencies.map(_temp$7).join(\"\\n\"));\n        }\n      }\n      setResponse(\"\");\n      setIsFetching(true);\n      const opName = operationName ?? queryEditor.operationName ?? void 0;\n      history == null ? void 0 : history.addToHistory({\n        query,\n        variables: variablesString,\n        headers: headersString,\n        operationName: opName\n      });\n      const _headers = headers ?? void 0;\n      const documentAST = queryEditor.documentAST ?? void 0;\n      try {\n        const fullResponse = {};\n        const handleResponse = (result) => {\n          if (queryId !== queryIdRef.current) {\n            return;\n          }\n          let maybeMultipart = Array.isArray(result) ? result : false;\n          if (!maybeMultipart && typeof result === \"object\" && result !== null && \"hasNext\" in result) {\n            maybeMultipart = [result];\n          }\n          if (maybeMultipart) {\n            for (const part of maybeMultipart) {\n              mergeIncrementalResult(fullResponse, part);\n            }\n            setIsFetching(false);\n            setResponse((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatResult)(fullResponse));\n          } else {\n            const response = (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatResult)(result);\n            setIsFetching(false);\n            setResponse(response);\n          }\n        };\n        const fetch2 = fetcher({\n          query,\n          variables,\n          operationName: opName\n        }, {\n          headers: _headers,\n          documentAST\n        });\n        const value_0 = await Promise.resolve(fetch2);\n        if ((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.isObservable)(value_0)) {\n          setSubscription(value_0.subscribe({\n            next(result_0) {\n              handleResponse(result_0);\n            },\n            error(error_2) {\n              setIsFetching(false);\n              if (error_2) {\n                setResponse((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatError)(error_2));\n              }\n              setSubscription(null);\n            },\n            complete() {\n              setIsFetching(false);\n              setSubscription(null);\n            }\n          }));\n        } else {\n          if ((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.isAsyncIterable)(value_0)) {\n            setSubscription({\n              unsubscribe: () => {\n                var _a, _b;\n                return (_b = (_a = value_0[Symbol.asyncIterator]()).return) == null ? void 0 : _b.call(_a);\n              }\n            });\n            await handleAsyncResults(handleResponse, value_0);\n            setIsFetching(false);\n            setSubscription(null);\n          } else {\n            handleResponse(value_0);\n          }\n        }\n      } catch (t72) {\n        const error_1 = t72;\n        setIsFetching(false);\n        setResponse((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatError)(error_1));\n        setSubscription(null);\n      }\n    };\n    $[5] = autoCompleteLeafs;\n    $[6] = externalFragments;\n    $[7] = fetcher;\n    $[8] = headerEditor;\n    $[9] = history;\n    $[10] = operationName;\n    $[11] = queryEditor;\n    $[12] = responseEditor;\n    $[13] = stop;\n    $[14] = subscription;\n    $[15] = updateActiveTabValues;\n    $[16] = variableEditor;\n    $[17] = t4;\n  } else {\n    t4 = $[17];\n  }\n  const run = t4;\n  const isSubscribed = Boolean(subscription);\n  const t5 = operationName ?? null;\n  let t6;\n  if ($[18] !== isFetching || $[19] !== isSubscribed || $[20] !== run || $[21] !== stop || $[22] !== t5) {\n    t6 = {\n      isFetching,\n      isSubscribed,\n      operationName: t5,\n      run,\n      stop\n    };\n    $[18] = isFetching;\n    $[19] = isSubscribed;\n    $[20] = run;\n    $[21] = stop;\n    $[22] = t5;\n    $[23] = t6;\n  } else {\n    t6 = $[23];\n  }\n  const value_1 = t6;\n  let t7;\n  if ($[24] !== children || $[25] !== value_1) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExecutionContext.Provider, { value: value_1, children });\n    $[24] = children;\n    $[25] = value_1;\n    $[26] = t7;\n  } else {\n    t7 = $[26];\n  }\n  return t7;\n}\nfunction _temp$7(node) {\n  return (0,graphql__WEBPACK_IMPORTED_MODULE_10__.print)(node);\n}\nasync function handleAsyncResults(onResponse, value) {\n  for await (const result of value) {\n    onResponse(result);\n  }\n}\nconst useExecutionContext = createContextHook(ExecutionContext);\nfunction tryParseJsonObject({\n  json,\n  errorMessageParse,\n  errorMessageType\n}) {\n  let parsed;\n  try {\n    parsed = json && json.trim() !== \"\" ? JSON.parse(json) : void 0;\n  } catch (error) {\n    throw new Error(`${errorMessageParse}: ${error instanceof Error ? error.message : error}.`);\n  }\n  const isObject = typeof parsed === \"object\" && parsed !== null && !Array.isArray(parsed);\n  if (parsed !== void 0 && !isObject) {\n    throw new Error(errorMessageType);\n  }\n  return parsed;\n}\nconst pathsMap = /* @__PURE__ */ new WeakMap();\nfunction mergeIncrementalResult(executionResult, incrementalResult) {\n  var _a, _b, _c;\n  let path = [\"data\", ...incrementalResult.path ?? []];\n  for (const result of [executionResult, incrementalResult]) {\n    if (result.pending) {\n      let paths = pathsMap.get(executionResult);\n      if (paths === void 0) {\n        paths = /* @__PURE__ */ new Map();\n        pathsMap.set(executionResult, paths);\n      }\n      for (const {\n        id,\n        path: pendingPath\n      } of result.pending) {\n        paths.set(id, [\"data\", ...pendingPath]);\n      }\n    }\n  }\n  const {\n    items\n  } = incrementalResult;\n  if (items) {\n    const {\n      id\n    } = incrementalResult;\n    if (id) {\n      path = (_a = pathsMap.get(executionResult)) == null ? void 0 : _a.get(id);\n      if (path === void 0) {\n        throw new Error(\"Invalid incremental delivery format.\");\n      }\n      const list = get_value__WEBPACK_IMPORTED_MODULE_16__(executionResult, path.join(\".\"));\n      list.push(...items);\n    } else {\n      path = [\"data\", ...incrementalResult.path ?? []];\n      for (const item of items) {\n        set_value__WEBPACK_IMPORTED_MODULE_15__(executionResult, path.join(\".\"), item);\n        path[path.length - 1]++;\n      }\n    }\n  }\n  const {\n    data\n  } = incrementalResult;\n  if (data) {\n    const {\n      id\n    } = incrementalResult;\n    if (id) {\n      path = (_b = pathsMap.get(executionResult)) == null ? void 0 : _b.get(id);\n      if (path === void 0) {\n        throw new Error(\"Invalid incremental delivery format.\");\n      }\n      const {\n        subPath\n      } = incrementalResult;\n      if (subPath !== void 0) {\n        path = [...path, ...subPath];\n      }\n    }\n    set_value__WEBPACK_IMPORTED_MODULE_15__(executionResult, path.join(\".\"), data, {\n      merge: true\n    });\n  }\n  if (incrementalResult.errors) {\n    executionResult.errors || (executionResult.errors = []);\n    executionResult.errors.push(...incrementalResult.errors);\n  }\n  if (incrementalResult.extensions) {\n    set_value__WEBPACK_IMPORTED_MODULE_15__(executionResult, \"extensions\", incrementalResult.extensions, {\n      merge: true\n    });\n  }\n  if (incrementalResult.incremental) {\n    for (const incrementalSubResult of incrementalResult.incremental) {\n      mergeIncrementalResult(executionResult, incrementalSubResult);\n    }\n  }\n  if (incrementalResult.completed) {\n    for (const {\n      id,\n      errors\n    } of incrementalResult.completed) {\n      (_c = pathsMap.get(executionResult)) == null ? void 0 : _c.delete(id);\n      if (errors) {\n        executionResult.errors || (executionResult.errors = []);\n        executionResult.errors.push(...errors);\n      }\n    }\n  }\n}\nconst isMacOs = typeof navigator !== \"undefined\" && navigator.userAgent.includes(\"Mac\");\nconst DEFAULT_EDITOR_THEME = \"graphiql\";\nconst DEFAULT_KEY_MAP = \"sublime\";\nconst commonKeys = {\n  // Persistent search box in Query Editor\n  [isMacOs ? \"Cmd-F\" : \"Ctrl-F\"]: \"findPersistent\",\n  \"Cmd-G\": \"findPersistent\",\n  \"Ctrl-G\": \"findPersistent\",\n  // Editor improvements\n  \"Ctrl-Left\": \"goSubwordLeft\",\n  \"Ctrl-Right\": \"goSubwordRight\",\n  \"Alt-Left\": \"goGroupLeft\",\n  \"Alt-Right\": \"goGroupRight\"\n};\nasync function importCodeMirror(addons, options) {\n  const CodeMirror = await Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/lib/codemirror.js\", 19)).then((c2) => (\n    // Depending on bundler and settings the dynamic import either returns a\n    // function (e.g. parcel) or an object containing a `default` property\n    typeof c2 === \"function\" ? c2 : c2.default\n  ));\n  await Promise.all((options == null ? void 0 : options.useCommonAddons) === false ? addons : [\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/hint/show-hint.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/hint/show-hint.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/edit/matchbrackets.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/edit/matchbrackets.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/edit/closebrackets.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/edit/closebrackets.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/fold/brace-fold.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/fold/brace-fold.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/fold/foldgutter.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/fold/foldgutter.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/lint/lint.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/lint/lint.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/searchcursor.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/searchcursor.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/jump-to-line.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/jump-to-line.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/dialog/dialog.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/dialog/dialog.js\", 19)),\n    // @ts-expect-error\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/keymap/sublime.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/keymap/sublime.js\", 19)),\n    ...addons\n  ]);\n  return CodeMirror;\n}\nconst printDefault = (ast) => {\n  if (!ast) {\n    return \"\";\n  }\n  return (0,graphql__WEBPACK_IMPORTED_MODULE_10__.print)(ast);\n};\nfunction DefaultValue(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(12);\n  const {\n    field\n  } = t0;\n  if (!(\"defaultValue\" in field) || field.defaultValue === void 0) {\n    return null;\n  }\n  const t1 = field.defaultValue;\n  const t2 = field.type;\n  let t3;\n  let t4;\n  let t5;\n  let t6;\n  if ($[0] !== field.defaultValue || $[1] !== field.type) {\n    t6 = Symbol.for(\"react.early_return_sentinel\");\n    bb0: {\n      const ast = (0,graphql__WEBPACK_IMPORTED_MODULE_12__.astFromValue)(t1, t2);\n      if (!ast) {\n        t6 = null;\n        break bb0;\n      }\n      t5 = \" = \";\n      t3 = \"graphiql-doc-explorer-default-value\";\n      t4 = printDefault(ast);\n    }\n    $[0] = field.defaultValue;\n    $[1] = field.type;\n    $[2] = t3;\n    $[3] = t4;\n    $[4] = t5;\n    $[5] = t6;\n  } else {\n    t3 = $[2];\n    t4 = $[3];\n    t5 = $[4];\n    t6 = $[5];\n  }\n  if (t6 !== Symbol.for(\"react.early_return_sentinel\")) {\n    return t6;\n  }\n  let t7;\n  if ($[6] !== t3 || $[7] !== t4) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: t3, children: t4 });\n    $[6] = t3;\n    $[7] = t4;\n    $[8] = t7;\n  } else {\n    t7 = $[8];\n  }\n  let t8;\n  if ($[9] !== t5 || $[10] !== t7) {\n    t8 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t5,\n      t7\n    ] });\n    $[9] = t5;\n    $[10] = t7;\n    $[11] = t8;\n  } else {\n    t8 = $[11];\n  }\n  return t8;\n}\nconst SchemaContext = createNullableContext(\"SchemaContext\");\nfunction SchemaContextProvider(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(38);\n  let fetcher;\n  let onSchemaChange;\n  let props;\n  if ($[0] !== t0) {\n    ({\n      fetcher,\n      onSchemaChange,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = fetcher;\n    $[2] = onSchemaChange;\n    $[3] = props;\n  } else {\n    fetcher = $[1];\n    onSchemaChange = $[2];\n    props = $[3];\n  }\n  if (!fetcher) {\n    throw new TypeError(\"The `SchemaContextProvider` component requires a `fetcher` function to be passed as prop.\");\n  }\n  let t1;\n  if ($[4] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: SchemaContextProvider\n    };\n    $[4] = t1;\n  } else {\n    t1 = $[4];\n  }\n  const {\n    initialHeaders,\n    headerEditor\n  } = useEditorContext(t1);\n  const [schema, setSchema] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)();\n  const [isFetching, setIsFetching] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  const [fetchError, setFetchError] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const counterRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(0);\n  let t2;\n  let t3;\n  if ($[5] !== props.schema) {\n    t2 = () => {\n      setSchema((0,graphql__WEBPACK_IMPORTED_MODULE_4__.isSchema)(props.schema) || props.schema == null ? props.schema : void 0);\n      counterRef.current = counterRef.current + 1;\n    };\n    t3 = [props.schema];\n    $[5] = props.schema;\n    $[6] = t2;\n    $[7] = t3;\n  } else {\n    t2 = $[6];\n    t3 = $[7];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t2, t3);\n  const headersRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(initialHeaders);\n  let t4;\n  if ($[8] !== headerEditor) {\n    t4 = () => {\n      if (headerEditor) {\n        headersRef.current = headerEditor.getValue();\n      }\n    };\n    $[8] = headerEditor;\n    $[9] = t4;\n  } else {\n    t4 = $[9];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t4);\n  let t5;\n  if ($[10] !== props.inputValueDeprecation || $[11] !== props.introspectionQueryName || $[12] !== props.schemaDescription) {\n    t5 = {\n      inputValueDeprecation: props.inputValueDeprecation,\n      introspectionQueryName: props.introspectionQueryName,\n      schemaDescription: props.schemaDescription\n    };\n    $[10] = props.inputValueDeprecation;\n    $[11] = props.introspectionQueryName;\n    $[12] = props.schemaDescription;\n    $[13] = t5;\n  } else {\n    t5 = $[13];\n  }\n  const {\n    introspectionQuery,\n    introspectionQueryName,\n    introspectionQuerySansSubscriptions\n  } = useIntrospectionQuery(t5);\n  let t6;\n  if ($[14] !== fetcher || $[15] !== introspectionQuery || $[16] !== introspectionQueryName || $[17] !== introspectionQuerySansSubscriptions || $[18] !== onSchemaChange || $[19] !== props.schema) {\n    t6 = () => {\n      if ((0,graphql__WEBPACK_IMPORTED_MODULE_4__.isSchema)(props.schema) || props.schema === null) {\n        return;\n      }\n      const counter = counterRef.current = counterRef.current + 1;\n      const maybeIntrospectionData = props.schema;\n      const fetchIntrospectionData = async function fetchIntrospectionData2() {\n        if (maybeIntrospectionData) {\n          return maybeIntrospectionData;\n        }\n        const parsedHeaders = parseHeaderString(headersRef.current);\n        if (!parsedHeaders.isValidJSON) {\n          setFetchError(\"Introspection failed as headers are invalid.\");\n          return;\n        }\n        const fetcherOpts = parsedHeaders.headers ? {\n          headers: parsedHeaders.headers\n        } : {};\n        const fetch2 = (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.fetcherReturnToPromise)(fetcher({\n          query: introspectionQuery,\n          operationName: introspectionQueryName\n        }, fetcherOpts));\n        if (!(0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.isPromise)(fetch2)) {\n          setFetchError(\"Fetcher did not return a Promise for introspection.\");\n          return;\n        }\n        setIsFetching(true);\n        setFetchError(null);\n        let result = await fetch2;\n        if (typeof result !== \"object\" || result === null || !(\"data\" in result)) {\n          const fetch22 = (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.fetcherReturnToPromise)(fetcher({\n            query: introspectionQuerySansSubscriptions,\n            operationName: introspectionQueryName\n          }, fetcherOpts));\n          if (!(0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.isPromise)(fetch22)) {\n            throw new Error(\"Fetcher did not return a Promise for introspection.\");\n          }\n          result = await fetch22;\n        }\n        setIsFetching(false);\n        if ((result == null ? void 0 : result.data) && \"__schema\" in result.data) {\n          return result.data;\n        }\n        const responseString = typeof result === \"string\" ? result : (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatResult)(result);\n        setFetchError(responseString);\n      };\n      fetchIntrospectionData().then((introspectionData) => {\n        if (counter !== counterRef.current || !introspectionData) {\n          return;\n        }\n        try {\n          const newSchema = (0,graphql__WEBPACK_IMPORTED_MODULE_7__.buildClientSchema)(introspectionData);\n          setSchema(newSchema);\n          if (onSchemaChange) {\n            onSchemaChange(newSchema);\n          }\n        } catch (t72) {\n          const error = t72;\n          setFetchError((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatError)(error));\n        }\n      }).catch((error_0) => {\n        if (counter !== counterRef.current) {\n          return;\n        }\n        setFetchError((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatError)(error_0));\n        setIsFetching(false);\n      });\n    };\n    $[14] = fetcher;\n    $[15] = introspectionQuery;\n    $[16] = introspectionQueryName;\n    $[17] = introspectionQuerySansSubscriptions;\n    $[18] = onSchemaChange;\n    $[19] = props.schema;\n    $[20] = t6;\n  } else {\n    t6 = $[20];\n  }\n  const introspect = t6;\n  let t7;\n  let t8;\n  if ($[21] !== introspect) {\n    t7 = () => {\n      introspect();\n    };\n    t8 = [introspect];\n    $[21] = introspect;\n    $[22] = t7;\n    $[23] = t8;\n  } else {\n    t7 = $[22];\n    t8 = $[23];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t7, t8);\n  let t9;\n  if ($[24] !== introspect) {\n    t9 = () => {\n      const triggerIntrospection = function triggerIntrospection2(event) {\n        if (event.ctrlKey && event.key === \"R\") {\n          introspect();\n        }\n      };\n      window.addEventListener(\"keydown\", triggerIntrospection);\n      return () => {\n        window.removeEventListener(\"keydown\", triggerIntrospection);\n      };\n    };\n    $[24] = introspect;\n    $[25] = t9;\n  } else {\n    t9 = $[25];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t9);\n  let t10;\n  if ($[26] !== props.dangerouslyAssumeSchemaIsValid || $[27] !== schema) {\n    t10 = !schema || props.dangerouslyAssumeSchemaIsValid ? [] : (0,graphql__WEBPACK_IMPORTED_MODULE_8__.validateSchema)(schema);\n    $[26] = props.dangerouslyAssumeSchemaIsValid;\n    $[27] = schema;\n    $[28] = t10;\n  } else {\n    t10 = $[28];\n  }\n  const validationErrors = t10;\n  let t11;\n  if ($[29] !== fetchError || $[30] !== introspect || $[31] !== isFetching || $[32] !== schema || $[33] !== validationErrors) {\n    t11 = {\n      fetchError,\n      introspect,\n      isFetching,\n      schema,\n      validationErrors\n    };\n    $[29] = fetchError;\n    $[30] = introspect;\n    $[31] = isFetching;\n    $[32] = schema;\n    $[33] = validationErrors;\n    $[34] = t11;\n  } else {\n    t11 = $[34];\n  }\n  const value = t11;\n  let t12;\n  if ($[35] !== props.children || $[36] !== value) {\n    t12 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaContext.Provider, { value, children: props.children });\n    $[35] = props.children;\n    $[36] = value;\n    $[37] = t12;\n  } else {\n    t12 = $[37];\n  }\n  return t12;\n}\nconst useSchemaContext = createContextHook(SchemaContext);\nfunction useIntrospectionQuery({\n  inputValueDeprecation,\n  introspectionQueryName,\n  schemaDescription\n}) {\n  const queryName = introspectionQueryName || \"IntrospectionQuery\";\n  let query = (0,graphql__WEBPACK_IMPORTED_MODULE_5__.getIntrospectionQuery)({\n    inputValueDeprecation,\n    schemaDescription\n  });\n  if (introspectionQueryName) {\n    query = query.replace(\"query IntrospectionQuery\", `query ${queryName}`);\n  }\n  const querySansSubscriptions = query.replace(\"subscriptionType { name }\", \"\");\n  return {\n    introspectionQueryName: queryName,\n    introspectionQuery: query,\n    introspectionQuerySansSubscriptions: querySansSubscriptions\n  };\n}\nfunction parseHeaderString(headersString) {\n  let headers = null;\n  let isValidJSON = true;\n  try {\n    if (headersString) {\n      headers = JSON.parse(headersString);\n    }\n  } catch {\n    isValidJSON = false;\n  }\n  return {\n    headers,\n    isValidJSON\n  };\n}\nconst initialNavStackItem = {\n  name: \"Docs\"\n};\nconst ExplorerContext = createNullableContext(\"ExplorerContext\");\nfunction ExplorerContextProvider(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(14);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: ExplorerContextProvider\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    schema,\n    validationErrors\n  } = useSchemaContext(t0);\n  let t1;\n  if ($[1] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = [initialNavStackItem];\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const [navStack, setNavStack] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t1);\n  let t2;\n  if ($[2] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t2 = (item) => {\n      setNavStack((currentState) => {\n        const lastItem = currentState.at(-1);\n        return lastItem.def === item.def ? currentState : [...currentState, item];\n      });\n    };\n    $[2] = t2;\n  } else {\n    t2 = $[2];\n  }\n  const push = t2;\n  let t3;\n  if ($[3] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t3 = () => {\n      setNavStack(_temp$6);\n    };\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const pop = t3;\n  let t4;\n  if ($[4] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t4 = () => {\n      setNavStack(_temp2$4);\n    };\n    $[4] = t4;\n  } else {\n    t4 = $[4];\n  }\n  const reset = t4;\n  let t5;\n  let t6;\n  if ($[5] !== schema || $[6] !== validationErrors) {\n    t5 = () => {\n      if (schema == null || validationErrors.length > 0) {\n        reset();\n      } else {\n        setNavStack((oldNavStack) => {\n          if (oldNavStack.length === 1) {\n            return oldNavStack;\n          }\n          const newNavStack = [initialNavStackItem];\n          let lastEntity = null;\n          for (const item_0 of oldNavStack) {\n            if (item_0 === initialNavStackItem) {\n              continue;\n            }\n            if (item_0.def) {\n              if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isNamedType)(item_0.def)) {\n                const newType = schema.getType(item_0.def.name);\n                if (newType) {\n                  newNavStack.push({\n                    name: item_0.name,\n                    def: newType\n                  });\n                  lastEntity = newType;\n                } else {\n                  break;\n                }\n              } else {\n                if (lastEntity === null) {\n                  break;\n                } else {\n                  if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isObjectType)(lastEntity) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInputObjectType)(lastEntity)) {\n                    const field = lastEntity.getFields()[item_0.name];\n                    if (field) {\n                      newNavStack.push({\n                        name: item_0.name,\n                        def: field\n                      });\n                    } else {\n                      break;\n                    }\n                  } else {\n                    if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isScalarType)(lastEntity) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isEnumType)(lastEntity) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInterfaceType)(lastEntity) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isUnionType)(lastEntity)) {\n                      break;\n                    } else {\n                      const field_0 = lastEntity;\n                      const arg = field_0.args.find((a) => a.name === item_0.name);\n                      if (arg) {\n                        newNavStack.push({\n                          name: item_0.name,\n                          def: field_0\n                        });\n                      } else {\n                        break;\n                      }\n                    }\n                  }\n                }\n              }\n            } else {\n              lastEntity = null;\n              newNavStack.push(item_0);\n            }\n          }\n          return newNavStack;\n        });\n      }\n    };\n    t6 = [schema, validationErrors];\n    $[5] = schema;\n    $[6] = validationErrors;\n    $[7] = t5;\n    $[8] = t6;\n  } else {\n    t5 = $[7];\n    t6 = $[8];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t5, t6);\n  let t7;\n  if ($[9] !== navStack) {\n    t7 = {\n      explorerNavStack: navStack,\n      push,\n      pop,\n      reset\n    };\n    $[9] = navStack;\n    $[10] = t7;\n  } else {\n    t7 = $[10];\n  }\n  const value = t7;\n  let t8;\n  if ($[11] !== props.children || $[12] !== value) {\n    t8 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerContext.Provider, { value, children: props.children });\n    $[11] = props.children;\n    $[12] = value;\n    $[13] = t8;\n  } else {\n    t8 = $[13];\n  }\n  return t8;\n}\nfunction _temp2$4(currentState_1) {\n  return currentState_1.length === 1 ? currentState_1 : [initialNavStackItem];\n}\nfunction _temp$6(currentState_0) {\n  return currentState_0.length > 1 ? currentState_0.slice(0, -1) : currentState_0;\n}\nconst useExplorerContext = createContextHook(ExplorerContext);\nfunction renderType(type, renderNamedType) {\n  if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isNonNullType)(type)) {\n    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      renderType(type.ofType, renderNamedType),\n      \"!\"\n    ] });\n  }\n  if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isListType)(type)) {\n    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      \"[\",\n      renderType(type.ofType, renderNamedType),\n      \"]\"\n    ] });\n  }\n  return renderNamedType(type);\n}\nfunction TypeLink(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: TypeLink\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    push\n  } = useExplorerContext(t0);\n  if (!props.type) {\n    return null;\n  }\n  let t1;\n  if ($[1] !== push) {\n    t1 = (namedType) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"graphiql-doc-explorer-type-name\", onClick: (event) => {\n      event.preventDefault();\n      push({\n        name: namedType.name,\n        def: namedType\n      });\n    }, href: \"#\", children: namedType.name });\n    $[1] = push;\n    $[2] = t1;\n  } else {\n    t1 = $[2];\n  }\n  let t2;\n  if ($[3] !== props.type || $[4] !== t1) {\n    t2 = renderType(props.type, t1);\n    $[3] = props.type;\n    $[4] = t1;\n    $[5] = t2;\n  } else {\n    t2 = $[5];\n  }\n  return t2;\n}\nfunction Argument(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(19);\n  const {\n    arg,\n    showDefaultValue,\n    inline\n  } = t0;\n  let t1;\n  if ($[0] !== arg.name) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-argument-name\", children: arg.name });\n    $[0] = arg.name;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  let t2;\n  if ($[2] !== arg.type) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: arg.type });\n    $[2] = arg.type;\n    $[3] = t2;\n  } else {\n    t2 = $[3];\n  }\n  let t3;\n  if ($[4] !== arg || $[5] !== showDefaultValue) {\n    t3 = showDefaultValue !== false && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DefaultValue, { field: arg });\n    $[4] = arg;\n    $[5] = showDefaultValue;\n    $[6] = t3;\n  } else {\n    t3 = $[6];\n  }\n  let t4;\n  if ($[7] !== t1 || $[8] !== t2 || $[9] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"span\", { children: [\n      t1,\n      \": \",\n      t2,\n      t3\n    ] });\n    $[7] = t1;\n    $[8] = t2;\n    $[9] = t3;\n    $[10] = t4;\n  } else {\n    t4 = $[10];\n  }\n  const definition = t4;\n  if (inline) {\n    return definition;\n  }\n  let t5;\n  if ($[11] !== arg.description) {\n    t5 = arg.description ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", children: arg.description }) : null;\n    $[11] = arg.description;\n    $[12] = t5;\n  } else {\n    t5 = $[12];\n  }\n  let t6;\n  if ($[13] !== arg.deprecationReason) {\n    t6 = arg.deprecationReason ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-argument-deprecation\", children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-argument-deprecation-label\", children: \"Deprecated\" }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"deprecation\", children: arg.deprecationReason })\n    ] }) : null;\n    $[13] = arg.deprecationReason;\n    $[14] = t6;\n  } else {\n    t6 = $[14];\n  }\n  let t7;\n  if ($[15] !== definition || $[16] !== t5 || $[17] !== t6) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-argument\", children: [\n      definition,\n      t5,\n      t6\n    ] });\n    $[15] = definition;\n    $[16] = t5;\n    $[17] = t6;\n    $[18] = t7;\n  } else {\n    t7 = $[18];\n  }\n  return t7;\n}\nfunction DeprecationReason(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(3);\n  let t0;\n  if ($[0] !== props.children || $[1] !== props.preview) {\n    t0 = props.children ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-deprecation\", children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-deprecation-label\", children: \"Deprecated\" }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"deprecation\", onlyShowFirstChild: props.preview ?? true, children: props.children })\n    ] }) : null;\n    $[0] = props.children;\n    $[1] = props.preview;\n    $[2] = t0;\n  } else {\n    t0 = $[2];\n  }\n  return t0;\n}\nfunction Directive(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n  const {\n    directive\n  } = t0;\n  let t1;\n  if ($[0] !== directive.name.value) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"span\", { className: \"graphiql-doc-explorer-directive\", children: [\n      \"@\",\n      directive.name.value\n    ] });\n    $[0] = directive.name.value;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  return t1;\n}\nfunction ExplorerSection(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  const Icon2 = TYPE_TO_ICON[props.title];\n  let t0;\n  if ($[0] !== Icon2) {\n    t0 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Icon2, {});\n    $[0] = Icon2;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props.title || $[3] !== t0) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-section-title\", children: [\n      t0,\n      props.title\n    ] });\n    $[2] = props.title;\n    $[3] = t0;\n    $[4] = t1;\n  } else {\n    t1 = $[4];\n  }\n  let t2;\n  if ($[5] !== props.children) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-section-content\", children: props.children });\n    $[5] = props.children;\n    $[6] = t2;\n  } else {\n    t2 = $[6];\n  }\n  let t3;\n  if ($[7] !== t1 || $[8] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n      t1,\n      t2\n    ] });\n    $[7] = t1;\n    $[8] = t2;\n    $[9] = t3;\n  } else {\n    t3 = $[9];\n  }\n  return t3;\n}\nconst TYPE_TO_ICON = {\n  Arguments: ArgumentIcon,\n  \"Deprecated Arguments\": DeprecatedArgumentIcon,\n  \"Deprecated Enum Values\": DeprecatedEnumValueIcon,\n  \"Deprecated Fields\": DeprecatedFieldIcon,\n  Directives: DirectiveIcon,\n  \"Enum Values\": EnumValueIcon,\n  Fields: FieldIcon,\n  Implements: ImplementsIcon,\n  Implementations: TypeIcon,\n  \"Possible Types\": TypeIcon,\n  \"Root Types\": RootTypeIcon,\n  Type: TypeIcon,\n  \"All Schema Types\": TypeIcon\n};\nfunction FieldDocumentation(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(15);\n  let t0;\n  if ($[0] !== props.field.description) {\n    t0 = props.field.description ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", children: props.field.description }) : null;\n    $[0] = props.field.description;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  let t1;\n  if ($[2] !== props.field.deprecationReason) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DeprecationReason, { preview: false, children: props.field.deprecationReason });\n    $[2] = props.field.deprecationReason;\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  let t2;\n  if ($[4] !== props.field.type) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Type\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: props.field.type }) });\n    $[4] = props.field.type;\n    $[5] = t2;\n  } else {\n    t2 = $[5];\n  }\n  let t3;\n  let t4;\n  if ($[6] !== props.field) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Arguments, { field: props.field });\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Directives, { field: props.field });\n    $[6] = props.field;\n    $[7] = t3;\n    $[8] = t4;\n  } else {\n    t3 = $[7];\n    t4 = $[8];\n  }\n  let t5;\n  if ($[9] !== t0 || $[10] !== t1 || $[11] !== t2 || $[12] !== t3 || $[13] !== t4) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t0,\n      t1,\n      t2,\n      t3,\n      t4\n    ] });\n    $[9] = t0;\n    $[10] = t1;\n    $[11] = t2;\n    $[12] = t3;\n    $[13] = t4;\n    $[14] = t5;\n  } else {\n    t5 = $[14];\n  }\n  return t5;\n}\nfunction Arguments(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(12);\n  const {\n    field\n  } = t0;\n  const [showDeprecated, setShowDeprecated] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  let t1;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = () => {\n      setShowDeprecated(true);\n    };\n    $[0] = t1;\n  } else {\n    t1 = $[0];\n  }\n  const handleShowDeprecated = t1;\n  if (!(\"args\" in field)) {\n    return null;\n  }\n  let args;\n  let deprecatedArgs;\n  let t2;\n  if ($[1] !== field.args) {\n    args = [];\n    deprecatedArgs = [];\n    for (const argument of field.args) {\n      if (argument.deprecationReason) {\n        deprecatedArgs.push(argument);\n      } else {\n        args.push(argument);\n      }\n    }\n    t2 = args.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Arguments\", children: args.map(_temp$5) }) : null;\n    $[1] = field.args;\n    $[2] = args;\n    $[3] = deprecatedArgs;\n    $[4] = t2;\n  } else {\n    args = $[2];\n    deprecatedArgs = $[3];\n    t2 = $[4];\n  }\n  let t3;\n  if ($[5] !== args.length || $[6] !== deprecatedArgs || $[7] !== showDeprecated) {\n    t3 = deprecatedArgs.length > 0 ? showDeprecated || args.length === 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Deprecated Arguments\", children: deprecatedArgs.map(_temp2$3) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Button$1, { type: \"button\", onClick: handleShowDeprecated, children: \"Show Deprecated Arguments\" }) : null;\n    $[5] = args.length;\n    $[6] = deprecatedArgs;\n    $[7] = showDeprecated;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  let t4;\n  if ($[9] !== t2 || $[10] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t2,\n      t3\n    ] });\n    $[9] = t2;\n    $[10] = t3;\n    $[11] = t4;\n  } else {\n    t4 = $[11];\n  }\n  return t4;\n}\nfunction _temp2$3(arg_0) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Argument, { arg: arg_0 }, arg_0.name);\n}\nfunction _temp$5(arg) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Argument, { arg }, arg.name);\n}\nfunction Directives(t0) {\n  var _a, _b, _c;\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(6);\n  const {\n    field\n  } = t0;\n  let t1;\n  if ($[0] !== ((_a = field.astNode) == null ? void 0 : _a.directives)) {\n    t1 = ((_b = field.astNode) == null ? void 0 : _b.directives) || [];\n    $[0] = (_c = field.astNode) == null ? void 0 : _c.directives;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const directives = t1;\n  if (!directives || directives.length === 0) {\n    return null;\n  }\n  let t2;\n  if ($[2] !== directives) {\n    t2 = directives.map(_temp3$3);\n    $[2] = directives;\n    $[3] = t2;\n  } else {\n    t2 = $[3];\n  }\n  let t3;\n  if ($[4] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Directives\", children: t2 });\n    $[4] = t2;\n    $[5] = t3;\n  } else {\n    t3 = $[5];\n  }\n  return t3;\n}\nfunction _temp3$3(directive) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Directive, { directive }) }, directive.name.value);\n}\nfunction SchemaDocumentation(props) {\n  var _a, _b, _c, _d;\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(39);\n  let t0;\n  if ($[0] !== props.schema) {\n    t0 = props.schema.getQueryType();\n    $[0] = props.schema;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  const queryType = t0;\n  let t1;\n  if ($[2] !== props.schema) {\n    t1 = (_b = (_a = props.schema).getMutationType) == null ? void 0 : _b.call(_a);\n    $[2] = props.schema;\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  const mutationType = t1;\n  let t2;\n  if ($[4] !== props.schema) {\n    t2 = (_d = (_c = props.schema).getSubscriptionType) == null ? void 0 : _d.call(_c);\n    $[4] = props.schema;\n    $[5] = t2;\n  } else {\n    t2 = $[5];\n  }\n  const subscriptionType = t2;\n  let T0;\n  let t3;\n  let t4;\n  let t5;\n  let t6;\n  if ($[6] !== mutationType || $[7] !== props.schema || $[8] !== queryType || $[9] !== subscriptionType) {\n    const typeMap = props.schema.getTypeMap();\n    const t72 = queryType == null ? void 0 : queryType.name;\n    const t82 = mutationType == null ? void 0 : mutationType.name;\n    const t9 = subscriptionType == null ? void 0 : subscriptionType.name;\n    let t10;\n    if ($[15] !== t72 || $[16] !== t82 || $[17] !== t9) {\n      t10 = [t72, t82, t9];\n      $[15] = t72;\n      $[16] = t82;\n      $[17] = t9;\n      $[18] = t10;\n    } else {\n      t10 = $[18];\n    }\n    const ignoreTypesInAllSchema = t10;\n    const t11 = props.schema.description || \"A GraphQL schema provides a root type for each kind of operation.\";\n    if ($[19] !== t11) {\n      t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", children: t11 });\n      $[19] = t11;\n      $[20] = t5;\n    } else {\n      t5 = $[20];\n    }\n    let t12;\n    if ($[21] !== queryType) {\n      t12 = queryType ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-root-type\", children: \"query\" }),\n        \": \",\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: queryType })\n      ] }) : null;\n      $[21] = queryType;\n      $[22] = t12;\n    } else {\n      t12 = $[22];\n    }\n    let t13;\n    if ($[23] !== mutationType) {\n      t13 = mutationType && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-root-type\", children: \"mutation\" }),\n        \": \",\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: mutationType })\n      ] });\n      $[23] = mutationType;\n      $[24] = t13;\n    } else {\n      t13 = $[24];\n    }\n    let t14;\n    if ($[25] !== subscriptionType) {\n      t14 = subscriptionType && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-root-type\", children: \"subscription\" }),\n        \": \",\n        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: subscriptionType })\n      ] });\n      $[25] = subscriptionType;\n      $[26] = t14;\n    } else {\n      t14 = $[26];\n    }\n    if ($[27] !== t12 || $[28] !== t13 || $[29] !== t14) {\n      t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(ExplorerSection, { title: \"Root Types\", children: [\n        t12,\n        t13,\n        t14\n      ] });\n      $[27] = t12;\n      $[28] = t13;\n      $[29] = t14;\n      $[30] = t6;\n    } else {\n      t6 = $[30];\n    }\n    T0 = ExplorerSection;\n    t3 = \"All Schema Types\";\n    t4 = typeMap && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { children: Object.values(typeMap).map((type) => {\n      if (ignoreTypesInAllSchema.includes(type.name) || type.name.startsWith(\"__\")) {\n        return null;\n      }\n      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type }) }, type.name);\n    }) });\n    $[6] = mutationType;\n    $[7] = props.schema;\n    $[8] = queryType;\n    $[9] = subscriptionType;\n    $[10] = T0;\n    $[11] = t3;\n    $[12] = t4;\n    $[13] = t5;\n    $[14] = t6;\n  } else {\n    T0 = $[10];\n    t3 = $[11];\n    t4 = $[12];\n    t5 = $[13];\n    t6 = $[14];\n  }\n  let t7;\n  if ($[31] !== T0 || $[32] !== t3 || $[33] !== t4) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(T0, { title: t3, children: t4 });\n    $[31] = T0;\n    $[32] = t3;\n    $[33] = t4;\n    $[34] = t7;\n  } else {\n    t7 = $[34];\n  }\n  let t8;\n  if ($[35] !== t5 || $[36] !== t6 || $[37] !== t7) {\n    t8 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t5,\n      t6,\n      t7\n    ] });\n    $[35] = t5;\n    $[36] = t6;\n    $[37] = t7;\n    $[38] = t8;\n  } else {\n    t8 = $[38];\n  }\n  return t8;\n}\nfunction debounce(duration, fn) {\n  let timeout;\n  return function(...args) {\n    if (timeout) {\n      window.clearTimeout(timeout);\n    }\n    timeout = window.setTimeout(() => {\n      timeout = null;\n      fn(...args);\n    }, duration);\n  };\n}\nconst Search = () => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(33);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: Search\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    explorerNavStack,\n    push\n  } = useExplorerContext(t0);\n  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const getSearchResults = useSearchResults();\n  const [searchValue, setSearchValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(\"\");\n  let t1;\n  if ($[1] !== getSearchResults || $[2] !== searchValue) {\n    t1 = () => getSearchResults(searchValue);\n    $[1] = getSearchResults;\n    $[2] = searchValue;\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  const [results, setResults] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t1);\n  let t2;\n  if ($[4] !== getSearchResults) {\n    t2 = debounce(200, (search) => {\n      setResults(getSearchResults(search));\n    });\n    $[4] = getSearchResults;\n    $[5] = t2;\n  } else {\n    t2 = $[5];\n  }\n  const debouncedGetSearchResults = t2;\n  const [ref] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(inputRef);\n  const isFocused = ref.current === document.activeElement;\n  let t3;\n  let t4;\n  if ($[6] !== debouncedGetSearchResults || $[7] !== searchValue) {\n    t3 = () => {\n      debouncedGetSearchResults(searchValue);\n    };\n    t4 = [debouncedGetSearchResults, searchValue];\n    $[6] = debouncedGetSearchResults;\n    $[7] = searchValue;\n    $[8] = t3;\n    $[9] = t4;\n  } else {\n    t3 = $[8];\n    t4 = $[9];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t3, t4);\n  let t5;\n  let t6;\n  if ($[10] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t5 = () => {\n      const handleKeyDown = function handleKeyDown2(event) {\n        if (event.metaKey && event.key === \"k\") {\n          inputRef.current.focus();\n        }\n      };\n      window.addEventListener(\"keydown\", handleKeyDown);\n      return () => window.removeEventListener(\"keydown\", handleKeyDown);\n    };\n    t6 = [];\n    $[10] = t5;\n    $[11] = t6;\n  } else {\n    t5 = $[10];\n    t6 = $[11];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t5, t6);\n  let navItem;\n  let onSelect;\n  let t7;\n  if ($[12] !== explorerNavStack || $[13] !== push) {\n    navItem = explorerNavStack.at(-1);\n    let t82;\n    if ($[17] !== push) {\n      t82 = (def) => {\n        push(\"field\" in def ? {\n          name: def.field.name,\n          def: def.field\n        } : {\n          name: def.type.name,\n          def: def.type\n        });\n      };\n      $[17] = push;\n      $[18] = t82;\n    } else {\n      t82 = $[18];\n    }\n    onSelect = t82;\n    t7 = explorerNavStack.length === 1 || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isObjectType)(navItem.def) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInterfaceType)(navItem.def) || (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInputObjectType)(navItem.def);\n    $[12] = explorerNavStack;\n    $[13] = push;\n    $[14] = navItem;\n    $[15] = onSelect;\n    $[16] = t7;\n  } else {\n    navItem = $[14];\n    onSelect = $[15];\n    t7 = $[16];\n  }\n  const shouldSearchBoxAppear = t7;\n  if (!shouldSearchBoxAppear) {\n    return null;\n  }\n  const t8 = isFocused ? void 0 : \"idle\";\n  const t9 = `Search ${navItem.name}...`;\n  let t10;\n  let t11;\n  if ($[19] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t10 = () => {\n      inputRef.current.focus();\n    };\n    t11 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MagnifyingGlassIcon, {});\n    $[19] = t10;\n    $[20] = t11;\n  } else {\n    t10 = $[19];\n    t11 = $[20];\n  }\n  let t12;\n  if ($[21] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t12 = (event_0) => setSearchValue(event_0.target.value);\n    $[21] = t12;\n  } else {\n    t12 = $[21];\n  }\n  let t13;\n  if ($[22] !== searchValue) {\n    t13 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-search-input\", onClick: t10, children: [\n      t11,\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox.Input, { autoComplete: \"off\", onChange: t12, placeholder: `${isMacOs ? \"⌘\" : \"Ctrl\"} K`, ref: inputRef, value: searchValue, \"data-cy\": \"doc-explorer-input\" })\n    ] });\n    $[22] = searchValue;\n    $[23] = t13;\n  } else {\n    t13 = $[23];\n  }\n  let t14;\n  if ($[24] !== isFocused || $[25] !== results) {\n    t14 = isFocused && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox.Options, { \"data-cy\": \"doc-explorer-list\", children: [\n      results.within.length + results.types.length + results.fields.length === 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"li\", { className: \"graphiql-doc-explorer-search-empty\", children: \"No results found\" }) : results.within.map(_temp$4),\n      results.within.length > 0 && results.types.length + results.fields.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-search-divider\", children: \"Other results\" }) : null,\n      results.types.map(_temp2$2),\n      results.fields.map(_temp3$2)\n    ] });\n    $[24] = isFocused;\n    $[25] = results;\n    $[26] = t14;\n  } else {\n    t14 = $[26];\n  }\n  let t15;\n  if ($[27] !== onSelect || $[28] !== t13 || $[29] !== t14 || $[30] !== t8 || $[31] !== t9) {\n    t15 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox, { as: \"div\", className: \"graphiql-doc-explorer-search\", onChange: onSelect, \"data-state\": t8, \"aria-label\": t9, children: [\n      t13,\n      t14\n    ] });\n    $[27] = onSelect;\n    $[28] = t13;\n    $[29] = t14;\n    $[30] = t8;\n    $[31] = t9;\n    $[32] = t15;\n  } else {\n    t15 = $[32];\n  }\n  return t15;\n};\nconst _useSearchResults = useSearchResults;\nfunction useSearchResults(caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(9);\n  const t0 = caller || _useSearchResults;\n  let t1;\n  if ($[0] !== t0) {\n    t1 = {\n      nonNull: true,\n      caller: t0\n    };\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    explorerNavStack\n  } = useExplorerContext(t1);\n  const t2 = caller || _useSearchResults;\n  let t3;\n  if ($[2] !== t2) {\n    t3 = {\n      nonNull: true,\n      caller: t2\n    };\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const {\n    schema\n  } = useSchemaContext(t3);\n  let t4;\n  if ($[4] !== explorerNavStack) {\n    t4 = explorerNavStack.at(-1);\n    $[4] = explorerNavStack;\n    $[5] = t4;\n  } else {\n    t4 = $[5];\n  }\n  const navItem = t4;\n  let t5;\n  if ($[6] !== navItem || $[7] !== schema) {\n    t5 = (searchValue) => {\n      const matches = {\n        within: [],\n        types: [],\n        fields: []\n      };\n      if (!schema) {\n        return matches;\n      }\n      const withinType = navItem.def;\n      const typeMap = schema.getTypeMap();\n      let typeNames = Object.keys(typeMap);\n      if (withinType) {\n        typeNames = typeNames.filter((n) => n !== withinType.name);\n        typeNames.unshift(withinType.name);\n      }\n      for (const typeName of typeNames) {\n        if (matches.within.length + matches.types.length + matches.fields.length >= 100) {\n          break;\n        }\n        const type = typeMap[typeName];\n        if (withinType !== type && isMatch(typeName, searchValue)) {\n          matches.types.push({\n            type\n          });\n        }\n        if (!(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isObjectType)(type) && !(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInterfaceType)(type) && !(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInputObjectType)(type)) {\n          continue;\n        }\n        const fields = type.getFields();\n        for (const fieldName in fields) {\n          const field = fields[fieldName];\n          let matchingArgs;\n          if (!isMatch(fieldName, searchValue)) {\n            if (\"args\" in field) {\n              matchingArgs = field.args.filter((arg) => isMatch(arg.name, searchValue));\n              if (matchingArgs.length === 0) {\n                continue;\n              }\n            } else {\n              continue;\n            }\n          }\n          matches[withinType === type ? \"within\" : \"fields\"].push(...matchingArgs ? matchingArgs.map((argument) => ({\n            type,\n            field,\n            argument\n          })) : [{\n            type,\n            field\n          }]);\n        }\n      }\n      return matches;\n    };\n    $[6] = navItem;\n    $[7] = schema;\n    $[8] = t5;\n  } else {\n    t5 = $[8];\n  }\n  return t5;\n}\nfunction isMatch(sourceText, searchValue) {\n  try {\n    const escaped = searchValue.replaceAll(/[^_0-9A-Za-z]/g, (ch) => \"\\\\\" + ch);\n    return new RegExp(escaped, \"i\").test(sourceText);\n  } catch {\n    return sourceText.toLowerCase().includes(searchValue.toLowerCase());\n  }\n}\nfunction Type(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n  let t0;\n  if ($[0] !== props.type.name) {\n    t0 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-search-type\", children: props.type.name });\n    $[0] = props.type.name;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  return t0;\n}\nfunction Field$1(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  const {\n    field,\n    argument\n  } = t0;\n  let t1;\n  if ($[0] !== field.name) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-search-field\", children: field.name });\n    $[0] = field.name;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  let t2;\n  if ($[2] !== argument) {\n    t2 = argument ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      \"(\",\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { className: \"graphiql-doc-explorer-search-argument\", children: argument.name }),\n      \":\",\n      \" \",\n      renderType(argument.type, _temp4$2),\n      \")\"\n    ] }) : null;\n    $[2] = argument;\n    $[3] = t2;\n  } else {\n    t2 = $[3];\n  }\n  let t3;\n  if ($[4] !== t1 || $[5] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t1,\n      t2\n    ] });\n    $[4] = t1;\n    $[5] = t2;\n    $[6] = t3;\n  } else {\n    t3 = $[6];\n  }\n  return t3;\n}\nfunction _temp4$2(namedType) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Type, { type: namedType });\n}\nfunction _temp$4(result, i) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox.Option, { value: result, \"data-cy\": \"doc-explorer-option\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Field$1, { field: result.field, argument: result.argument }) }, `within-${i}`);\n}\nfunction _temp2$2(result_0, i_0) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox.Option, { value: result_0, \"data-cy\": \"doc-explorer-option\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Type, { type: result_0.type }) }, `type-${i_0}`);\n}\nfunction _temp3$2(result_1, i_1) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_24__.Combobox.Option, { value: result_1, \"data-cy\": \"doc-explorer-option\", children: [\n    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Type, { type: result_1.type }),\n    \".\",\n    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Field$1, { field: result_1.field, argument: result_1.argument })\n  ] }, `field-${i_1}`);\n}\nfunction FieldLink(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    push\n  } = useExplorerContext(t0);\n  let t1;\n  if ($[1] !== props.field || $[2] !== push) {\n    t1 = (event) => {\n      event.preventDefault();\n      push({\n        name: props.field.name,\n        def: props.field\n      });\n    };\n    $[1] = props.field;\n    $[2] = push;\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  let t2;\n  if ($[4] !== props.field.name || $[5] !== t1) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"graphiql-doc-explorer-field-name\", onClick: t1, href: \"#\", children: props.field.name });\n    $[4] = props.field.name;\n    $[5] = t1;\n    $[6] = t2;\n  } else {\n    t2 = $[6];\n  }\n  return t2;\n}\nfunction TypeDocumentation(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n  let t0;\n  if ($[0] !== props.type) {\n    t0 = (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isNamedType)(props.type) ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      props.type.description ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", children: props.type.description }) : null,\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ImplementsInterfaces, { type: props.type }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Fields, { type: props.type }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EnumValues, { type: props.type }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PossibleTypes, { type: props.type })\n    ] }) : null;\n    $[0] = props.type;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  return t0;\n}\nfunction ImplementsInterfaces(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(5);\n  const {\n    type\n  } = t0;\n  if (!(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isObjectType)(type)) {\n    return null;\n  }\n  let t1;\n  if ($[0] !== type) {\n    t1 = type.getInterfaces();\n    $[0] = type;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const interfaces = t1;\n  let t2;\n  if ($[2] !== interfaces.length || $[3] !== type) {\n    t2 = interfaces.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Implements\", children: type.getInterfaces().map(_temp$3) }) : null;\n    $[2] = interfaces.length;\n    $[3] = type;\n    $[4] = t2;\n  } else {\n    t2 = $[4];\n  }\n  return t2;\n}\nfunction _temp$3(implementedInterface) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: implementedInterface }) }, implementedInterface.name);\n}\nfunction Fields(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(12);\n  const {\n    type\n  } = t0;\n  const [showDeprecated, setShowDeprecated] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  let t1;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = () => {\n      setShowDeprecated(true);\n    };\n    $[0] = t1;\n  } else {\n    t1 = $[0];\n  }\n  const handleShowDeprecated = t1;\n  if (!(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isObjectType)(type) && !(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInterfaceType)(type) && !(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInputObjectType)(type)) {\n    return null;\n  }\n  let deprecatedFields;\n  let fields;\n  let t2;\n  if ($[1] !== type) {\n    const fieldMap = type.getFields();\n    fields = [];\n    deprecatedFields = [];\n    for (const field of Object.keys(fieldMap).map((name) => fieldMap[name])) {\n      if (field.deprecationReason) {\n        deprecatedFields.push(field);\n      } else {\n        fields.push(field);\n      }\n    }\n    t2 = fields.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Fields\", children: fields.map(_temp2$1) }) : null;\n    $[1] = type;\n    $[2] = deprecatedFields;\n    $[3] = fields;\n    $[4] = t2;\n  } else {\n    deprecatedFields = $[2];\n    fields = $[3];\n    t2 = $[4];\n  }\n  let t3;\n  if ($[5] !== deprecatedFields || $[6] !== fields.length || $[7] !== showDeprecated) {\n    t3 = deprecatedFields.length > 0 ? showDeprecated || fields.length === 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Deprecated Fields\", children: deprecatedFields.map(_temp3$1) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Button$1, { type: \"button\", onClick: handleShowDeprecated, children: \"Show Deprecated Fields\" }) : null;\n    $[5] = deprecatedFields;\n    $[6] = fields.length;\n    $[7] = showDeprecated;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  let t4;\n  if ($[9] !== t2 || $[10] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t2,\n      t3\n    ] });\n    $[9] = t2;\n    $[10] = t3;\n    $[11] = t4;\n  } else {\n    t4 = $[11];\n  }\n  return t4;\n}\nfunction _temp3$1(field_1) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Field, { field: field_1 }, field_1.name);\n}\nfunction _temp2$1(field_0) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Field, { field: field_0 }, field_0.name);\n}\nfunction Field(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(22);\n  const {\n    field\n  } = t0;\n  let t1;\n  let t2;\n  let t3;\n  if ($[0] !== field) {\n    const args = \"args\" in field ? field.args.filter(_temp4$1) : [];\n    t3 = \"graphiql-doc-explorer-item\";\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldLink, { field });\n    t2 = args.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      \"(\",\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"span\", { children: args.map((arg_0) => args.length === 1 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Argument, { arg: arg_0, inline: true }, arg_0.name) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-argument-multiple\", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Argument, { arg: arg_0, inline: true }) }, arg_0.name)) }),\n      \")\"\n    ] }) : null;\n    $[0] = field;\n    $[1] = t1;\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t1 = $[1];\n    t2 = $[2];\n    t3 = $[3];\n  }\n  let t4;\n  if ($[4] !== field.type) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: field.type });\n    $[4] = field.type;\n    $[5] = t4;\n  } else {\n    t4 = $[5];\n  }\n  let t5;\n  if ($[6] !== field) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DefaultValue, { field });\n    $[6] = field;\n    $[7] = t5;\n  } else {\n    t5 = $[7];\n  }\n  let t6;\n  if ($[8] !== t1 || $[9] !== t2 || $[10] !== t4 || $[11] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n      t1,\n      t2,\n      \": \",\n      t4,\n      t5\n    ] });\n    $[8] = t1;\n    $[9] = t2;\n    $[10] = t4;\n    $[11] = t5;\n    $[12] = t6;\n  } else {\n    t6 = $[12];\n  }\n  let t7;\n  if ($[13] !== field.description) {\n    t7 = field.description ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", onlyShowFirstChild: true, children: field.description }) : null;\n    $[13] = field.description;\n    $[14] = t7;\n  } else {\n    t7 = $[14];\n  }\n  let t8;\n  if ($[15] !== field.deprecationReason) {\n    t8 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DeprecationReason, { children: field.deprecationReason });\n    $[15] = field.deprecationReason;\n    $[16] = t8;\n  } else {\n    t8 = $[16];\n  }\n  let t9;\n  if ($[17] !== t3 || $[18] !== t6 || $[19] !== t7 || $[20] !== t8) {\n    t9 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: t3, children: [\n      t6,\n      t7,\n      t8\n    ] });\n    $[17] = t3;\n    $[18] = t6;\n    $[19] = t7;\n    $[20] = t8;\n    $[21] = t9;\n  } else {\n    t9 = $[21];\n  }\n  return t9;\n}\nfunction _temp4$1(arg) {\n  return !arg.deprecationReason;\n}\nfunction EnumValues(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(12);\n  const {\n    type\n  } = t0;\n  const [showDeprecated, setShowDeprecated] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);\n  let t1;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = () => {\n      setShowDeprecated(true);\n    };\n    $[0] = t1;\n  } else {\n    t1 = $[0];\n  }\n  const handleShowDeprecated = t1;\n  if (!(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isEnumType)(type)) {\n    return null;\n  }\n  let deprecatedValues;\n  let t2;\n  let values;\n  if ($[1] !== type) {\n    values = [];\n    deprecatedValues = [];\n    for (const value of type.getValues()) {\n      if (value.deprecationReason) {\n        deprecatedValues.push(value);\n      } else {\n        values.push(value);\n      }\n    }\n    t2 = values.length > 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Enum Values\", children: values.map(_temp5) }) : null;\n    $[1] = type;\n    $[2] = deprecatedValues;\n    $[3] = t2;\n    $[4] = values;\n  } else {\n    deprecatedValues = $[2];\n    t2 = $[3];\n    values = $[4];\n  }\n  let t3;\n  if ($[5] !== deprecatedValues || $[6] !== showDeprecated || $[7] !== values.length) {\n    t3 = deprecatedValues.length > 0 ? showDeprecated || values.length === 0 ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: \"Deprecated Enum Values\", children: deprecatedValues.map(_temp6) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Button$1, { type: \"button\", onClick: handleShowDeprecated, children: \"Show Deprecated Values\" }) : null;\n    $[5] = deprecatedValues;\n    $[6] = showDeprecated;\n    $[7] = values.length;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  let t4;\n  if ($[9] !== t2 || $[10] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [\n      t2,\n      t3\n    ] });\n    $[9] = t2;\n    $[10] = t3;\n    $[11] = t4;\n  } else {\n    t4 = $[11];\n  }\n  return t4;\n}\nfunction _temp6(value_1) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EnumValue, { value: value_1 }, value_1.name);\n}\nfunction _temp5(value_0) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EnumValue, { value: value_0 }, value_0.name);\n}\nfunction EnumValue(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  const {\n    value\n  } = t0;\n  let t1;\n  if ($[0] !== value.name) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-enum-value\", children: value.name });\n    $[0] = value.name;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  let t2;\n  if ($[2] !== value.description) {\n    t2 = value.description ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"description\", children: value.description }) : null;\n    $[2] = value.description;\n    $[3] = t2;\n  } else {\n    t2 = $[3];\n  }\n  let t3;\n  if ($[4] !== value.deprecationReason) {\n    t3 = value.deprecationReason ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownContent, { type: \"deprecation\", children: value.deprecationReason }) : null;\n    $[4] = value.deprecationReason;\n    $[5] = t3;\n  } else {\n    t3 = $[5];\n  }\n  let t4;\n  if ($[6] !== t1 || $[7] !== t2 || $[8] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-item\", children: [\n      t1,\n      t2,\n      t3\n    ] });\n    $[6] = t1;\n    $[7] = t2;\n    $[8] = t3;\n    $[9] = t4;\n  } else {\n    t4 = $[9];\n  }\n  return t4;\n}\nfunction PossibleTypes(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  const {\n    type\n  } = t0;\n  let t1;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true\n    };\n    $[0] = t1;\n  } else {\n    t1 = $[0];\n  }\n  const {\n    schema\n  } = useSchemaContext(t1);\n  if (!schema || !(0,graphql__WEBPACK_IMPORTED_MODULE_6__.isAbstractType)(type)) {\n    return null;\n  }\n  const t2 = (0,graphql__WEBPACK_IMPORTED_MODULE_6__.isInterfaceType)(type) ? \"Implementations\" : \"Possible Types\";\n  let t3;\n  if ($[1] !== schema || $[2] !== type) {\n    t3 = schema.getPossibleTypes(type).map(_temp7);\n    $[1] = schema;\n    $[2] = type;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  let t4;\n  if ($[4] !== t2 || $[5] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerSection, { title: t2, children: t3 });\n    $[4] = t2;\n    $[5] = t3;\n    $[6] = t4;\n  } else {\n    t4 = $[6];\n  }\n  return t4;\n}\nfunction _temp7(possibleType) {\n  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeLink, { type: possibleType }) }, possibleType.name);\n}\nfunction DocExplorer() {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(40);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: DocExplorer\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    fetchError,\n    isFetching,\n    schema,\n    validationErrors\n  } = useSchemaContext(t0);\n  let t1;\n  if ($[1] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: DocExplorer\n    };\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    explorerNavStack,\n    pop\n  } = useExplorerContext(t1);\n  let content;\n  let navItem;\n  if ($[2] !== explorerNavStack || $[3] !== fetchError || $[4] !== isFetching || $[5] !== schema || $[6] !== validationErrors) {\n    navItem = explorerNavStack.at(-1);\n    content = null;\n    if (fetchError) {\n      let t22;\n      if ($[9] === Symbol.for(\"react.memo_cache_sentinel\")) {\n        t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-error\", children: \"Error fetching schema\" });\n        $[9] = t22;\n      } else {\n        t22 = $[9];\n      }\n      content = t22;\n    } else {\n      if (validationErrors.length > 0) {\n        let t22;\n        if ($[10] !== validationErrors[0].message) {\n          t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-error\", children: [\n            \"Schema is invalid: \",\n            validationErrors[0].message\n          ] });\n          $[10] = validationErrors[0].message;\n          $[11] = t22;\n        } else {\n          t22 = $[11];\n        }\n        content = t22;\n      } else {\n        if (isFetching) {\n          let t22;\n          if ($[12] === Symbol.for(\"react.memo_cache_sentinel\")) {\n            t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Spinner, {});\n            $[12] = t22;\n          } else {\n            t22 = $[12];\n          }\n          content = t22;\n        } else {\n          if (!schema) {\n            let t22;\n            if ($[13] === Symbol.for(\"react.memo_cache_sentinel\")) {\n              t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-error\", children: \"No GraphQL schema available\" });\n              $[13] = t22;\n            } else {\n              t22 = $[13];\n            }\n            content = t22;\n          } else {\n            if (explorerNavStack.length === 1) {\n              let t22;\n              if ($[14] !== schema) {\n                t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaDocumentation, { schema });\n                $[14] = schema;\n                $[15] = t22;\n              } else {\n                t22 = $[15];\n              }\n              content = t22;\n            } else {\n              if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isType)(navItem.def)) {\n                let t22;\n                if ($[16] !== navItem.def) {\n                  t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TypeDocumentation, { type: navItem.def });\n                  $[16] = navItem.def;\n                  $[17] = t22;\n                } else {\n                  t22 = $[17];\n                }\n                content = t22;\n              } else {\n                if (navItem.def) {\n                  let t22;\n                  if ($[18] !== navItem.def) {\n                    t22 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldDocumentation, { field: navItem.def });\n                    $[18] = navItem.def;\n                    $[19] = t22;\n                  } else {\n                    t22 = $[19];\n                  }\n                  content = t22;\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n    $[2] = explorerNavStack;\n    $[3] = fetchError;\n    $[4] = isFetching;\n    $[5] = schema;\n    $[6] = validationErrors;\n    $[7] = content;\n    $[8] = navItem;\n  } else {\n    content = $[7];\n    navItem = $[8];\n  }\n  let prevName;\n  if (explorerNavStack.length > 1) {\n    let t22;\n    if ($[20] !== explorerNavStack) {\n      t22 = explorerNavStack.at(-2);\n      $[20] = explorerNavStack;\n      $[21] = t22;\n    } else {\n      t22 = $[21];\n    }\n    prevName = t22.name;\n  }\n  let t2;\n  if ($[22] !== pop || $[23] !== prevName) {\n    t2 = prevName && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"a\", { href: \"#\", className: \"graphiql-doc-explorer-back\", onClick: (event) => {\n      event.preventDefault();\n      pop();\n    }, \"aria-label\": `Go back to ${prevName}`, children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ChevronLeftIcon, {}),\n      prevName\n    ] });\n    $[22] = pop;\n    $[23] = prevName;\n    $[24] = t2;\n  } else {\n    t2 = $[24];\n  }\n  let t3;\n  if ($[25] !== navItem.name) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-title\", children: navItem.name });\n    $[25] = navItem.name;\n    $[26] = t3;\n  } else {\n    t3 = $[26];\n  }\n  let t4;\n  if ($[27] !== t2 || $[28] !== t3) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-header-content\", children: [\n      t2,\n      t3\n    ] });\n    $[27] = t2;\n    $[28] = t3;\n    $[29] = t4;\n  } else {\n    t4 = $[29];\n  }\n  let t5;\n  if ($[30] !== navItem.name) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Search, {}, navItem.name);\n    $[30] = navItem.name;\n    $[31] = t5;\n  } else {\n    t5 = $[31];\n  }\n  let t6;\n  if ($[32] !== t4 || $[33] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"graphiql-doc-explorer-header\", children: [\n      t4,\n      t5\n    ] });\n    $[32] = t4;\n    $[33] = t5;\n    $[34] = t6;\n  } else {\n    t6 = $[34];\n  }\n  let t7;\n  if ($[35] !== content) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-doc-explorer-content\", children: content });\n    $[35] = content;\n    $[36] = t7;\n  } else {\n    t7 = $[36];\n  }\n  let t8;\n  if ($[37] !== t6 || $[38] !== t7) {\n    t8 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"section\", { className: \"graphiql-doc-explorer\", \"aria-label\": \"Documentation Explorer\", children: [\n      t6,\n      t7\n    ] });\n    $[37] = t6;\n    $[38] = t7;\n    $[39] = t8;\n  } else {\n    t8 = $[39];\n  }\n  return t8;\n}\nconst DOC_EXPLORER_PLUGIN = {\n  title: \"Documentation Explorer\",\n  icon: function Icon() {\n    const pluginContext = usePluginContext();\n    return (pluginContext == null ? void 0 : pluginContext.visiblePlugin) === DOC_EXPLORER_PLUGIN ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DocsFilledIcon, {}) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DocsIcon, {});\n  },\n  content: DocExplorer\n};\nconst HISTORY_PLUGIN = {\n  title: \"History\",\n  icon: HistoryIcon,\n  content: History\n};\nconst PluginContext = createNullableContext(\"PluginContext\");\nfunction PluginContextProvider(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(27);\n  const storage = useStorageContext();\n  const explorerContext = useExplorerContext();\n  const historyContext = useHistoryContext();\n  const hasExplorerContext = Boolean(explorerContext);\n  const hasHistoryContext = Boolean(historyContext);\n  let t0;\n  let pluginList;\n  if ($[0] !== hasExplorerContext || $[1] !== hasHistoryContext || $[2] !== props.plugins) {\n    pluginList = [];\n    const pluginTitles = {};\n    if (hasExplorerContext) {\n      pluginList.push(DOC_EXPLORER_PLUGIN);\n      pluginTitles[DOC_EXPLORER_PLUGIN.title] = true;\n    }\n    if (hasHistoryContext) {\n      pluginList.push(HISTORY_PLUGIN);\n      pluginTitles[HISTORY_PLUGIN.title] = true;\n    }\n    let t12;\n    if ($[4] !== props.plugins) {\n      t12 = props.plugins || [];\n      $[4] = props.plugins;\n      $[5] = t12;\n    } else {\n      t12 = $[5];\n    }\n    for (const plugin of t12) {\n      if (typeof plugin.title !== \"string\" || !plugin.title) {\n        throw new Error(\"All GraphiQL plugins must have a unique title\");\n      }\n      if (pluginTitles[plugin.title]) {\n        throw new Error(`All GraphiQL plugins must have a unique title, found two plugins with the title '${plugin.title}'`);\n      } else {\n        pluginList.push(plugin);\n        pluginTitles[plugin.title] = true;\n      }\n    }\n    $[0] = hasExplorerContext;\n    $[1] = hasHistoryContext;\n    $[2] = props.plugins;\n    $[3] = pluginList;\n  } else {\n    pluginList = $[3];\n  }\n  t0 = pluginList;\n  const plugins = t0;\n  let t1;\n  if ($[6] !== plugins || $[7] !== props.visiblePlugin || $[8] !== storage) {\n    t1 = () => {\n      const storedValue = storage == null ? void 0 : storage.get(STORAGE_KEY$4);\n      const pluginForStoredValue = plugins.find((plugin_0) => plugin_0.title === storedValue);\n      if (pluginForStoredValue) {\n        return pluginForStoredValue;\n      }\n      if (storedValue) {\n        storage == null ? void 0 : storage.set(STORAGE_KEY$4, \"\");\n      }\n      if (!props.visiblePlugin) {\n        return null;\n      }\n      return plugins.find((plugin_1) => (typeof props.visiblePlugin === \"string\" ? plugin_1.title : plugin_1) === props.visiblePlugin) || null;\n    };\n    $[6] = plugins;\n    $[7] = props.visiblePlugin;\n    $[8] = storage;\n    $[9] = t1;\n  } else {\n    t1 = $[9];\n  }\n  const [visiblePlugin, internalSetVisiblePlugin] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t1);\n  const {\n    onTogglePluginVisibility,\n    children\n  } = props;\n  let t2;\n  if ($[10] !== onTogglePluginVisibility || $[11] !== plugins) {\n    t2 = (plugin_2) => {\n      const newVisiblePlugin = plugin_2 ? plugins.find((p) => (typeof plugin_2 === \"string\" ? p.title : p) === plugin_2) || null : null;\n      internalSetVisiblePlugin((current) => {\n        if (newVisiblePlugin === current) {\n          return current;\n        }\n        onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);\n        return newVisiblePlugin;\n      });\n    };\n    $[10] = onTogglePluginVisibility;\n    $[11] = plugins;\n    $[12] = t2;\n  } else {\n    t2 = $[12];\n  }\n  const setVisiblePlugin = t2;\n  let t3;\n  if ($[13] !== props.visiblePlugin || $[14] !== setVisiblePlugin) {\n    t3 = () => {\n      if (props.visiblePlugin) {\n        setVisiblePlugin(props.visiblePlugin);\n      }\n    };\n    $[13] = props.visiblePlugin;\n    $[14] = setVisiblePlugin;\n    $[15] = t3;\n  } else {\n    t3 = $[15];\n  }\n  let t4;\n  if ($[16] !== plugins || $[17] !== props.visiblePlugin || $[18] !== setVisiblePlugin) {\n    t4 = [plugins, props.visiblePlugin, setVisiblePlugin];\n    $[16] = plugins;\n    $[17] = props.visiblePlugin;\n    $[18] = setVisiblePlugin;\n    $[19] = t4;\n  } else {\n    t4 = $[19];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t3, t4);\n  let t5;\n  if ($[20] !== plugins || $[21] !== setVisiblePlugin || $[22] !== visiblePlugin) {\n    t5 = {\n      plugins,\n      setVisiblePlugin,\n      visiblePlugin\n    };\n    $[20] = plugins;\n    $[21] = setVisiblePlugin;\n    $[22] = visiblePlugin;\n    $[23] = t5;\n  } else {\n    t5 = $[23];\n  }\n  const value = t5;\n  let t6;\n  if ($[24] !== children || $[25] !== value) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PluginContext.Provider, { value, children });\n    $[24] = children;\n    $[25] = value;\n    $[26] = t6;\n  } else {\n    t6 = $[26];\n  }\n  return t6;\n}\nconst usePluginContext = createContextHook(PluginContext);\nconst STORAGE_KEY$4 = \"visiblePlugin\";\nfunction onHasCompletion(_cm, data, schema, explorer, plugin, callback) {\n  void importCodeMirror([], {\n    useCommonAddons: false\n  }).then((CodeMirror) => {\n    let information;\n    let fieldName;\n    let typeNamePill;\n    let typeNamePrefix;\n    let typeName;\n    let typeNameSuffix;\n    let description;\n    let deprecation;\n    let deprecationReason;\n    CodeMirror.on(\n      data,\n      \"select\",\n      // @ts-expect-error\n      (ctx, el) => {\n        if (!information) {\n          const hintsUl = el.parentNode;\n          information = document.createElement(\"div\");\n          information.className = \"CodeMirror-hint-information\";\n          hintsUl.append(information);\n          const header = document.createElement(\"header\");\n          header.className = \"CodeMirror-hint-information-header\";\n          information.append(header);\n          fieldName = document.createElement(\"span\");\n          fieldName.className = \"CodeMirror-hint-information-field-name\";\n          header.append(fieldName);\n          typeNamePill = document.createElement(\"span\");\n          typeNamePill.className = \"CodeMirror-hint-information-type-name-pill\";\n          header.append(typeNamePill);\n          typeNamePrefix = document.createElement(\"span\");\n          typeNamePill.append(typeNamePrefix);\n          typeName = document.createElement(\"a\");\n          typeName.className = \"CodeMirror-hint-information-type-name\";\n          typeName.href = \"javascript:void 0\";\n          typeName.addEventListener(\"click\", onClickHintInformation);\n          typeNamePill.append(typeName);\n          typeNameSuffix = document.createElement(\"span\");\n          typeNamePill.append(typeNameSuffix);\n          description = document.createElement(\"div\");\n          description.className = \"CodeMirror-hint-information-description\";\n          information.append(description);\n          deprecation = document.createElement(\"div\");\n          deprecation.className = \"CodeMirror-hint-information-deprecation\";\n          information.append(deprecation);\n          const deprecationLabel = document.createElement(\"span\");\n          deprecationLabel.className = \"CodeMirror-hint-information-deprecation-label\";\n          deprecationLabel.textContent = \"Deprecated\";\n          deprecation.append(deprecationLabel);\n          deprecationReason = document.createElement(\"div\");\n          deprecationReason.className = \"CodeMirror-hint-information-deprecation-reason\";\n          deprecation.append(deprecationReason);\n          const defaultInformationPadding = parseInt(window.getComputedStyle(information).paddingBottom.replace(/px$/, \"\"), 10) || 0;\n          const defaultInformationMaxHeight = parseInt(window.getComputedStyle(information).maxHeight.replace(/px$/, \"\"), 10) || 0;\n          const handleScroll = () => {\n            if (information) {\n              information.style.paddingTop = hintsUl.scrollTop + defaultInformationPadding + \"px\";\n              information.style.maxHeight = hintsUl.scrollTop + defaultInformationMaxHeight + \"px\";\n            }\n          };\n          hintsUl.addEventListener(\"scroll\", handleScroll);\n          let onRemoveFn;\n          hintsUl.addEventListener(\"DOMNodeRemoved\", onRemoveFn = (event) => {\n            if (event.target !== hintsUl) {\n              return;\n            }\n            hintsUl.removeEventListener(\"scroll\", handleScroll);\n            hintsUl.removeEventListener(\"DOMNodeRemoved\", onRemoveFn);\n            if (information) {\n              information.removeEventListener(\"click\", onClickHintInformation);\n            }\n            information = null;\n            fieldName = null;\n            typeNamePill = null;\n            typeNamePrefix = null;\n            typeName = null;\n            typeNameSuffix = null;\n            description = null;\n            deprecation = null;\n            deprecationReason = null;\n            onRemoveFn = null;\n          });\n        }\n        if (fieldName) {\n          fieldName.textContent = ctx.text;\n        }\n        if (typeNamePill && typeNamePrefix && typeName && typeNameSuffix) {\n          if (ctx.type) {\n            typeNamePill.style.display = \"inline\";\n            const renderType2 = (type) => {\n              if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isNonNullType)(type)) {\n                typeNameSuffix.textContent = \"!\" + typeNameSuffix.textContent;\n                renderType2(type.ofType);\n              } else if ((0,graphql__WEBPACK_IMPORTED_MODULE_6__.isListType)(type)) {\n                typeNamePrefix.textContent += \"[\";\n                typeNameSuffix.textContent = \"]\" + typeNameSuffix.textContent;\n                renderType2(type.ofType);\n              } else {\n                typeName.textContent = type.name;\n              }\n            };\n            typeNamePrefix.textContent = \"\";\n            typeNameSuffix.textContent = \"\";\n            renderType2(ctx.type);\n          } else {\n            typeNamePrefix.textContent = \"\";\n            typeName.textContent = \"\";\n            typeNameSuffix.textContent = \"\";\n            typeNamePill.style.display = \"none\";\n          }\n        }\n        if (description) {\n          if (ctx.description) {\n            description.style.display = \"block\";\n            description.innerHTML = markdown.render(ctx.description);\n          } else {\n            description.style.display = \"none\";\n            description.innerHTML = \"\";\n          }\n        }\n        if (deprecation && deprecationReason) {\n          if (ctx.deprecationReason) {\n            deprecation.style.display = \"block\";\n            deprecationReason.innerHTML = markdown.render(ctx.deprecationReason);\n          } else {\n            deprecation.style.display = \"none\";\n            deprecationReason.innerHTML = \"\";\n          }\n        }\n      }\n    );\n  });\n  function onClickHintInformation(event) {\n    if (!schema || !explorer || !plugin || !(event.currentTarget instanceof HTMLElement)) {\n      return;\n    }\n    const typeName = event.currentTarget.textContent || \"\";\n    const type = schema.getType(typeName);\n    if (type) {\n      plugin.setVisiblePlugin(DOC_EXPLORER_PLUGIN);\n      explorer.push({\n        name: type.name,\n        def: type\n      });\n      callback == null ? void 0 : callback(type);\n    }\n  }\n}\nfunction useSynchronizeValue(editor, value) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(4);\n  let t0;\n  let t1;\n  if ($[0] !== editor || $[1] !== value) {\n    t0 = () => {\n      if (editor && typeof value === \"string\" && value !== editor.getValue()) {\n        editor.setValue(value);\n      }\n    };\n    t1 = [editor, value];\n    $[0] = editor;\n    $[1] = value;\n    $[2] = t0;\n    $[3] = t1;\n  } else {\n    t0 = $[2];\n    t1 = $[3];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t0, t1);\n}\nfunction useSynchronizeOption(editor, option, value) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(5);\n  let t0;\n  let t1;\n  if ($[0] !== editor || $[1] !== option || $[2] !== value) {\n    t0 = () => {\n      if (editor) {\n        editor.setOption(option, value);\n      }\n    };\n    t1 = [editor, option, value];\n    $[0] = editor;\n    $[1] = option;\n    $[2] = value;\n    $[3] = t0;\n    $[4] = t1;\n  } else {\n    t0 = $[3];\n    t1 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t0, t1);\n}\nfunction useChangeHandler(editor, callback, storageKey, tabProperty, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  let t0;\n  if ($[0] !== caller) {\n    t0 = {\n      nonNull: true,\n      caller\n    };\n    $[0] = caller;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  const {\n    updateActiveTabValues\n  } = useEditorContext(t0);\n  const storage = useStorageContext();\n  let t1;\n  let t2;\n  if ($[2] !== callback || $[3] !== editor || $[4] !== storage || $[5] !== storageKey || $[6] !== tabProperty || $[7] !== updateActiveTabValues) {\n    t1 = () => {\n      if (!editor) {\n        return;\n      }\n      const store = debounce(500, (value) => {\n        if (!storage || storageKey === null) {\n          return;\n        }\n        storage.set(storageKey, value);\n      });\n      const updateTab = debounce(100, (value_0) => {\n        updateActiveTabValues({\n          [tabProperty]: value_0\n        });\n      });\n      const handleChange = (editorInstance, changeObj) => {\n        if (!changeObj) {\n          return;\n        }\n        const newValue = editorInstance.getValue();\n        store(newValue);\n        updateTab(newValue);\n        callback == null ? void 0 : callback(newValue);\n      };\n      editor.on(\"change\", handleChange);\n      return () => editor.off(\"change\", handleChange);\n    };\n    t2 = [callback, editor, storage, storageKey, tabProperty, updateActiveTabValues];\n    $[2] = callback;\n    $[3] = editor;\n    $[4] = storage;\n    $[5] = storageKey;\n    $[6] = tabProperty;\n    $[7] = updateActiveTabValues;\n    $[8] = t1;\n    $[9] = t2;\n  } else {\n    t1 = $[8];\n    t2 = $[9];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n}\nfunction useCompletion(editor, callback, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(9);\n  let t0;\n  if ($[0] !== caller) {\n    t0 = {\n      nonNull: true,\n      caller\n    };\n    $[0] = caller;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  const {\n    schema\n  } = useSchemaContext(t0);\n  const explorer = useExplorerContext();\n  const plugin = usePluginContext();\n  let t1;\n  let t2;\n  if ($[2] !== callback || $[3] !== editor || $[4] !== explorer || $[5] !== plugin || $[6] !== schema) {\n    t1 = () => {\n      if (!editor) {\n        return;\n      }\n      const handleCompletion = (instance, changeObj) => {\n        onHasCompletion(instance, changeObj, schema, explorer, plugin, (type) => {\n          callback == null ? void 0 : callback({\n            kind: \"Type\",\n            type,\n            schema: schema || void 0\n          });\n        });\n      };\n      editor.on(\"hasCompletion\", handleCompletion);\n      return () => editor.off(\"hasCompletion\", handleCompletion);\n    };\n    t2 = [callback, editor, explorer, plugin, schema];\n    $[2] = callback;\n    $[3] = editor;\n    $[4] = explorer;\n    $[5] = plugin;\n    $[6] = schema;\n    $[7] = t1;\n    $[8] = t2;\n  } else {\n    t1 = $[7];\n    t2 = $[8];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n}\nfunction useKeyMap(editor, keys, callback) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(5);\n  let t0;\n  let t1;\n  if ($[0] !== callback || $[1] !== editor || $[2] !== keys) {\n    t0 = () => {\n      if (!editor) {\n        return;\n      }\n      for (const key of keys) {\n        editor.removeKeyMap(key);\n      }\n      if (callback) {\n        const keyMap = {};\n        for (const key_0 of keys) {\n          keyMap[key_0] = () => callback();\n        }\n        editor.addKeyMap(keyMap);\n      }\n    };\n    t1 = [editor, keys, callback];\n    $[0] = callback;\n    $[1] = editor;\n    $[2] = keys;\n    $[3] = t0;\n    $[4] = t1;\n  } else {\n    t0 = $[3];\n    t1 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t0, t1);\n}\nconst _useCopyQuery = useCopyQuery;\nconst _useMergeQuery = useMergeQuery;\nconst _usePrettifyEditors = usePrettifyEditors;\nconst _useAutoCompleteLeafs = useAutoCompleteLeafs;\nfunction useCopyQuery(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    caller,\n    onCopyQuery\n  } = t1;\n  const t2 = caller || _useCopyQuery;\n  let t3;\n  if ($[2] !== t2) {\n    t3 = {\n      nonNull: true,\n      caller: t2\n    };\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const {\n    queryEditor\n  } = useEditorContext(t3);\n  let t4;\n  if ($[4] !== onCopyQuery || $[5] !== queryEditor) {\n    t4 = () => {\n      if (!queryEditor) {\n        return;\n      }\n      const query = queryEditor.getValue();\n      copy_to_clipboard__WEBPACK_IMPORTED_MODULE_17__(query);\n      onCopyQuery == null ? void 0 : onCopyQuery(query);\n    };\n    $[4] = onCopyQuery;\n    $[5] = queryEditor;\n    $[6] = t4;\n  } else {\n    t4 = $[6];\n  }\n  return t4;\n}\nfunction useMergeQuery(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(8);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    caller\n  } = t1;\n  const t2 = caller || _useMergeQuery;\n  let t3;\n  if ($[2] !== t2) {\n    t3 = {\n      nonNull: true,\n      caller: t2\n    };\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const {\n    queryEditor\n  } = useEditorContext(t3);\n  let t4;\n  if ($[4] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t4 = {\n      nonNull: true,\n      caller: _useMergeQuery\n    };\n    $[4] = t4;\n  } else {\n    t4 = $[4];\n  }\n  const {\n    schema\n  } = useSchemaContext(t4);\n  let t5;\n  if ($[5] !== queryEditor || $[6] !== schema) {\n    t5 = () => {\n      const documentAST = queryEditor == null ? void 0 : queryEditor.documentAST;\n      const query = queryEditor == null ? void 0 : queryEditor.getValue();\n      if (!documentAST || !query) {\n        return;\n      }\n      queryEditor.setValue((0,graphql__WEBPACK_IMPORTED_MODULE_10__.print)((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.mergeAst)(documentAST, schema)));\n    };\n    $[5] = queryEditor;\n    $[6] = schema;\n    $[7] = t5;\n  } else {\n    t5 = $[7];\n  }\n  return t5;\n}\nfunction usePrettifyEditors(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(8);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    caller\n  } = t1;\n  const t2 = caller || _usePrettifyEditors;\n  let t3;\n  if ($[2] !== t2) {\n    t3 = {\n      nonNull: true,\n      caller: t2\n    };\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const {\n    queryEditor,\n    headerEditor,\n    variableEditor\n  } = useEditorContext(t3);\n  let t4;\n  if ($[4] !== headerEditor || $[5] !== queryEditor || $[6] !== variableEditor) {\n    t4 = () => {\n      if (variableEditor) {\n        const variableEditorContent = variableEditor.getValue();\n        try {\n          const prettifiedVariableEditorContent = JSON.stringify(JSON.parse(variableEditorContent), null, 2);\n          if (prettifiedVariableEditorContent !== variableEditorContent) {\n            variableEditor.setValue(prettifiedVariableEditorContent);\n          }\n        } catch {\n        }\n      }\n      if (headerEditor) {\n        const headerEditorContent = headerEditor.getValue();\n        try {\n          const prettifiedHeaderEditorContent = JSON.stringify(JSON.parse(headerEditorContent), null, 2);\n          if (prettifiedHeaderEditorContent !== headerEditorContent) {\n            headerEditor.setValue(prettifiedHeaderEditorContent);\n          }\n        } catch {\n        }\n      }\n      if (queryEditor) {\n        const editorContent = queryEditor.getValue();\n        const prettifiedEditorContent = (0,graphql__WEBPACK_IMPORTED_MODULE_10__.print)((0,graphql__WEBPACK_IMPORTED_MODULE_9__.parse)(editorContent));\n        if (prettifiedEditorContent !== editorContent) {\n          queryEditor.setValue(prettifiedEditorContent);\n        }\n      }\n    };\n    $[4] = headerEditor;\n    $[5] = queryEditor;\n    $[6] = variableEditor;\n    $[7] = t4;\n  } else {\n    t4 = $[7];\n  }\n  return t4;\n}\nfunction useAutoCompleteLeafs(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(10);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    getDefaultFieldNames,\n    caller\n  } = t1;\n  const t2 = caller || _useAutoCompleteLeafs;\n  let t3;\n  if ($[2] !== t2) {\n    t3 = {\n      nonNull: true,\n      caller: t2\n    };\n    $[2] = t2;\n    $[3] = t3;\n  } else {\n    t3 = $[3];\n  }\n  const {\n    schema\n  } = useSchemaContext(t3);\n  const t4 = caller || _useAutoCompleteLeafs;\n  let t5;\n  if ($[4] !== t4) {\n    t5 = {\n      nonNull: true,\n      caller: t4\n    };\n    $[4] = t4;\n    $[5] = t5;\n  } else {\n    t5 = $[5];\n  }\n  const {\n    queryEditor\n  } = useEditorContext(t5);\n  let t6;\n  if ($[6] !== getDefaultFieldNames || $[7] !== queryEditor || $[8] !== schema) {\n    t6 = () => {\n      if (!queryEditor) {\n        return;\n      }\n      const query = queryEditor.getValue();\n      const {\n        insertions,\n        result\n      } = (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.fillLeafs)(schema, query, getDefaultFieldNames);\n      if (insertions && insertions.length > 0) {\n        queryEditor.operation(() => {\n          const cursor = queryEditor.getCursor();\n          const cursorIndex = queryEditor.indexFromPos(cursor);\n          queryEditor.setValue(result || \"\");\n          let added;\n          added = 0;\n          const markers = insertions.map((t7) => {\n            const {\n              index,\n              string\n            } = t7;\n            added = added + string.length;\n            return queryEditor.markText(queryEditor.posFromIndex(index + added), queryEditor.posFromIndex(index + added), {\n              className: \"auto-inserted-leaf\",\n              clearOnEnter: true,\n              title: \"Automatically added leaf fields\"\n            });\n          });\n          setTimeout(() => {\n            for (const marker of markers) {\n              marker.clear();\n            }\n          }, 7e3);\n          let newCursorIndex = cursorIndex;\n          for (const {\n            index: index_0,\n            string: string_0\n          } of insertions) {\n            if (index_0 < cursorIndex) {\n              newCursorIndex = newCursorIndex + string_0.length;\n            }\n          }\n          queryEditor.setCursor(queryEditor.posFromIndex(newCursorIndex));\n        });\n      }\n      return result;\n    };\n    $[6] = getDefaultFieldNames;\n    $[7] = queryEditor;\n    $[8] = schema;\n    $[9] = t6;\n  } else {\n    t6 = $[9];\n  }\n  return t6;\n}\nconst useEditorState = (editor) => {\n  \"use no memo\";\n  const context = useEditorContext({\n    nonNull: true\n  });\n  const editorInstance = context[`${editor}Editor`];\n  let valueString = \"\";\n  const editorValue = (editorInstance == null ? void 0 : editorInstance.getValue()) ?? false;\n  if (editorValue && editorValue.length > 0) {\n    valueString = editorValue;\n  }\n  const handleEditorValue = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((value) => editorInstance == null ? void 0 : editorInstance.setValue(value), [editorInstance]);\n  return (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [valueString, handleEditorValue], [valueString, handleEditorValue]);\n};\nconst useOperationsEditorState = () => {\n  return useEditorState(\"query\");\n};\nconst useVariablesEditorState = () => {\n  return useEditorState(\"variable\");\n};\nconst useHeadersEditorState = () => {\n  return useEditorState(\"header\");\n};\nfunction useOptimisticState(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(12);\n  const [upstreamState, upstreamSetState] = t0;\n  let t1;\n  if ($[0] !== upstreamState) {\n    t1 = {\n      pending: null,\n      last: upstreamState\n    };\n    $[0] = upstreamState;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const lastStateRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(t1);\n  const [state, setOperationsText] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(upstreamState);\n  let t2;\n  let t3;\n  if ($[2] !== state || $[3] !== upstreamSetState || $[4] !== upstreamState) {\n    t2 = () => {\n      if (lastStateRef.current.last === upstreamState) ;\n      else {\n        lastStateRef.current.last = upstreamState;\n        if (lastStateRef.current.pending === null) {\n          setOperationsText(upstreamState);\n        } else {\n          if (lastStateRef.current.pending === upstreamState) {\n            lastStateRef.current.pending = null;\n            if (upstreamState !== state) {\n              lastStateRef.current.pending = state;\n              upstreamSetState(state);\n            }\n          } else {\n            lastStateRef.current.pending = null;\n            setOperationsText(upstreamState);\n          }\n        }\n      }\n    };\n    t3 = [upstreamState, state, upstreamSetState];\n    $[2] = state;\n    $[3] = upstreamSetState;\n    $[4] = upstreamState;\n    $[5] = t2;\n    $[6] = t3;\n  } else {\n    t2 = $[5];\n    t3 = $[6];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t2, t3);\n  let t4;\n  if ($[7] !== upstreamSetState) {\n    t4 = (newState) => {\n      setOperationsText(newState);\n      if (lastStateRef.current.pending === null && lastStateRef.current.last !== newState) {\n        lastStateRef.current.pending = newState;\n        upstreamSetState(newState);\n      }\n    };\n    $[7] = upstreamSetState;\n    $[8] = t4;\n  } else {\n    t4 = $[8];\n  }\n  const setState = t4;\n  let t5;\n  if ($[9] !== setState || $[10] !== state) {\n    t5 = [state, setState];\n    $[9] = setState;\n    $[10] = state;\n    $[11] = t5;\n  } else {\n    t5 = $[11];\n  }\n  return t5;\n}\nfunction importCodeMirrorImports$3() {\n  return importCodeMirror([\n    // @ts-expect-error\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/mode/javascript/javascript.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/mode/javascript/javascript.js\", 19))\n  ]);\n}\nconst _useHeaderEditor = useHeaderEditor;\nfunction useHeaderEditor(t0, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(17);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    editorTheme: t2,\n    keyMap: t3,\n    onEdit,\n    readOnly: t4\n  } = t1;\n  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;\n  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;\n  const readOnly = t4 === void 0 ? false : t4;\n  const t5 = caller || _useHeaderEditor;\n  let t6;\n  if ($[2] !== t5) {\n    t6 = {\n      nonNull: true,\n      caller: t5\n    };\n    $[2] = t5;\n    $[3] = t6;\n  } else {\n    t6 = $[3];\n  }\n  const {\n    initialHeaders,\n    headerEditor,\n    setHeaderEditor,\n    shouldPersistHeaders\n  } = useEditorContext(t6);\n  const executionContext = useExecutionContext();\n  const t7 = caller || _useHeaderEditor;\n  let t8;\n  if ($[4] !== t7) {\n    t8 = {\n      caller: t7\n    };\n    $[4] = t7;\n    $[5] = t8;\n  } else {\n    t8 = $[5];\n  }\n  const merge = useMergeQuery(t8);\n  const t9 = caller || _useHeaderEditor;\n  let t10;\n  if ($[6] !== t9) {\n    t10 = {\n      caller: t9\n    };\n    $[6] = t9;\n    $[7] = t10;\n  } else {\n    t10 = $[7];\n  }\n  const prettify = usePrettifyEditors(t10);\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  let t11;\n  let t12;\n  if ($[8] !== editorTheme || $[9] !== initialHeaders || $[10] !== readOnly || $[11] !== setHeaderEditor) {\n    t11 = () => {\n      let isActive;\n      isActive = true;\n      importCodeMirrorImports$3().then((CodeMirror) => {\n        if (!isActive) {\n          return;\n        }\n        const container = ref.current;\n        if (!container) {\n          return;\n        }\n        const newEditor = CodeMirror(container, {\n          value: initialHeaders,\n          lineNumbers: true,\n          tabSize: 2,\n          mode: {\n            name: \"javascript\",\n            json: true\n          },\n          theme: editorTheme,\n          autoCloseBrackets: true,\n          matchBrackets: true,\n          showCursorWhenSelecting: true,\n          readOnly: readOnly ? \"nocursor\" : false,\n          foldGutter: true,\n          gutters: [\"CodeMirror-linenumbers\", \"CodeMirror-foldgutter\"],\n          extraKeys: commonKeys\n        });\n        newEditor.addKeyMap({\n          \"Cmd-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Ctrl-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Alt-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Shift-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          }\n        });\n        newEditor.on(\"keyup\", _temp$2);\n        setHeaderEditor(newEditor);\n      });\n      return () => {\n        isActive = false;\n      };\n    };\n    t12 = [editorTheme, initialHeaders, readOnly, setHeaderEditor];\n    $[8] = editorTheme;\n    $[9] = initialHeaders;\n    $[10] = readOnly;\n    $[11] = setHeaderEditor;\n    $[12] = t11;\n    $[13] = t12;\n  } else {\n    t11 = $[12];\n    t12 = $[13];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t11, t12);\n  useSynchronizeOption(headerEditor, \"keyMap\", keyMap);\n  useChangeHandler(headerEditor, onEdit, shouldPersistHeaders ? STORAGE_KEY$3 : null, \"headers\", _useHeaderEditor);\n  let t13;\n  if ($[14] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t13 = [\"Cmd-Enter\", \"Ctrl-Enter\"];\n    $[14] = t13;\n  } else {\n    t13 = $[14];\n  }\n  useKeyMap(headerEditor, t13, executionContext == null ? void 0 : executionContext.run);\n  let t14;\n  if ($[15] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t14 = [\"Shift-Ctrl-P\"];\n    $[15] = t14;\n  } else {\n    t14 = $[15];\n  }\n  useKeyMap(headerEditor, t14, prettify);\n  let t15;\n  if ($[16] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t15 = [\"Shift-Ctrl-M\"];\n    $[16] = t15;\n  } else {\n    t15 = $[16];\n  }\n  useKeyMap(headerEditor, t15, merge);\n  return ref;\n}\nfunction _temp$2(editorInstance, event) {\n  const {\n    code,\n    key,\n    shiftKey\n  } = event;\n  const isLetter = code.startsWith(\"Key\");\n  const isNumber = !shiftKey && code.startsWith(\"Digit\");\n  if (isLetter || isNumber || key === \"_\" || key === '\"') {\n    editorInstance.execCommand(\"autocomplete\");\n  }\n}\nconst STORAGE_KEY$3 = \"headers\";\nconst invalidCharacters = Array.from({\n  length: 11\n}, (_, i) => {\n  return String.fromCharCode(8192 + i);\n}).concat([\"\\u2028\", \"\\u2029\", \" \", \" \"]);\nconst sanitizeRegex = new RegExp(\"[\" + invalidCharacters.join(\"\") + \"]\", \"g\");\nfunction normalizeWhitespace(line) {\n  return line.replace(sanitizeRegex, \" \");\n}\nfunction importCodeMirrorImports$2() {\n  return importCodeMirror([Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/comment/comment.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/comment/comment.js\", 19)), Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/search.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/search.js\", 19)), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/hint.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/hint.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/lint.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/lint.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/info.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/info.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/jump.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/jump.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/mode.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/mode.js\"))]);\n}\nconst _useQueryEditor = useQueryEditor;\nfunction updateVariableEditor(variableEditor, operationFacts) {\n  variableEditor.state.lint.linterOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;\n  variableEditor.options.lint.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;\n  variableEditor.options.hintOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;\n}\nfunction updateEditorSchema(editor, schema) {\n  editor.state.lint.linterOptions.schema = schema;\n  editor.options.lint.schema = schema;\n  editor.options.hintOptions.schema = schema;\n  editor.options.info.schema = schema;\n  editor.options.jump.schema = schema;\n}\nfunction updateEditorValidationRules(editor, validationRules) {\n  editor.state.lint.linterOptions.validationRules = validationRules;\n  editor.options.lint.validationRules = validationRules;\n}\nfunction updateEditorExternalFragments(editor, externalFragmentList) {\n  editor.state.lint.linterOptions.externalFragments = externalFragmentList;\n  editor.options.lint.externalFragments = externalFragmentList;\n  editor.options.hintOptions.externalFragments = externalFragmentList;\n}\nfunction useQueryEditor(t0, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(41);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    editorTheme: t2,\n    keyMap: t3,\n    onClickReference,\n    onCopyQuery,\n    onEdit,\n    readOnly: t4\n  } = t1;\n  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;\n  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;\n  const readOnly = t4 === void 0 ? false : t4;\n  const t5 = caller || _useQueryEditor;\n  let t6;\n  if ($[2] !== t5) {\n    t6 = {\n      nonNull: true,\n      caller: t5\n    };\n    $[2] = t5;\n    $[3] = t6;\n  } else {\n    t6 = $[3];\n  }\n  const {\n    schema\n  } = useSchemaContext(t6);\n  const t7 = caller || _useQueryEditor;\n  let t8;\n  if ($[4] !== t7) {\n    t8 = {\n      nonNull: true,\n      caller: t7\n    };\n    $[4] = t7;\n    $[5] = t8;\n  } else {\n    t8 = $[5];\n  }\n  const {\n    externalFragments,\n    initialQuery,\n    queryEditor,\n    setOperationName,\n    setQueryEditor,\n    validationRules,\n    variableEditor,\n    updateActiveTabValues\n  } = useEditorContext(t8);\n  const executionContext = useExecutionContext();\n  const storage = useStorageContext();\n  const explorer = useExplorerContext();\n  const plugin = usePluginContext();\n  const t9 = caller || _useQueryEditor;\n  let t10;\n  if ($[6] !== onCopyQuery || $[7] !== t9) {\n    t10 = {\n      caller: t9,\n      onCopyQuery\n    };\n    $[6] = onCopyQuery;\n    $[7] = t9;\n    $[8] = t10;\n  } else {\n    t10 = $[8];\n  }\n  const copy = useCopyQuery(t10);\n  const t11 = caller || _useQueryEditor;\n  let t12;\n  if ($[9] !== t11) {\n    t12 = {\n      caller: t11\n    };\n    $[9] = t11;\n    $[10] = t12;\n  } else {\n    t12 = $[10];\n  }\n  const merge = useMergeQuery(t12);\n  const t13 = caller || _useQueryEditor;\n  let t14;\n  if ($[11] !== t13) {\n    t14 = {\n      caller: t13\n    };\n    $[11] = t13;\n    $[12] = t14;\n  } else {\n    t14 = $[12];\n  }\n  const prettify = usePrettifyEditors(t14);\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const codeMirrorRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)();\n  const onClickReferenceRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(_temp$1);\n  let t15;\n  let t16;\n  if ($[13] !== explorer || $[14] !== onClickReference || $[15] !== plugin) {\n    t15 = () => {\n      onClickReferenceRef.current = (reference) => {\n        if (!explorer || !plugin) {\n          return;\n        }\n        plugin.setVisiblePlugin(DOC_EXPLORER_PLUGIN);\n        bb47: switch (reference.kind) {\n          case \"Type\": {\n            explorer.push({\n              name: reference.type.name,\n              def: reference.type\n            });\n            break bb47;\n          }\n          case \"Field\": {\n            explorer.push({\n              name: reference.field.name,\n              def: reference.field\n            });\n            break bb47;\n          }\n          case \"Argument\": {\n            if (reference.field) {\n              explorer.push({\n                name: reference.field.name,\n                def: reference.field\n              });\n            }\n            break bb47;\n          }\n          case \"EnumValue\": {\n            if (reference.type) {\n              explorer.push({\n                name: reference.type.name,\n                def: reference.type\n              });\n            }\n          }\n        }\n        onClickReference == null ? void 0 : onClickReference(reference);\n      };\n    };\n    t16 = [explorer, onClickReference, plugin];\n    $[13] = explorer;\n    $[14] = onClickReference;\n    $[15] = plugin;\n    $[16] = t15;\n    $[17] = t16;\n  } else {\n    t15 = $[16];\n    t16 = $[17];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t15, t16);\n  let t17;\n  let t18;\n  if ($[18] !== editorTheme || $[19] !== initialQuery || $[20] !== readOnly || $[21] !== setQueryEditor) {\n    t17 = () => {\n      let isActive;\n      isActive = true;\n      importCodeMirrorImports$2().then((CodeMirror) => {\n        if (!isActive) {\n          return;\n        }\n        codeMirrorRef.current = CodeMirror;\n        const container = ref.current;\n        if (!container) {\n          return;\n        }\n        const newEditor = CodeMirror(container, {\n          value: initialQuery,\n          lineNumbers: true,\n          tabSize: 2,\n          foldGutter: true,\n          mode: \"graphql\",\n          theme: editorTheme,\n          autoCloseBrackets: true,\n          matchBrackets: true,\n          showCursorWhenSelecting: true,\n          readOnly: readOnly ? \"nocursor\" : false,\n          lint: {\n            schema: void 0,\n            validationRules: null,\n            externalFragments: void 0\n          },\n          hintOptions: {\n            schema: void 0,\n            closeOnUnfocus: false,\n            completeSingle: false,\n            container,\n            externalFragments: void 0,\n            autocompleteOptions: {\n              mode: graphql_language_service__WEBPACK_IMPORTED_MODULE_14__.GraphQLDocumentMode.EXECUTABLE\n            }\n          },\n          info: {\n            schema: void 0,\n            renderDescription: _temp2,\n            onClick(reference_0) {\n              onClickReferenceRef.current(reference_0);\n            }\n          },\n          jump: {\n            schema: void 0,\n            onClick(reference_1) {\n              onClickReferenceRef.current(reference_1);\n            }\n          },\n          gutters: [\"CodeMirror-linenumbers\", \"CodeMirror-foldgutter\"],\n          extraKeys: {\n            ...commonKeys,\n            \"Cmd-S\"() {\n            },\n            \"Ctrl-S\"() {\n            }\n          }\n        });\n        newEditor.addKeyMap({\n          \"Cmd-Space\"() {\n            newEditor.showHint({\n              completeSingle: true,\n              container\n            });\n          },\n          \"Ctrl-Space\"() {\n            newEditor.showHint({\n              completeSingle: true,\n              container\n            });\n          },\n          \"Alt-Space\"() {\n            newEditor.showHint({\n              completeSingle: true,\n              container\n            });\n          },\n          \"Shift-Space\"() {\n            newEditor.showHint({\n              completeSingle: true,\n              container\n            });\n          },\n          \"Shift-Alt-Space\"() {\n            newEditor.showHint({\n              completeSingle: true,\n              container\n            });\n          }\n        });\n        newEditor.on(\"keyup\", _temp3);\n        let showingHints;\n        showingHints = false;\n        newEditor.on(\"startCompletion\", () => {\n          showingHints = true;\n        });\n        newEditor.on(\"endCompletion\", () => {\n          showingHints = false;\n        });\n        newEditor.on(\"keydown\", (editorInstance_0, event_0) => {\n          if (event_0.key === \"Escape\" && showingHints) {\n            event_0.stopPropagation();\n          }\n        });\n        newEditor.on(\"beforeChange\", _temp4);\n        newEditor.documentAST = null;\n        newEditor.operationName = null;\n        newEditor.operations = null;\n        newEditor.variableToType = null;\n        setQueryEditor(newEditor);\n      });\n      return () => {\n        isActive = false;\n      };\n    };\n    t18 = [editorTheme, initialQuery, readOnly, setQueryEditor];\n    $[18] = editorTheme;\n    $[19] = initialQuery;\n    $[20] = readOnly;\n    $[21] = setQueryEditor;\n    $[22] = t17;\n    $[23] = t18;\n  } else {\n    t17 = $[22];\n    t18 = $[23];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t17, t18);\n  useSynchronizeOption(queryEditor, \"keyMap\", keyMap);\n  let t19;\n  let t20;\n  if ($[24] !== onEdit || $[25] !== queryEditor || $[26] !== schema || $[27] !== setOperationName || $[28] !== storage || $[29] !== updateActiveTabValues || $[30] !== variableEditor) {\n    t19 = () => {\n      if (!queryEditor) {\n        return;\n      }\n      const getAndUpdateOperationFacts = function getAndUpdateOperationFacts2(editorInstance_2) {\n        var _a;\n        const operationFacts = (0,graphql_language_service__WEBPACK_IMPORTED_MODULE_14__.getOperationFacts)(schema, editorInstance_2.getValue());\n        const operationName = (0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.getSelectedOperationName)(editorInstance_2.operations ?? void 0, editorInstance_2.operationName ?? void 0, operationFacts == null ? void 0 : operationFacts.operations);\n        editorInstance_2.documentAST = (operationFacts == null ? void 0 : operationFacts.documentAST) ?? null;\n        editorInstance_2.operationName = operationName ?? null;\n        editorInstance_2.operations = (operationFacts == null ? void 0 : operationFacts.operations) ?? null;\n        if (variableEditor) {\n          updateVariableEditor(variableEditor, operationFacts);\n          (_a = codeMirrorRef.current) == null ? void 0 : _a.signal(variableEditor, \"change\", variableEditor);\n        }\n        return operationFacts ? {\n          ...operationFacts,\n          operationName\n        } : null;\n      };\n      const handleChange = debounce(100, (editorInstance_3) => {\n        const query = editorInstance_3.getValue();\n        storage == null ? void 0 : storage.set(STORAGE_KEY_QUERY, query);\n        const currentOperationName = editorInstance_3.operationName;\n        const operationFacts_0 = getAndUpdateOperationFacts(editorInstance_3);\n        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) !== void 0) {\n          storage == null ? void 0 : storage.set(STORAGE_KEY_OPERATION_NAME, operationFacts_0.operationName);\n        }\n        onEdit == null ? void 0 : onEdit(query, operationFacts_0 == null ? void 0 : operationFacts_0.documentAST);\n        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) && currentOperationName !== operationFacts_0.operationName) {\n          setOperationName(operationFacts_0.operationName);\n        }\n        updateActiveTabValues({\n          query,\n          operationName: (operationFacts_0 == null ? void 0 : operationFacts_0.operationName) ?? null\n        });\n      });\n      getAndUpdateOperationFacts(queryEditor);\n      queryEditor.on(\"change\", handleChange);\n      return () => queryEditor.off(\"change\", handleChange);\n    };\n    t20 = [onEdit, queryEditor, schema, setOperationName, storage, variableEditor, updateActiveTabValues];\n    $[24] = onEdit;\n    $[25] = queryEditor;\n    $[26] = schema;\n    $[27] = setOperationName;\n    $[28] = storage;\n    $[29] = updateActiveTabValues;\n    $[30] = variableEditor;\n    $[31] = t19;\n    $[32] = t20;\n  } else {\n    t19 = $[31];\n    t20 = $[32];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t19, t20);\n  useSynchronizeSchema(queryEditor, schema ?? null, codeMirrorRef);\n  useSynchronizeValidationRules(queryEditor, validationRules ?? null, codeMirrorRef);\n  useSynchronizeExternalFragments(queryEditor, externalFragments, codeMirrorRef);\n  useCompletion(queryEditor, onClickReference || null, _useQueryEditor);\n  const run = executionContext == null ? void 0 : executionContext.run;\n  let t21;\n  if ($[33] !== queryEditor || $[34] !== run || $[35] !== setOperationName) {\n    t21 = () => {\n      var _a;\n      if (!run || !queryEditor || !queryEditor.operations || !queryEditor.hasFocus()) {\n        run == null ? void 0 : run();\n        return;\n      }\n      const cursorIndex = queryEditor.indexFromPos(queryEditor.getCursor());\n      let operationName_0;\n      for (const operation of queryEditor.operations) {\n        if (operation.loc && operation.loc.start <= cursorIndex && operation.loc.end >= cursorIndex) {\n          operationName_0 = (_a = operation.name) == null ? void 0 : _a.value;\n        }\n      }\n      if (operationName_0 && operationName_0 !== queryEditor.operationName) {\n        setOperationName(operationName_0);\n      }\n      run();\n    };\n    $[33] = queryEditor;\n    $[34] = run;\n    $[35] = setOperationName;\n    $[36] = t21;\n  } else {\n    t21 = $[36];\n  }\n  const runAtCursor = t21;\n  let t22;\n  if ($[37] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t22 = [\"Cmd-Enter\", \"Ctrl-Enter\"];\n    $[37] = t22;\n  } else {\n    t22 = $[37];\n  }\n  useKeyMap(queryEditor, t22, runAtCursor);\n  let t23;\n  if ($[38] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t23 = [\"Shift-Ctrl-C\"];\n    $[38] = t23;\n  } else {\n    t23 = $[38];\n  }\n  useKeyMap(queryEditor, t23, copy);\n  let t24;\n  if ($[39] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t24 = [\"Shift-Ctrl-P\", \"Shift-Ctrl-F\"];\n    $[39] = t24;\n  } else {\n    t24 = $[39];\n  }\n  useKeyMap(queryEditor, t24, prettify);\n  let t25;\n  if ($[40] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t25 = [\"Shift-Ctrl-M\"];\n    $[40] = t25;\n  } else {\n    t25 = $[40];\n  }\n  useKeyMap(queryEditor, t25, merge);\n  return ref;\n}\nfunction _temp4(editorInstance_1, change) {\n  var _a;\n  if (change.origin === \"paste\") {\n    const text_0 = change.text.map(normalizeWhitespace);\n    (_a = change.update) == null ? void 0 : _a.call(change, change.from, change.to, text_0);\n  }\n}\nfunction _temp3(editorInstance, event) {\n  if (AUTO_COMPLETE_AFTER_KEY.test(event.key)) {\n    editorInstance.execCommand(\"autocomplete\");\n  }\n}\nfunction _temp2(text) {\n  return markdown.render(text);\n}\nfunction _temp$1() {\n}\nfunction useSynchronizeSchema(editor, schema, codeMirrorRef) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(5);\n  let t0;\n  let t1;\n  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== schema) {\n    t0 = () => {\n      if (!editor) {\n        return;\n      }\n      const didChange = editor.options.lint.schema !== schema;\n      updateEditorSchema(editor, schema);\n      if (didChange && codeMirrorRef.current) {\n        codeMirrorRef.current.signal(editor, \"change\", editor);\n      }\n    };\n    t1 = [editor, schema, codeMirrorRef];\n    $[0] = codeMirrorRef;\n    $[1] = editor;\n    $[2] = schema;\n    $[3] = t0;\n    $[4] = t1;\n  } else {\n    t0 = $[3];\n    t1 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t0, t1);\n}\nfunction useSynchronizeValidationRules(editor, validationRules, codeMirrorRef) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(5);\n  let t0;\n  let t1;\n  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== validationRules) {\n    t0 = () => {\n      if (!editor) {\n        return;\n      }\n      const didChange = editor.options.lint.validationRules !== validationRules;\n      updateEditorValidationRules(editor, validationRules);\n      if (didChange && codeMirrorRef.current) {\n        codeMirrorRef.current.signal(editor, \"change\", editor);\n      }\n    };\n    t1 = [editor, validationRules, codeMirrorRef];\n    $[0] = codeMirrorRef;\n    $[1] = editor;\n    $[2] = validationRules;\n    $[3] = t0;\n    $[4] = t1;\n  } else {\n    t0 = $[3];\n    t1 = $[4];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t0, t1);\n}\nfunction useSynchronizeExternalFragments(editor, externalFragments, codeMirrorRef) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(7);\n  let t0;\n  if ($[0] !== externalFragments) {\n    t0 = [...externalFragments.values()];\n    $[0] = externalFragments;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  const externalFragmentList = t0;\n  let t1;\n  let t2;\n  if ($[2] !== codeMirrorRef || $[3] !== editor || $[4] !== externalFragmentList) {\n    t1 = () => {\n      if (!editor) {\n        return;\n      }\n      const didChange = editor.options.lint.externalFragments !== externalFragmentList;\n      updateEditorExternalFragments(editor, externalFragmentList);\n      if (didChange && codeMirrorRef.current) {\n        codeMirrorRef.current.signal(editor, \"change\", editor);\n      }\n    };\n    t2 = [editor, externalFragmentList, codeMirrorRef];\n    $[2] = codeMirrorRef;\n    $[3] = editor;\n    $[4] = externalFragmentList;\n    $[5] = t1;\n    $[6] = t2;\n  } else {\n    t1 = $[5];\n    t2 = $[6];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n}\nconst AUTO_COMPLETE_AFTER_KEY = /^[a-zA-Z0-9_@(]$/;\nconst STORAGE_KEY_QUERY = \"query\";\nconst STORAGE_KEY_OPERATION_NAME = \"operationName\";\nfunction getDefaultTabState({\n  defaultQuery,\n  defaultHeaders,\n  headers,\n  defaultTabs,\n  query,\n  variables,\n  storage,\n  shouldPersistHeaders\n}) {\n  const storedState = storage == null ? void 0 : storage.get(STORAGE_KEY$2);\n  try {\n    if (!storedState) {\n      throw new Error(\"Storage for tabs is empty\");\n    }\n    const parsed = JSON.parse(storedState);\n    const headersForHash = shouldPersistHeaders ? headers : void 0;\n    if (isTabsState(parsed)) {\n      const expectedHash = hashFromTabContents({\n        query,\n        variables,\n        headers: headersForHash\n      });\n      let matchingTabIndex = -1;\n      for (let index = 0; index < parsed.tabs.length; index++) {\n        const tab = parsed.tabs[index];\n        tab.hash = hashFromTabContents({\n          query: tab.query,\n          variables: tab.variables,\n          headers: tab.headers\n        });\n        if (tab.hash === expectedHash) {\n          matchingTabIndex = index;\n        }\n      }\n      if (matchingTabIndex >= 0) {\n        parsed.activeTabIndex = matchingTabIndex;\n      } else {\n        const operationName = query ? fuzzyExtractOperationName(query) : null;\n        parsed.tabs.push({\n          id: guid(),\n          hash: expectedHash,\n          title: operationName || DEFAULT_TITLE,\n          query,\n          variables,\n          headers,\n          operationName,\n          response: null\n        });\n        parsed.activeTabIndex = parsed.tabs.length - 1;\n      }\n      return parsed;\n    }\n    throw new Error(\"Storage for tabs is invalid\");\n  } catch {\n    return {\n      activeTabIndex: 0,\n      tabs: (defaultTabs || [{\n        query: query ?? defaultQuery,\n        variables,\n        headers: headers ?? defaultHeaders\n      }]).map(createTab)\n    };\n  }\n}\nfunction isTabsState(obj) {\n  return obj && typeof obj === \"object\" && !Array.isArray(obj) && hasNumberKey(obj, \"activeTabIndex\") && \"tabs\" in obj && Array.isArray(obj.tabs) && obj.tabs.every(isTabState);\n}\nfunction isTabState(obj) {\n  return obj && typeof obj === \"object\" && !Array.isArray(obj) && hasStringKey(obj, \"id\") && hasStringKey(obj, \"title\") && hasStringOrNullKey(obj, \"query\") && hasStringOrNullKey(obj, \"variables\") && hasStringOrNullKey(obj, \"headers\") && hasStringOrNullKey(obj, \"operationName\") && hasStringOrNullKey(obj, \"response\");\n}\nfunction hasNumberKey(obj, key) {\n  return key in obj && typeof obj[key] === \"number\";\n}\nfunction hasStringKey(obj, key) {\n  return key in obj && typeof obj[key] === \"string\";\n}\nfunction hasStringOrNullKey(obj, key) {\n  return key in obj && (typeof obj[key] === \"string\" || obj[key] === null);\n}\nfunction useSynchronizeActiveTabValues({\n  queryEditor,\n  variableEditor,\n  headerEditor,\n  responseEditor\n}) {\n  return (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((state) => {\n    const query = (queryEditor == null ? void 0 : queryEditor.getValue()) ?? null;\n    const variables = (variableEditor == null ? void 0 : variableEditor.getValue()) ?? null;\n    const headers = (headerEditor == null ? void 0 : headerEditor.getValue()) ?? null;\n    const operationName = (queryEditor == null ? void 0 : queryEditor.operationName) ?? null;\n    const response = (responseEditor == null ? void 0 : responseEditor.getValue()) ?? null;\n    return setPropertiesInActiveTab(state, {\n      query,\n      variables,\n      headers,\n      response,\n      operationName\n    });\n  }, [queryEditor, variableEditor, headerEditor, responseEditor]);\n}\nfunction serializeTabState(tabState, shouldPersistHeaders = false) {\n  return JSON.stringify(tabState, (key, value) => key === \"hash\" || key === \"response\" || !shouldPersistHeaders && key === \"headers\" ? null : value);\n}\nfunction useStoreTabs({\n  storage,\n  shouldPersistHeaders\n}) {\n  const store = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => debounce(500, (value) => {\n    storage == null ? void 0 : storage.set(STORAGE_KEY$2, value);\n  }), [storage]);\n  return (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((currentState) => {\n    store(serializeTabState(currentState, shouldPersistHeaders));\n  }, [shouldPersistHeaders, store]);\n}\nfunction useSetEditorValues({\n  queryEditor,\n  variableEditor,\n  headerEditor,\n  responseEditor,\n  defaultHeaders\n}) {\n  return (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(({\n    query,\n    variables,\n    headers,\n    response\n  }) => {\n    queryEditor == null ? void 0 : queryEditor.setValue(query ?? \"\");\n    variableEditor == null ? void 0 : variableEditor.setValue(variables ?? \"\");\n    headerEditor == null ? void 0 : headerEditor.setValue(headers ?? defaultHeaders ?? \"\");\n    responseEditor == null ? void 0 : responseEditor.setValue(response ?? \"\");\n  }, [headerEditor, queryEditor, responseEditor, variableEditor, defaultHeaders]);\n}\nfunction createTab({\n  query = null,\n  variables = null,\n  headers = null\n} = {}) {\n  return {\n    id: guid(),\n    hash: hashFromTabContents({\n      query,\n      variables,\n      headers\n    }),\n    title: query && fuzzyExtractOperationName(query) || DEFAULT_TITLE,\n    query,\n    variables,\n    headers,\n    operationName: null,\n    response: null\n  };\n}\nfunction setPropertiesInActiveTab(state, partialTab) {\n  return {\n    ...state,\n    tabs: state.tabs.map((tab, index) => {\n      if (index !== state.activeTabIndex) {\n        return tab;\n      }\n      const newTab = {\n        ...tab,\n        ...partialTab\n      };\n      return {\n        ...newTab,\n        hash: hashFromTabContents(newTab),\n        title: newTab.operationName || (newTab.query ? fuzzyExtractOperationName(newTab.query) : void 0) || DEFAULT_TITLE\n      };\n    })\n  };\n}\nfunction guid() {\n  const s4 = () => {\n    return Math.floor((1 + Math.random()) * 65536).toString(16).slice(1);\n  };\n  return `${s4()}${s4()}-${s4()}-${s4()}-${s4()}-${s4()}${s4()}${s4()}`;\n}\nfunction hashFromTabContents(args) {\n  return [args.query ?? \"\", args.variables ?? \"\", args.headers ?? \"\"].join(\"|\");\n}\nfunction fuzzyExtractOperationName(str) {\n  const regex = /^(?!#).*(query|subscription|mutation)\\s+([a-zA-Z0-9_]+)/m;\n  const match = regex.exec(str);\n  return (match == null ? void 0 : match[2]) ?? null;\n}\nfunction clearHeadersFromTabs(storage) {\n  const persistedTabs = storage == null ? void 0 : storage.get(STORAGE_KEY$2);\n  if (persistedTabs) {\n    const parsedTabs = JSON.parse(persistedTabs);\n    storage == null ? void 0 : storage.set(STORAGE_KEY$2, JSON.stringify(parsedTabs, (key, value) => key === \"headers\" ? null : value));\n  }\n}\nconst DEFAULT_TITLE = \"<untitled>\";\nconst STORAGE_KEY$2 = \"tabState\";\nfunction importCodeMirrorImports$1() {\n  return importCodeMirror([Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/variables/hint.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/variables/hint.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/variables/lint.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/variables/lint.js\")), Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/variables/mode.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/variables/mode.js\"))]);\n}\nconst _useVariableEditor = useVariableEditor;\nfunction useVariableEditor(t0, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(17);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    editorTheme: t2,\n    keyMap: t3,\n    onClickReference,\n    onEdit,\n    readOnly: t4\n  } = t1;\n  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;\n  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;\n  const readOnly = t4 === void 0 ? false : t4;\n  const t5 = caller || _useVariableEditor;\n  let t6;\n  if ($[2] !== t5) {\n    t6 = {\n      nonNull: true,\n      caller: t5\n    };\n    $[2] = t5;\n    $[3] = t6;\n  } else {\n    t6 = $[3];\n  }\n  const {\n    initialVariables,\n    variableEditor,\n    setVariableEditor\n  } = useEditorContext(t6);\n  const executionContext = useExecutionContext();\n  const t7 = caller || _useVariableEditor;\n  let t8;\n  if ($[4] !== t7) {\n    t8 = {\n      caller: t7\n    };\n    $[4] = t7;\n    $[5] = t8;\n  } else {\n    t8 = $[5];\n  }\n  const merge = useMergeQuery(t8);\n  const t9 = caller || _useVariableEditor;\n  let t10;\n  if ($[6] !== t9) {\n    t10 = {\n      caller: t9\n    };\n    $[6] = t9;\n    $[7] = t10;\n  } else {\n    t10 = $[7];\n  }\n  const prettify = usePrettifyEditors(t10);\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const codeMirrorRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)();\n  let t11;\n  let t12;\n  if ($[8] !== editorTheme || $[9] !== initialVariables || $[10] !== readOnly || $[11] !== setVariableEditor) {\n    t11 = () => {\n      let isActive;\n      isActive = true;\n      importCodeMirrorImports$1().then((CodeMirror) => {\n        if (!isActive) {\n          return;\n        }\n        codeMirrorRef.current = CodeMirror;\n        const container = ref.current;\n        if (!container) {\n          return;\n        }\n        const newEditor = CodeMirror(container, {\n          value: initialVariables,\n          lineNumbers: true,\n          tabSize: 2,\n          mode: \"graphql-variables\",\n          theme: editorTheme,\n          autoCloseBrackets: true,\n          matchBrackets: true,\n          showCursorWhenSelecting: true,\n          readOnly: readOnly ? \"nocursor\" : false,\n          foldGutter: true,\n          lint: {\n            variableToType: void 0\n          },\n          hintOptions: {\n            closeOnUnfocus: false,\n            completeSingle: false,\n            container,\n            variableToType: void 0\n          },\n          gutters: [\"CodeMirror-linenumbers\", \"CodeMirror-foldgutter\"],\n          extraKeys: commonKeys\n        });\n        newEditor.addKeyMap({\n          \"Cmd-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Ctrl-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Alt-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          },\n          \"Shift-Space\"() {\n            newEditor.showHint({\n              completeSingle: false,\n              container\n            });\n          }\n        });\n        newEditor.on(\"keyup\", _temp);\n        setVariableEditor(newEditor);\n      });\n      return () => {\n        isActive = false;\n      };\n    };\n    t12 = [editorTheme, initialVariables, readOnly, setVariableEditor];\n    $[8] = editorTheme;\n    $[9] = initialVariables;\n    $[10] = readOnly;\n    $[11] = setVariableEditor;\n    $[12] = t11;\n    $[13] = t12;\n  } else {\n    t11 = $[12];\n    t12 = $[13];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t11, t12);\n  useSynchronizeOption(variableEditor, \"keyMap\", keyMap);\n  useChangeHandler(variableEditor, onEdit, STORAGE_KEY$1, \"variables\", _useVariableEditor);\n  useCompletion(variableEditor, onClickReference || null, _useVariableEditor);\n  let t13;\n  if ($[14] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t13 = [\"Cmd-Enter\", \"Ctrl-Enter\"];\n    $[14] = t13;\n  } else {\n    t13 = $[14];\n  }\n  useKeyMap(variableEditor, t13, executionContext == null ? void 0 : executionContext.run);\n  let t14;\n  if ($[15] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t14 = [\"Shift-Ctrl-P\"];\n    $[15] = t14;\n  } else {\n    t14 = $[15];\n  }\n  useKeyMap(variableEditor, t14, prettify);\n  let t15;\n  if ($[16] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t15 = [\"Shift-Ctrl-M\"];\n    $[16] = t15;\n  } else {\n    t15 = $[16];\n  }\n  useKeyMap(variableEditor, t15, merge);\n  return ref;\n}\nfunction _temp(editorInstance, event) {\n  const {\n    code,\n    key,\n    shiftKey\n  } = event;\n  const isLetter = code.startsWith(\"Key\");\n  const isNumber = !shiftKey && code.startsWith(\"Digit\");\n  if (isLetter || isNumber || key === \"_\" || key === '\"') {\n    editorInstance.execCommand(\"autocomplete\");\n  }\n}\nconst STORAGE_KEY$1 = \"variables\";\nconst EditorContext = createNullableContext(\"EditorContext\");\nfunction EditorContextProvider(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(89);\n  const storage = useStorageContext();\n  const [headerEditor, setHeaderEditor] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const [queryEditor, setQueryEditor] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const [responseEditor, setResponseEditor] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const [variableEditor, setVariableEditor] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  let t0;\n  if ($[0] !== props.shouldPersistHeaders || $[1] !== storage) {\n    t0 = () => {\n      const isStored = (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) !== null;\n      return props.shouldPersistHeaders !== false && isStored ? (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) === \"true\" : Boolean(props.shouldPersistHeaders);\n    };\n    $[0] = props.shouldPersistHeaders;\n    $[1] = storage;\n    $[2] = t0;\n  } else {\n    t0 = $[2];\n  }\n  const [shouldPersistHeaders, setShouldPersistHeadersInternal] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t0);\n  useSynchronizeValue(headerEditor, props.headers);\n  useSynchronizeValue(queryEditor, props.query);\n  useSynchronizeValue(responseEditor, props.response);\n  useSynchronizeValue(variableEditor, props.variables);\n  let t1;\n  if ($[3] !== shouldPersistHeaders || $[4] !== storage) {\n    t1 = {\n      storage,\n      shouldPersistHeaders\n    };\n    $[3] = shouldPersistHeaders;\n    $[4] = storage;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  const storeTabs = useStoreTabs(t1);\n  let t2;\n  if ($[6] !== props.defaultHeaders || $[7] !== props.defaultQuery || $[8] !== props.defaultTabs || $[9] !== props.headers || $[10] !== props.query || $[11] !== props.response || $[12] !== props.variables || $[13] !== shouldPersistHeaders || $[14] !== storage || $[15] !== storeTabs) {\n    t2 = () => {\n      const query = props.query ?? (storage == null ? void 0 : storage.get(STORAGE_KEY_QUERY)) ?? null;\n      const variables = props.variables ?? (storage == null ? void 0 : storage.get(STORAGE_KEY$1)) ?? null;\n      const headers = props.headers ?? (storage == null ? void 0 : storage.get(STORAGE_KEY$3)) ?? null;\n      const response = props.response ?? \"\";\n      const tabState = getDefaultTabState({\n        query,\n        variables,\n        headers,\n        defaultTabs: props.defaultTabs,\n        defaultQuery: props.defaultQuery || DEFAULT_QUERY,\n        defaultHeaders: props.defaultHeaders,\n        storage,\n        shouldPersistHeaders\n      });\n      storeTabs(tabState);\n      return {\n        query: query ?? (tabState.activeTabIndex === 0 ? tabState.tabs[0].query : null) ?? \"\",\n        variables: variables ?? \"\",\n        headers: headers ?? props.defaultHeaders ?? \"\",\n        response,\n        tabState\n      };\n    };\n    $[6] = props.defaultHeaders;\n    $[7] = props.defaultQuery;\n    $[8] = props.defaultTabs;\n    $[9] = props.headers;\n    $[10] = props.query;\n    $[11] = props.response;\n    $[12] = props.variables;\n    $[13] = shouldPersistHeaders;\n    $[14] = storage;\n    $[15] = storeTabs;\n    $[16] = t2;\n  } else {\n    t2 = $[16];\n  }\n  const [initialState] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t2);\n  const [tabState_0, setTabState] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(initialState.tabState);\n  let t3;\n  if ($[17] !== headerEditor || $[18] !== storage || $[19] !== tabState_0) {\n    t3 = (persist) => {\n      if (persist) {\n        storage == null ? void 0 : storage.set(STORAGE_KEY$3, (headerEditor == null ? void 0 : headerEditor.getValue()) ?? \"\");\n        const serializedTabs = serializeTabState(tabState_0, true);\n        storage == null ? void 0 : storage.set(STORAGE_KEY$2, serializedTabs);\n      } else {\n        storage == null ? void 0 : storage.set(STORAGE_KEY$3, \"\");\n        clearHeadersFromTabs(storage);\n      }\n      setShouldPersistHeadersInternal(persist);\n      storage == null ? void 0 : storage.set(PERSIST_HEADERS_STORAGE_KEY, persist.toString());\n    };\n    $[17] = headerEditor;\n    $[18] = storage;\n    $[19] = tabState_0;\n    $[20] = t3;\n  } else {\n    t3 = $[20];\n  }\n  const setShouldPersistHeaders = t3;\n  const lastShouldPersistHeadersProp = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)();\n  let t4;\n  let t5;\n  if ($[21] !== props.shouldPersistHeaders || $[22] !== setShouldPersistHeaders) {\n    t4 = () => {\n      const propValue = Boolean(props.shouldPersistHeaders);\n      if ((lastShouldPersistHeadersProp == null ? void 0 : lastShouldPersistHeadersProp.current) !== propValue) {\n        setShouldPersistHeaders(propValue);\n        lastShouldPersistHeadersProp.current = propValue;\n      }\n    };\n    t5 = [props.shouldPersistHeaders, setShouldPersistHeaders];\n    $[21] = props.shouldPersistHeaders;\n    $[22] = setShouldPersistHeaders;\n    $[23] = t4;\n    $[24] = t5;\n  } else {\n    t4 = $[23];\n    t5 = $[24];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t4, t5);\n  let t6;\n  if ($[25] !== headerEditor || $[26] !== queryEditor || $[27] !== responseEditor || $[28] !== variableEditor) {\n    t6 = {\n      queryEditor,\n      variableEditor,\n      headerEditor,\n      responseEditor\n    };\n    $[25] = headerEditor;\n    $[26] = queryEditor;\n    $[27] = responseEditor;\n    $[28] = variableEditor;\n    $[29] = t6;\n  } else {\n    t6 = $[29];\n  }\n  const synchronizeActiveTabValues = useSynchronizeActiveTabValues(t6);\n  const {\n    onTabChange,\n    defaultHeaders,\n    defaultQuery,\n    children\n  } = props;\n  let t7;\n  if ($[30] !== defaultHeaders || $[31] !== headerEditor || $[32] !== queryEditor || $[33] !== responseEditor || $[34] !== variableEditor) {\n    t7 = {\n      queryEditor,\n      variableEditor,\n      headerEditor,\n      responseEditor,\n      defaultHeaders\n    };\n    $[30] = defaultHeaders;\n    $[31] = headerEditor;\n    $[32] = queryEditor;\n    $[33] = responseEditor;\n    $[34] = variableEditor;\n    $[35] = t7;\n  } else {\n    t7 = $[35];\n  }\n  const setEditorValues = useSetEditorValues(t7);\n  let t8;\n  if ($[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== onTabChange || $[39] !== setEditorValues || $[40] !== storeTabs || $[41] !== synchronizeActiveTabValues) {\n    t8 = () => {\n      setTabState((current) => {\n        const updatedValues = synchronizeActiveTabValues(current);\n        const updated = {\n          tabs: [...updatedValues.tabs, createTab({\n            headers: defaultHeaders,\n            query: defaultQuery ?? DEFAULT_QUERY\n          })],\n          activeTabIndex: updatedValues.tabs.length\n        };\n        storeTabs(updated);\n        setEditorValues(updated.tabs[updated.activeTabIndex]);\n        onTabChange == null ? void 0 : onTabChange(updated);\n        return updated;\n      });\n    };\n    $[36] = defaultHeaders;\n    $[37] = defaultQuery;\n    $[38] = onTabChange;\n    $[39] = setEditorValues;\n    $[40] = storeTabs;\n    $[41] = synchronizeActiveTabValues;\n    $[42] = t8;\n  } else {\n    t8 = $[42];\n  }\n  const addTab = t8;\n  let t9;\n  if ($[43] !== onTabChange || $[44] !== setEditorValues || $[45] !== storeTabs) {\n    t9 = (index) => {\n      setTabState((current_0) => {\n        const updated_0 = {\n          ...current_0,\n          activeTabIndex: index\n        };\n        storeTabs(updated_0);\n        setEditorValues(updated_0.tabs[updated_0.activeTabIndex]);\n        onTabChange == null ? void 0 : onTabChange(updated_0);\n        return updated_0;\n      });\n    };\n    $[43] = onTabChange;\n    $[44] = setEditorValues;\n    $[45] = storeTabs;\n    $[46] = t9;\n  } else {\n    t9 = $[46];\n  }\n  const changeTab = t9;\n  let t10;\n  if ($[47] !== onTabChange || $[48] !== setEditorValues || $[49] !== storeTabs) {\n    t10 = (newOrder) => {\n      setTabState((current_1) => {\n        const activeTab = current_1.tabs[current_1.activeTabIndex];\n        const updated_1 = {\n          tabs: newOrder,\n          activeTabIndex: newOrder.indexOf(activeTab)\n        };\n        storeTabs(updated_1);\n        setEditorValues(updated_1.tabs[updated_1.activeTabIndex]);\n        onTabChange == null ? void 0 : onTabChange(updated_1);\n        return updated_1;\n      });\n    };\n    $[47] = onTabChange;\n    $[48] = setEditorValues;\n    $[49] = storeTabs;\n    $[50] = t10;\n  } else {\n    t10 = $[50];\n  }\n  const moveTab = t10;\n  let t11;\n  if ($[51] !== onTabChange || $[52] !== setEditorValues || $[53] !== storeTabs) {\n    t11 = (index_0) => {\n      setTabState((current_2) => {\n        const updated_2 = {\n          tabs: current_2.tabs.filter((_tab, i) => index_0 !== i),\n          activeTabIndex: Math.max(current_2.activeTabIndex - 1, 0)\n        };\n        storeTabs(updated_2);\n        setEditorValues(updated_2.tabs[updated_2.activeTabIndex]);\n        onTabChange == null ? void 0 : onTabChange(updated_2);\n        return updated_2;\n      });\n    };\n    $[51] = onTabChange;\n    $[52] = setEditorValues;\n    $[53] = storeTabs;\n    $[54] = t11;\n  } else {\n    t11 = $[54];\n  }\n  const closeTab = t11;\n  let t12;\n  if ($[55] !== onTabChange || $[56] !== storeTabs) {\n    t12 = (partialTab) => {\n      setTabState((current_3) => {\n        const updated_3 = setPropertiesInActiveTab(current_3, partialTab);\n        storeTabs(updated_3);\n        onTabChange == null ? void 0 : onTabChange(updated_3);\n        return updated_3;\n      });\n    };\n    $[55] = onTabChange;\n    $[56] = storeTabs;\n    $[57] = t12;\n  } else {\n    t12 = $[57];\n  }\n  const updateActiveTabValues = t12;\n  const {\n    onEditOperationName\n  } = props;\n  let t13;\n  if ($[58] !== onEditOperationName || $[59] !== queryEditor || $[60] !== updateActiveTabValues) {\n    t13 = (operationName) => {\n      if (!queryEditor) {\n        return;\n      }\n      updateQueryEditor(queryEditor, operationName);\n      updateActiveTabValues({\n        operationName\n      });\n      onEditOperationName == null ? void 0 : onEditOperationName(operationName);\n    };\n    $[58] = onEditOperationName;\n    $[59] = queryEditor;\n    $[60] = updateActiveTabValues;\n    $[61] = t13;\n  } else {\n    t13 = $[61];\n  }\n  const setOperationName = t13;\n  let t14;\n  let map;\n  if ($[62] !== props.externalFragments) {\n    map = /* @__PURE__ */ new Map();\n    if (Array.isArray(props.externalFragments)) {\n      for (const fragment of props.externalFragments) {\n        map.set(fragment.name.value, fragment);\n      }\n    } else {\n      if (typeof props.externalFragments === \"string\") {\n        (0,graphql__WEBPACK_IMPORTED_MODULE_11__.visit)((0,graphql__WEBPACK_IMPORTED_MODULE_9__.parse)(props.externalFragments, {}), {\n          FragmentDefinition(fragment_0) {\n            map.set(fragment_0.name.value, fragment_0);\n          }\n        });\n      } else {\n        if (props.externalFragments) {\n          throw new Error(\"The `externalFragments` prop must either be a string that contains the fragment definitions in SDL or a list of FragmentDefinitionNode objects.\");\n        }\n      }\n    }\n    $[62] = props.externalFragments;\n    $[63] = map;\n  } else {\n    map = $[63];\n  }\n  t14 = map;\n  const externalFragments = t14;\n  let t15;\n  if ($[64] !== props.validationRules) {\n    t15 = props.validationRules || [];\n    $[64] = props.validationRules;\n    $[65] = t15;\n  } else {\n    t15 = $[65];\n  }\n  const validationRules = t15;\n  let t16;\n  if ($[66] !== addTab || $[67] !== changeTab || $[68] !== closeTab || $[69] !== externalFragments || $[70] !== headerEditor || $[71] !== initialState.headers || $[72] !== initialState.query || $[73] !== initialState.response || $[74] !== initialState.variables || $[75] !== moveTab || $[76] !== queryEditor || $[77] !== responseEditor || $[78] !== setOperationName || $[79] !== setShouldPersistHeaders || $[80] !== shouldPersistHeaders || $[81] !== tabState_0 || $[82] !== updateActiveTabValues || $[83] !== validationRules || $[84] !== variableEditor) {\n    t16 = {\n      ...tabState_0,\n      addTab,\n      changeTab,\n      moveTab,\n      closeTab,\n      updateActiveTabValues,\n      headerEditor,\n      queryEditor,\n      responseEditor,\n      variableEditor,\n      setHeaderEditor,\n      setQueryEditor,\n      setResponseEditor,\n      setVariableEditor,\n      setOperationName,\n      initialQuery: initialState.query,\n      initialVariables: initialState.variables,\n      initialHeaders: initialState.headers,\n      initialResponse: initialState.response,\n      externalFragments,\n      validationRules,\n      shouldPersistHeaders,\n      setShouldPersistHeaders\n    };\n    $[66] = addTab;\n    $[67] = changeTab;\n    $[68] = closeTab;\n    $[69] = externalFragments;\n    $[70] = headerEditor;\n    $[71] = initialState.headers;\n    $[72] = initialState.query;\n    $[73] = initialState.response;\n    $[74] = initialState.variables;\n    $[75] = moveTab;\n    $[76] = queryEditor;\n    $[77] = responseEditor;\n    $[78] = setOperationName;\n    $[79] = setShouldPersistHeaders;\n    $[80] = shouldPersistHeaders;\n    $[81] = tabState_0;\n    $[82] = updateActiveTabValues;\n    $[83] = validationRules;\n    $[84] = variableEditor;\n    $[85] = t16;\n  } else {\n    t16 = $[85];\n  }\n  const value = t16;\n  let t17;\n  if ($[86] !== children || $[87] !== value) {\n    t17 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EditorContext.Provider, { value, children });\n    $[86] = children;\n    $[87] = value;\n    $[88] = t17;\n  } else {\n    t17 = $[88];\n  }\n  return t17;\n}\nfunction updateQueryEditor(queryEditor, operationName) {\n  queryEditor.operationName = operationName;\n}\nconst useEditorContext = createContextHook(EditorContext);\nconst PERSIST_HEADERS_STORAGE_KEY = \"shouldPersistHeaders\";\nconst DEFAULT_QUERY = `# Welcome to GraphiQL\n#\n# GraphiQL is an in-browser tool for writing, validating, and\n# testing GraphQL queries.\n#\n# Type queries into this side of the screen, and you will see intelligent\n# typeaheads aware of the current GraphQL type schema and live syntax and\n# validation errors highlighted within the text.\n#\n# GraphQL queries typically start with a \"{\" character. Lines that start\n# with a # are ignored.\n#\n# An example GraphQL query might look like:\n#\n#     {\n#       field(arg: \"value\") {\n#         subField\n#       }\n#     }\n#\n# Keyboard shortcuts:\n#\n#   Prettify query:  Shift-Ctrl-P (or press the prettify button)\n#\n#  Merge fragments:  Shift-Ctrl-M (or press the merge button)\n#\n#        Run Query:  Ctrl-Enter (or press the play button)\n#\n#    Auto Complete:  Ctrl-Space (or just start typing)\n#\n\n`;\nfunction HeaderEditor(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(13);\n  let hookArgs;\n  let isHidden;\n  if ($[0] !== t0) {\n    ({\n      isHidden,\n      ...hookArgs\n    } = t0);\n    $[0] = t0;\n    $[1] = hookArgs;\n    $[2] = isHidden;\n  } else {\n    hookArgs = $[1];\n    isHidden = $[2];\n  }\n  let t1;\n  if ($[3] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: HeaderEditor\n    };\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  const {\n    headerEditor\n  } = useEditorContext(t1);\n  const ref = useHeaderEditor(hookArgs, HeaderEditor);\n  let t2;\n  let t3;\n  if ($[4] !== headerEditor || $[5] !== isHidden) {\n    t2 = () => {\n      if (!isHidden) {\n        headerEditor == null ? void 0 : headerEditor.refresh();\n      }\n    };\n    t3 = [headerEditor, isHidden];\n    $[4] = headerEditor;\n    $[5] = isHidden;\n    $[6] = t2;\n    $[7] = t3;\n  } else {\n    t2 = $[6];\n    t3 = $[7];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t2, t3);\n  const t4 = isHidden && \"hidden\";\n  let t5;\n  if ($[8] !== t4) {\n    t5 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-editor\", t4);\n    $[8] = t4;\n    $[9] = t5;\n  } else {\n    t5 = $[9];\n  }\n  let t6;\n  if ($[10] !== ref || $[11] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: t5, ref });\n    $[10] = ref;\n    $[11] = t5;\n    $[12] = t6;\n  } else {\n    t6 = $[12];\n  }\n  return t6;\n}\nfunction ImagePreview(props) {\n  var _a;\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(14);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      width: null,\n      height: null\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const [dimensions, setDimensions] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t0);\n  const [mime, setMime] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const src = (_a = tokenToURL(props.token)) == null ? void 0 : _a.href;\n  let t1;\n  let t2;\n  if ($[1] !== src) {\n    t1 = () => {\n      if (!ref.current) {\n        return;\n      }\n      if (!src) {\n        setDimensions({\n          width: null,\n          height: null\n        });\n        setMime(null);\n        return;\n      }\n      fetch(src, {\n        method: \"HEAD\"\n      }).then((response) => {\n        setMime(response.headers.get(\"Content-Type\"));\n      }).catch(() => {\n        setMime(null);\n      });\n    };\n    t2 = [src];\n    $[1] = src;\n    $[2] = t1;\n    $[3] = t2;\n  } else {\n    t1 = $[2];\n    t2 = $[3];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t1, t2);\n  let t3;\n  if ($[4] !== dimensions.height || $[5] !== dimensions.width || $[6] !== mime) {\n    t3 = dimensions.width !== null && dimensions.height !== null ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n      dimensions.width,\n      \"x\",\n      dimensions.height,\n      mime === null ? null : \" \" + mime\n    ] }) : null;\n    $[4] = dimensions.height;\n    $[5] = dimensions.width;\n    $[6] = mime;\n    $[7] = t3;\n  } else {\n    t3 = $[7];\n  }\n  const dims = t3;\n  let t4;\n  if ($[8] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t4 = () => {\n      var _a2, _b;\n      setDimensions({\n        width: ((_a2 = ref.current) == null ? void 0 : _a2.naturalWidth) ?? null,\n        height: ((_b = ref.current) == null ? void 0 : _b.naturalHeight) ?? null\n      });\n    };\n    $[8] = t4;\n  } else {\n    t4 = $[8];\n  }\n  let t5;\n  if ($[9] !== src) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { onLoad: t4, ref, src });\n    $[9] = src;\n    $[10] = t5;\n  } else {\n    t5 = $[10];\n  }\n  let t6;\n  if ($[11] !== dims || $[12] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [\n      t5,\n      dims\n    ] });\n    $[11] = dims;\n    $[12] = t5;\n    $[13] = t6;\n  } else {\n    t6 = $[13];\n  }\n  return t6;\n}\nImagePreview.shouldRender = function shouldRender(token) {\n  const url = tokenToURL(token);\n  return url ? isImageURL(url) : false;\n};\nfunction tokenToURL(token) {\n  if (token.type !== \"string\") {\n    return;\n  }\n  const value = token.string.slice(1).slice(0, -1).trim();\n  try {\n    const {\n      location\n    } = window;\n    return new URL(value, location.protocol + \"//\" + location.host);\n  } catch {\n    return;\n  }\n}\nfunction isImageURL(url) {\n  return /\\.(bmp|gif|jpe?g|png|svg|webp)$/.test(url.pathname);\n}\nfunction QueryEditor(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n  const ref = useQueryEditor(props, QueryEditor);\n  let t0;\n  if ($[0] !== ref) {\n    t0 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"graphiql-editor\", ref });\n    $[0] = ref;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  return t0;\n}\nfunction importCodeMirrorImports() {\n  return importCodeMirror([\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/fold/foldgutter.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/fold/foldgutter.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/fold/brace-fold.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/fold/brace-fold.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/dialog/dialog.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/dialog/dialog.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/search.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/search.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/searchcursor.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/searchcursor.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/addon/search/jump-to-line.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/addon/search/jump-to-line.js\", 19)),\n    // @ts-expect-error\n    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! codemirror/keymap/sublime.js */ \"../../../node_modules/.pnpm/codemirror@5.65.19/node_modules/codemirror/keymap/sublime.js\", 19)),\n    Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/results/mode.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/results/mode.js\")),\n    Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! codemirror-graphql/esm/utils/info-addon.js */ \"../../../node_modules/.pnpm/codemirror-graphql@2.2.2_@codemirror+language@6.11.3_codemirror@5.65.19_graphql@16.11.0/node_modules/codemirror-graphql/esm/utils/info-addon.js\"))\n  ], {\n    useCommonAddons: false\n  });\n}\nconst _useResponseEditor = useResponseEditor;\nfunction useResponseEditor(t0, caller) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(19);\n  let t1;\n  if ($[0] !== t0) {\n    t1 = t0 === void 0 ? {} : t0;\n    $[0] = t0;\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    responseTooltip,\n    editorTheme: t2,\n    keyMap: t3\n  } = t1;\n  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;\n  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;\n  const t4 = caller || _useResponseEditor;\n  let t5;\n  if ($[2] !== t4) {\n    t5 = {\n      nonNull: true,\n      caller: t4\n    };\n    $[2] = t4;\n    $[3] = t5;\n  } else {\n    t5 = $[3];\n  }\n  const {\n    fetchError,\n    validationErrors\n  } = useSchemaContext(t5);\n  const t6 = caller || _useResponseEditor;\n  let t7;\n  if ($[4] !== t6) {\n    t7 = {\n      nonNull: true,\n      caller: t6\n    };\n    $[4] = t6;\n    $[5] = t7;\n  } else {\n    t7 = $[5];\n  }\n  const {\n    initialResponse,\n    responseEditor,\n    setResponseEditor\n  } = useEditorContext(t7);\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const responseTooltipRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(responseTooltip);\n  let t8;\n  let t9;\n  if ($[6] !== responseTooltip) {\n    t8 = () => {\n      responseTooltipRef.current = responseTooltip;\n    };\n    t9 = [responseTooltip];\n    $[6] = responseTooltip;\n    $[7] = t8;\n    $[8] = t9;\n  } else {\n    t8 = $[7];\n    t9 = $[8];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t8, t9);\n  let t10;\n  let t11;\n  if ($[9] !== editorTheme || $[10] !== initialResponse || $[11] !== setResponseEditor) {\n    t10 = () => {\n      let isActive;\n      isActive = true;\n      importCodeMirrorImports().then((CodeMirror) => {\n        if (!isActive) {\n          return;\n        }\n        const tooltipDiv = document.createElement(\"div\");\n        CodeMirror.registerHelper(\"info\", \"graphql-results\", (token, _options, _cm, pos) => {\n          const infoElements = [];\n          const ResponseTooltipComponent = responseTooltipRef.current;\n          if (ResponseTooltipComponent) {\n            infoElements.push(/* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ResponseTooltipComponent, { pos, token }));\n          }\n          if (ImagePreview.shouldRender(token)) {\n            infoElements.push(/* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ImagePreview, { token }, \"image-preview\"));\n          }\n          if (!infoElements.length) {\n            (0,react_dom__WEBPACK_IMPORTED_MODULE_25__.unmountComponentAtNode)(tooltipDiv);\n            return null;\n          }\n          (0,react_dom__WEBPACK_IMPORTED_MODULE_25__.render)(infoElements, tooltipDiv);\n          return tooltipDiv;\n        });\n        const container = ref.current;\n        if (!container) {\n          return;\n        }\n        const newEditor = CodeMirror(container, {\n          value: initialResponse,\n          lineWrapping: true,\n          readOnly: true,\n          theme: editorTheme,\n          mode: \"graphql-results\",\n          foldGutter: true,\n          gutters: [\"CodeMirror-foldgutter\"],\n          info: true,\n          extraKeys: commonKeys\n        });\n        setResponseEditor(newEditor);\n      });\n      return () => {\n        isActive = false;\n      };\n    };\n    t11 = [editorTheme, initialResponse, setResponseEditor];\n    $[9] = editorTheme;\n    $[10] = initialResponse;\n    $[11] = setResponseEditor;\n    $[12] = t10;\n    $[13] = t11;\n  } else {\n    t10 = $[12];\n    t11 = $[13];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t10, t11);\n  useSynchronizeOption(responseEditor, \"keyMap\", keyMap);\n  let t12;\n  let t13;\n  if ($[14] !== fetchError || $[15] !== responseEditor || $[16] !== validationErrors) {\n    t12 = () => {\n      if (fetchError) {\n        responseEditor == null ? void 0 : responseEditor.setValue(fetchError);\n      }\n      if (validationErrors.length > 0) {\n        responseEditor == null ? void 0 : responseEditor.setValue((0,_graphiql_toolkit__WEBPACK_IMPORTED_MODULE_13__.formatError)(validationErrors));\n      }\n    };\n    t13 = [responseEditor, fetchError, validationErrors];\n    $[14] = fetchError;\n    $[15] = responseEditor;\n    $[16] = validationErrors;\n    $[17] = t12;\n    $[18] = t13;\n  } else {\n    t12 = $[17];\n    t13 = $[18];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t12, t13);\n  return ref;\n}\nfunction ResponseEditor(props) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(2);\n  const ref = useResponseEditor(props, ResponseEditor);\n  let t0;\n  if ($[0] !== ref) {\n    t0 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"section\", { className: \"result-window\", \"aria-label\": \"Result Window\", \"aria-live\": \"polite\", \"aria-atomic\": \"true\", ref });\n    $[0] = ref;\n    $[1] = t0;\n  } else {\n    t0 = $[1];\n  }\n  return t0;\n}\nfunction VariableEditor(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(13);\n  let hookArgs;\n  let isHidden;\n  if ($[0] !== t0) {\n    ({\n      isHidden,\n      ...hookArgs\n    } = t0);\n    $[0] = t0;\n    $[1] = hookArgs;\n    $[2] = isHidden;\n  } else {\n    hookArgs = $[1];\n    isHidden = $[2];\n  }\n  let t1;\n  if ($[3] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: VariableEditor\n    };\n    $[3] = t1;\n  } else {\n    t1 = $[3];\n  }\n  const {\n    variableEditor\n  } = useEditorContext(t1);\n  const ref = useVariableEditor(hookArgs, VariableEditor);\n  let t2;\n  let t3;\n  if ($[4] !== isHidden || $[5] !== variableEditor) {\n    t2 = () => {\n      if (variableEditor && !isHidden) {\n        variableEditor.refresh();\n      }\n    };\n    t3 = [variableEditor, isHidden];\n    $[4] = isHidden;\n    $[5] = variableEditor;\n    $[6] = t2;\n    $[7] = t3;\n  } else {\n    t2 = $[6];\n    t3 = $[7];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t2, t3);\n  const t4 = isHidden && \"hidden\";\n  let t5;\n  if ($[8] !== t4) {\n    t5 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-editor\", t4);\n    $[8] = t4;\n    $[9] = t5;\n  } else {\n    t5 = $[9];\n  }\n  let t6;\n  if ($[10] !== ref || $[11] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: t5, ref });\n    $[10] = ref;\n    $[11] = t5;\n    $[12] = t6;\n  } else {\n    t6 = $[12];\n  }\n  return t6;\n}\nfunction GraphiQLProvider(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(39);\n  const {\n    children,\n    dangerouslyAssumeSchemaIsValid,\n    defaultQuery,\n    defaultHeaders,\n    defaultTabs,\n    externalFragments,\n    fetcher,\n    getDefaultFieldNames,\n    headers,\n    inputValueDeprecation,\n    introspectionQueryName,\n    maxHistoryLength,\n    onEditOperationName,\n    onSchemaChange,\n    onTabChange,\n    onTogglePluginVisibility,\n    operationName,\n    plugins,\n    query,\n    response,\n    schema,\n    schemaDescription,\n    shouldPersistHeaders,\n    storage,\n    validationRules,\n    variables,\n    visiblePlugin\n  } = t0;\n  let t1;\n  if ($[0] !== children || $[1] !== onTogglePluginVisibility || $[2] !== plugins || $[3] !== visiblePlugin) {\n    t1 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExplorerContextProvider, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PluginContextProvider, { onTogglePluginVisibility, plugins, visiblePlugin, children }) });\n    $[0] = children;\n    $[1] = onTogglePluginVisibility;\n    $[2] = plugins;\n    $[3] = visiblePlugin;\n    $[4] = t1;\n  } else {\n    t1 = $[4];\n  }\n  let t2;\n  if ($[5] !== fetcher || $[6] !== getDefaultFieldNames || $[7] !== operationName || $[8] !== t1) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExecutionContextProvider, { getDefaultFieldNames, fetcher, operationName, children: t1 });\n    $[5] = fetcher;\n    $[6] = getDefaultFieldNames;\n    $[7] = operationName;\n    $[8] = t1;\n    $[9] = t2;\n  } else {\n    t2 = $[9];\n  }\n  let t3;\n  if ($[10] !== dangerouslyAssumeSchemaIsValid || $[11] !== fetcher || $[12] !== inputValueDeprecation || $[13] !== introspectionQueryName || $[14] !== onSchemaChange || $[15] !== schema || $[16] !== schemaDescription || $[17] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaContextProvider, { dangerouslyAssumeSchemaIsValid, fetcher, inputValueDeprecation, introspectionQueryName, onSchemaChange, schema, schemaDescription, children: t2 });\n    $[10] = dangerouslyAssumeSchemaIsValid;\n    $[11] = fetcher;\n    $[12] = inputValueDeprecation;\n    $[13] = introspectionQueryName;\n    $[14] = onSchemaChange;\n    $[15] = schema;\n    $[16] = schemaDescription;\n    $[17] = t2;\n    $[18] = t3;\n  } else {\n    t3 = $[18];\n  }\n  let t4;\n  if ($[19] !== defaultHeaders || $[20] !== defaultQuery || $[21] !== defaultTabs || $[22] !== externalFragments || $[23] !== headers || $[24] !== onEditOperationName || $[25] !== onTabChange || $[26] !== query || $[27] !== response || $[28] !== shouldPersistHeaders || $[29] !== t3 || $[30] !== validationRules || $[31] !== variables) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EditorContextProvider, { defaultQuery, defaultHeaders, defaultTabs, externalFragments, headers, onEditOperationName, onTabChange, query, response, shouldPersistHeaders, validationRules, variables, children: t3 });\n    $[19] = defaultHeaders;\n    $[20] = defaultQuery;\n    $[21] = defaultTabs;\n    $[22] = externalFragments;\n    $[23] = headers;\n    $[24] = onEditOperationName;\n    $[25] = onTabChange;\n    $[26] = query;\n    $[27] = response;\n    $[28] = shouldPersistHeaders;\n    $[29] = t3;\n    $[30] = validationRules;\n    $[31] = variables;\n    $[32] = t4;\n  } else {\n    t4 = $[32];\n  }\n  let t5;\n  if ($[33] !== maxHistoryLength || $[34] !== t4) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HistoryContextProvider, { maxHistoryLength, children: t4 });\n    $[33] = maxHistoryLength;\n    $[34] = t4;\n    $[35] = t5;\n  } else {\n    t5 = $[35];\n  }\n  let t6;\n  if ($[36] !== storage || $[37] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StorageContextProvider, { storage, children: t5 });\n    $[36] = storage;\n    $[37] = t5;\n    $[38] = t6;\n  } else {\n    t6 = $[38];\n  }\n  return t6;\n}\nfunction useTheme(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(11);\n  const defaultTheme = t0 === void 0 ? null : t0;\n  const storageContext = useStorageContext();\n  let t1;\n  if ($[0] !== defaultTheme || $[1] !== storageContext) {\n    t1 = () => {\n      if (!storageContext) {\n        return null;\n      }\n      const stored = storageContext.get(STORAGE_KEY);\n      switch (stored) {\n        case \"light\": {\n          return \"light\";\n        }\n        case \"dark\": {\n          return \"dark\";\n        }\n        default: {\n          if (typeof stored === \"string\") {\n            storageContext.set(STORAGE_KEY, \"\");\n          }\n          return defaultTheme;\n        }\n      }\n    };\n    $[0] = defaultTheme;\n    $[1] = storageContext;\n    $[2] = t1;\n  } else {\n    t1 = $[2];\n  }\n  const [theme, setThemeInternal] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t1);\n  let t2;\n  let t3;\n  if ($[3] !== theme) {\n    t2 = () => {\n      if (typeof window === \"undefined\") {\n        return;\n      }\n      document.body.classList.remove(\"graphiql-light\", \"graphiql-dark\");\n      if (theme) {\n        document.body.classList.add(`graphiql-${theme}`);\n      }\n    };\n    t3 = [theme];\n    $[3] = theme;\n    $[4] = t2;\n    $[5] = t3;\n  } else {\n    t2 = $[4];\n    t3 = $[5];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(t2, t3);\n  let t4;\n  if ($[6] !== storageContext) {\n    t4 = (newTheme) => {\n      storageContext == null ? void 0 : storageContext.set(STORAGE_KEY, newTheme || \"\");\n      setThemeInternal(newTheme);\n    };\n    $[6] = storageContext;\n    $[7] = t4;\n  } else {\n    t4 = $[7];\n  }\n  const setTheme = t4;\n  let t5;\n  if ($[8] !== setTheme || $[9] !== theme) {\n    t5 = {\n      theme,\n      setTheme\n    };\n    $[8] = setTheme;\n    $[9] = theme;\n    $[10] = t5;\n  } else {\n    t5 = $[10];\n  }\n  return t5;\n}\nconst STORAGE_KEY = \"theme\";\nfunction useDragResize(t0) {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(31);\n  const {\n    defaultSizeRelation: t1,\n    direction,\n    initiallyHidden,\n    onHiddenElementChange,\n    sizeThresholdFirst: t2,\n    sizeThresholdSecond: t3,\n    storageKey\n  } = t0;\n  const defaultSizeRelation = t1 === void 0 ? DEFAULT_FLEX : t1;\n  const sizeThresholdFirst = t2 === void 0 ? 100 : t2;\n  const sizeThresholdSecond = t3 === void 0 ? 100 : t3;\n  const storage = useStorageContext();\n  let t4;\n  if ($[0] !== storage || $[1] !== storageKey) {\n    t4 = debounce(500, (value) => {\n      if (storageKey) {\n        storage == null ? void 0 : storage.set(storageKey, value);\n      }\n    });\n    $[0] = storage;\n    $[1] = storageKey;\n    $[2] = t4;\n  } else {\n    t4 = $[2];\n  }\n  const store = t4;\n  let t5;\n  if ($[3] !== initiallyHidden || $[4] !== storage || $[5] !== storageKey) {\n    t5 = () => {\n      const storedValue = storageKey && (storage == null ? void 0 : storage.get(storageKey));\n      if (storedValue === HIDE_FIRST || initiallyHidden === \"first\") {\n        return \"first\";\n      }\n      if (storedValue === HIDE_SECOND || initiallyHidden === \"second\") {\n        return \"second\";\n      }\n      return null;\n    };\n    $[3] = initiallyHidden;\n    $[4] = storage;\n    $[5] = storageKey;\n    $[6] = t5;\n  } else {\n    t5 = $[6];\n  }\n  const [hiddenElement, setHiddenElement] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(t5);\n  let t6;\n  if ($[7] !== hiddenElement || $[8] !== onHiddenElementChange) {\n    t6 = (element) => {\n      if (element !== hiddenElement) {\n        setHiddenElement(element);\n        onHiddenElementChange == null ? void 0 : onHiddenElementChange(element);\n      }\n    };\n    $[7] = hiddenElement;\n    $[8] = onHiddenElementChange;\n    $[9] = t6;\n  } else {\n    t6 = $[9];\n  }\n  const setHiddenElementWithCallback = t6;\n  const firstRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const dragBarRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const secondRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);\n  const defaultFlexRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(`${defaultSizeRelation}`);\n  let t7;\n  if ($[10] !== storage || $[11] !== storageKey) {\n    t7 = () => {\n      const storedValue_0 = storageKey && (storage == null ? void 0 : storage.get(storageKey)) || defaultFlexRef.current;\n      if (firstRef.current) {\n        firstRef.current.style.display = \"flex\";\n        firstRef.current.style.flex = storedValue_0 === HIDE_FIRST || storedValue_0 === HIDE_SECOND ? defaultFlexRef.current : storedValue_0;\n      }\n      if (secondRef.current) {\n        secondRef.current.style.display = \"flex\";\n        secondRef.current.style.flex = \"1\";\n      }\n      if (dragBarRef.current) {\n        dragBarRef.current.style.display = \"flex\";\n      }\n    };\n    $[10] = storage;\n    $[11] = storageKey;\n    $[12] = t7;\n  } else {\n    t7 = $[12];\n  }\n  let t8;\n  if ($[13] !== direction || $[14] !== storage || $[15] !== storageKey) {\n    t8 = [direction, storage, storageKey];\n    $[13] = direction;\n    $[14] = storage;\n    $[15] = storageKey;\n    $[16] = t8;\n  } else {\n    t8 = $[16];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(t7, t8);\n  let t10;\n  let t9;\n  if ($[17] !== hiddenElement || $[18] !== storage || $[19] !== storageKey) {\n    t9 = () => {\n      const hide = (resizableElement) => {\n        const element_0 = resizableElement === \"first\" ? firstRef.current : secondRef.current;\n        if (!element_0) {\n          return;\n        }\n        element_0.style.left = \"-1000px\";\n        element_0.style.position = \"absolute\";\n        element_0.style.opacity = \"0\";\n        element_0.style.height = \"500px\";\n        element_0.style.width = \"500px\";\n        if (firstRef.current) {\n          const flex = parseFloat(firstRef.current.style.flex);\n          if (!Number.isFinite(flex) || flex < 1) {\n            firstRef.current.style.flex = \"1\";\n          }\n        }\n      };\n      const show = (resizableElement_0) => {\n        const element_1 = resizableElement_0 === \"first\" ? firstRef.current : secondRef.current;\n        if (!element_1) {\n          return;\n        }\n        element_1.style.width = \"\";\n        element_1.style.height = \"\";\n        element_1.style.opacity = \"\";\n        element_1.style.position = \"\";\n        element_1.style.left = \"\";\n        if (storage && storageKey) {\n          const storedValue_1 = storage.get(storageKey);\n          if (firstRef.current && storedValue_1 !== HIDE_FIRST && storedValue_1 !== HIDE_SECOND) {\n            firstRef.current.style.flex = storedValue_1 || defaultFlexRef.current;\n          }\n        }\n      };\n      if (hiddenElement === \"first\") {\n        hide(\"first\");\n      } else {\n        show(\"first\");\n      }\n      if (hiddenElement === \"second\") {\n        hide(\"second\");\n      } else {\n        show(\"second\");\n      }\n    };\n    t10 = [hiddenElement, storage, storageKey];\n    $[17] = hiddenElement;\n    $[18] = storage;\n    $[19] = storageKey;\n    $[20] = t10;\n    $[21] = t9;\n  } else {\n    t10 = $[20];\n    t9 = $[21];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(t9, t10);\n  let t11;\n  let t12;\n  if ($[22] !== direction || $[23] !== setHiddenElementWithCallback || $[24] !== sizeThresholdFirst || $[25] !== sizeThresholdSecond || $[26] !== store) {\n    t11 = () => {\n      if (!dragBarRef.current || !firstRef.current || !secondRef.current) {\n        return;\n      }\n      const dragBarContainer = dragBarRef.current;\n      const firstContainer = firstRef.current;\n      const wrapper = firstContainer.parentElement;\n      const eventProperty = direction === \"horizontal\" ? \"clientX\" : \"clientY\";\n      const rectProperty = direction === \"horizontal\" ? \"left\" : \"top\";\n      const adjacentRectProperty = direction === \"horizontal\" ? \"right\" : \"bottom\";\n      const sizeProperty = direction === \"horizontal\" ? \"clientWidth\" : \"clientHeight\";\n      const handleMouseDown = function handleMouseDown2(downEvent) {\n        downEvent.preventDefault();\n        const offset = downEvent[eventProperty] - dragBarContainer.getBoundingClientRect()[rectProperty];\n        const handleMouseMove = function handleMouseMove2(moveEvent) {\n          if (moveEvent.buttons === 0) {\n            return handleMouseUp();\n          }\n          const firstSize = moveEvent[eventProperty] - wrapper.getBoundingClientRect()[rectProperty] - offset;\n          const secondSize = wrapper.getBoundingClientRect()[adjacentRectProperty] - moveEvent[eventProperty] + offset - dragBarContainer[sizeProperty];\n          if (firstSize < sizeThresholdFirst) {\n            setHiddenElementWithCallback(\"first\");\n            store(HIDE_FIRST);\n          } else {\n            if (secondSize < sizeThresholdSecond) {\n              setHiddenElementWithCallback(\"second\");\n              store(HIDE_SECOND);\n            } else {\n              setHiddenElementWithCallback(null);\n              const newFlex = `${firstSize / secondSize}`;\n              firstContainer.style.flex = newFlex;\n              store(newFlex);\n            }\n          }\n        };\n        function handleMouseUp() {\n          document.removeEventListener(\"mousemove\", handleMouseMove);\n          document.removeEventListener(\"mouseup\", handleMouseUp);\n        }\n        document.addEventListener(\"mousemove\", handleMouseMove);\n        document.addEventListener(\"mouseup\", handleMouseUp);\n      };\n      dragBarContainer.addEventListener(\"mousedown\", handleMouseDown);\n      const reset = function reset2() {\n        if (firstRef.current) {\n          firstRef.current.style.flex = defaultFlexRef.current;\n        }\n        store(defaultFlexRef.current);\n        setHiddenElementWithCallback(null);\n      };\n      dragBarContainer.addEventListener(\"dblclick\", reset);\n      return () => {\n        dragBarContainer.removeEventListener(\"mousedown\", handleMouseDown);\n        dragBarContainer.removeEventListener(\"dblclick\", reset);\n      };\n    };\n    t12 = [direction, setHiddenElementWithCallback, sizeThresholdFirst, sizeThresholdSecond, store];\n    $[22] = direction;\n    $[23] = setHiddenElementWithCallback;\n    $[24] = sizeThresholdFirst;\n    $[25] = sizeThresholdSecond;\n    $[26] = store;\n    $[27] = t11;\n    $[28] = t12;\n  } else {\n    t11 = $[27];\n    t12 = $[28];\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(t11, t12);\n  let t13;\n  if ($[29] !== hiddenElement) {\n    t13 = {\n      dragBarRef,\n      hiddenElement,\n      firstRef,\n      setHiddenElement,\n      secondRef\n    };\n    $[29] = hiddenElement;\n    $[30] = t13;\n  } else {\n    t13 = $[30];\n  }\n  return t13;\n}\nconst DEFAULT_FLEX = 1;\nconst HIDE_FIRST = \"hide-first\";\nconst HIDE_SECOND = \"hide-second\";\nconst ToolbarButton = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((t0, ref) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(19);\n  let label;\n  let onClick;\n  let props;\n  if ($[0] !== t0) {\n    ({\n      label,\n      onClick,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = label;\n    $[2] = onClick;\n    $[3] = props;\n  } else {\n    label = $[1];\n    onClick = $[2];\n    props = $[3];\n  }\n  const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);\n  let t1;\n  if ($[4] !== onClick) {\n    t1 = (event) => {\n      try {\n        if (onClick) {\n          onClick(event);\n        }\n        setError(null);\n      } catch (t22) {\n        const err = t22;\n        setError(err instanceof Error ? err : new Error(`Toolbar button click failed: ${err}`));\n      }\n    };\n    $[4] = onClick;\n    $[5] = t1;\n  } else {\n    t1 = $[5];\n  }\n  const handleClick = t1;\n  const t2 = error && \"error\";\n  let t3;\n  if ($[6] !== props.className || $[7] !== t2) {\n    t3 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-toolbar-button\", t2, props.className);\n    $[6] = props.className;\n    $[7] = t2;\n    $[8] = t3;\n  } else {\n    t3 = $[8];\n  }\n  const t4 = error ? error.message : label;\n  const t5 = error ? \"true\" : props[\"aria-invalid\"];\n  let t6;\n  if ($[9] !== handleClick || $[10] !== props || $[11] !== ref || $[12] !== t3 || $[13] !== t4 || $[14] !== t5) {\n    t6 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnStyledButton, { ...props, ref, type: \"button\", className: t3, onClick: handleClick, \"aria-label\": t4, \"aria-invalid\": t5 });\n    $[9] = handleClick;\n    $[10] = props;\n    $[11] = ref;\n    $[12] = t3;\n    $[13] = t4;\n    $[14] = t5;\n    $[15] = t6;\n  } else {\n    t6 = $[15];\n  }\n  let t7;\n  if ($[16] !== label || $[17] !== t6) {\n    t7 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label, children: t6 });\n    $[16] = label;\n    $[17] = t6;\n    $[18] = t7;\n  } else {\n    t7 = $[18];\n  }\n  return t7;\n});\nToolbarButton.displayName = \"ToolbarButton\";\nfunction ExecuteButton() {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(19);\n  let t0;\n  if ($[0] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t0 = {\n      nonNull: true,\n      caller: ExecuteButton\n    };\n    $[0] = t0;\n  } else {\n    t0 = $[0];\n  }\n  const {\n    queryEditor,\n    setOperationName\n  } = useEditorContext(t0);\n  let t1;\n  if ($[1] === Symbol.for(\"react.memo_cache_sentinel\")) {\n    t1 = {\n      nonNull: true,\n      caller: ExecuteButton\n    };\n    $[1] = t1;\n  } else {\n    t1 = $[1];\n  }\n  const {\n    isFetching,\n    isSubscribed,\n    operationName,\n    run,\n    stop\n  } = useExecutionContext(t1);\n  let t2;\n  if ($[2] !== (queryEditor == null ? void 0 : queryEditor.operations)) {\n    t2 = (queryEditor == null ? void 0 : queryEditor.operations) || [];\n    $[2] = queryEditor == null ? void 0 : queryEditor.operations;\n    $[3] = t2;\n  } else {\n    t2 = $[3];\n  }\n  const operations = t2;\n  const hasOptions = operations.length > 1 && typeof operationName !== \"string\";\n  const isRunning = isFetching || isSubscribed;\n  const label = `${isRunning ? \"Stop\" : \"Execute\"} query (Ctrl-Enter)`;\n  let t3;\n  if ($[4] !== isRunning) {\n    t3 = isRunning ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StopIcon, {}) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PlayIcon, {});\n    $[4] = isRunning;\n    $[5] = t3;\n  } else {\n    t3 = $[5];\n  }\n  let t4;\n  if ($[6] !== label || $[7] !== t3) {\n    t4 = {\n      type: \"button\",\n      className: \"graphiql-execute-button\",\n      children: t3,\n      \"aria-label\": label\n    };\n    $[6] = label;\n    $[7] = t3;\n    $[8] = t4;\n  } else {\n    t4 = $[8];\n  }\n  const buttonProps = t4;\n  let t5;\n  if ($[9] !== buttonProps || $[10] !== hasOptions || $[11] !== isRunning || $[12] !== label || $[13] !== operations || $[14] !== queryEditor || $[15] !== run || $[16] !== setOperationName || $[17] !== stop) {\n    t5 = hasOptions && !isRunning ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(DropdownMenu, { children: [\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DropdownMenu.Button, { ...buttonProps }) }),\n      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DropdownMenu.Content, { children: operations.map((operation, i) => {\n        const opName = operation.name ? operation.name.value : `<Unnamed ${operation.operation}>`;\n        return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DropdownMenu.Item, { onSelect: () => {\n          var _a;\n          const selectedOperationName = (_a = operation.name) == null ? void 0 : _a.value;\n          if (queryEditor && selectedOperationName && selectedOperationName !== queryEditor.operationName) {\n            setOperationName(selectedOperationName);\n          }\n          run();\n        }, children: opName }, `${opName}-${i}`);\n      }) })\n    ] }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"button\", { ...buttonProps, onClick: () => {\n      if (isRunning) {\n        stop();\n      } else {\n        run();\n      }\n    } }) });\n    $[9] = buttonProps;\n    $[10] = hasOptions;\n    $[11] = isRunning;\n    $[12] = label;\n    $[13] = operations;\n    $[14] = queryEditor;\n    $[15] = run;\n    $[16] = setOperationName;\n    $[17] = stop;\n    $[18] = t5;\n  } else {\n    t5 = $[18];\n  }\n  return t5;\n}\nconst ToolbarMenuRoot = (t0) => {\n  const $ = (0,react_compiler_runtime__WEBPACK_IMPORTED_MODULE_1__.c)(20);\n  let button;\n  let children;\n  let label;\n  let props;\n  if ($[0] !== t0) {\n    ({\n      button,\n      children,\n      label,\n      ...props\n    } = t0);\n    $[0] = t0;\n    $[1] = button;\n    $[2] = children;\n    $[3] = label;\n    $[4] = props;\n  } else {\n    button = $[1];\n    children = $[2];\n    label = $[3];\n    props = $[4];\n  }\n  let t1;\n  if ($[5] !== props.className) {\n    t1 = (0,clsx__WEBPACK_IMPORTED_MODULE_3__.clsx)(\"graphiql-un-styled graphiql-toolbar-menu\", props.className);\n    $[5] = props.className;\n    $[6] = t1;\n  } else {\n    t1 = $[6];\n  }\n  let t2;\n  if ($[7] !== button || $[8] !== label || $[9] !== t1) {\n    t2 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DropdownMenu.Button, { className: t1, \"aria-label\": label, children: button });\n    $[7] = button;\n    $[8] = label;\n    $[9] = t1;\n    $[10] = t2;\n  } else {\n    t2 = $[10];\n  }\n  let t3;\n  if ($[11] !== label || $[12] !== t2) {\n    t3 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tooltip, { label, children: t2 });\n    $[11] = label;\n    $[12] = t2;\n    $[13] = t3;\n  } else {\n    t3 = $[13];\n  }\n  let t4;\n  if ($[14] !== children) {\n    t4 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DropdownMenu.Content, { children });\n    $[14] = children;\n    $[15] = t4;\n  } else {\n    t4 = $[15];\n  }\n  let t5;\n  if ($[16] !== props || $[17] !== t3 || $[18] !== t4) {\n    t5 = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(DropdownMenu, { ...props, children: [\n      t3,\n      t4\n    ] });\n    $[16] = props;\n    $[17] = t3;\n    $[18] = t4;\n    $[19] = t5;\n  } else {\n    t5 = $[19];\n  }\n  return t5;\n};\nconst ToolbarMenu = createComponentGroup(ToolbarMenuRoot, {\n  Item: DropdownMenu.Item\n});\n\n//# sourceMappingURL=index.mjs.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+react@0.29.0_@codemirror+language@6.11.3_@types+node@24.9.0_@types+react-dom@_08b4c03f213ee5c49169b3648695812c/node_modules/@graphiql/react/dist/index.mjs\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/async-helpers/index.js":
/*!**********************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/async-helpers/index.js ***!
  \**********************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   fetcherReturnToPromise: () => (/* binding */ fetcherReturnToPromise),\n/* harmony export */   isAsyncIterable: () => (/* binding */ isAsyncIterable),\n/* harmony export */   isObservable: () => (/* binding */ isObservable),\n/* harmony export */   isPromise: () => (/* binding */ isPromise)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n\nfunction isPromise(value) {\n  return typeof value == \"object\" && value !== null && typeof value.then == \"function\";\n}\nfunction observableToPromise(observable) {\n  return new Promise((resolve, reject) => {\n    const subscription = observable.subscribe({\n      next(v) {\n        resolve(v), subscription.unsubscribe();\n      },\n      error: reject,\n      complete() {\n        reject(new Error(\"no value resolved\"));\n      }\n    });\n  });\n}\nfunction isObservable(value) {\n  return typeof value == \"object\" && value !== null && \"subscribe\" in value && typeof value.subscribe == \"function\";\n}\nfunction isAsyncIterable(input) {\n  return typeof input == \"object\" && input !== null && // Some browsers still don't have Symbol.asyncIterator implemented (iOS Safari)\n  // That means every custom AsyncIterable must be built using a AsyncGeneratorFunction (async function * () {})\n  (input[Symbol.toStringTag] === \"AsyncGenerator\" || Symbol.asyncIterator in input);\n}\nasync function asyncIterableToPromise(input) {\n  var _a;\n  const iteratorReturn = (_a = (\"return\" in input ? input : input[Symbol.asyncIterator]()).return) == null ? void 0 : _a.bind(input), result = await (\"next\" in input ? input : input[Symbol.asyncIterator]()).next.bind(input)();\n  return iteratorReturn == null || iteratorReturn(), result.value;\n}\nasync function fetcherReturnToPromise(fetcherResult) {\n  const result = await fetcherResult;\n  return isAsyncIterable(result) ? asyncIterableToPromise(result) : isObservable(result) ? observableToPromise(result) : result;\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/async-helpers/index.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js":
/*!*****************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js ***!
  \*****************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   __asyncGenerator: () => (/* binding */ __asyncGenerator),\n/* harmony export */   __await: () => (/* binding */ __await),\n/* harmony export */   __forAwait: () => (/* binding */ __forAwait),\n/* harmony export */   __spreadProps: () => (/* binding */ __spreadProps),\n/* harmony export */   __spreadValues: () => (/* binding */ __spreadValues)\n/* harmony export */ });\nvar __defProp = Object.defineProperty, __defProps = Object.defineProperties;\nvar __getOwnPropDescs = Object.getOwnPropertyDescriptors;\nvar __getOwnPropSymbols = Object.getOwnPropertySymbols;\nvar __hasOwnProp = Object.prototype.hasOwnProperty, __propIsEnum = Object.prototype.propertyIsEnumerable;\nvar __knownSymbol = (name, symbol) => (symbol = Symbol[name]) ? symbol : Symbol.for(\"Symbol.\" + name);\nvar __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value, __spreadValues = (a, b) => {\n  for (var prop in b || (b = {}))\n    __hasOwnProp.call(b, prop) && __defNormalProp(a, prop, b[prop]);\n  if (__getOwnPropSymbols)\n    for (var prop of __getOwnPropSymbols(b))\n      __propIsEnum.call(b, prop) && __defNormalProp(a, prop, b[prop]);\n  return a;\n}, __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));\nvar __await = function(promise, isYieldStar) {\n  this[0] = promise, this[1] = isYieldStar;\n}, __asyncGenerator = (__this, __arguments, generator) => {\n  var resume = (k, v, yes, no) => {\n    try {\n      var x = generator[k](v), isAwait = (v = x.value) instanceof __await, done = x.done;\n      Promise.resolve(isAwait ? v[0] : v).then((y) => isAwait ? resume(k === \"return\" ? k : \"next\", v[1] ? { done: y.done, value: y.value } : y, yes, no) : yes({ value: y, done })).catch((e) => resume(\"throw\", e, yes, no));\n    } catch (e) {\n      no(e);\n    }\n  }, method = (k) => it[k] = (x) => new Promise((yes, no) => resume(k, x, yes, no)), it = {};\n  return generator = generator.apply(__this, __arguments), it[__knownSymbol(\"asyncIterator\")] = () => it, method(\"next\"), method(\"throw\"), method(\"return\"), it;\n};\nvar __forAwait = (obj, it, method) => (it = obj[__knownSymbol(\"asyncIterator\")]) ? it.call(obj) : (obj = obj[__knownSymbol(\"iterator\")](), it = {}, method = (key, fn) => (fn = obj[key]) && (it[key] = (arg) => new Promise((yes, no, done) => (arg = fn.call(obj, arg), done = arg.done, Promise.resolve(arg.value).then((value) => yes({ value, done }), no)))), method(\"next\"), method(\"return\"), it);\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/createFetcher.js":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/createFetcher.js ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createGraphiQLFetcher: () => (/* binding */ createGraphiQLFetcher)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n/* harmony import */ var _lib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/lib.js\");\n\n\nfunction createGraphiQLFetcher(options) {\n  const httpFetch = options.fetch || typeof window != \"undefined\" && window.fetch;\n  if (!httpFetch)\n    throw new Error(\"No valid fetcher implementation available\");\n  options.enableIncrementalDelivery = options.enableIncrementalDelivery !== !1;\n  const simpleFetcher = (0,_lib__WEBPACK_IMPORTED_MODULE_1__.createSimpleFetcher)(options, httpFetch), httpFetcher = options.enableIncrementalDelivery ? (0,_lib__WEBPACK_IMPORTED_MODULE_1__.createMultipartFetcher)(options, httpFetch) : simpleFetcher;\n  return async (graphQLParams, fetcherOpts) => {\n    if (graphQLParams.operationName === \"IntrospectionQuery\")\n      return (options.schemaFetcher || simpleFetcher)(\n        graphQLParams,\n        fetcherOpts\n      );\n    if (fetcherOpts != null && fetcherOpts.documentAST ? (0,_lib__WEBPACK_IMPORTED_MODULE_1__.isSubscriptionWithName)(\n      fetcherOpts.documentAST,\n      graphQLParams.operationName || void 0\n    ) : !1) {\n      const wsFetcher = await (0,_lib__WEBPACK_IMPORTED_MODULE_1__.getWsFetcher)(options, fetcherOpts);\n      if (!wsFetcher)\n        throw new Error(\n          `Your GraphiQL createFetcher is not properly configured for websocket subscriptions yet. ${options.subscriptionUrl ? `Provided URL ${options.subscriptionUrl} failed` : \"Please provide subscriptionUrl, wsClient or legacyClient option first.\"}`\n        );\n      return wsFetcher(graphQLParams);\n    }\n    return httpFetcher(graphQLParams, fetcherOpts);\n  };\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/createFetcher.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/index.js":
/*!***********************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/index.js ***!
  \***********************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createGraphiQLFetcher: () => (/* reexport safe */ _createFetcher__WEBPACK_IMPORTED_MODULE_2__.createGraphiQLFetcher)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/types.js\");\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};\n/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in _types__WEBPACK_IMPORTED_MODULE_1__) if([\"default\",\"createGraphiQLFetcher\"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => _types__WEBPACK_IMPORTED_MODULE_1__[__WEBPACK_IMPORT_KEY__]\n/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);\n/* harmony import */ var _createFetcher__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createFetcher */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/createFetcher.js\");\n\n\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vLi4vbm9kZV9tb2R1bGVzLy5wbnBtL0BncmFwaGlxbCt0b29sa2l0QDAuMTEuM19AdHlwZXMrbm9kZUAyNC45LjBfZ3JhcGhxbC13c0A2LjAuNl9ncmFwaHFsQDE2LjExLjBfd3NAOC4xOC4zX19ncmFwaHFsQDE2LjExLjAvbm9kZV9tb2R1bGVzL0BncmFwaGlxbC90b29sa2l0L2Rpc3QvZXNtL2NyZWF0ZS1mZXRjaGVyL2luZGV4LmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBQThCO0FBQ047QUFDZ0M7QUFHdEQiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9Ac2FnZS94dHJlbS11aS1wbHVnaW4tZ3JhcGhpcWwvLi4vLi4vLi4vbm9kZV9tb2R1bGVzLy5wbnBtL0BncmFwaGlxbCt0b29sa2l0QDAuMTEuM19AdHlwZXMrbm9kZUAyNC45LjBfZ3JhcGhxbC13c0A2LjAuNl9ncmFwaHFsQDE2LjExLjBfd3NAOC4xOC4zX19ncmFwaHFsQDE2LjExLjAvbm9kZV9tb2R1bGVzL0BncmFwaGlxbC90b29sa2l0L2Rpc3QvZXNtL2NyZWF0ZS1mZXRjaGVyL2luZGV4LmpzPzlhNDUiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFwiLi4vY2h1bmstTE1PUUlYVjQuanNcIjtcbmV4cG9ydCAqIGZyb20gXCIuL3R5cGVzXCI7XG5pbXBvcnQgeyBjcmVhdGVHcmFwaGlRTEZldGNoZXIgfSBmcm9tIFwiLi9jcmVhdGVGZXRjaGVyXCI7XG5leHBvcnQge1xuICBjcmVhdGVHcmFwaGlRTEZldGNoZXJcbn07XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/index.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/lib.js":
/*!*********************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/lib.js ***!
  \*********************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createLegacyWebsocketsFetcher: () => (/* binding */ createLegacyWebsocketsFetcher),\n/* harmony export */   createMultipartFetcher: () => (/* binding */ createMultipartFetcher),\n/* harmony export */   createSimpleFetcher: () => (/* binding */ createSimpleFetcher),\n/* harmony export */   createWebsocketsFetcherFromClient: () => (/* binding */ createWebsocketsFetcherFromClient),\n/* harmony export */   createWebsocketsFetcherFromUrl: () => (/* binding */ createWebsocketsFetcherFromUrl),\n/* harmony export */   getWsFetcher: () => (/* binding */ getWsFetcher),\n/* harmony export */   isSubscriptionWithName: () => (/* binding */ isSubscriptionWithName)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/visitor.mjs\");\n/* harmony import */ var meros__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! meros */ \"../../../node_modules/.pnpm/meros@1.3.1_@types+node@24.9.0/node_modules/meros/browser/index.mjs\");\n/* harmony import */ var _n1ru4l_push_pull_async_iterable_iterator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @n1ru4l/push-pull-async-iterable-iterator */ \"../../../node_modules/.pnpm/@n1ru4l+push-pull-async-iterable-iterator@3.2.0/node_modules/@n1ru4l/push-pull-async-iterable-iterator/index.mjs\");\n\n\n\n\nconst errorHasCode = (err) => typeof err == \"object\" && err !== null && \"code\" in err, isSubscriptionWithName = (document, name) => {\n  let isSubscription = !1;\n  return (0,graphql__WEBPACK_IMPORTED_MODULE_1__.visit)(document, {\n    OperationDefinition(node) {\n      var _a;\n      name === ((_a = node.name) == null ? void 0 : _a.value) && node.operation === \"subscription\" && (isSubscription = !0);\n    }\n  }), isSubscription;\n}, createSimpleFetcher = (options, httpFetch) => async (graphQLParams, fetcherOpts) => (await httpFetch(options.url, {\n  method: \"POST\",\n  body: JSON.stringify(graphQLParams),\n  headers: (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)((0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({\n    \"content-type\": \"application/json\"\n  }, options.headers), fetcherOpts == null ? void 0 : fetcherOpts.headers)\n})).json();\nasync function createWebsocketsFetcherFromUrl(url, connectionParams) {\n  let wsClient;\n  try {\n    const { createClient } = await Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! graphql-ws */ \"../../../node_modules/.pnpm/graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3/node_modules/graphql-ws/dist/index.js\"));\n    return wsClient = createClient({ url, connectionParams }), createWebsocketsFetcherFromClient(wsClient);\n  } catch (err) {\n    if (errorHasCode(err) && err.code === \"MODULE_NOT_FOUND\")\n      throw new Error(\n        \"You need to install the 'graphql-ws' package to use websockets when passing a 'subscriptionUrl'\"\n      );\n    console.error(`Error creating websocket client for ${url}`, err);\n  }\n}\nconst createWebsocketsFetcherFromClient = (wsClient) => (graphQLParams) => (0,_n1ru4l_push_pull_async_iterable_iterator__WEBPACK_IMPORTED_MODULE_3__.makeAsyncIterableIteratorFromSink)(\n  (sink) => wsClient.subscribe(graphQLParams, (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadProps)((0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, sink), {\n    error(err) {\n      err instanceof CloseEvent ? sink.error(\n        new Error(\n          `Socket closed with event ${err.code} ${err.reason || \"\"}`.trim()\n        )\n      ) : sink.error(err);\n    }\n  }))\n), createLegacyWebsocketsFetcher = (legacyWsClient) => (graphQLParams) => {\n  const observable = legacyWsClient.request(graphQLParams);\n  return (0,_n1ru4l_push_pull_async_iterable_iterator__WEBPACK_IMPORTED_MODULE_3__.makeAsyncIterableIteratorFromSink)(\n    // @ts-ignore\n    (sink) => observable.subscribe(sink).unsubscribe\n  );\n}, createMultipartFetcher = (options, httpFetch) => function(graphQLParams, fetcherOpts) {\n  return (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__asyncGenerator)(this, null, function* () {\n    const response = yield new _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__await(httpFetch(options.url, {\n      method: \"POST\",\n      body: JSON.stringify(graphQLParams),\n      headers: (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)((0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({\n        \"content-type\": \"application/json\",\n        accept: \"application/json, multipart/mixed\"\n      }, options.headers), fetcherOpts == null ? void 0 : fetcherOpts.headers)\n    }).then(\n      (r) => (0,meros__WEBPACK_IMPORTED_MODULE_2__.meros)(r, {\n        multiple: !0\n      })\n    ));\n    if (!(0,_n1ru4l_push_pull_async_iterable_iterator__WEBPACK_IMPORTED_MODULE_3__.isAsyncIterable)(response))\n      return yield response.json();\n    try {\n      for (var iter = (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__forAwait)(response), more, temp, error; more = !(temp = yield new _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__await(iter.next())).done; more = !1) {\n        const chunk = temp.value;\n        if (chunk.some((part) => !part.json)) {\n          const message = chunk.map(\n            (part) => `Headers::\n${part.headers}\n\nBody::\n${part.body}`\n          );\n          throw new Error(\n            `Expected multipart chunks to be of json type. got:\n${message}`\n          );\n        }\n        yield chunk.map((part) => part.body);\n      }\n    } catch (temp) {\n      error = [temp];\n    } finally {\n      try {\n        more && (temp = iter.return) && (yield new _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__await(temp.call(iter)));\n      } finally {\n        if (error)\n          throw error[0];\n      }\n    }\n  });\n};\nasync function getWsFetcher(options, fetcherOpts) {\n  if (options.wsClient)\n    return createWebsocketsFetcherFromClient(options.wsClient);\n  if (options.subscriptionUrl)\n    return createWebsocketsFetcherFromUrl(options.subscriptionUrl, (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)((0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, options.wsConnectionParams), fetcherOpts == null ? void 0 : fetcherOpts.headers));\n  const legacyWebsocketsClient = options.legacyClient || options.legacyWsClient;\n  if (legacyWebsocketsClient)\n    return createLegacyWebsocketsFetcher(legacyWebsocketsClient);\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vLi4vbm9kZV9tb2R1bGVzLy5wbnBtL0BncmFwaGlxbCt0b29sa2l0QDAuMTEuM19AdHlwZXMrbm9kZUAyNC45LjBfZ3JhcGhxbC13c0A2LjAuNl9ncmFwaHFsQDE2LjExLjBfd3NAOC4xOC4zX19ncmFwaHFsQDE2LjExLjAvbm9kZV9tb2R1bGVzL0BncmFwaGlxbC90b29sa2l0L2Rpc3QvZXNtL2NyZWF0ZS1mZXRjaGVyL2xpYi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7OztBQU04QjtBQUNFO0FBQ0Y7QUFJcUI7QUFDbkQ7QUFDQTtBQUNBLFNBQVMsOENBQUs7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSCxDQUFDO0FBQ0Q7QUFDQTtBQUNBLFdBQVcsa0VBQWMsQ0FBQyxrRUFBYztBQUN4QztBQUNBLEdBQUc7QUFDSCxDQUFDO0FBQ0Q7QUFDQTtBQUNBO0FBQ0EsWUFBWSxlQUFlLFFBQVEsc05BQW9CO0FBQ3ZELHFDQUFxQyx1QkFBdUI7QUFDNUQsSUFBSTtBQUNKO0FBQ0E7QUFDQTtBQUNBO0FBQ0EseURBQXlELElBQUk7QUFDN0Q7QUFDQTtBQUNBLDJFQUEyRSw0R0FBaUM7QUFDNUcsOENBQThDLGlFQUFhLENBQUMsa0VBQWMsR0FBRztBQUM3RTtBQUNBO0FBQ0E7QUFDQSxzQ0FBc0MsVUFBVSxFQUFFLGlCQUFpQjtBQUNuRTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBLFNBQVMsNEdBQWlDO0FBQzFDO0FBQ0E7QUFDQTtBQUNBLENBQUM7QUFDRCxTQUFTLG9FQUFnQjtBQUN6QiwrQkFBK0IsdURBQU87QUFDdEM7QUFDQTtBQUNBLGVBQWUsa0VBQWMsQ0FBQyxrRUFBYztBQUM1QztBQUNBO0FBQ0EsT0FBTztBQUNQLEtBQUs7QUFDTCxhQUFhLDRDQUFLO0FBQ2xCO0FBQ0EsT0FBTztBQUNQO0FBQ0EsU0FBUywwRkFBZTtBQUN4QjtBQUNBO0FBQ0Esc0JBQXNCLDhEQUFVLCtCQUErQiwwQkFBMEIsdURBQU8scUJBQXFCO0FBQ3JIO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBLEVBQUUsVUFBVTtBQUNaO0FBQ0E7QUFDQTtBQUNBLEVBQUUsUUFBUTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsbURBQW1ELHVEQUFPO0FBQzFELFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsbUVBQW1FLGtFQUFjLENBQUMsa0VBQWMsR0FBRztBQUNuRztBQUNBO0FBQ0E7QUFDQTtBQVNFIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQHNhZ2UveHRyZW0tdWktcGx1Z2luLWdyYXBoaXFsLy4uLy4uLy4uL25vZGVfbW9kdWxlcy8ucG5wbS9AZ3JhcGhpcWwrdG9vbGtpdEAwLjExLjNfQHR5cGVzK25vZGVAMjQuOS4wX2dyYXBocWwtd3NANi4wLjZfZ3JhcGhxbEAxNi4xMS4wX3dzQDguMTguM19fZ3JhcGhxbEAxNi4xMS4wL25vZGVfbW9kdWxlcy9AZ3JhcGhpcWwvdG9vbGtpdC9kaXN0L2VzbS9jcmVhdGUtZmV0Y2hlci9saWIuanM/ZjY2ZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBfX2FzeW5jR2VuZXJhdG9yLFxuICBfX2F3YWl0LFxuICBfX2ZvckF3YWl0LFxuICBfX3NwcmVhZFByb3BzLFxuICBfX3NwcmVhZFZhbHVlc1xufSBmcm9tIFwiLi4vY2h1bmstTE1PUUlYVjQuanNcIjtcbmltcG9ydCB7IHZpc2l0IH0gZnJvbSBcImdyYXBocWxcIjtcbmltcG9ydCB7IG1lcm9zIH0gZnJvbSBcIm1lcm9zXCI7XG5pbXBvcnQge1xuICBpc0FzeW5jSXRlcmFibGUsXG4gIG1ha2VBc3luY0l0ZXJhYmxlSXRlcmF0b3JGcm9tU2lua1xufSBmcm9tIFwiQG4xcnU0bC9wdXNoLXB1bGwtYXN5bmMtaXRlcmFibGUtaXRlcmF0b3JcIjtcbmNvbnN0IGVycm9ySGFzQ29kZSA9IChlcnIpID0+IHR5cGVvZiBlcnIgPT0gXCJvYmplY3RcIiAmJiBlcnIgIT09IG51bGwgJiYgXCJjb2RlXCIgaW4gZXJyLCBpc1N1YnNjcmlwdGlvbldpdGhOYW1lID0gKGRvY3VtZW50LCBuYW1lKSA9PiB7XG4gIGxldCBpc1N1YnNjcmlwdGlvbiA9ICExO1xuICByZXR1cm4gdmlzaXQoZG9jdW1lbnQsIHtcbiAgICBPcGVyYXRpb25EZWZpbml0aW9uKG5vZGUpIHtcbiAgICAgIHZhciBfYTtcbiAgICAgIG5hbWUgPT09ICgoX2EgPSBub2RlLm5hbWUpID09IG51bGwgPyB2b2lkIDAgOiBfYS52YWx1ZSkgJiYgbm9kZS5vcGVyYXRpb24gPT09IFwic3Vic2NyaXB0aW9uXCIgJiYgKGlzU3Vic2NyaXB0aW9uID0gITApO1xuICAgIH1cbiAgfSksIGlzU3Vic2NyaXB0aW9uO1xufSwgY3JlYXRlU2ltcGxlRmV0Y2hlciA9IChvcHRpb25zLCBodHRwRmV0Y2gpID0+IGFzeW5jIChncmFwaFFMUGFyYW1zLCBmZXRjaGVyT3B0cykgPT4gKGF3YWl0IGh0dHBGZXRjaChvcHRpb25zLnVybCwge1xuICBtZXRob2Q6IFwiUE9TVFwiLFxuICBib2R5OiBKU09OLnN0cmluZ2lmeShncmFwaFFMUGFyYW1zKSxcbiAgaGVhZGVyczogX19zcHJlYWRWYWx1ZXMoX19zcHJlYWRWYWx1ZXMoe1xuICAgIFwiY29udGVudC10eXBlXCI6IFwiYXBwbGljYXRpb24vanNvblwiXG4gIH0sIG9wdGlvbnMuaGVhZGVycyksIGZldGNoZXJPcHRzID09IG51bGwgPyB2b2lkIDAgOiBmZXRjaGVyT3B0cy5oZWFkZXJzKVxufSkpLmpzb24oKTtcbmFzeW5jIGZ1bmN0aW9uIGNyZWF0ZVdlYnNvY2tldHNGZXRjaGVyRnJvbVVybCh1cmwsIGNvbm5lY3Rpb25QYXJhbXMpIHtcbiAgbGV0IHdzQ2xpZW50O1xuICB0cnkge1xuICAgIGNvbnN0IHsgY3JlYXRlQ2xpZW50IH0gPSBhd2FpdCBpbXBvcnQoXCJncmFwaHFsLXdzXCIpO1xuICAgIHJldHVybiB3c0NsaWVudCA9IGNyZWF0ZUNsaWVudCh7IHVybCwgY29ubmVjdGlvblBhcmFtcyB9KSwgY3JlYXRlV2Vic29ja2V0c0ZldGNoZXJGcm9tQ2xpZW50KHdzQ2xpZW50KTtcbiAgfSBjYXRjaCAoZXJyKSB7XG4gICAgaWYgKGVycm9ySGFzQ29kZShlcnIpICYmIGVyci5jb2RlID09PSBcIk1PRFVMRV9OT1RfRk9VTkRcIilcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgXCJZb3UgbmVlZCB0byBpbnN0YWxsIHRoZSAnZ3JhcGhxbC13cycgcGFja2FnZSB0byB1c2Ugd2Vic29ja2V0cyB3aGVuIHBhc3NpbmcgYSAnc3Vic2NyaXB0aW9uVXJsJ1wiXG4gICAgICApO1xuICAgIGNvbnNvbGUuZXJyb3IoYEVycm9yIGNyZWF0aW5nIHdlYnNvY2tldCBjbGllbnQgZm9yICR7dXJsfWAsIGVycik7XG4gIH1cbn1cbmNvbnN0IGNyZWF0ZVdlYnNvY2tldHNGZXRjaGVyRnJvbUNsaWVudCA9ICh3c0NsaWVudCkgPT4gKGdyYXBoUUxQYXJhbXMpID0+IG1ha2VBc3luY0l0ZXJhYmxlSXRlcmF0b3JGcm9tU2luayhcbiAgKHNpbmspID0+IHdzQ2xpZW50LnN1YnNjcmliZShncmFwaFFMUGFyYW1zLCBfX3NwcmVhZFByb3BzKF9fc3ByZWFkVmFsdWVzKHt9LCBzaW5rKSwge1xuICAgIGVycm9yKGVycikge1xuICAgICAgZXJyIGluc3RhbmNlb2YgQ2xvc2VFdmVudCA/IHNpbmsuZXJyb3IoXG4gICAgICAgIG5ldyBFcnJvcihcbiAgICAgICAgICBgU29ja2V0IGNsb3NlZCB3aXRoIGV2ZW50ICR7ZXJyLmNvZGV9ICR7ZXJyLnJlYXNvbiB8fCBcIlwifWAudHJpbSgpXG4gICAgICAgIClcbiAgICAgICkgOiBzaW5rLmVycm9yKGVycik7XG4gICAgfVxuICB9KSlcbiksIGNyZWF0ZUxlZ2FjeVdlYnNvY2tldHNGZXRjaGVyID0gKGxlZ2FjeVdzQ2xpZW50KSA9PiAoZ3JhcGhRTFBhcmFtcykgPT4ge1xuICBjb25zdCBvYnNlcnZhYmxlID0gbGVnYWN5V3NDbGllbnQucmVxdWVzdChncmFwaFFMUGFyYW1zKTtcbiAgcmV0dXJuIG1ha2VBc3luY0l0ZXJhYmxlSXRlcmF0b3JGcm9tU2luayhcbiAgICAvLyBAdHMtaWdub3JlXG4gICAgKHNpbmspID0+IG9ic2VydmFibGUuc3Vic2NyaWJlKHNpbmspLnVuc3Vic2NyaWJlXG4gICk7XG59LCBjcmVhdGVNdWx0aXBhcnRGZXRjaGVyID0gKG9wdGlvbnMsIGh0dHBGZXRjaCkgPT4gZnVuY3Rpb24oZ3JhcGhRTFBhcmFtcywgZmV0Y2hlck9wdHMpIHtcbiAgcmV0dXJuIF9fYXN5bmNHZW5lcmF0b3IodGhpcywgbnVsbCwgZnVuY3Rpb24qICgpIHtcbiAgICBjb25zdCByZXNwb25zZSA9IHlpZWxkIG5ldyBfX2F3YWl0KGh0dHBGZXRjaChvcHRpb25zLnVybCwge1xuICAgICAgbWV0aG9kOiBcIlBPU1RcIixcbiAgICAgIGJvZHk6IEpTT04uc3RyaW5naWZ5KGdyYXBoUUxQYXJhbXMpLFxuICAgICAgaGVhZGVyczogX19zcHJlYWRWYWx1ZXMoX19zcHJlYWRWYWx1ZXMoe1xuICAgICAgICBcImNvbnRlbnQtdHlwZVwiOiBcImFwcGxpY2F0aW9uL2pzb25cIixcbiAgICAgICAgYWNjZXB0OiBcImFwcGxpY2F0aW9uL2pzb24sIG11bHRpcGFydC9taXhlZFwiXG4gICAgICB9LCBvcHRpb25zLmhlYWRlcnMpLCBmZXRjaGVyT3B0cyA9PSBudWxsID8gdm9pZCAwIDogZmV0Y2hlck9wdHMuaGVhZGVycylcbiAgICB9KS50aGVuKFxuICAgICAgKHIpID0+IG1lcm9zKHIsIHtcbiAgICAgICAgbXVsdGlwbGU6ICEwXG4gICAgICB9KVxuICAgICkpO1xuICAgIGlmICghaXNBc3luY0l0ZXJhYmxlKHJlc3BvbnNlKSlcbiAgICAgIHJldHVybiB5aWVsZCByZXNwb25zZS5qc29uKCk7XG4gICAgdHJ5IHtcbiAgICAgIGZvciAodmFyIGl0ZXIgPSBfX2ZvckF3YWl0KHJlc3BvbnNlKSwgbW9yZSwgdGVtcCwgZXJyb3I7IG1vcmUgPSAhKHRlbXAgPSB5aWVsZCBuZXcgX19hd2FpdChpdGVyLm5leHQoKSkpLmRvbmU7IG1vcmUgPSAhMSkge1xuICAgICAgICBjb25zdCBjaHVuayA9IHRlbXAudmFsdWU7XG4gICAgICAgIGlmIChjaHVuay5zb21lKChwYXJ0KSA9PiAhcGFydC5qc29uKSkge1xuICAgICAgICAgIGNvbnN0IG1lc3NhZ2UgPSBjaHVuay5tYXAoXG4gICAgICAgICAgICAocGFydCkgPT4gYEhlYWRlcnM6OlxuJHtwYXJ0LmhlYWRlcnN9XG5cbkJvZHk6OlxuJHtwYXJ0LmJvZHl9YFxuICAgICAgICAgICk7XG4gICAgICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAgICAgYEV4cGVjdGVkIG11bHRpcGFydCBjaHVua3MgdG8gYmUgb2YganNvbiB0eXBlLiBnb3Q6XG4ke21lc3NhZ2V9YFxuICAgICAgICAgICk7XG4gICAgICAgIH1cbiAgICAgICAgeWllbGQgY2h1bmsubWFwKChwYXJ0KSA9PiBwYXJ0LmJvZHkpO1xuICAgICAgfVxuICAgIH0gY2F0Y2ggKHRlbXApIHtcbiAgICAgIGVycm9yID0gW3RlbXBdO1xuICAgIH0gZmluYWxseSB7XG4gICAgICB0cnkge1xuICAgICAgICBtb3JlICYmICh0ZW1wID0gaXRlci5yZXR1cm4pICYmICh5aWVsZCBuZXcgX19hd2FpdCh0ZW1wLmNhbGwoaXRlcikpKTtcbiAgICAgIH0gZmluYWxseSB7XG4gICAgICAgIGlmIChlcnJvcilcbiAgICAgICAgICB0aHJvdyBlcnJvclswXTtcbiAgICAgIH1cbiAgICB9XG4gIH0pO1xufTtcbmFzeW5jIGZ1bmN0aW9uIGdldFdzRmV0Y2hlcihvcHRpb25zLCBmZXRjaGVyT3B0cykge1xuICBpZiAob3B0aW9ucy53c0NsaWVudClcbiAgICByZXR1cm4gY3JlYXRlV2Vic29ja2V0c0ZldGNoZXJGcm9tQ2xpZW50KG9wdGlvbnMud3NDbGllbnQpO1xuICBpZiAob3B0aW9ucy5zdWJzY3JpcHRpb25VcmwpXG4gICAgcmV0dXJuIGNyZWF0ZVdlYnNvY2tldHNGZXRjaGVyRnJvbVVybChvcHRpb25zLnN1YnNjcmlwdGlvblVybCwgX19zcHJlYWRWYWx1ZXMoX19zcHJlYWRWYWx1ZXMoe30sIG9wdGlvbnMud3NDb25uZWN0aW9uUGFyYW1zKSwgZmV0Y2hlck9wdHMgPT0gbnVsbCA/IHZvaWQgMCA6IGZldGNoZXJPcHRzLmhlYWRlcnMpKTtcbiAgY29uc3QgbGVnYWN5V2Vic29ja2V0c0NsaWVudCA9IG9wdGlvbnMubGVnYWN5Q2xpZW50IHx8IG9wdGlvbnMubGVnYWN5V3NDbGllbnQ7XG4gIGlmIChsZWdhY3lXZWJzb2NrZXRzQ2xpZW50KVxuICAgIHJldHVybiBjcmVhdGVMZWdhY3lXZWJzb2NrZXRzRmV0Y2hlcihsZWdhY3lXZWJzb2NrZXRzQ2xpZW50KTtcbn1cbmV4cG9ydCB7XG4gIGNyZWF0ZUxlZ2FjeVdlYnNvY2tldHNGZXRjaGVyLFxuICBjcmVhdGVNdWx0aXBhcnRGZXRjaGVyLFxuICBjcmVhdGVTaW1wbGVGZXRjaGVyLFxuICBjcmVhdGVXZWJzb2NrZXRzRmV0Y2hlckZyb21DbGllbnQsXG4gIGNyZWF0ZVdlYnNvY2tldHNGZXRjaGVyRnJvbVVybCxcbiAgZ2V0V3NGZXRjaGVyLFxuICBpc1N1YnNjcmlwdGlvbldpdGhOYW1lXG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/lib.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/types.js":
/*!***********************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/create-fetcher/types.js ***!
  \***********************************************************************************************************************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/format/index.js":
/*!***************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/format/index.js ***!
  \***************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatError: () => (/* binding */ formatError),\n/* harmony export */   formatResult: () => (/* binding */ formatResult)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n\nfunction stringify(obj) {\n  return JSON.stringify(obj, null, 2);\n}\nfunction formatSingleError(error) {\n  return (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadProps)((0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, error), {\n    // Raise these details even if they're non-enumerable\n    message: error.message,\n    stack: error.stack\n  });\n}\nfunction handleSingleError(error) {\n  return error instanceof Error ? formatSingleError(error) : error;\n}\nfunction formatError(error) {\n  return Array.isArray(error) ? stringify({\n    errors: error.map((e) => handleSingleError(e))\n  }) : stringify({ errors: [handleSingleError(error)] });\n}\nfunction formatResult(result) {\n  return stringify(result);\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vLi4vbm9kZV9tb2R1bGVzLy5wbnBtL0BncmFwaGlxbCt0b29sa2l0QDAuMTEuM19AdHlwZXMrbm9kZUAyNC45LjBfZ3JhcGhxbC13c0A2LjAuNl9ncmFwaHFsQDE2LjExLjBfd3NAOC4xOC4zX19ncmFwaHFsQDE2LjExLjAvbm9kZV9tb2R1bGVzL0BncmFwaGlxbC90b29sa2l0L2Rpc3QvZXNtL2Zvcm1hdC9pbmRleC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7QUFHOEI7QUFDOUI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLGlFQUFhLENBQUMsa0VBQWMsR0FBRztBQUN4QztBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHLGdCQUFnQixvQ0FBb0M7QUFDdkQ7QUFDQTtBQUNBO0FBQ0E7QUFJRSIsInNvdXJjZXMiOlsid2VicGFjazovL0BzYWdlL3h0cmVtLXVpLXBsdWdpbi1ncmFwaGlxbC8uLi8uLi8uLi9ub2RlX21vZHVsZXMvLnBucG0vQGdyYXBoaXFsK3Rvb2xraXRAMC4xMS4zX0B0eXBlcytub2RlQDI0LjkuMF9ncmFwaHFsLXdzQDYuMC42X2dyYXBocWxAMTYuMTEuMF93c0A4LjE4LjNfX2dyYXBocWxAMTYuMTEuMC9ub2RlX21vZHVsZXMvQGdyYXBoaXFsL3Rvb2xraXQvZGlzdC9lc20vZm9ybWF0L2luZGV4LmpzPzI5OTAiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgX19zcHJlYWRQcm9wcyxcbiAgX19zcHJlYWRWYWx1ZXNcbn0gZnJvbSBcIi4uL2NodW5rLUxNT1FJWFY0LmpzXCI7XG5mdW5jdGlvbiBzdHJpbmdpZnkob2JqKSB7XG4gIHJldHVybiBKU09OLnN0cmluZ2lmeShvYmosIG51bGwsIDIpO1xufVxuZnVuY3Rpb24gZm9ybWF0U2luZ2xlRXJyb3IoZXJyb3IpIHtcbiAgcmV0dXJuIF9fc3ByZWFkUHJvcHMoX19zcHJlYWRWYWx1ZXMoe30sIGVycm9yKSwge1xuICAgIC8vIFJhaXNlIHRoZXNlIGRldGFpbHMgZXZlbiBpZiB0aGV5J3JlIG5vbi1lbnVtZXJhYmxlXG4gICAgbWVzc2FnZTogZXJyb3IubWVzc2FnZSxcbiAgICBzdGFjazogZXJyb3Iuc3RhY2tcbiAgfSk7XG59XG5mdW5jdGlvbiBoYW5kbGVTaW5nbGVFcnJvcihlcnJvcikge1xuICByZXR1cm4gZXJyb3IgaW5zdGFuY2VvZiBFcnJvciA/IGZvcm1hdFNpbmdsZUVycm9yKGVycm9yKSA6IGVycm9yO1xufVxuZnVuY3Rpb24gZm9ybWF0RXJyb3IoZXJyb3IpIHtcbiAgcmV0dXJuIEFycmF5LmlzQXJyYXkoZXJyb3IpID8gc3RyaW5naWZ5KHtcbiAgICBlcnJvcnM6IGVycm9yLm1hcCgoZSkgPT4gaGFuZGxlU2luZ2xlRXJyb3IoZSkpXG4gIH0pIDogc3RyaW5naWZ5KHsgZXJyb3JzOiBbaGFuZGxlU2luZ2xlRXJyb3IoZXJyb3IpXSB9KTtcbn1cbmZ1bmN0aW9uIGZvcm1hdFJlc3VsdChyZXN1bHQpIHtcbiAgcmV0dXJuIHN0cmluZ2lmeShyZXN1bHQpO1xufVxuZXhwb3J0IHtcbiAgZm9ybWF0RXJyb3IsXG4gIGZvcm1hdFJlc3VsdFxufTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/format/index.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/auto-complete.js":
/*!********************************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/auto-complete.js ***!
  \********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   fillLeafs: () => (/* binding */ fillLeafs)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/type/definition.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/kinds.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/parser.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/printer.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/visitor.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/utilities/TypeInfo.mjs\");\n\n\nfunction fillLeafs(schema, docString, getDefaultFieldNames) {\n  const insertions = [];\n  if (!schema || !docString)\n    return { insertions, result: docString };\n  let ast;\n  try {\n    ast = (0,graphql__WEBPACK_IMPORTED_MODULE_3__.parse)(docString);\n  } catch (e) {\n    return { insertions, result: docString };\n  }\n  const fieldNameFn = getDefaultFieldNames || defaultGetDefaultFieldNames, typeInfo = new graphql__WEBPACK_IMPORTED_MODULE_6__.TypeInfo(schema);\n  return (0,graphql__WEBPACK_IMPORTED_MODULE_5__.visit)(ast, {\n    leave(node) {\n      typeInfo.leave(node);\n    },\n    enter(node) {\n      if (typeInfo.enter(node), node.kind === \"Field\" && !node.selectionSet) {\n        const fieldType = typeInfo.getType(), selectionSet = buildSelectionSet(\n          isFieldType(fieldType),\n          fieldNameFn\n        );\n        if (selectionSet && node.loc) {\n          const indent = getIndentation(docString, node.loc.start);\n          insertions.push({\n            index: node.loc.end,\n            string: \" \" + (0,graphql__WEBPACK_IMPORTED_MODULE_4__.print)(selectionSet).replaceAll(`\n`, `\n` + indent)\n          });\n        }\n      }\n    }\n  }), {\n    insertions,\n    result: withInsertions(docString, insertions)\n  };\n}\nfunction defaultGetDefaultFieldNames(type) {\n  if (!(\"getFields\" in type))\n    return [];\n  const fields = type.getFields();\n  if (fields.id)\n    return [\"id\"];\n  if (fields.edges)\n    return [\"edges\"];\n  if (fields.node)\n    return [\"node\"];\n  const leafFieldNames = [];\n  for (const fieldName of Object.keys(fields))\n    (0,graphql__WEBPACK_IMPORTED_MODULE_1__.isLeafType)(fields[fieldName].type) && leafFieldNames.push(fieldName);\n  return leafFieldNames;\n}\nfunction buildSelectionSet(type, getDefaultFieldNames) {\n  const namedType = (0,graphql__WEBPACK_IMPORTED_MODULE_1__.getNamedType)(type);\n  if (!type || (0,graphql__WEBPACK_IMPORTED_MODULE_1__.isLeafType)(type))\n    return;\n  const fieldNames = getDefaultFieldNames(namedType);\n  if (!(!Array.isArray(fieldNames) || fieldNames.length === 0 || !(\"getFields\" in namedType)))\n    return {\n      kind: graphql__WEBPACK_IMPORTED_MODULE_2__.Kind.SELECTION_SET,\n      selections: fieldNames.map((fieldName) => {\n        const fieldDef = namedType.getFields()[fieldName], fieldType = fieldDef ? fieldDef.type : null;\n        return {\n          kind: graphql__WEBPACK_IMPORTED_MODULE_2__.Kind.FIELD,\n          name: {\n            kind: graphql__WEBPACK_IMPORTED_MODULE_2__.Kind.NAME,\n            value: fieldName\n          },\n          // we can use as here, because we already know that fieldType\n          // comes from an origin parameter\n          selectionSet: buildSelectionSet(fieldType, getDefaultFieldNames)\n        };\n      })\n    };\n}\nfunction withInsertions(initial, insertions) {\n  if (insertions.length === 0)\n    return initial;\n  let edited = \"\", prevIndex = 0;\n  for (const { index, string } of insertions)\n    edited += initial.slice(prevIndex, index) + string, prevIndex = index;\n  return edited += initial.slice(prevIndex), edited;\n}\nfunction getIndentation(str, index) {\n  let indentStart = index, indentEnd = index;\n  for (; indentStart; ) {\n    const c = str.charCodeAt(indentStart - 1);\n    if (c === 10 || c === 13 || c === 8232 || c === 8233)\n      break;\n    indentStart--, c !== 9 && c !== 11 && c !== 12 && c !== 32 && c !== 160 && (indentEnd = indentStart);\n  }\n  return str.slice(indentStart, indentEnd);\n}\nfunction isFieldType(fieldType) {\n  if (fieldType)\n    return fieldType;\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/auto-complete.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/index.js":
/*!************************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/index.js ***!
  \************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   fillLeafs: () => (/* reexport safe */ _auto_complete__WEBPACK_IMPORTED_MODULE_0__.fillLeafs),\n/* harmony export */   getSelectedOperationName: () => (/* reexport safe */ _operation_name__WEBPACK_IMPORTED_MODULE_2__.getSelectedOperationName),\n/* harmony export */   mergeAst: () => (/* reexport safe */ _merge_ast__WEBPACK_IMPORTED_MODULE_1__.mergeAst)\n/* harmony export */ });\n/* harmony import */ var _auto_complete__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./auto-complete */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/auto-complete.js\");\n/* harmony import */ var _merge_ast__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./merge-ast */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/merge-ast.js\");\n/* harmony import */ var _operation_name__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./operation-name */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/operation-name.js\");\n\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vLi4vbm9kZV9tb2R1bGVzLy5wbnBtL0BncmFwaGlxbCt0b29sa2l0QDAuMTEuM19AdHlwZXMrbm9kZUAyNC45LjBfZ3JhcGhxbC13c0A2LjAuNl9ncmFwaHFsQDE2LjExLjBfd3NAOC4xOC4zX19ncmFwaHFsQDE2LjExLjAvbm9kZV9tb2R1bGVzL0BncmFwaGlxbC90b29sa2l0L2Rpc3QvZXNtL2dyYXBocWwtaGVscGVycy9pbmRleC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBZ0M7QUFDSjtBQUNLIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQHNhZ2UveHRyZW0tdWktcGx1Z2luLWdyYXBoaXFsLy4uLy4uLy4uL25vZGVfbW9kdWxlcy8ucG5wbS9AZ3JhcGhpcWwrdG9vbGtpdEAwLjExLjNfQHR5cGVzK25vZGVAMjQuOS4wX2dyYXBocWwtd3NANi4wLjZfZ3JhcGhxbEAxNi4xMS4wX3dzQDguMTguM19fZ3JhcGhxbEAxNi4xMS4wL25vZGVfbW9kdWxlcy9AZ3JhcGhpcWwvdG9vbGtpdC9kaXN0L2VzbS9ncmFwaHFsLWhlbHBlcnMvaW5kZXguanM/ZGRmMiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgKiBmcm9tIFwiLi9hdXRvLWNvbXBsZXRlXCI7XG5leHBvcnQgKiBmcm9tIFwiLi9tZXJnZS1hc3RcIjtcbmV4cG9ydCAqIGZyb20gXCIuL29wZXJhdGlvbi1uYW1lXCI7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/index.js\n\n}");

/***/ }),

/***/ "../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/merge-ast.js":
/*!****************************************************************************************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/graphql-helpers/merge-ast.js ***!
  \****************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   mergeAst: () => (/* binding */ mergeAst)\n/* harmony export */ });\n/* harmony import */ var _chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunk-LMOQIXV4.js */ \"../../../node_modules/.pnpm/@graphiql+toolkit@0.11.3_@types+node@24.9.0_graphql-ws@6.0.6_graphql@16.11.0_ws@8.18.3__graphql@16.11.0/node_modules/@graphiql/toolkit/dist/esm/chunk-LMOQIXV4.js\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/type/definition.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/kinds.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/language/visitor.mjs\");\n/* harmony import */ var graphql__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! graphql */ \"../../../node_modules/.pnpm/graphql@16.11.0/node_modules/graphql/utilities/TypeInfo.mjs\");\n\n\nfunction uniqueBy(array, iteratee) {\n  var _a;\n  const FilteredMap = /* @__PURE__ */ new Map(), result = [];\n  for (const item of array)\n    if (item.kind === \"Field\") {\n      const uniqueValue = iteratee(item), existing = FilteredMap.get(uniqueValue);\n      if ((_a = item.directives) != null && _a.length) {\n        const itemClone = (0,_chunk_LMOQIXV4_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, item);\n        result.push(itemClone);\n      } else if (