import * as React from 'react';
import { renderToStaticMarkup } from 'react-dom/server';
import { ButtonView } from '@ckeditor/ckeditor5-ui';
import { COMMAND_ZOOM_OUT } from '../../constants';
import { Plugin } from '@ckeditor/ckeditor5-core';
export default class ZoomOutUi extends Plugin {
    constructor() {
        super(...arguments);
        this.zoomOut = () => {
            this.editor.fire(COMMAND_ZOOM_OUT);
        };
    }
    static get pluginName() {
        return 'ZoomOutUi';
    }
    init() {
        const editor = this.editor;
        // Add bold button to feature components.
        editor.ui.componentFactory.add(COMMAND_ZOOM_OUT, (locale) => {
            this.view = new ButtonView(locale);
            const { localize } = this.editor.config.get('reportEditorConfig');
            this.view.set({
                label: localize('@sage/xtrem-document-editor/zoom-out', 'Zoom out'),
                icon: renderToStaticMarkup(React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", width: "20", height: "20", viewBox: "0 0 20 20", fill: "none" },
                    React.createElement("path", { d: "M16.3 11H3.7C3.28 11 3 10.6 3 10C3 9.4 3.28 9 3.7 9H16.3C16.72 9 17 9.4 17 10C17 10.6 16.72 11 16.3 11Z", fill: "#000000e6" }))),
                tooltip: true,
                isToggleable: true,
                isEnabled: true,
            });
            this.listenTo(this.view, 'execute', this.zoomOut);
            return this.view;
        });
    }
}
//# sourceMappingURL=zoom-out-ui.js.map