import { Element } from '@ckeditor/ckeditor5-engine';
import { ATTR_CONTEXT_CONDITION, ATTR_CONTEXT_FILTER, ATTR_CONTEXT_LIST_ORDER, ATTR_CONTEXT_OBJECT_TYPE, ATTR_FOOTER_GROUP, ATTR_PROPERTY_DATA_FORMAT, ATTR_PROPERTY_DATA_TYPE, } from '@sage/xtrem-shared';
export const getSelectedPropertyDataTypeAndFormat = (editor) => {
    const model = editor.model;
    const selection = model.document.selection;
    const isProperty = model.schema.checkChild(selection.focus?.parent, 'property');
    if (!isProperty) {
        return null;
    }
    const selectedElement = [...selection.getRanges()][0]?.getContainedElement();
    if (!selectedElement) {
        return null;
    }
    const dataType = selectedElement.getAttribute(ATTR_PROPERTY_DATA_TYPE) || null;
    const format = selectedElement.getAttribute(ATTR_PROPERTY_DATA_FORMAT) || null;
    return { dataType, format };
};
export const getSelectedPropertyFormat = (editor) => {
    const model = editor.model;
    const selection = model.document.selection;
    const isProperty = model.schema.checkChild(selection.focus?.parent, 'property');
    if (!isProperty) {
        return null;
    }
    const selectedElement = [...selection.getRanges()][0]?.getContainedElement();
    if (!selectedElement) {
        return null;
    }
    return selectedElement.getAttribute(ATTR_PROPERTY_DATA_TYPE) || null;
};
export function isTableElement(element) {
    const table = element.findAncestor('queryTable');
    return Boolean(table);
}
export function isDataContainer(element) {
    const recordContext = element.findAncestor('recordContext');
    return Boolean(recordContext);
}
export function getContextObjectType(element) {
    const contextObjectType = element?.getAttribute(ATTR_CONTEXT_OBJECT_TYPE);
    if (contextObjectType) {
        return String(contextObjectType);
    }
    if (element?.parent) {
        return getContextObjectType(element.parent);
    }
    return '$root';
}
export function getContextSortOrder(element) {
    const orderByAttribute = element?.getAttribute(ATTR_CONTEXT_LIST_ORDER);
    if (orderByAttribute) {
        return JSON.parse(String(orderByAttribute));
    }
    if (element?.parent) {
        return getContextSortOrder(element.parent);
    }
    return null;
}
export function getContextFilter(element) {
    const filtersAttribute = element?.getAttribute(ATTR_CONTEXT_FILTER);
    if (filtersAttribute) {
        return JSON.parse(String(filtersAttribute));
    }
    if (element?.parent) {
        return getContextFilter(element.parent);
    }
    return null;
}
export function getContextCondition(element) {
    const conditionAttribute = element?.getAttribute(ATTR_CONTEXT_CONDITION);
    if (conditionAttribute) {
        return JSON.parse(String(conditionAttribute));
    }
    if (element?.parent) {
        return getContextCondition(element.parent);
    }
    return null;
}
export function findChildElementsByName(elementName, parentElement, collector = []) {
    const children = [...(parentElement?.getChildren?.() || [])];
    children.forEach(c => {
        if (c instanceof Element) {
            if (c.is('element', elementName)) {
                collector.push(c);
            }
            else {
                findChildElementsByName(elementName, c, collector);
            }
        }
    });
    return collector;
}
export function getSelectedItemsFromProperties(properties) {
    return (properties ?? []).reduce((acc, item) => {
        acc[item.name] = {
            ...item,
            id: item.name,
            data: item,
            key: item.name,
            label: item.label,
            labelKey: item.name,
            labelPath: item.name,
            node: item.node,
        };
        return acc;
    }, {});
}
export function generateQueryAlias() {
    if (window.navigator.webdriver) {
        // In automation we need to hard code this so the generated alias is predictable
        return 'TEST_ALIAS';
    }
    let result = '';
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    const charactersLength = characters.length;
    let counter = 0;
    while (counter < 8) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
        counter += 1;
    }
    return result;
}
export function getFooterGroup(element) {
    const footerGroupAttribute = element?.getAttribute(ATTR_FOOTER_GROUP);
    if (footerGroupAttribute) {
        return footerGroupAttribute;
    }
    if (element?.parent) {
        return getFooterGroup(element.parent);
    }
    return null;
}
//# sourceMappingURL=utils.js.map