import type { Editor } from '@ckeditor/ckeditor5-core';
import type { DocumentFragment } from '@ckeditor/ckeditor5-engine';
import { Element } from '@ckeditor/ckeditor5-engine';
import type { Dict, FilterProperty } from '@sage/xtrem-shared';
import type { ConditionEditorProperty, Order, TableContentWithGroupsProps } from '@sage/xtrem-ui-components';
import type { DataModelProperty, DataModelPropertyType } from '../context-provider';
export declare const getSelectedPropertyDataTypeAndFormat: (editor: Editor) => {
    dataType: DataModelPropertyType | null;
    format: string | number | null;
} | null;
export declare const getSelectedPropertyFormat: (editor: Editor) => string | number | null;
export declare function isTableElement(element: Element): boolean;
export declare function isDataContainer(element: Element): boolean;
export declare function getContextObjectType(element?: Element | DocumentFragment): string | null;
export declare function getContextSortOrder(element?: Element | DocumentFragment): Dict<Order> | null;
export declare function getContextFilter(element?: Element | DocumentFragment): Array<FilterProperty> | null;
export declare function getContextCondition(element?: Element | DocumentFragment): ConditionEditorProperty[] | null;
export declare function findChildElementsByName(elementName: string, parentElement: Element, collector?: Element[]): Element[];
export declare function getSelectedItemsFromProperties(properties: DataModelProperty[] | null): NonNullable<TableContentWithGroupsProps['selectedItems']>;
export declare function generateQueryAlias(): string;
export declare function getFooterGroup(element?: Element | DocumentFragment): any | null;
//# sourceMappingURL=utils.d.ts.map