// unbreakablebox/insertunbreakableboxcommand.js
import { Command } from '@ckeditor/ckeditor5-core';
export default class InsertUnbreakableBlockCommand extends Command {
    execute() {
        this.editor.model.change(writer => {
            this.editor.model.insertObject(this._createUnbreakableBlock(writer));
        });
    }
    refresh() {
        const model = this.editor.model;
        const selection = model.document.selection;
        const position = selection.getFirstPosition();
        if (position === null) {
            return;
        }
        const allowedIn = model.schema.findAllowedParent(position, 'unbreakableBlock');
        this.isEnabled = allowedIn !== null;
    }
    _createUnbreakableBlock(writer) {
        const unbreakableBlock = writer.createElement('unbreakableBlock');
        const unbreakableBlockBody = writer.createElement('unbreakableBlockBody');
        writer.append(unbreakableBlockBody, unbreakableBlock);
        writer.appendElement('paragraph', unbreakableBlockBody);
        return unbreakableBlock;
    }
}
//# sourceMappingURL=insert-unbreakable-block-command.js.map