import { Element } from '@ckeditor/ckeditor5-engine';
import type { Conversion, Item, Position, Schema, Writer } from '@ckeditor/ckeditor5-engine';
import type QueryTableUtils from './query-table-utils';
/**
 * A common method to update the numeric value. If a value is the default one, it will be unset.
 *
 * @param key An attribute key.
 * @param value The new attribute value.
 * @param item A model item on which the attribute will be set.
 * @param defaultValue The default attribute value. If a value is lower or equal, it will be unset.
 */
export declare function updateNumericAttribute(key: string, value: number, item: Item, writer: Writer, defaultValue?: number): void;
/**
 * A common method to create an empty table cell. It creates a proper model structure as a table cell must have at least one block inside.
 *
 * @param writer The model writer.
 * @param insertPosition The position at which the table cell should be inserted.
 * @param attributes The element attributes.
 * @returns Created table cell.
 */
export declare function createEmptyTableCell(writer: Writer, insertPosition: Position, attributes?: Record<string, unknown>): Element;
/**
 * Checks if a table cell belongs to the heading column section.
 */
export declare function isHeadingColumnCell(tableUtils: QueryTableUtils, tableCell: Element): boolean;
/**
 * Enables conversion for an attribute for simple view-model mappings.
 *
 * @param options.defaultValue The default value for the specified `modelAttribute`.
 */
export declare function enableProperty(schema: Schema, conversion: Conversion, options: {
    modelAttribute: string;
    styleName: string;
    defaultValue: string;
    reduceBoxSides?: boolean;
}): void;
export declare function getRows(tableElement: Element): Array<Element>;
//# sourceMappingURL=common.d.ts.map