import { Plugin } from '@ckeditor/ckeditor5-core';
/**
 * This plugin enables a table cells' selection with the mouse.
 * It is loaded automatically by the {@link module:table/table~Table} plugin.
 */
export default class QueryTableMouse extends Plugin {
    /**
     * @inheritDoc
     */
    static get pluginName(): string;
    /**
     * @inheritDoc
     */
    static get requires(): Array<typeof Plugin>;
    /**
     * @inheritDoc
     */
    init(): void;
    /**
     * Enables making cells selection by <kbd>Shift</kbd>+click. Creates a selection from the cell which previously held
     * the selection to the cell which was clicked. It can be the same cell, in which case it selects a single cell.
     */
    private _enableShiftClickSelection;
    /**
     * Enables making cells selection by dragging.
     *
     * The selection is made only on mousemove. Mouse tracking is started on mousedown.
     * However, the cells selection is enabled only after the mouse cursor left the anchor cell.
     * Thanks to that normal text selection within one cell works just fine. However, you can still select
     * just one cell by leaving the anchor cell and moving back to it.
     */
    private _enableMouseDragSelection;
    /**
     * Returns the model table cell element based on the target element of the passed DOM event.
     *
     * @returns Returns the table cell or `undefined`.
     */
    private _getModelTableCellFromDomEvent;
}
//# sourceMappingURL=query-table-mouse.d.ts.map