import type { Batch, Element } from '@ckeditor/ckeditor5-engine';
import { Command, type Editor } from '@ckeditor/ckeditor5-core';
export interface TableRowPropertyCommandExecuteOptions {
    value?: string;
    batch?: Batch;
}
/**
 * The table row attribute command.
 *
 * This command is a base command for other table property commands.
 */
export default class QueryTableRowPropertyCommand extends Command {
    /**
     * The attribute that will be set by the command.
     */
    readonly attributeName: string;
    /**
     * The default value for the attribute.
     */
    protected readonly _defaultValue: string | undefined;
    /**
     * Creates a new `TableRowPropertyCommand` instance.
     *
     * @param editor An editor in which this command will be used.
     * @param attributeName Table cell attribute name.
     * @param defaultValue The default value of the attribute.
     */
    constructor(editor: Editor, attributeName: string, defaultValue?: string);
    /**
     * @inheritDoc
     */
    refresh(): void;
    /**
     * Executes the command.
     *
     * @fires execute
     * @param options.value If set, the command will set the attribute on the selected table.
     * If not set, the command will remove the attribute from the selected table.
     * @param options.batch Pass the model batch instance to the command to aggregate changes,
     * for example, to allow a single undo step for multiple executions.
     */
    execute(options?: TableRowPropertyCommandExecuteOptions): void;
    /**
     * Returns the attribute value for a table.
     */
    protected _getValue(tableRow: Element): unknown;
    /**
     * Returns the proper model value. It can be used to add a default unit to numeric values.
     */
    protected _getValueToSet(value: string | number | undefined): string | number | undefined;
}
//# sourceMappingURL=query-table-row-property-command.d.ts.map