import { Command } from '@ckeditor/ckeditor5-core';
import { ATTR_PROPERTY_DATA_FORMAT, ATTR_PROPERTY_DATA_TYPE, ATTR_PROPERTY_DISPLAY_LABEL, ATTR_PROPERTY_NAME, ATTR_PROPERTY_PARENT_CONTEXT_TYPE, } from '@sage/xtrem-shared';
import { isEnumField } from '@sage/xtrem-ui-components';
import { DATA_FORMAT_DECIMAL, DATA_FORMAT_ENUM } from '../../constants';
import { getContextObjectType } from '../utils';
export default class InsertPropertyCommand extends Command {
    static { this.getDataFormat = (itemDetails) => {
        if (itemDetails.type === 'Date') {
            return 'FullDate';
        }
        if (isEnumField(itemDetails)) {
            return DATA_FORMAT_ENUM;
        }
        if (itemDetails.type === 'Decimal' || itemDetails.type === 'Float') {
            return DATA_FORMAT_DECIMAL;
        }
        return '';
    }; }
    static { this.createPropertyElement = (propertyKey, itemDetails, recordContext, writer) => {
        return writer.createElement('property', {
            [ATTR_PROPERTY_NAME]: propertyKey,
            [ATTR_PROPERTY_DISPLAY_LABEL]: itemDetails.label,
            [ATTR_PROPERTY_DATA_TYPE]: itemDetails.type,
            [ATTR_PROPERTY_DATA_FORMAT]: InsertPropertyCommand.getDataFormat(itemDetails),
            [ATTR_PROPERTY_PARENT_CONTEXT_TYPE]: recordContext,
        });
    }; }
    execute({ selectedItem, remapInfo, recordContext, }) {
        const editor = this.editor;
        editor.model.change(writer => {
            // Create a <placeholder> element with the "name" attribute (and all the selection attributes)...
            const placeholder = InsertPropertyCommand.createPropertyElement(remapInfo.path, selectedItem.data, recordContext, writer);
            // ... and insert it into the document. Put the selection on the inserted element.
            editor.model.insertObject(placeholder);
        });
    }
    refresh() {
        const model = this.editor.model;
        const selection = model.document.selection;
        const isAllowed = model.schema.checkChild(selection.focus?.parent, 'property');
        const contextObjectType = getContextObjectType(selection.focus?.parent);
        this.isEnabled = isAllowed && !!contextObjectType;
    }
}
//# sourceMappingURL=insert-property-command.js.map