import { Command } from '@ckeditor/ckeditor5-core';
import { Position } from '@ckeditor/ckeditor5-engine';
import { ATTR_CONTEXT_CONDITION } from '@sage/xtrem-shared';
import { isNil } from 'lodash';
import { getContextObjectType } from '../utils';
import { writeConditionComment } from './conditional-block-utils';
export default class ConditionalBlockInsertCommand extends Command {
    constructor(editor) {
        super(editor);
        this.parameters = [];
        this.insertCondition = (conditions) => {
            if (isNil(conditions)) {
                return;
            }
            this.editor.model.change(writer => {
                const conditionalBlockElement = writer.createElement('conditionalBlock', {
                    [ATTR_CONTEXT_CONDITION]: JSON.stringify(conditions),
                });
                const conditionalBlockBodyElement = writer.createElement('conditionalBlockBody');
                const conditionalBlockFooterElement = writer.createElement('conditionalBlockFooter');
                writer.append(conditionalBlockBodyElement, conditionalBlockElement);
                writer.append(conditionalBlockFooterElement, conditionalBlockElement);
                this.editor.model.insertObject(conditionalBlockElement);
                this.htmlCommentPlugin.createHtmlComment(new Position(conditionalBlockElement.root, conditionalBlockFooterElement.getPath(), 'toNext'), '{{/if}}');
                writeConditionComment(this.htmlCommentPlugin, conditions, conditionalBlockBodyElement, this.parameters);
            });
        };
        const reportEditorConfig = this.editor.config.get('reportEditorConfig');
        reportEditorConfig.contextProvider.getDocumentParameters().then(parameters => {
            this.parameters = parameters || [];
        });
    }
    get htmlCommentPlugin() {
        return this.editor.plugins.get('HtmlComment');
    }
    execute() {
        const selection = this.editor.model.document.selection;
        const contextObjectType = getContextObjectType(selection.focus?.parent);
        if (!contextObjectType) {
            return;
        }
        const reportEditorConfig = this.editor.config.get('reportEditorConfig');
        const conditionDialogRequest = {
            existingConditions: [],
            onFinished: this.insertCondition,
        };
        reportEditorConfig.onOpenConditionDialog(conditionDialogRequest);
    }
    refresh() {
        const model = this.editor.model;
        const selection = model.document.selection;
        const position = selection.getFirstPosition();
        if (position === null) {
            return;
        }
        const allowedIn = model.schema.findAllowedParent(position, 'conditionalBlock');
        const contextObjectType = getContextObjectType(selection.focus?.parent);
        this.isEnabled = allowedIn !== null && !!contextObjectType && contextObjectType !== '$root';
    }
}
//# sourceMappingURL=conditional-block-insert-command.js.map