import * as React from 'react';
import { createRoot } from 'react-dom/client';
import GlobalStyle from 'carbon-react/esm/style/global-style';
import CKEditorInspector from '@ckeditor/ckeditor5-inspector';
import XtremDocumentEditor from '.';
import CarbonProvider from 'carbon-react/esm/components/carbon-provider';
import sageTheme from 'carbon-react/esm/style/themes/sage';
import { LOCAL_STORAGE_FOOTER_KEY, LOCAL_STORAGE_HEADER_KEY, LOCAL_STORAGE_KEY, LOCAL_STORAGE_MARGIN_BOTTOM_KEY, LOCAL_STORAGE_MARGIN_LEFT_KEY, LOCAL_STORAGE_MARGIN_RIGHT_KEY, LOCAL_STORAGE_MARGIN_TOP_KEY, LOCAL_STORAGE_ORIENTATION_KEY, LOCAL_STORAGE_SIZE_KEY, } from './constants';
import Toast from 'carbon-react/esm/components/toast';
import Switch from 'carbon-react/esm/components/switch';
import { compile } from 'handlebars';
import { GridRow, GridColumn } from '@sage/xtrem-ui-components';
import { Select, Option } from 'carbon-react/esm/components/select';
import NumberComponent from 'carbon-react/esm/components/number';
import 'carbon-react/esm/style/fonts.css';
import './style.scss';
import { fakeContextProvider } from './consumer-mock-static-definitions';
const fakeCarbonLocale = () => ({});
function ConsumerMock() {
    const [value, setValue] = React.useState(window.localStorage.getItem(LOCAL_STORAGE_KEY) || '');
    const [headerValue, setHeaderValue] = React.useState(window.localStorage.getItem(LOCAL_STORAGE_HEADER_KEY) || '');
    const [footerValue, setFooterValue] = React.useState(window.localStorage.getItem(LOCAL_STORAGE_FOOTER_KEY) || '');
    const [notificationRequest, setNotificationRequest] = React.useState(null);
    const [isDisabled, setDisabled] = React.useState(false);
    const [paperSize, setPaperSize] = React.useState(window.localStorage.getItem(LOCAL_STORAGE_SIZE_KEY) || 'a4');
    const [paperOrientation, setPaperOrientation] = React.useState(window.localStorage.getItem(LOCAL_STORAGE_ORIENTATION_KEY) || 'portrait');
    const [marginTop, setMarginTop] = React.useState(Number(window.localStorage.getItem(LOCAL_STORAGE_MARGIN_TOP_KEY) || '2'));
    const [marginRight, setMarginRight] = React.useState(Number(window.localStorage.getItem(LOCAL_STORAGE_MARGIN_RIGHT_KEY) || '2'));
    const [marginBottom, setMarginBottom] = React.useState(Number(window.localStorage.getItem(LOCAL_STORAGE_MARGIN_BOTTOM_KEY) || '2'));
    const [marginLeft, setMarginLeft] = React.useState(Number(window.localStorage.getItem(LOCAL_STORAGE_MARGIN_LEFT_KEY) || '2'));
    const onDisplayNotification = React.useCallback((content, type) => {
        setNotificationRequest({ content, type });
        setTimeout(() => setNotificationRequest(null), 5000);
    }, []);
    const onReady = React.useCallback((editor) => {
        window.EDITOR = editor;
        CKEditorInspector.attach(editor);
    }, []);
    const onFocus = React.useCallback(() => {
        // eslint-disable-next-line no-console
        console.log('EDITOR FOCUSED');
    }, []);
    const onBlur = React.useCallback(() => {
        // eslint-disable-next-line no-console
        console.log('EDITOR BLURRED');
    }, []);
    const onMarginTopChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_MARGIN_TOP_KEY, event.target.value);
        setMarginTop(Number(event.target.value || '0'));
    }, []);
    const onMarginBottomChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_MARGIN_BOTTOM_KEY, event.target.value);
        setMarginBottom(Number(event.target.value || '0'));
    }, []);
    const onMarginLeftChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_MARGIN_LEFT_KEY, event.target.value);
        setMarginLeft(Number(event.target.value || '0'));
    }, []);
    const onMarginRightChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_MARGIN_RIGHT_KEY, event.target.value);
        setMarginRight(Number(event.target.value || '0'));
    }, []);
    const onPaperSizeChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_SIZE_KEY, event.target.value);
        setPaperSize(event.target.value);
    }, []);
    const onPaperOrientationChanged = React.useCallback((event) => {
        window.localStorage.setItem(LOCAL_STORAGE_ORIENTATION_KEY, event.target.value);
        setPaperOrientation(event.target.value);
    }, []);
    const onChange = React.useCallback((newValue) => {
        window.localStorage.setItem(LOCAL_STORAGE_KEY, newValue);
        setValue(newValue);
        // eslint-disable-next-line no-console
        console.log('Body value changed', newValue);
    }, []);
    const onHeaderChange = React.useCallback((newValue) => {
        window.localStorage.setItem(LOCAL_STORAGE_HEADER_KEY, newValue);
        setHeaderValue(newValue);
        // eslint-disable-next-line no-console
        console.log('Header value changed', newValue);
    }, []);
    const onFooterChange = React.useCallback((newValue) => {
        window.localStorage.setItem(LOCAL_STORAGE_FOOTER_KEY, newValue);
        setFooterValue(newValue);
        // eslint-disable-next-line no-console
        console.log('Footer value changed', newValue);
    }, []);
    const localize = React.useCallback((_, literal, context) => compile(literal)(context), []);
    const localizeEnumMember = () => 'FakeNode';
    return (React.createElement(CarbonProvider, { theme: sageTheme },
        React.createElement("div", { className: "App" },
            React.createElement(GlobalStyle, null),
            React.createElement(Toast, { open: !!notificationRequest, onDismiss: () => setNotificationRequest(null), variant: notificationRequest?.type },
                React.createElement("div", { "data-testid": "notification-content" }, notificationRequest?.content)),
            React.createElement("div", null,
                React.createElement(GridRow, { columns: 12, gutter: 8, margin: 12 },
                    React.createElement(GridColumn, { columnSpan: 12 },
                        React.createElement("h2", null, "Document editor"),
                        React.createElement(XtremDocumentEditor, { carbonLocale: fakeCarbonLocale, contextProvider: fakeContextProvider, footerValue: footerValue, headerValue: headerValue, isDisabled: isDisabled, locale: "en-US", localize: localize, localizeEnumMember: localizeEnumMember, marginBottom: marginBottom, marginLeft: marginLeft, marginRight: marginRight, marginTop: marginTop, onBlur: onBlur, onChange: onChange, onDisplayNotification: onDisplayNotification, onFocus: onFocus, onFooterChange: onFooterChange, onHeaderChange: onHeaderChange, onReady: onReady, paperOrientation: paperOrientation, paperSize: paperSize, value: value })),
                    React.createElement(GridColumn, { columnSpan: 2 },
                        React.createElement(Select, { id: "paperSize", name: "paperSize", value: paperSize, onChange: onPaperSizeChanged, label: "Paper size" },
                            React.createElement(Option, { text: "A0", value: "a0" }),
                            React.createElement(Option, { text: "A1", value: "a1" }),
                            React.createElement(Option, { text: "A2", value: "a2" }),
                            React.createElement(Option, { text: "A3", value: "a3" }),
                            React.createElement(Option, { text: "A4", value: "a4" }),
                            React.createElement(Option, { text: "A5", value: "a5" }),
                            React.createElement(Option, { text: "A6", value: "a6" }),
                            React.createElement(Option, { text: "Letter", value: "ledger" }),
                            React.createElement(Option, { text: "Legal", value: "legal" }),
                            React.createElement(Option, { text: "Tabloid", value: "tabloid" }),
                            React.createElement(Option, { text: "Ledger", value: "ledger" }))),
                    React.createElement(GridColumn, { columnSpan: 2 },
                        React.createElement(Select, { id: "paperOrientation", name: "paperOrientation", value: paperOrientation, onChange: onPaperOrientationChanged, label: "Paper Orientation" },
                            React.createElement(Option, { text: "Portrait", value: "portrait" }),
                            React.createElement(Option, { text: "Landscape", value: "landscape" }),
                            React.createElement(Option, { text: "Full screen", value: "fullScreen" }))),
                    React.createElement(GridColumn, { columnSpan: 1 },
                        React.createElement(NumberComponent, { label: "Margin top", name: "marginTop", value: String(marginTop), onChange: onMarginTopChanged })),
                    React.createElement(GridColumn, { columnSpan: 1 },
                        React.createElement(NumberComponent, { label: "Margin right", name: "marginRight", value: String(marginRight), onChange: onMarginRightChanged })),
                    React.createElement(GridColumn, { columnSpan: 1 },
                        React.createElement(NumberComponent, { label: "Margin bottom", name: "marginBottom", value: String(marginBottom), onChange: onMarginBottomChanged })),
                    React.createElement(GridColumn, { columnSpan: 1 },
                        React.createElement(NumberComponent, { label: "Margin left", name: "marginLeft", value: String(marginLeft), onChange: onMarginLeftChanged })),
                    React.createElement(GridColumn, { columnSpan: 1 },
                        React.createElement(Switch, { label: "Is disabled?", name: "isEditorDisabled", onChange: (e) => {
                                setDisabled(e.target.checked);
                            }, checked: isDisabled })),
                    React.createElement(GridColumn, { columnSpan: 12 },
                        React.createElement("h2", null, "Body value"),
                        React.createElement("textarea", { id: "bodyValue", style: { width: '100%', height: '600px' }, onChange: (e) => {
                                onChange(e.target.value || '');
                            } }, value)),
                    React.createElement(GridColumn, { columnSpan: 12 },
                        React.createElement("h2", null, "Header value"),
                        React.createElement("textarea", { id: "headerValue", style: { width: '100%', height: '600px' }, onChange: (e) => {
                                onHeaderChange(e.target.value || '');
                            } }, headerValue)),
                    React.createElement(GridColumn, { columnSpan: 12 },
                        React.createElement("h2", null, "Footer value"),
                        React.createElement("textarea", { id: "footerValue", style: { width: '100%', height: '600px' }, onChange: (e) => {
                                onFooterChange(e.target.value || '');
                            } }, footerValue)))))));
}
/* istanbul ignore next */
window.start = () => {
    createRoot(window.document.getElementById('root')).render(React.createElement(ConsumerMock, null));
};
//# sourceMappingURL=consumer-mock.js.map