import { cloneDeep } from 'lodash';
/**
 * This function will retrieve the Node Data for a context object type ex: 'Item'
 * and will also retrieve the Node Data for any reference objects ex: 'category.name'
 */
export const getDeepObjectDetails = async ({ contextProvider, contextObjectType, referenceIds, onTelemetryEvent, }) => {
    const nodeData = await contextProvider.getObjectDetails({
        objectType: contextObjectType,
        contextType: 'body',
        canParentFilter: true,
        canParentSort: true,
    });
    let currContextObjectType = contextObjectType;
    if (referenceIds.length > 0) {
        let newData = nodeData;
        const mappedAsyncReferences = await Promise.all(referenceIds.map(async (referenceId) => {
            // Custom fields are deep bound but they are not references
            const propDetails = nodeData.find(node => node.name === referenceId);
            if (propDetails) {
                return propDetails;
            }
            const referenceParts = referenceId.split('.');
            let clonedReferenceObject;
            for (let i = 0; i < referenceParts.length; i += 1) {
                currContextObjectType = newData.find(node => node.name === referenceParts[i])?.type;
                if (!currContextObjectType) {
                    onTelemetryEvent('Reference type not found', {
                        referenceId,
                        currContextObjectType,
                        propDetails,
                        referenceParts,
                    });
                    break;
                }
                const referenceObject = newData.find(node => node.name === referenceParts[i]);
                if (i === referenceParts.length - 1) {
                    if (!referenceObject) {
                        onTelemetryEvent('Reference object not found', {
                            referenceId,
                            referenceObject,
                            referenceParts,
                        });
                        break;
                    }
                    clonedReferenceObject = cloneDeep(referenceObject);
                    clonedReferenceObject.name = referenceId;
                    clonedReferenceObject.node = currContextObjectType;
                    return clonedReferenceObject;
                }
                newData = await contextProvider.getObjectDetails({
                    objectType: currContextObjectType,
                    contextType: 'body',
                    canParentFilter: referenceObject?.canFilter || false,
                    canParentSort: referenceObject?.canSort || false,
                });
            }
            return clonedReferenceObject;
        }));
        const resolvedReferences = mappedAsyncReferences.filter(Boolean);
        return [...nodeData, ...resolvedReferences];
    }
    return nodeData;
};
//# sourceMappingURL=utils.js.map