import { useEffect, useState } from 'react';
import { FORMATTING_COMMANDS } from '../constants';
export const useEditorCommandState = (editorRef) => {
    const [commandStates, setCommandStates] = useState({});
    useEffect(() => {
        const commands = {};
        const updateCommandStates = () => {
            const newCommandStates = {};
            Object.keys(commands).forEach(commandName => {
                newCommandStates[commandName] = commands[commandName].isEnabled;
            });
            setCommandStates(newCommandStates);
        };
        if (editorRef) {
            const commandsList = FORMATTING_COMMANDS;
            commandsList.forEach(commandName => {
                const command = editorRef.commands.get(commandName);
                if (command) {
                    commands[commandName] = command;
                    command.on('change:isEnabled', updateCommandStates);
                }
            });
            updateCommandStates();
        }
        return () => {
            Object.keys(commands).forEach(commandName => {
                commands[commandName].off('change:isEnabled', updateCommandStates);
            });
        };
    }, [editorRef]);
    return commandStates;
};
//# sourceMappingURL=use-editor-command-state.js.map