import { SortConditionEditor } from '@sage/xtrem-ui-components';
import * as React from 'react';
import { getSelectedItemsFromProperties } from '../../plugins/utils';
export function SortingComponent({ canAddNewLines = true, canDrag = true, canRemoveLines = true, localize, onChange, properties, propertyReadOnly = false, value, }) {
    const remappedProperties = getSelectedItemsFromProperties(properties);
    return (React.createElement("div", { className: "document-editor-sorting-step", "data-testid": "document-editor-sorting-step" },
        React.createElement(SortConditionEditor, { localize: localize, value: value, canAddNewLines: canAddNewLines, canRemoveLines: canRemoveLines, canDrag: canDrag, properties: remappedProperties, propertyReadOnly: propertyReadOnly, onChange: onChange, gridGutter: 16 })));
}
//# sourceMappingURL=sorting-component.js.map