import * as React from 'react';
import Icon from 'carbon-react/esm/components/icon';
export const SelectionCard = React.memo(React.forwardRef(({ _id, title, description = '', icon, onClick, isSelected = false, isReadOnly = false }, ref) => {
    const onCardClick = React.useCallback((ev) => {
        ev.preventDefault();
        onClick();
    }, [onClick]);
    const baseClassName = isSelected ? 'e-selection-card e-selection-card-selected' : 'e-selection-card';
    return (React.createElement("button", { ref: ref, type: "button", "data-testid": `e-selection-card-${_id}`, className: baseClassName, onClick: onCardClick, "aria-label": title, disabled: isReadOnly },
        React.createElement("div", { "data-testid": "e-selection-card-image", className: "e-selection-card-image" }, isSelected ? (React.createElement(Icon, { "data-testid": "e-selection-card-image-selected", fontSize: "large", type: "tick_circle", color: "--colorsSemanticPositive500" })) : (React.createElement(Icon, { "data-testid": "e-selection-card-image-selected", fontSize: "large", type: icon }))),
        React.createElement("div", { "data-testid": "e-selection-card-content", className: "e-selection-card-content" },
            React.createElement("div", { "data-testid": "e-selection-card-title", className: "e-selection-card-title" }, title),
            React.createElement("div", { "data-testid": "e-selection-card-description", className: "e-selection-card-description" }, description))));
}));
SelectionCard.displayName = 'SelectionCard';
//# sourceMappingURL=selection-card.js.map