import * as React from 'react';
import { Tree } from '@sage/xtrem-ui-components';
import { textStreams } from '@sage/xtrem-shared';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import Textbox from 'carbon-react/esm/components/textbox';
export const NodeBrowserTree = React.memo(({ checkedItems, filter: incomingFilter, getObjectDetails, isDisabled, isReadOnly, localize, objectType, onCheckedItemsUpdated, root, selectionMode, }) => {
    const filter = React.useMemo(() => incomingFilter ?? ((v) => v), [incomingFilter]);
    const rootElement = React.useMemo(() => ({
        key: '',
        id: '',
        labelKey: '',
        label: '',
        labelPath: '',
        canBeExpanded: true,
        canBeSelected: false,
        data: {
            kind: 'OBJECT',
            type: objectType,
            name: '',
            label: '',
            canFilter: true,
            canSort: true,
            enumType: null,
            isCustom: false,
            dataType: '',
            targetNode: '',
            isStored: false,
            isOnInputType: false,
            isOnOutputType: false,
            isMutable: false,
        },
    }), [objectType]);
    const fetchItems = React.useCallback(async (treeNode) => {
        const allNodeInfo = await getObjectDetails({
            objectType: treeNode.data.type,
            canParentFilter: treeNode.data.canFilter,
            canParentSort: treeNode.data.canSort,
            contextType: root,
        });
        let filteredNodes = [...allNodeInfo];
        if (filter) {
            filteredNodes = filter(filteredNodes);
        }
        return filteredNodes.map(nodeInfo => ({
            data: {
                ...nodeInfo,
            },
            id: treeNode.key ? `${treeNode.key}.${nodeInfo.name}` : nodeInfo.name,
            key: treeNode.key ? `${treeNode.key}.${nodeInfo.name}` : nodeInfo.name,
            labelPath: treeNode.key ? `${treeNode.key}.${nodeInfo.name}` : nodeInfo.name,
            labelKey: treeNode.label ? `${treeNode.label}.${nodeInfo.label}` : nodeInfo.label,
            label: nodeInfo.label,
            canBeExpanded: (nodeInfo.kind === 'OBJECT' && !textStreams.includes(nodeInfo.type)) ||
                nodeInfo.kind === 'INTERFACE',
            canBeSelected: (nodeInfo.kind !== 'OBJECT' || textStreams.includes(nodeInfo.type)) &&
                nodeInfo.kind !== 'INTERFACE',
        }));
    }, [filter, getObjectDetails, root]);
    const [searchText, setSearchText] = React.useState('');
    const inputRef = React.useRef(null);
    const [listOpenedItems, setListOpenedItems] = React.useState({
        key: '',
        children: [],
    });
    const handleOpenChild = React.useCallback((key, children) => {
        setListOpenedItems(currentItems => ({
            ...currentItems,
            [key]: children,
        }));
    }, []);
    const handleCloseChild = React.useCallback((key) => {
        const updatedOpenedItems = { ...listOpenedItems };
        delete updatedOpenedItems[key];
        setListOpenedItems(updatedOpenedItems);
    }, [listOpenedItems]);
    const onClearButtonClicked = React.useCallback(() => {
        setSearchText('');
        if (inputRef?.current) {
            inputRef.current.focus();
        }
    }, [setSearchText, inputRef]);
    const onSearchTextChanged = React.useCallback((ev) => {
        setSearchText(ev.target.value);
    }, []);
    const treeComponent = (React.createElement(Tree, { checkedItems: checkedItems || {}, element: rootElement, fetchItems: fetchItems, isDisabled: isDisabled, level: 0, listOpenedItems: listOpenedItems, localize: localize, onCheckedItemsUpdated: onCheckedItemsUpdated, onCloseChild: handleCloseChild, onOpenChild: handleOpenChild, searchText: searchText, isReadOnly: isReadOnly, selectionMode: selectionMode, isFolderIconHidden: selectionMode === 'button' }));
    return (rootElement && (React.createElement(React.Fragment, null,
        React.createElement("div", { "data-testid": "e-data-step-search" },
            React.createElement(Textbox, { "data-testid": "e-node-browser-filter", ref: inputRef, onKeyDown: (e) => {
                    // On hitting the enter key the component reloads the page for some reason
                    if (e.key === 'Enter') {
                        e.preventDefault();
                    }
                }, disabled: isDisabled, onChange: onSearchTextChanged, placeholder: "Search...", "aria-label": "Search...", leftChildren: React.createElement(Icon, { type: "search", bgSize: "large" }), value: searchText, mb: 1 }, !!searchText && (React.createElement(IconButton, { onClick: onClearButtonClicked, "aria-label": localize('@sage/xtrem-document-editor/clear-filter-text', 'Clear filter text') },
                React.createElement(Icon, { type: "cross" }))))),
        React.createElement("div", { className: "e-data-node-step-tree-container", "data-testid": "e-data-step-tree-container" },
            React.createElement("div", { className: "e-data-node-step-tree-wrapper" }, treeComponent)))));
});
NodeBrowserTree.displayName = 'NodeBrowserTree';
//# sourceMappingURL=node-browser-tree.js.map