import * as React from 'react';
import Numeric from 'carbon-react/esm/components/number';
import { useQueryTableCellPropertyCommand } from './use-table-cell-property-command';
import { GridColumn } from '@sage/xtrem-ui-components';
export function MinimumCellHeight({ title, editor, commandName, tableUtilsPluginConstructor, isEnabled, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
    });
    const [inputValue, setInputValue] = React.useState(value || '24 px');
    React.useEffect(() => {
        setInputValue(value || 24);
    }, [value]);
    const onSelectChange = React.useCallback((event) => {
        setInputValue(Number(event.target.value));
    }, []);
    const onBlur = React.useCallback(() => {
        onChange(String(inputValue));
    }, [onChange, inputValue]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 4 },
        React.createElement(Numeric, { onBlur: onBlur, id: commandName, label: title, value: String(inputValue), onChange: onSelectChange })));
}
//# sourceMappingURL=min-cell-height.js.map