export function getAggregationsFromItems(tableContentValue) {
    return tableContentValue.reduce((prevValue, row) => {
        prevValue[row.path] = {
            group: row.group || 0,
            operation: row.operation || 'NONE',
        };
        return prevValue;
    }, {});
}
export function getSelectedFieldsFromItems(tableContentValue) {
    return tableContentValue.reduce((prevValue, row) => {
        if (row.property) {
            prevValue[row.path] = row.property.data;
        }
        return prevValue;
    }, {});
}
export function getOrderByFromItems(tableContentValue) {
    return tableContentValue
        .filter(i => Boolean(i.property?.data.canSort))
        .reduce((prevValue, row) => {
        const sorting = row.sorting;
        if (sorting) {
            prevValue[row.path] = sorting;
        }
        return prevValue;
    }, {});
}
//# sourceMappingURL=insert-list-property-dialog-utils.js.map