import * as React from 'react';
import { ButtonToggle, ButtonToggleGroup } from 'carbon-react/esm/components/button-toggle';
import { useQueryTableCellPropertyCommand } from './use-table-cell-property-command';
import { GridColumn } from '@sage/xtrem-ui-components';
export function HorizontalCellAlignment({ title, editor, commandName, tableUtilsPluginConstructor, localize, isEnabled, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
        defaultValue: 'left',
    });
    const onSelectChange = React.useCallback((_ev, alignment) => {
        onChange(alignment);
    }, [onChange]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 4 },
        React.createElement(ButtonToggleGroup, { id: "button-toggle-group-id", label: title, value: value, onChange: onSelectChange },
            React.createElement(ButtonToggle, { value: "left" }, localize('@sage/xtrem-document-editor/horizontal-alignment-left', 'Left')),
            React.createElement(ButtonToggle, { value: "center" }, localize('@sage/xtrem-document-editor/horizontal-alignment-center', 'Center')),
            React.createElement(ButtonToggle, { value: "right" }, localize('@sage/xtrem-document-editor/horizontal-alignment-right', 'Right')))));
}
//# sourceMappingURL=horizontal-alignment.js.map