import * as React from 'react';
import { COMMAND_INSERT_PROPERTY, COMMAND_INSERT_QUERY_TABLE, COMMAND_INSERT_RECORD_CONTEXT, OBJECT_TYPE_GLOBAL_PROPERTIES, OBJECT_TYPE_ROOT, } from '../../constants';
import ToggleDataPropertiesPanelUi from '../../plugins/toggle-data-properties-panel/toggle-data-properties-panel-ui';
import { getContextObjectType } from '../../plugins/utils';
import { NodeBrowserTree } from '../node-browser-tree/node-browser-tree';
import { PanelHeader } from './panel-header';
import ToggleGlobalPropertiesPanelUi from '../../plugins/toggle-global-properties-panel/toggle-global-properties-panel-ui';
export function LeftPanel({ isOpen, contextProvider: { getObjectDetails, onObjectInsert }, editorRef, onOpenLookupDialog, localize, rootContext, }) {
    const [recordContext, setRecordContext] = React.useState(rootContext);
    const [rootName, setSelectedNameRoot] = React.useState('body');
    const onItemsSelected = React.useCallback(async (selectedItems) => {
        const selectedItem = Object.values(selectedItems)[0];
        // Inserting simple scalar property
        if (selectedItem.data.kind === 'SCALAR' || selectedItem.data.kind === 'ENUM') {
            const remapInfo = await onObjectInsert(selectedItem.key, selectedItem.data, 'property');
            editorRef?.execute(COMMAND_INSERT_PROPERTY, { selectedItem, remapInfo, recordContext });
        }
        // Inserting a list or record context
        if (selectedItem.data.kind === 'LIST') {
            const lookupRequest = {
                root: rootName,
                contextObjectType: selectedItem.data.type,
                onSelected: async (lookupResult) => {
                    const remapInfo = await onObjectInsert(selectedItem.key, selectedItem.data, lookupResult.selectedMode);
                    editorRef?.execute(lookupResult.selectedMode === 'list'
                        ? COMMAND_INSERT_QUERY_TABLE
                        : COMMAND_INSERT_RECORD_CONTEXT, { lookupResult, selectedItem, remapInfo });
                },
            };
            onOpenLookupDialog(lookupRequest);
        }
    }, [editorRef, onObjectInsert, onOpenLookupDialog, recordContext, rootName]);
    React.useEffect(() => {
        const onChange = () => {
            if (rootContext === OBJECT_TYPE_ROOT) {
                setRecordContext(getContextObjectType(editorRef?.model.document.selection.focus?.parent) || rootContext);
            }
            const currentRootName = editorRef?.model.document.selection.getFirstRange()?.start.root.rootName || 'body';
            setSelectedNameRoot(currentRootName);
        };
        editorRef?.model.document.on('change', onChange);
        onChange();
        return () => {
            editorRef?.model.document.off('change', onChange);
        };
    }, [editorRef, isOpen, rootContext]);
    const getTitle = React.useCallback(() => {
        if (recordContext === OBJECT_TYPE_ROOT) {
            return localize('@sage/xtrem-document-editor/global-context', 'Global context');
        }
        if (recordContext === OBJECT_TYPE_GLOBAL_PROPERTIES) {
            return localize('@sage/xtrem-document-editor/global-properties', 'Document properties');
        }
        return recordContext;
    }, [localize, recordContext]);
    const getNodesAndCollections = React.useCallback(async (getObjectDetailsArgs) => {
        const objectDetails = await getObjectDetails({ ...getObjectDetailsArgs, contextType: rootName });
        const isRootContext = recordContext === OBJECT_TYPE_ROOT;
        return isRootContext ? objectDetails.map(o => ({ ...o, kind: 'LIST' })) : objectDetails;
    }, [getObjectDetails, recordContext, rootName]);
    if (!isOpen || !editorRef) {
        return null;
    }
    return (React.createElement("div", { className: "document-editor-left-panel" },
        React.createElement(PanelHeader, { editorRef: editorRef, title: localize('@sage/xtrem-document-editor/left-panel-title', 'Fields'), actionUiPlugin: rootContext === OBJECT_TYPE_ROOT ? ToggleDataPropertiesPanelUi : ToggleGlobalPropertiesPanelUi, localize: localize }),
        React.createElement("div", { className: "document-editor-panel-context-indicator" }, getTitle()),
        React.createElement("div", { className: "document-editor-right-panel-node-browser" },
            React.createElement(NodeBrowserTree, { checkedItems: {}, getObjectDetails: getNodesAndCollections, localize: localize, objectType: recordContext, onCheckedItemsUpdated: onItemsSelected, root: rootName, selectionMode: "button" }))));
}
//# sourceMappingURL=left-panel.js.map