import * as React from 'react';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { Element } from '@ckeditor/ckeditor5-engine';
import { GridColumn } from '@sage/xtrem-ui-components';
import { COMMAND_EDIT_ORDER_QUERY_TABLE } from '../constants';
import Dialog from 'carbon-react/esm/components/dialog';
import Form from 'carbon-react/esm/components/form';
import Button from 'carbon-react/esm/components/button';
import { getContextObjectType, getContextSortOrder, isTableElement } from '../plugins/utils';
import { SortingComponent } from './sorting/sorting-component';
import Loader from 'carbon-react/esm/components/loader';
import { isEmpty } from 'lodash';
import { getDeepObjectDetails } from './utils';
export function EditOrderActionButton({ contextProvider, editor, isEnabled, localize, onTelemetryEvent, }) {
    const [isOpen, setOpen] = React.useState(false);
    const [properties, setProperties] = React.useState(null);
    const [orderBy, setOrderBy] = React.useState({});
    const focusElement = editor?.model.document.selection.focus?.parent;
    const [isTable, setIsTable] = React.useState(focusElement && focusElement instanceof Element ? isTableElement(focusElement) : false);
    const openSnapshotRef = React.useRef(null);
    React.useEffect(() => {
        setProperties(null);
        if (editor && isOpen) {
            const focusedElement = editor.model.document.selection.focus?.parent;
            const objectType = getContextObjectType(focusedElement);
            const derivedOrderBy = getContextSortOrder(focusedElement) || {};
            const table = focusedElement && focusedElement instanceof Element ? isTableElement(focusedElement) : false;
            openSnapshotRef.current = { objectType, order: derivedOrderBy, isTable: table };
            setOrderBy(derivedOrderBy);
            setIsTable(table);
        }
    }, [contextProvider, editor, isOpen]);
    React.useEffect(() => {
        let isCurrent = true;
        if (editor && isEnabled && isOpen) {
            const snap = openSnapshotRef.current;
            if (snap?.objectType) {
                const referenceIds = Object.keys(snap.order).filter(key => key.includes('.'));
                getDeepObjectDetails({
                    contextProvider,
                    contextObjectType: snap.objectType,
                    referenceIds,
                    onTelemetryEvent,
                }).then(dataModel => {
                    if (isCurrent)
                        setProperties(dataModel);
                });
            }
        }
        return () => {
            isCurrent = false;
        };
    }, [isEnabled, isOpen, contextProvider, editor, onTelemetryEvent]);
    const onSaveOrder = React.useCallback(() => {
        if (editor) {
            editor.execute(COMMAND_EDIT_ORDER_QUERY_TABLE, { orderBy });
        }
        setOpen(false);
    }, [editor, orderBy]);
    if (!isEnabled) {
        return null;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Dialog, { open: isOpen, onCancel: () => setOpen(false), title: localize('@sage/xtrem-document-editor/edit-sorting-dialog-title', 'Edit sorting'), className: "document-editor-edit-sorting-dialog", size: "extra-large", height: "600px" },
            React.createElement(Form, { onSubmit: (ev) => {
                    ev.preventDefault();
                }, stickyFooter: true, height: "500px", saveButton: React.createElement(Button, { buttonType: "primary", type: "submit", onClick: onSaveOrder }, localize('@sage/xtrem-document-editor/apply-button', 'Apply')) },
                isEmpty(properties) && React.createElement(Loader, null),
                !isEmpty(properties) && properties && (React.createElement(SortingComponent, { canAddNewLines: !isTable, canDrag: !isTable, canRemoveLines: !isTable, localize: localize, onChange: setOrderBy, properties: properties, propertyReadOnly: isTable, value: orderBy })))),
        React.createElement(GridColumn, { columnSpan: 2 },
            React.createElement(ButtonMinor, { fullWidth: true, onClick: () => setOpen(true), "data-testid": "document-editor-edit-sorting-button" }, localize('@sage/xtrem-document-editor/edit-sorting-button', 'Edit sorting')))));
}
//# sourceMappingURL=edit-order-action-button.js.map