import * as React from 'react';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { GridColumn } from '@sage/xtrem-ui-components';
import { getContextCondition } from '../plugins/utils';
import { COMMAND_EDIT_CONDITION_BLOCK } from '../constants';
export function EditConditionActionButton({ editor, localize, isEnabled, setConditionDialogRequest, }) {
    const onClick = React.useCallback(() => {
        if (!editor) {
            return;
        }
        const focusedElement = editor.model.document.selection.focus?.parent;
        const conditionDialogRequest = {
            existingConditions: getContextCondition(focusedElement) || [],
            onFinished: (conditions) => {
                if (editor) {
                    editor.execute(COMMAND_EDIT_CONDITION_BLOCK, { conditions });
                }
            },
        };
        setConditionDialogRequest(conditionDialogRequest);
    }, [editor, setConditionDialogRequest]);
    if (!isEnabled) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 2 },
        React.createElement(ButtonMinor, { fullWidth: true, onClick: onClick, "data-testid": "document-editor-edit-condition-button" }, localize('@sage/xtrem-document-editor/edit-conditions-button', 'Edit conditions'))));
}
//# sourceMappingURL=edit-condition-action-button.js.map