import Button from 'carbon-react/esm/components/button';
import Dialog from 'carbon-react/esm/components/dialog';
import Form from 'carbon-react/esm/components/form';
import Typography from 'carbon-react/esm/components/typography';
import React from 'react';
import { getContextObjectType } from '../plugins/utils';
import { ConditionEditorTableComponent } from '@sage/xtrem-ui-components';
export function ConditionDialog({ carbonLocale, conditionRequest, contextProvider, editorRef, locale, localize, localizeEnumMember, onClose, }) {
    const [conditions, setConditions] = React.useState(conditionRequest?.existingConditions ?? []);
    const [contextObjectType, setContextObjectType] = React.useState(null);
    const [parameters, setParameters] = React.useState(null);
    const [isValid, setValid] = React.useState(false);
    const fetchedParameters = React.useMemo(() => contextProvider.getDocumentParameters(), [contextProvider]);
    React.useEffect(() => {
        const asyncEffect = async () => {
            const params = await fetchedParameters;
            setParameters(params || []);
        };
        if (!conditionRequest) {
            setConditions([]);
            return;
        }
        const cot = getContextObjectType(editorRef?.model.document.selection.getFirstPosition()?.parent);
        setContextObjectType(cot);
        setConditions(conditionRequest?.existingConditions ?? []);
        asyncEffect();
    }, [conditionRequest, contextProvider, editorRef, fetchedParameters]);
    const isOpen = React.useMemo(() => Boolean(conditionRequest), [conditionRequest]);
    const onConfirmed = React.useCallback(() => {
        if (conditionRequest?.onFinished) {
            conditionRequest?.onFinished(conditions);
            onClose();
        }
    }, [conditionRequest, conditions, onClose]);
    const fetchItems = React.useCallback((object) => {
        if (object?.node) {
            return contextProvider.getObjectDetails({
                objectType: object?.node,
                contextType: 'body',
                canParentFilter: true,
                canParentSort: true,
            });
        }
        return Promise.resolve([]);
    }, [contextProvider]);
    return (React.createElement(Dialog, { className: "document-editor-condition-dialog", onCancel: onClose, open: isOpen, size: "extra-large", title: localize('@sage/xtrem-document-editor/conditional-block-title', 'Conditional block'), height: "600px" },
        React.createElement(Form, { stickyFooter: true, height: "500px", leftSideButtons: React.createElement(Button, { onClick: onClose }, localize('@sage/xtrem-document-editor/cancel', 'Cancel')), saveButton: React.createElement(Button, { buttonType: "primary", type: "button", onClick: onConfirmed, disabled: !isValid }, localize('@sage/xtrem-document-editor/apply-button', 'Apply')) },
            React.createElement(Typography, null, localize('@sage/xtrem-document-editor/conditional-block-description', 'A new block will be inserted and its content will be displayed only if all the following conditions are satisfied.')),
            contextObjectType && parameters && (React.createElement(ConditionEditorTableComponent, { carbonLocale: carbonLocale, fetchItems: fetchItems, locale: locale, localize: localize, localizeEnumMember: localizeEnumMember, node: contextObjectType, onChange: setConditions, onValidityChange: setValid, parameters: parameters, value: conditions })))));
}
//# sourceMappingURL=condition-dialog.js.map