import React from 'react';
import type { DocumentContextProvider } from '../context-provider';
import type { MultiRootEditor } from '@ckeditor/ckeditor5-editor-multi-root';
import type { LocalizeEnumFunction, LocalizeFunction, LocalizeLocale } from '@sage/xtrem-shared';
import type { ConditionEditorProperty, CarbonLocaleType } from '@sage/xtrem-ui-components';
export interface ConditionDialogRequest {
    existingConditions?: ConditionEditorProperty[];
    onFinished: (newCondition: any) => void;
}
export interface ConditionDialogProps {
    conditionRequest: ConditionDialogRequest | null;
    contextProvider: DocumentContextProvider;
    editorRef: MultiRootEditor | null;
    locale: LocalizeLocale;
    localize: LocalizeFunction;
    localizeEnumMember: LocalizeEnumFunction;
    onClose: () => void;
    carbonLocale: CarbonLocaleType;
}
export declare function ConditionDialog({ carbonLocale, conditionRequest, contextProvider, editorRef, locale, localize, localizeEnumMember, onClose, }: ConditionDialogProps): React.ReactElement;
//# sourceMappingURL=condition-dialog.d.ts.map