import * as React from 'react';
import { THEME_COLORS } from '../../constants';
import AdvancedColorPicker from 'carbon-react/esm/components/advanced-color-picker';
import { GridColumn } from '@sage/xtrem-ui-components';
export function ColorPicker({ title, value, onChange, isEnabled, editor }) {
    const [isOpen, setOpen] = React.useState(false);
    const onColorChange = React.useCallback((event) => {
        setOpen(false);
        onChange(event.target.value);
    }, [onChange]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 2 },
        React.createElement("label", { className: "field-label" }, title),
        React.createElement(AdvancedColorPicker, { name: "advancedPicker", availableColors: THEME_COLORS.map(c => ({ value: c, label: c })), defaultColor: value, selectedColor: value, onChange: onColorChange, onOpen: () => {
                setOpen(!isOpen);
            }, onClose: () => {
                setOpen(false);
            }, open: isOpen })));
}
//# sourceMappingURL=color-picker.js.map