import * as React from 'react';
import { BorderWidth } from './border-width-select';
import { useQueryTableCellPropertyCommand } from '../use-table-cell-property-command';
export function CellBorderWidthSelect({ title, commandName, editor, isEnabled, tableUtilsPluginConstructor, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
    });
    return (React.createElement(BorderWidth, { title: title, commandName: commandName, value: value, onChange: onChange, isEnabled: isEnabled, editor: editor }));
}
//# sourceMappingURL=cell-border-width-select.js.map