import * as React from 'react';
import { useQueryTableCellPropertyCommand } from '../use-table-cell-property-command';
import { BorderStyle } from './border-style-select';
export function CellBorderStyleSelect({ title, commandName, editor, isEnabled, tableUtilsPluginConstructor, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
    });
    return (React.createElement(BorderStyle, { title: title, commandName: commandName, value: value, onChange: onChange, isEnabled: isEnabled, editor: editor }));
}
//# sourceMappingURL=cell-border-style-select.js.map