import type { CancelTokenSource } from 'axios';
import type { HttpConfig } from './http-config.model';
export interface IHttpService {
    source: CancelTokenSource;
    resetCancelTokens(): void;
    get<T>(url: string, config?: HttpConfig): Promise<T>;
    delete<T>(url: string, config?: HttpConfig): Promise<T>;
    post<T>(url: string, data?: any, config?: HttpConfig): Promise<T>;
    put<T>(url: string, data?: any, config?: HttpConfig): Promise<T>;
    patch<T>(url: string, data?: any, config?: HttpConfig): Promise<T>;
}
