import type { Dict, StringLiterals } from '../../types';
import type { IconType } from 'carbon-react/lib/components/icon';
import './FilterLine.scss';
export interface FilterLineFilterConfig {
    ariaLabel: string;
    options: Dict<string>;
    onChange: (newValue: string | null) => void;
    value?: string;
    representation?: 'dropdown' | 'tabs';
    isEmptyAllowed?: boolean;
    variant?: 'default' | 'ghost';
    placeholder?: string;
}
export interface FilterLineToggleConfig {
    id: string;
    ariaLabel: string;
    onChange: (newValue: string) => void;
    value?: string;
    options: Dict<{
        icon: IconType;
        label: string;
    }>;
}
export interface FilterLineSelectAllConfig {
    onChange: (newValue: boolean) => void;
    value?: boolean;
}
export interface FilterLineProps {
    filter?: FilterLineFilterConfig;
    toggle?: FilterLineToggleConfig;
    selectAll?: FilterLineSelectAllConfig;
    stringLiterals: StringLiterals;
    isFilterFullWidth?: boolean;
    onFilterHeightChange?: (value: number) => void;
}
export declare function FilterLine({ filter, toggle, selectAll, stringLiterals, isFilterFullWidth, onFilterHeightChange, }: FilterLineProps): JSX.Element | null;
