import type { ColorVariant } from './types';
export declare const baseColorVariants: readonly ["neutral", "negative", "positive", "warning"];
export declare function isBaseCorlorVariant(value: string | undefined | null): value is typeof baseColorVariants[number];
export declare function getPillStyleAndVariant(variant?: ColorVariant | null): {
    colorVariant: "neutral" | "negative" | "positive" | "warning" | undefined;
    style: import("react").CSSProperties | undefined;
};
export declare const colorfulPillPattern: {
    readonly filledNeutral: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledInformation: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledPositive: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledNegative: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledCaution: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledFocus: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly filledClosing: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedNeutral: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedInformation: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedPositive: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedNegative: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedCaution: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedFocus: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly outlinedClosing: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly default: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly transparent: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
    readonly textBox: {
        readonly backgroundColor: string;
        readonly borderColor: string;
        readonly color: string;
    };
};
