import type { IconType } from 'carbon-react/lib/components/icon';
import type { DashboardValueOrCallback, Locale, StringLiterals } from '../../../types';
export type EventListener = (i: string | number) => void;
export type ValueFormatType = 'number' | 'string';
export type RenderAsType = 'link' | 'pill' | 'normal' | 'icon' | null | undefined;
export type ColorVariant = 'neutral' | 'negative' | 'positive' | 'warning' | 'filledNeutral' | 'filledInformation' | 'filledPositive' | 'filledNegative' | 'filledCaution' | 'filledFocus' | 'filledClosing' | 'outlinedNeutral' | 'outlinedInformation' | 'outlinedPositive' | 'outlinedNegative' | 'outlinedCaution' | 'outlinedFocus' | 'outlinedClosing' | 'default' | 'transparent' | 'textBox' | undefined;
export interface WidgetCollectionItemDisplayOptions {
    colorVariant?: DashboardValueOrCallback<ColorVariant>;
    tooltipText?: DashboardValueOrCallback<string | undefined>;
    columnWidth?: number;
    isLabelDisplayedOnCard?: boolean;
}
export interface WidgetColumnDefinitionOptions {
    title: string;
    onClick?: EventListener;
    displayOptions?: WidgetCollectionItemDisplayOptions;
    renderedAs?: RenderAsType;
    valueFormat?: ValueFormatType;
    decimalDigits?: number;
}
export interface WidgetCollectionItemDefinition {
    title: WidgetColumnDefinitionOptions;
    titleRight?: WidgetColumnDefinitionOptions;
    line2?: WidgetColumnDefinitionOptions;
    line2Right?: WidgetColumnDefinitionOptions;
    line3?: WidgetColumnDefinitionOptions;
    line3Right?: WidgetColumnDefinitionOptions;
    image?: WidgetColumnDefinitionOptions;
    icon?: WidgetColumnDefinitionOptions;
    longContent?: WidgetColumnDefinitionOptions;
    [key: string]: WidgetColumnDefinitionOptions | undefined;
}
export interface WidgetCollectionItemAction {
    icon?: IconType;
    label: string;
    isDestructive?: boolean;
    isDisabled?: boolean | ((i: string | number, row: WidgetCollectionItem) => boolean);
    isHidden?: boolean | ((i: string | number, row: WidgetCollectionItem) => boolean);
    isMenuSeparator?: false;
    onClick: (i: string | number, row: WidgetCollectionItem) => void;
}
export interface WidgetCollectionItemMenuSeparator {
    id?: string;
    isHidden?: boolean | ((i: string | number, row: WidgetCollectionItem) => boolean);
    isMenuSeparator?: true;
}
export type WidgetCollectionItemActionOrMenuSeparator = WidgetCollectionItemAction | WidgetCollectionItemMenuSeparator;
export interface WidgetCollectionItem {
    i: string | number;
    title: string | number;
    titleRight?: string | number;
    line2?: string | number;
    line2Right?: string | number;
    line3?: string | number;
    line3Right?: string | number;
    image?: string;
    icon?: IconType;
    longContent?: string;
    [key: string]: string | number | undefined;
}
export declare enum WidgetCollectionItemStatus {
    LOADING = 0,
    LOADED = 1,
    FAILED = 2,
    STALE = 3
}
export interface WidgetCollectionRendererProps {
    canSelect?: WidgetCollectionItemRendererProps['canSelect'];
    data: WidgetCollectionItem[];
    hasIcon: WidgetCollectionItemRendererProps['hasIcon'];
    hasImage: WidgetCollectionItemRendererProps['hasImage'];
    height?: number;
    loadMoreRows?: (args: {
        startIndex: number;
        stopIndex: number;
        pageCount: number;
        pageSize: number;
        after?: WidgetCollectionItem;
        first: number;
    }) => Promise<WidgetCollectionItem[]>;
    locale: WidgetCollectionItemRendererProps['locale'];
    onSelectAllChange: (newState: boolean) => void;
    onSelectionChange: WidgetCollectionItemRendererProps['onSelectionChange'];
    rowDefinition: WidgetCollectionItemRendererProps['rowDefinition'];
    rowActions?: WidgetCollectionItemRendererProps['rowActions'];
    selectedRows: (string | number)[];
    setHasAllDataLoaded: (allDataLoaded: boolean) => void;
    stringLiterals: WidgetCollectionItemRendererProps['stringLiterals'];
}
export interface WidgetCollectionItemRendererProps {
    canSelect?: boolean;
    hasIcon: boolean;
    hasImage: boolean;
    index: number;
    isRowExpanded: boolean;
    isSelected?: boolean;
    locale: Locale;
    onRowExpandToggle: (index: number, isExpanded: boolean) => void;
    onRowResized: (index: number, height: number) => void;
    onSelectionChange: (i: string | number) => void;
    row: WidgetCollectionItem;
    rowActions?: WidgetCollectionItemActionOrMenuSeparator[];
    rowDefinition: WidgetCollectionItemDefinition;
    stringLiterals: StringLiterals;
    style?: React.CSSProperties & {
        columnWidth?: number;
    };
}
export interface WidgetCollectionItemValueComponentProps {
    i: string | number;
    value: any;
    locale: Locale;
    definition?: WidgetColumnDefinitionOptions;
    isLeftPosition?: boolean;
    isInTable?: boolean;
    isBold?: boolean;
    propertyName: string;
}
export interface WidgetCollectionActionPopoverComponentProps {
    row: WidgetCollectionItem;
    rowActions: WidgetCollectionItemRendererProps['rowActions'];
    rowActionTestId: string;
    rowActionsTestId: string;
    stringLiterals: StringLiterals;
}
