import type { Dict, StringLiterals } from '../../types';
export type ContactType = 'contact' | 'site';
export type ContactCardProps = {
    address?: string;
    addresses?: Dict<string>;
    addressFunction?: string;
    addressRole?: string;
    canAddNotes?: boolean;
    contactEmailAddress?: string;
    contactImage?: string;
    contactName?: string;
    contactPhoneNumber?: string;
    contactPosition?: string;
    contactRole?: string;
    contacts: Dict<string>;
    iconSrc?: string;
    notes?: {
        _id: string;
        text: string;
        timestamp: Date;
    }[];
    numberOfAddresses: number;
    numberOfContacts: number;
    onContactAdd?: () => Promise<void>;
    onAddressAdd?: () => Promise<void>;
    onContactTypeSwitchChanged?: (type: ContactType) => Promise<void>;
    onNoteAdded?: (text: string) => Promise<void>;
    onNoteDeleted?: (_id: string) => Promise<void>;
    onNoteEdited?: (_id: string, text: string) => Promise<void>;
    onSelectedAddressChanged?: (id: string | null) => Promise<void>;
    onSelectedContactChanged?: (id: string | null) => Promise<void>;
    stringLiterals: StringLiterals;
    selectedContactId?: string | null;
    selectedAddressId?: string | null;
};
